/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.util.DesEncrypter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumManifest {
    public static final String MANIFEST_NAME = "manifest.jmf";
    private static final String PLAIN_CONTENT = "content.txt";
    private static final String ENCRYPTED_CONTENT = "content.des";
    private Set<RemoteFile> content;

    public AlbumManifest(Set<RemoteFile> content) {
        this.content = content;
    }

    public AlbumManifest() {
        this.content = new ManifestBasedSet();
    }

    public AlbumManifest(RemoteFS remoteFS, String remoteDir) throws IOException, RemoteFSException {
        String s = this.read(remoteFS, remoteDir);
        this.content = this.parse(s);
    }

    public Set<RemoteFile> getContent() {
        return this.content;
    }

    public void putFile(RemoteFile rf) {
        this.content.remove(rf);
        this.content.add(rf);
    }

    public void removeFile(RemoteFile rf) {
        this.content.remove(rf);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (RemoteFile f : this.content) {
            buf.append(f.getModificationDate().getTime() / 1000L);
            buf.append('\t');
            buf.append(f.size());
            buf.append('\t');
            buf.append(f.getFullPath());
            buf.append('\n');
        }
        return buf.toString();
    }

    public byte[] getBytes() throws IOException {
        byte[] bytes = this.toString().getBytes("UTF-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        if (Config.getConfig().isEncryptManifest()) {
            zos.putNextEntry(new ZipEntry(ENCRYPTED_CONTENT));
            DesEncrypter encr = new DesEncrypter(Config.getConfig().getManifestPassword());
            zos.write(encr.encrypt(bytes));
        } else {
            zos.putNextEntry(new ZipEntry(PLAIN_CONTENT));
            zos.write(bytes);
        }
        zos.closeEntry();
        zos.finish();
        zos.close();
        return bos.toByteArray();
    }

    public void write(RemoteFS remoteFS, String remoteDir) throws IOException, RemoteFSException {
        remoteFS.setDirectory(remoteDir);
        remoteFS.put(new ByteArrayInputStream(this.getBytes()), MANIFEST_NAME);
    }

    private String read(RemoteFS remoteFS, String remoteDir) throws IOException, RemoteFSException {
        DesEncrypter decr;
        String name;
        ZipEntry entry;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        remoteFS.setDirectory(remoteDir);
        remoteFS.get(MANIFEST_NAME, bos);
        bos.close();
        byte[] rawbytes = bos.toByteArray();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(rawbytes));
        byte[] bytes = null;
        while ((entry = zis.getNextEntry()) != null) {
            int n;
            name = entry.getName();
            if (!name.equals(PLAIN_CONTENT) && !name.equals(ENCRYPTED_CONTENT)) continue;
            byte[] buffer = new byte[65536];
            bos.reset();
            while ((n = zis.read(buffer)) >= 0) {
                bos.write(buffer, 0, n);
            }
            zis.closeEntry();
            bytes = bos.toByteArray();
            break;
        }
        zis.close();
        if (bytes == null) {
            throw new IOException("Content file not found in manifest zip file");
        }
        name = entry.getName();
        if (name.equals(ENCRYPTED_CONTENT) && (bytes = (decr = new DesEncrypter(Config.getConfig().getManifestPassword())).decrypt(bytes)) == null) {
            throw new IOException("Couldn't decrypt encrypted manifest");
        }
        return new String(bytes, "UTF-8");
    }

    private ManifestBasedSet<RemoteFile> parse(String manifest) {
        BufferedReader reader = new BufferedReader(new StringReader(manifest));
        ManifestBasedSet<RemoteFile> files = new ManifestBasedSet<RemoteFile>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, "\t");
                long date = 1000L * Long.parseLong(tokens.nextToken());
                long size = Long.parseLong(tokens.nextToken());
                String fullPath = tokens.nextToken();
                RemoteFileImpl file = new RemoteFileImpl(fullPath, size, date);
                files.add((RemoteFileImpl)file);
            }
            return files;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ManifestBasedSet<RemoteFile>
    extends TreeSet {
        private ManifestBasedSet() {
        }
    }
}

