/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.xmp.XMPException;
import com.apple.eio.FileManager;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import org.jdesktop.jdic.fileutil.FileUtil;
import org.netbeans.editor.WeakPropertyChangeSupport;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamerContext;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;
import se.datadosen.util.StringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectImpl
implements AlbumObject,
Serializable {
    public static final String COMMENTS_FILE_NAME = "comments.properties";
    public static final String META_FILE_NAME = "meta.properties";
    public static final String ALBUMFILES_FILE_NAME = "albumfiles.txt";
    public static final String JALBUM_FOLDER_NAME = ".jalbum";
    public static final Dimension THUMBNAIL_DIMENSION = new Dimension(160, 160);
    public static final String THUMBNAILS_FOLDER = "thumbs";
    private static ImageIcon folderIcon = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed.png"));
    private static ImageIcon faintFolderIcon = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed_faint.png"));
    private static ImageIcon brokenLinkIcon = new ImageIcon(JAlbumObject.class.getResource("images/broken_link.png"));
    private static ImageIcon brokenImageIcon = new ImageIcon(JAlbumObject.class.getResource("images/broken_image.png"));
    private static DataFlavor[] flavors = new DataFlavor[]{AlbumObject.albumObjectFlavor, DataFlavor.javaFileListFlavor};
    transient AlbumObjectFactory factory;
    private transient AlbumObject parent;
    File file;
    Category category;
    String comment;
    private transient SoftReference<List<AlbumObject>> children;
    Map<String, AlbumObject> nameMap;
    boolean included = true;
    boolean doCache = true;
    AlbumObjectMetadata meta;
    transient SoftReference<AlbumObjectProperties> properties;
    transient SoftReference<XmpManager> xmpProperties;
    private AlbumObject representingAlbumObject;
    private WeakPropertyChangeSupport changeSupport;
    transient FileCollection fc;
    private transient ThumbnailCache thumbnailCache = new ThumbnailCache();
    private transient Scope vars;

    AlbumObjectImpl(File file, AlbumObject parent, AlbumObjectFactory factory) {
        this.file = file;
        this.parent = parent;
        this.factory = factory;
        if (this.isFolder()) {
            this.fc = new FileCollection(factory.engine, file);
        }
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AlbumObject> getNameMap() {
        if (this.nameMap == null && this.isFolder()) {
            AlbumObjectImpl albumObjectImpl = this;
            synchronized (albumObjectImpl) {
                if (this.nameMap == null) {
                    HashMap<String, AlbumObject> nameMap = new HashMap<String, AlbumObject>();
                    for (AlbumObject ao : this.getChildren()) {
                        nameMap.put(ao.getName().toLowerCase(), ao);
                    }
                    this.nameMap = nameMap;
                }
            }
        }
        return this.nameMap;
    }

    private static AlbumObject doGetRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon, Set<AlbumObject> alreadyVisited) {
        try {
            Map props = AlbumBean.getFolderProperties(ao.getFile());
            String folderIconPath = (String)props.get("folderIcon");
            if (AlbumObjectImpl.exists(folderIconPath)) {
                AlbumObject child = ao.getChild(folderIconPath);
                if (child == null) {
                    return null;
                }
                if (child.isFolder()) {
                    return AlbumObjectImpl.getRepresentingAlbumObject(child, useThumbForFolderIcon, alreadyVisited);
                }
                return child;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AlbumObject getRepresentingAlbumObject() {
        if (this.representingAlbumObject == null) {
            if (this.isFolder()) {
                this.representingAlbumObject = AlbumObjectImpl.getRepresentingAlbumObject(this, this.factory.engine.isUseThumbForFolderIcon());
            } else {
                File thumbFile = IO.thumbFile(this.file);
                if (!this.file.equals(thumbFile) && thumbFile.exists()) {
                    this.representingAlbumObject = this.factory.createInstance(thumbFile);
                }
            }
        }
        return this.representingAlbumObject;
    }

    @Override
    public AlbumObject getRepresentingAlbumObject(boolean force) {
        return AlbumObjectImpl.getRepresentingAlbumObject(this, force);
    }

    private static AlbumObject getRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon) {
        return AlbumObjectImpl.getRepresentingAlbumObject(ao, useThumbForFolderIcon, new HashSet<AlbumObject>());
    }

    private static AlbumObject getRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon, Set<AlbumObject> alreadyVisited) {
        if (alreadyVisited.contains(ao)) {
            System.err.println("Circular folder link detected when entering " + ao.getFile());
            return null;
        }
        alreadyVisited.add(ao);
        AlbumObject rep = AlbumObjectImpl.doGetRepresentingAlbumObject(ao, useThumbForFolderIcon, alreadyVisited);
        if (rep == null && useThumbForFolderIcon) {
            try {
                List<AlbumObject> children = ao.getChildren();
                for (AlbumObject child : children) {
                    if (!child.isIncluded() || child.isFolder() || !child.isDisplayableImage()) continue;
                    return child;
                }
                for (AlbumObject child : children) {
                    if (!child.isFolder() || (rep = AlbumObjectImpl.getRepresentingAlbumObject(child, useThumbForFolderIcon, alreadyVisited)) == null) continue;
                    return rep;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return rep;
    }

    @Override
    public AlbumObject getParent() {
        return this.parent;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLastModified() {
        long last = this.file.lastModified();
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        last = Math.max(propFile.lastModified(), last);
        if (this.file.isDirectory()) {
            File metaFile = new File(this.file, META_FILE_NAME);
            last = Math.max(metaFile.lastModified(), last);
            File albumFilesFile = new File(this.file, ALBUMFILES_FILE_NAME);
            last = Math.max(albumFilesFile.lastModified(), last);
        }
        return last;
    }

    @Override
    public Image loadImage() throws IOException {
        return this.loadImage(false, null);
    }

    @Override
    public Image loadImage(boolean useFastLoading, Dimension imageDim) throws IOException {
        BufferedImage im;
        if (!this.isDisplayableImage()) {
            return null;
        }
        if (useFastLoading) {
            int scale = FileFilters.calculateSubsamplingByScale(this.file, imageDim);
            im = FileFilters.loadImage(this.file, scale);
        } else {
            im = FileFilters.loadImage(this.file);
        }
        this.getMetadata();
        if (im.getWidth() > im.getHeight()) {
            return RotationSupport.adjustOrientation(im, this.file);
        }
        return im;
    }

    @Override
    public AlbumObjectFactory getFactory() {
        return this.factory;
    }

    @Override
    public void rotateLeft() throws IOException {
        this.thumbnailCache.clear();
        int r = RotationSupport.getOrientation(this.meta.metadata);
        RotationSupport.Orientation o = RotationSupport.Orientation.fromValue(r);
        RotationSupport.setOrientation(o.next().getValue(), this.file);
        this.firePropertyChange("orientation", r, o.next().getValue());
        this.meta = null;
        this.getMetadata();
    }

    @Override
    public void rotateRight() throws IOException {
        this.thumbnailCache.clear();
        int r = RotationSupport.getOrientation(this.meta.metadata);
        RotationSupport.Orientation o = RotationSupport.Orientation.fromValue(r);
        RotationSupport.setOrientation(o.previous().getValue(), this.file);
        this.firePropertyChange("orientation", r, o.previous().getValue());
        this.meta = null;
        this.getMetadata();
        this.meta = null;
        this.getMetadata();
    }

    private void deleteFromParent() throws IOException {
        AlbumObjectImpl pao = (AlbumObjectImpl)this.parent;
        if (pao != null) {
            List<AlbumObject> parentChildren = pao.getChildren();
            parentChildren.remove(this);
            pao.setChildren(parentChildren);
        }
    }

    @Override
    public void delete() throws IOException, PermissionException {
        File cachedThumbnailFile;
        if (this.parent != null && !this.isFolder()) {
            this.setClassicComment("");
        }
        if (!this.isLink()) {
            try {
                File thumbFile = IO.thumbFile(this.file);
                if (Platform.isMac()) {
                    if (!FileManager.moveToTrash((File)this.file)) {
                        throw new IOException("Unable to recycle");
                    }
                    if (thumbFile.exists()) {
                        thumbFile.delete();
                    }
                } else {
                    FileUtil fu = new FileUtil();
                    fu.recycle(this.file);
                    if (thumbFile.exists()) {
                        thumbFile.delete();
                    }
                }
            }
            catch (Throwable t) {
                if (this.isFolder()) {
                    List<AlbumObject> children = this.getChildren();
                    if (children.size() > 0) {
                        throw new PermissionException(Msg.get("edit.folderNotEmptyError", this.getName()));
                    }
                    this.deleteFolderSafely(this.file);
                }
                this.file.delete();
                IO.thumbFile(this.file).delete();
            }
        }
        File aop = AlbumObjectProperties.getPropertyFile(this.file);
        if (aop.exists()) {
            aop.delete();
        }
        if ((cachedThumbnailFile = this.getCachedThumbnailFile(this.file)).exists()) {
            cachedThumbnailFile.delete();
        }
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        albumSynchronizer.delete(this);
        this.deleteFromParent();
    }

    private boolean deleteFolderSafely(File folder) throws IOException {
        File f = new File(folder, COMMENTS_FILE_NAME);
        f.delete();
        f = new File(folder, META_FILE_NAME);
        f.delete();
        f = new File(folder, ALBUMFILES_FILE_NAME);
        f.delete();
        File jalbumFolder = new File(folder, JALBUM_FOLDER_NAME);
        if (jalbumFolder.exists()) {
            AlbumObjectImpl.deleteDirRecursively(jalbumFolder);
        }
        File dsStore = new File(folder, ".DS_Store");
        dsStore.delete();
        File thumbsDb = new File(folder, "THUMBS.DB");
        thumbsDb.delete();
        return folder.delete();
    }

    private static void deleteDirRecursively(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                AlbumObjectImpl.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private String uniqueName(String suggestedName) {
        String base = IO.baseName(suggestedName);
        String ext = IO.extensionOf(suggestedName);
        if (ext.length() > 0) {
            ext = "." + ext;
        }
        String name = suggestedName;
        int i = 1;
        while (this.containsName(name)) {
            name = base + "-" + i + ext;
            ++i;
        }
        return name;
    }

    @Override
    public AlbumObject createFolder(String suggestedName) throws IOException {
        File folderFile = new File(this.file, this.uniqueName(suggestedName));
        folderFile.mkdir();
        AlbumObject ao = this.factory.createInstance(folderFile, this);
        this.getChildren().add(ao);
        this.setChildren(this.getChildren());
        return ao;
    }

    @Override
    public AlbumObject createPage(String suggestedName) throws IOException {
        File progDir = Config.getConfig().progDir;
        return this.createPage(suggestedName, new File(progDir, "system/empty-page.htt"));
    }

    @Override
    public AlbumObject createPage(String suggestedName, File original) throws IOException {
        File pageFile = new File(this.file, this.uniqueName(suggestedName));
        IO.copyFile(original, pageFile);
        AlbumObject ao = this.factory.createInstance(pageFile, this);
        AlbumObjectProperties props = ao.getProperties();
        props.put("originalPath", original.getAbsolutePath());
        props.save();
        this.getChildren().add(ao);
        this.setChildren(this.getChildren());
        return ao;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getWebName() {
        return this.factory.engine.getTargetName(this.getName());
    }

    @Override
    public boolean setName(String newName) {
        newName = newName.trim();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        String oldName = this.file.getName();
        File renamedFile = new File(this.file.getParentFile(), newName);
        if (!this.isFolder() && !IO.extensionOf(newName).equalsIgnoreCase(IO.extensionOf(this.file))) {
            newName = IO.baseName(renamedFile) + "." + IO.extensionOf(this.file);
            renamedFile = new File(renamedFile.getParentFile(), newName);
        }
        if (this.getParent() != null && !oldName.equalsIgnoreCase(newName) && this.getParent().containsName(newName) || newName.length() == 0) {
            return false;
        }
        if (this.isLink()) {
            renamedFile = new LinkFile(((LinkFile)this.file).getLink().getParentFile(), renamedFile.getName(), this.file.getAbsoluteFile());
        }
        if (this.file.renameTo(renamedFile)) {
            if (this.parent != null) {
                AlbumObjectImpl.setComment(this.getComment(), renamedFile, this.file);
            } else {
                this.factory.engine.setDirectory(renamedFile.getAbsolutePath());
            }
            File propFile = AlbumObjectProperties.getPropertyFile(this.file);
            File renamedPropFile = AlbumObjectProperties.getPropertyFile(renamedFile);
            if (propFile.exists()) {
                propFile.renameTo(renamedPropFile);
            }
            File thumbFile = this.getCachedThumbnailFile(this.file);
            File renamedThumbFile = this.getCachedThumbnailFile(renamedFile);
            if (thumbFile.exists()) {
                thumbFile.renameTo(renamedThumbFile);
            }
            File fromTranslated = albumSynchronizer.translate(this);
            this.file = renamedFile;
            File toTranslated = albumSynchronizer.translate(this);
            albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
            try {
                if (this.parent != null) {
                    this.parent.setChildren(this.parent.getChildren());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.invalidate();
            this.category = null;
            this.firePropertyChange("name", oldName, newName);
            if (newName.equals(this.factory.engine.getResourceDirectory())) {
                this.setHidden(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getComment() {
        String comment;
        XmpManager mgr;
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isFolder()) {
            try {
                Map props = this.getFolderProperties();
                this.comment = (String)props.get("descript");
                return this.comment != null ? this.comment : "";
            }
            catch (IOException ex) {
                return "";
            }
        }
        if (this.factory.engine.isReadXmp() && (mgr = this.getXmpManager()) != null && (comment = mgr.getDescription()) != null) {
            return comment;
        }
        this.getMetadata();
        this.comment = this.factory.engine.readComment(this.file, this.parent != null ? this.parent.getFile() : this.file.getParentFile(), this.meta.metadata);
        return this.comment;
    }

    private void setClassicComment(String newComment) throws IOException {
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            props.put("descript", newComment);
            this.setFolderProperties(props);
        } else {
            AlbumObjectImpl.setComment(newComment, this.file, this.file);
        }
        this.comment = newComment;
    }

    private void setXmpComment(String newComment) {
        XmpManager xmpProps;
        if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                xmpProps.setDescription(newComment);
                xmpProps.save();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void setComment(String newComment) throws IOException {
        String oldComment = this.comment;
        if (newComment.equals(oldComment)) {
            return;
        }
        this.setClassicComment(newComment);
        this.setXmpComment(newComment);
        this.firePropertyChange("comment", oldComment, newComment);
    }

    @Override
    public String getTitle() {
        AlbumObjectMetadata aoMeta;
        Metadata md;
        String title;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (title = xmpProps.getTitle()) != null) {
            return title;
        }
        AlbumObjectProperties aop = this.getProperties();
        title = (String)aop.get("title");
        if (title == null && (md = (aoMeta = this.getMetadata()).getMetadata()) != null && md.containsDirectory(IptcDirectory.class)) {
            IptcDirectory iptc = (IptcDirectory)md.getDirectory(IptcDirectory.class);
            switch (this.factory.engine.getTitleSource()) {
                case IPTCObjectName: {
                    if (!iptc.containsTag(517)) break;
                    title = iptc.getString(517);
                    break;
                }
                case IPTCHeadline: {
                    if (!iptc.containsTag(617)) break;
                    title = iptc.getString(617);
                }
            }
        }
        return title != null ? title : "";
    }

    @Override
    public boolean setTitle(String newTitle) {
        String oldTitle = this.getTitle();
        if (!newTitle.equals(oldTitle)) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setTitle(newTitle);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("title", newTitle);
            return aop.save(false);
        }
        return true;
    }

    @Override
    public int getRating() {
        Integer rating;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (rating = xmpProps.getRating()) != null) {
            return rating;
        }
        AlbumObjectProperties aop = this.getProperties();
        Integer r = (Integer)aop.get("rating");
        if (r == null) {
            r = new Integer(0);
        }
        return r;
    }

    @Override
    public void setRating(int rating) {
        int oldRating = this.getRating();
        if (rating != oldRating) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setRating(rating);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("rating", rating);
            aop.save(false);
        }
    }

    @Override
    public Flag getFlag() {
        AlbumObjectProperties aop;
        Flag flag;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                return xmpProps.getFlag();
            }
            catch (XMPException ex) {
                // empty catch block
            }
        }
        return (flag = (Flag)((Object)(aop = this.getProperties()).get("flag"))) != null ? flag : Flag.NoFlag;
    }

    @Override
    public void setFlag(Flag flag) {
        Flag oldFlag = this.getFlag();
        if (flag != oldFlag) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setFlag(flag);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            if (flag == Flag.NoFlag) {
                aop.remove("flag");
            } else {
                aop.put("flag", (Object)flag);
            }
            aop.save(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileMetadataToXmp() throws XMPException, IOException {
        boolean readXmp;
        block6: {
            readXmp = this.factory.engine.isReadXmp();
            this.factory.engine.setReadXmp(false);
            try {
                Integer rating;
                AlbumObjectProperties aop;
                String title;
                XmpManager xmpProps = this.getXmpManager();
                int modCount = 0;
                if (xmpProps == null) break block6;
                if (this.getComment().length() > 0) {
                    xmpProps.setDescription(this.getComment());
                    ++modCount;
                }
                if ((title = (String)(aop = this.getProperties()).get("title")) != null) {
                    xmpProps.setTitle(title);
                    ++modCount;
                }
                if ((rating = (Integer)aop.get("rating")) != null) {
                    xmpProps.setRating(rating);
                    ++modCount;
                }
                if (modCount <= 0) break block6;
                xmpProps.save();
                boolean bl = true;
                Object var9_9 = null;
                this.factory.engine.setReadXmp(readXmp);
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.factory.engine.setReadXmp(readXmp);
                throw throwable;
            }
        }
        boolean bl = false;
        Object var9_10 = null;
        this.factory.engine.setReadXmp(readXmp);
        return bl;
    }

    @Override
    public String getPathFromRoot() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.getParent() == null) {
            return this.getName();
        }
        return this.parent.getPathFromRoot() + '/' + this.getName();
    }

    @Override
    public AlbumObjectMetadata getMetadata() {
        if (this.meta == null) {
            try {
                this.meta = new AlbumObjectMetadata(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.meta;
    }

    @Override
    public AlbumObjectProperties getProperties() {
        AlbumObjectProperties aop;
        AlbumObjectProperties albumObjectProperties = aop = this.properties != null ? this.properties.get() : null;
        if (aop == null) {
            aop = new AlbumObjectProperties(this);
            this.properties = new SoftReference<AlbumObjectProperties>(aop);
        }
        return aop;
    }

    @Override
    public XmpManager getXmpManager() {
        XmpManager xmpProps;
        XmpManager xmpManager = xmpProps = this.xmpProperties != null ? this.xmpProperties.get() : null;
        if (xmpProps == null && !this.isFolder() && this.isJPEGImage()) {
            try {
                xmpProps = new XmpManager(this);
                this.xmpProperties = new SoftReference<XmpManager>(xmpProps);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return xmpProps;
    }

    private boolean isJPEGImage() {
        String name = this.getFile().getName().toLowerCase();
        return name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    @Override
    public boolean isDisplayableImage() {
        return this.file.exists() && !FileFilters.hasIcon(this.file);
    }

    @Override
    public boolean isLink() {
        return this.file instanceof LinkFile;
    }

    @Override
    public boolean isFolder() {
        return this.file.isDirectory();
    }

    @Override
    public Category getCategory() {
        if (this.category == null) {
            if (this.isFolder()) {
                this.category = Category.folder;
            } else if (this.isDisplayableImage()) {
                this.category = Category.image;
            } else {
                this.category = Category.other;
                FileFilters.FileType ft = FileFilters.getFileType(this.file);
                if (ft != null && "Web page template".equals(ft.name)) {
                    this.category = Category.webPage;
                }
            }
        }
        return this.category;
    }

    @Override
    public boolean isIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        boolean oldIncluded = this.included;
        this.included = included;
        this.firePropertyChange("included", oldIncluded, included);
    }

    @Override
    public boolean isHidden() {
        AlbumObjectProperties aop = this.getProperties();
        Boolean hidden = (Boolean)aop.get("hidden");
        return hidden != null ? hidden : false;
    }

    @Override
    public void setHidden(boolean hidden) {
        boolean oldHidden = this.isHidden();
        AlbumObjectProperties aop = this.getProperties();
        aop.put("hidden", hidden);
        aop.save(false);
        this.firePropertyChange("hidden", oldHidden, hidden);
    }

    @Override
    public boolean isWithin(AlbumObject parent) {
        for (AlbumObject ao = this; ao != null; ao = ao.getParent()) {
            if (ao != parent) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlbumObject> getChildren() {
        List<AlbumObject> children;
        List<AlbumObject> list = children = this.children != null ? this.children.get() : null;
        if (this.isFolder() && children == null) {
            AlbumObjectImpl albumObjectImpl = this;
            synchronized (albumObjectImpl) {
                List<AlbumObject> list2 = children = this.children != null ? this.children.get() : null;
                if (children == null) {
                    children = new ArrayList<AlbumObject>();
                    if (!this.file.equals(this.fc.getBaseDir())) {
                        this.fc = new FileCollection(this.factory.engine, this.file);
                    }
                    this.fc.setDoSort(true);
                    File[] files = this.fc.listFiles(this.factory.getFilter(), this.factory.isIncludeExcluded(), this.factory.isIncludeMissing());
                    FileNamerContext context = new FileNamerContext(this);
                    for (File f : files) {
                        AlbumObject ao = this.factory.createInstance(f, context);
                        if (this.fc.isExcluded(f)) {
                            ao.setIncluded(false);
                        }
                        if (ao.getName().equals(this.factory.engine.getResourceDirectory())) {
                            ao.setHidden(true);
                        }
                        children.add(ao);
                    }
                    this.children = new SoftReference<List<AlbumObject>>(children);
                }
            }
        }
        return children;
    }

    @Override
    public AlbumObject getChild(String path) {
        int slashIndex = (path = path.toLowerCase()).indexOf(47);
        if (slashIndex >= 0) {
            AlbumObject child = this.getChild(path.substring(0, slashIndex));
            if (child != null) {
                return child.getChild(path.substring(slashIndex + 1));
            }
        } else {
            Map<String, AlbumObject> nm = this.getNameMap();
            return nm != null ? nm.get(path) : null;
        }
        return null;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = new SoftReference<List<AlbumObject>>(children);
        this.nameMap = null;
        StringBuilder content = new StringBuilder();
        content.append("# This file is created by JAlbum. It sets custom file filtering and ordering for this image directory.\r\n# Each row indicate a file and it's order. Files not listed here are added to the end of the album\r\n# Rows beginning with \"-\" indicate excluded files.\r\n# Rows containing a tab character indicate links, where the text before the tab is the logical file name\r\n# and the path to the right is the target path.\r\n# Note: This file allows absolute paths to files and directories in other locations and thereby\r\n# allows you to compile albums consisting of files from several different locations.\r\n\r\n");
        for (AlbumObjectImpl albumObjectImpl : children) {
            if (!albumObjectImpl.isIncluded()) {
                content.append('-');
            }
            content.append(albumObjectImpl.file.getName());
            if (albumObjectImpl.file instanceof LinkFile) {
                content.append('\t');
                content.append(albumObjectImpl.file.getAbsolutePath());
            }
            content.append("\r\n");
        }
        File file = new File(this.file, ALBUMFILES_FILE_NAME);
        String textEncoding = this.factory.engine.isWriteUTF8() ? "UTF-8" : this.factory.engine.getTextEncoding();
        String s = content.toString();
        if (!textEncoding.equals("UTF-8") && !StringCodec.isEncodable(s, textEncoding)) {
            textEncoding = "UTF-8";
        }
        IO.writeTextFile(s, file, textEncoding);
        this.firePropertyChange("children", null, children);
    }

    @Override
    public boolean containsName(String name) {
        return this.getNameMap().containsKey(name.toLowerCase());
    }

    @Override
    public void moveTo(AlbumObject newParent) throws IOException {
        this.moveTo(newParent, -1);
    }

    @Override
    public boolean repairLink(File newTarget) throws IOException {
        if (!this.isLink() || this.file.exists() || !newTarget.exists()) {
            return false;
        }
        this.file = new LinkFile(((LinkFile)this.file).getLink().getParentFile(), this.file.getName(), newTarget);
        this.invalidate();
        this.parent.setChildren(this.parent.getChildren());
        return true;
    }

    @Override
    public void moveTo(AlbumObject newParent, int position) throws IOException {
        File newFile;
        if (!newParent.isFolder()) {
            throw new IllegalArgumentException("Argument must be a folder");
        }
        if (newParent.containsName(this.getName())) {
            throw new IOException(Msg.get("edit.objectAlreadyExists", this.getName()));
        }
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        File fromTranslated = albumSynchronizer.translate(this);
        if (this.isLink()) {
            newFile = new LinkFile(newParent.getFile(), this.getName(), this.file.getAbsoluteFile());
        } else {
            newFile = new File(newParent.getFile(), this.getName());
            if (!this.file.renameTo(newFile)) {
                throw new IOException(Msg.get("edit.moveError", this.file, newFile));
            }
            IO.thumbFile(this.file).renameTo(IO.thumbFile(newFile));
        }
        if (this.parent != null) {
            AlbumObjectImpl.setComment(this.getComment(), newFile, this.file);
        }
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        File renamedPropFile = AlbumObjectProperties.getPropertyFile(newFile);
        if (propFile.exists()) {
            renamedPropFile.getParentFile().mkdir();
            propFile.renameTo(renamedPropFile);
        }
        File thumbFile = this.getCachedThumbnailFile(this.file);
        File renamedThumbFile = this.getCachedThumbnailFile(newFile);
        if (thumbFile.exists()) {
            renamedThumbFile.getParentFile().mkdirs();
            thumbFile.renameTo(renamedThumbFile);
        }
        this.invalidate();
        this.deleteFromParent();
        this.file = newFile;
        this.parent = newParent;
        List<AlbumObject> l = newParent.getChildren();
        if (position != -1) {
            l.add(position, this);
        } else {
            l.add(this);
        }
        newParent.setChildren(l);
        File toTranslated = albumSynchronizer.translate(this);
        albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<File> files) throws IOException {
        List<AlbumObject> children = this.getChildren();
        try {
            for (File f : files) {
                if (this.containsName(f.getName())) {
                    throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                }
                AlbumObject ao = this.factory.createInstance((File)new LinkFile(this.file, f.getName(), f), this);
                children.add(ao);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setChildren(children);
            throw throwable;
        }
        this.setChildren(children);
    }

    @Override
    public void add(Set<AlbumObject> objects) throws IOException {
        this.add(this.getChildren().size(), objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Set<AlbumObject> objects) throws IOException {
        List<AlbumObject> children = this.getChildren();
        try {
            for (AlbumObject ao : objects) {
                ((AlbumObjectImpl)ao).parent = this;
            }
            if (index < children.size()) {
                int indexAfterRemoval = index;
                Iterator<AlbumObject> it = children.iterator();
                for (int i = 0; i < index && it.hasNext(); ++i) {
                    AlbumObject ao = it.next();
                    if (!objects.contains(ao)) continue;
                    this.nameMap.remove(ao.getName().toLowerCase());
                    it.remove();
                    --indexAfterRemoval;
                }
                children.removeAll(objects);
                children.addAll(indexAfterRemoval, objects);
            } else {
                children.removeAll(objects);
                children.addAll(objects);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.setChildren(children);
            throw throwable;
        }
        this.setChildren(children);
    }

    @Override
    public String getOrdering() {
        return this.fc.getOrdering();
    }

    @Override
    public void setOrdering(String ordering) throws IOException {
        this.fc.setOrdering(ordering);
    }

    @Override
    public String getFolderOrdering() {
        return this.fc.getFolderOrdering();
    }

    @Override
    public void setFolderOrdering(String folderOrdering) throws IOException {
        this.fc.setFolderOrdering(folderOrdering);
    }

    @Override
    public boolean isFoldersFirst() {
        return this.fc.isFoldersFirst();
    }

    @Override
    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.fc.setFoldersFirst(foldersFirst);
    }

    @Override
    public boolean isReverseOrdering() {
        return this.fc.isReverseOrdering();
    }

    @Override
    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.fc.setReverseOrdering(reverseOrdering);
    }

    @Override
    public boolean isReverseFolderOrdering() {
        return this.fc.isReverseFolderOrdering();
    }

    @Override
    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.fc.setReverseFolderOrdering(reverseFolderOrdering);
    }

    @Override
    public void invalidate() {
        this.children = null;
        this.nameMap = null;
    }

    private static BufferedImage cropToShape(BufferedImage bi, Dimension dDim) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        double sAspekt = (double)sDim.width / (double)sDim.height;
        double dAspekt = (double)dDim.width / (double)dDim.height;
        if (sAspekt > dAspekt) {
            int newWidth = (int)(dAspekt * (double)sDim.height);
            return bi.getSubimage((sDim.width - newWidth) / 2, 0, newWidth, sDim.height);
        }
        if (sAspekt < dAspekt) {
            int newHeight = (int)((double)sDim.width / dAspekt);
            return bi.getSubimage(0, (sDim.height - newHeight) / 6, sDim.width, newHeight);
        }
        return bi;
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean enlarge) throws IOException {
        return this.getRepresentingIcon(bounds, false, enlarge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean cropToBounds, boolean enlarge) throws IOException {
        block27: {
            ImageIcon rep = this.thumbnailCache.getIcon(bounds, cropToBounds);
            if (rep != null) {
                return rep;
            }
            if (!this.isDisplayableImage()) {
                Graphics2D g;
                ImageIcon repIcon = null;
                if (this.getRepresentingAlbumObject() != null) {
                    repIcon = this.representingAlbumObject.getRepresentingIcon(bounds, enlarge);
                    if (this.isFolder() && !this.representingAlbumObject.isFolder() && repIcon != null) {
                        Image ri = repIcon.getImage();
                        ri = this.factory.engine.createBufferedImage(ri);
                        g = (Graphics2D)ri.getGraphics();
                        Image fi = faintFolderIcon.getImage();
                        g.drawImage(fi, (ri.getWidth(null) - fi.getWidth(null)) / 2, (ri.getHeight(null) - fi.getHeight(null)) / 2, null);
                        g.dispose();
                        repIcon = new ImageIcon(ri);
                    }
                } else {
                    repIcon = !this.file.exists() ? brokenLinkIcon : (this.isFolder() ? folderIcon : new ImageIcon(FileFilters.getIconFor(this.file, this.factory.engine).toURL()));
                }
                if (!this.isHidden()) return repIcon;
                BufferedImage im = new BufferedImage(repIcon.getIconWidth(), repIcon.getIconHeight(), 6);
                g = im.createGraphics();
                AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
                g.setComposite(composite);
                g.drawImage(repIcon.getImage(), 0, 0, null);
                return new ImageIcon(im);
            }
            try {
                File thumbnailFile = this.getCachedThumbnailFile(this.file);
                if (thumbnailFile.exists()) {
                    if (thumbnailFile.lastModified() < this.file.lastModified()) {
                        this.updateRepresentingIcon();
                    }
                    BufferedImage bi = FileFilters.loadImage(thumbnailFile);
                    if (cropToBounds) {
                        bi = AlbumObjectImpl.cropToShape(bi, bounds);
                    }
                    ImageIcon ii = new ImageIcon(bi);
                    ii = RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, enlarge), this.file);
                    this.thumbnailCache.update(ii, bounds, cropToBounds);
                    return ii;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.getMetadata();
                if (this.meta.metadata != null && this.meta.metadata.containsDirectory(ExifDirectory.class)) {
                    Directory dir = this.meta.metadata.getDirectory(ExifDirectory.class);
                    byte[] rawImage = (byte[])dir.getObject(61441);
                    ImageIcon ii = new ImageIcon(rawImage);
                    if (cropToBounds) {
                        BufferedImage bi = AlbumObjectImpl.ensureBuffered(ii);
                        bi = AlbumObjectImpl.cropToShape(bi, bounds);
                        ii = new ImageIcon(bi);
                    }
                    ii = RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, enlarge), this.file);
                    this.thumbnailCache.update(ii, bounds, cropToBounds);
                    return ii;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                ImageInputStream iis;
                block28: {
                    ImageIcon imageIcon;
                    Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(this.file));
                    if (!it.hasNext()) break block27;
                    ImageReader ir = it.next();
                    iis = null;
                    try {
                        BufferedImage bi;
                        iis = ImageIO.createImageInputStream(this.file);
                        ir.setInput(iis);
                        int minIndex = ir.getMinIndex();
                        if (!ir.hasThumbnails(minIndex) || (bi = ir.readThumbnail(minIndex, minIndex)) == null) break block28;
                        if (cropToBounds) {
                            bi = AlbumObjectImpl.cropToShape(bi, bounds);
                        }
                        ImageIcon ii = RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(new ImageIcon(bi), bounds, enlarge), this.file);
                        this.thumbnailCache.update(ii, bounds, cropToBounds);
                        imageIcon = ii;
                        Object var13_28 = null;
                        if (iis == null) return imageIcon;
                    }
                    catch (Throwable throwable) {
                        Object var13_30 = null;
                        if (iis == null) throw throwable;
                        iis.close();
                        throw throwable;
                    }
                    iis.close();
                    return imageIcon;
                }
                Object var13_29 = null;
                if (iis != null) {
                    iis.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            int scale = FileFilters.calculateSubsamplingByScale(this.file, THUMBNAIL_DIMENSION);
            BufferedImage bi = FileFilters.loadImage(this.file, scale);
            if (cropToBounds) {
                bi = AlbumObjectImpl.cropToShape(bi, bounds);
            }
            ImageIcon ii = new ImageIcon(bi);
            try {
                this.setRepresentingIcon(bi, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ii = RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(new ImageIcon(bi), bounds, enlarge), this.file);
                this.thumbnailCache.update(ii, bounds, cropToBounds);
                return ii;
            }
            catch (Exception e) {
                // empty catch block
            }
            return ii;
        }
        catch (Exception e) {
            return AlbumObjectImpl.scaleToFit(brokenImageIcon, bounds, enlarge);
        }
    }

    @Override
    public File getRepresentingIconFile() {
        if (this.getRepresentingAlbumObject() != null) {
            return this.representingAlbumObject.getRepresentingIconFile();
        }
        if (this.isFolder()) {
            return null;
        }
        return this.file;
    }

    @Override
    public void setRepresentingAlbumObject(AlbumObject rep) {
        try {
            AlbumObject oldRep = this.getRepresentingAlbumObject();
            Map props = this.getFolderProperties();
            if (rep == null) {
                props.remove("folderIcon");
                this.representingAlbumObject = null;
            } else {
                String path = IO.relativePath(rep.getPathFromRoot(), this.getPathFromRoot());
                props.put("folderIcon", path);
                this.representingAlbumObject = rep;
            }
            this.setFolderProperties(props);
            this.firePropertyChange("representingAlbumObject", oldRep, this.representingAlbumObject);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public String getThumbnailPath() {
        AlbumObject rep = AlbumObjectImpl.getRepresentingAlbumObject(this, true);
        if (rep != null) {
            String name;
            String pathFromRoot = rep.getPathFromRoot();
            String path = "";
            int slashIndex = pathFromRoot.lastIndexOf(47);
            if (slashIndex == -1) {
                name = pathFromRoot;
            } else {
                path = pathFromRoot.substring(0, slashIndex);
                name = pathFromRoot.substring(slashIndex + 1);
            }
            path = IO.combinePaths(path, this.factory.engine.getThumbnailDirectory());
            path = IO.combinePaths(path, this.factory.engine.getThumbnailPrefix() + this.factory.engine.getTargetName(name));
            return path;
        }
        return null;
    }

    public static ImageIcon scaleToFit(ImageIcon ii, Dimension boundingBox, boolean enlarge) {
        int width = ii.getIconWidth();
        int height = ii.getIconHeight();
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return ii;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        BufferedImage scaled = AlbumObjectImpl.ensureBuffered(ii.getImage(), width, height);
        scaled = GraphicsUtilities.getFasterScaledInstance(scaled, newWidth, newHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        return new ImageIcon(scaled);
    }

    private static BufferedImage ensureBuffered(ImageIcon ii) {
        return AlbumObjectImpl.ensureBuffered(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 6);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AlbumObject)) {
            return false;
        }
        AlbumObjectImpl otherAO = (AlbumObjectImpl)o;
        return this.getName().equals(otherAO.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    static void setComment(String comment, File file, File oldFile) {
        boolean done = false;
        try {
            Map<String, String> map;
            File oldMapFile = new File(AlbumObjectImpl.getAlbumParentFile(oldFile), COMMENTS_FILE_NAME);
            File newMapFile = new File(AlbumObjectImpl.getAlbumParentFile(file), COMMENTS_FILE_NAME);
            if (oldMapFile.exists()) {
                map = IO.readMapFile(oldMapFile);
                if (oldFile != null) {
                    map.remove(oldFile.getName());
                }
                if (newMapFile.equals(oldMapFile)) {
                    if (comment.length() > 0) {
                        map.put(file.getName(), comment);
                    } else {
                        map.remove(file.getName());
                    }
                    done = true;
                }
                IO.writeMapFile(map, oldMapFile);
                if (done) {
                    return;
                }
            }
            map = new HashMap();
            if (newMapFile.exists()) {
                map = IO.readMapFile(newMapFile);
            }
            if (comment.length() > 0) {
                map.put(file.getName(), comment);
            } else {
                map.remove(file.getName());
            }
            IO.writeMapFile(map, newMapFile);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private Map getFolderProperties() throws IOException {
        return AlbumBean.getFolderProperties(this.file);
    }

    private void setFolderProperties(Map properties) throws IOException {
        IO.writeMapFile(properties, new File(this.file, META_FILE_NAME));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor element : flavors) {
            if (!flavor.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        if (flavor.equals(flavors[1])) {
            return new File[]{this.file};
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void setRepresentingIcon(BufferedImage thumbnail, boolean changed) throws IOException {
        if (this.factory.isCacheThumbnails()) {
            try {
                int existingOrientation = RotationSupport.getOrientation(this.file);
                if (existingOrientation == 6) {
                    existingOrientation = 8;
                } else if (existingOrientation == 8) {
                    existingOrientation = 6;
                }
                thumbnail = RotationSupport.adjustOrientation(thumbnail, existingOrientation);
            }
            catch (IOException ex) {
                // empty catch block
            }
            AlbumImage ai = new AlbumImage(thumbnail, this.factory.engine);
            ai = ai.scaleToFit(THUMBNAIL_DIMENSION);
            File thumbnailFile = this.getCachedThumbnailFile(this.file);
            thumbnailFile.getParentFile().mkdirs();
            ai.saveJPEG(thumbnailFile);
            this.thumbnailCache.clear();
        }
        if (changed) {
            this.firePropertyChange("imageUpdated", null, null);
        }
    }

    @Override
    public void updateRepresentingIcon() throws IOException {
        int scale = FileFilters.calculateSubsamplingByScale(this.file, THUMBNAIL_DIMENSION);
        BufferedImage im = FileFilters.loadImage(this.file, scale);
        if (im.getWidth() > im.getHeight()) {
            im = RotationSupport.adjustOrientation(im, this.file);
        }
        FilterRenderer filterRenderer = new FilterRenderer();
        AlbumObjectProperties props = this.getProperties();
        FilterList fl = (FilterList)props.get("filterList");
        if (fl != null) {
            filterRenderer.setFilterList(fl);
            im = filterRenderer.applyPrescaleFilters(im);
            im = this.factory.engine.scaleToFit(im, new Dimension(600, 600), "ScaleFast");
            im = filterRenderer.applyPostscaleFilters(im);
        }
        this.setRepresentingIcon(im, true);
    }

    static File getThumbnailsFolder(File f) {
        return new File(AlbumObjectImpl.getJAlbumFolder(f), THUMBNAILS_FOLDER);
    }

    private File getCachedThumbnailFile(File f) {
        return new File(AlbumObjectImpl.getThumbnailsFolder(f), this.factory.engine.getTargetName(f.getName()));
    }

    static File getAlbumParentFile(File f) {
        return f instanceof LinkFile ? ((LinkFile)f).getLink().getParentFile() : f.getParentFile();
    }

    static File getJAlbumFolder(File f) {
        return new File(AlbumObjectImpl.getAlbumParentFile(f), JALBUM_FOLDER_NAME);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        System.out.println("Read object called");
        ois.defaultReadObject();
        this.factory = JAlbumContext.getInstance().getAlbumObjectfactory();
        this.fc = new FileCollection(this.factory.engine, this.file);
        this.thumbnailCache = new ThumbnailCache();
    }

    @Override
    public Scope getVars() {
        if (this.vars == null && this.getParent() != null) {
            this.vars = new Scope(this.factory.engine.globalVariables);
            this.factory.engine.fileVariables.put(this.file, this.vars);
            try {
                this.factory.engine.registerVariables(this, new File(this.factory.engine.getInterpretedOutputDirectory(), this.getParent().getPathFromRoot()), true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot register variables for " + this.getName(), ex);
            }
        }
        return this.vars;
    }

    @Override
    public void setVars(Scope vars) {
        this.vars = vars;
    }

    private static class ThumbnailCache {
        ImageIcon icon;
        Dimension bounds;
        boolean cropToBounds;

        private ThumbnailCache() {
        }

        void update(ImageIcon icon, Dimension bounds, boolean cropToBounds) {
            this.icon = icon;
            this.bounds = bounds;
            this.cropToBounds = cropToBounds;
        }

        ImageIcon getIcon(Dimension bounds, boolean cropToBounds) {
            if (this.icon != null && this.bounds.equals(bounds) && this.cropToBounds == cropToBounds) {
                return this.icon;
            }
            return null;
        }

        private void clear() {
            this.icon = null;
        }
    }
}

