/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JButton;
import se.datadosen.util.Platform;

public class JToolBarButton
extends JButton {
    private boolean showLabel = true;
    private Action action;
    private boolean hoverStyle = false;
    private MouseListener myMouseListener;

    public JToolBarButton() {
        this.init();
    }

    public JToolBarButton(Action action) {
        super(action);
        this.action = action;
        this.init();
    }

    public JToolBarButton(Action action, boolean showLabel) {
        super(action);
        this.action = action;
        this.showLabel = showLabel;
        this.init();
    }

    public boolean isHoverStyle() {
        return this.hoverStyle;
    }

    public void setHoverStyle(boolean hoverStyle) {
        this.hoverStyle = hoverStyle;
        this.setBorderPainted(!hoverStyle);
        this.setContentAreaFilled(!hoverStyle);
        if (hoverStyle) {
            this.addMouseListener(this.myMouseListener);
        } else {
            this.removeMouseListener(this.myMouseListener);
        }
    }

    private void init() {
        if (Platform.isMac()) {
            this.setFocusable(false);
            this.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.putClientProperty("JButton.segmentPosition", "only");
            this.setFont(this.getFont().deriveFont(0, 11.0f));
        } else {
            this.setMargin(new Insets(1, 2, 1, 3));
        }
        if (this.action != null) {
            this.setText((String)this.action.getValue("Name"));
        }
        this.myMouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JToolBarButton.this.setBorderPainted(true);
                JToolBarButton.this.setContentAreaFilled(true);
            }

            public void mouseExited(MouseEvent e) {
                JToolBarButton.this.setBorderPainted(false);
                JToolBarButton.this.setContentAreaFilled(false);
            }
        };
        this.setHoverStyle(this.hoverStyle);
    }

    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }
}

