/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.WindowUtilities;

public class LicenseManagerImpl
implements LicenseManager {
    protected final JAlbumContext context;
    public static final String JALBUM_SUPPORTER = "jAlbumSupporter";
    private PropertyChangeSupport changeSupport;
    protected Preferences preferences = Preferences.userNodeForPackage(LicenseManager.class);
    private JBackgroundTextField uacField;

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    LicenseManagerImpl(JAlbumContext context) {
        this.context = context;
    }

    public void activateLicense() {
        if (this.uacField == null) {
            this.uacField = new JBackgroundTextField(26);
            this.uacField.setBackgroundText("nnnnnn-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            WindowUtilities.setDefaultFocus(this.uacField);
        }
        WrappableJLabel info = new WrappableJLabel(Msg.get("ui.activateLicenseInfo"));
        info.setPreferredWidth(360);
        Object[] options = new Object[]{Msg.get("ui.activateLicense"), Msg.get("ui.signIn"), Msg.get("cancel")};
        int answer = JOptionPane.showOptionDialog(this.getWindow(), new Object[]{info, this.uacField}, Msg.get("ui.activateLicense"), 0, 1, null, options, options[0]);
        if (answer == 0) {
            this.checkLicenseStatus(this.uacField.getText());
        } else if (answer == 1) {
            SignInManager.getInstance().showDialog();
        }
    }

    public void backgroundCheckLicenseStatus() {
        Thread backgroundThread = new Thread("License authenticator"){

            public void run() {
                try {
                    String uic = LicenseManagerImpl.this.preferences.get("uic", null);
                    if (uic == null) {
                        return;
                    }
                    AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(uic);
                    LicenseManagerImpl.this.checkLicenseStatus(status);
                }
                catch (IOException ex) {
                }
                catch (AuthenticationException ex) {
                    LicenseManagerImpl.this.detachLicense();
                }
            }
        };
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void checkLicenseStatus(final String uic) {
        Thread backgroundThread = new Thread("License authenticator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        LicenseManagerImpl.this.getWindow().progressSpinner.workStarted();
                        AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(uic);
                        LicenseManagerImpl.this.checkLicenseStatus(status);
                        if (!LicenseManagerImpl.this.isLicenseValid()) {
                            JOptionPane.showMessageDialog(LicenseManagerImpl.this.getWindow(), Msg.get("activation.noLicenseError", LicenseManagerImpl.this.getUserName()), Msg.get("ui.activateLicense"), 2);
                        }
                        Object var3_4 = null;
                        LicenseManagerImpl.this.getWindow().progressSpinner.workDone();
                        return;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(LicenseManagerImpl.this.getWindow(), Msg.get("activation.ioProblem", ex.getMessage()), Msg.get("ui.activateLicense"), 0);
                        Object var3_5 = null;
                        LicenseManagerImpl.this.getWindow().progressSpinner.workDone();
                    }
                    catch (AuthenticationException ex) {
                        JOptionPane.showMessageDialog(LicenseManagerImpl.this.getWindow(), Msg.get("activation.authenticationError"), Msg.get("ui.activateLicense"), 0);
                        Object var3_6 = null;
                        LicenseManagerImpl.this.getWindow().progressSpinner.workDone();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    LicenseManagerImpl.this.getWindow().progressSpinner.workDone();
                    throw throwable;
                }
                LicenseManagerImpl.this.activateLicense();
            }
        };
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    void detachLicense() {
        if (this.getUserId() != -1) {
            if (this.uacField != null) {
                this.uacField.setText("");
            }
            this.preferences.putBoolean("validLicense", false);
            this.preferences.remove("username");
            this.preferences.remove("uic");
            try {
                this.preferences.flush();
                this.firePropertyChange("licenseValid", true, false);
                this.firePropertyChange("identified", true, false);
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void checkLicenseStatus(AccountManager.AccountStatus status) {
        boolean wasIdentified = this.getUserId() != -1;
        String userName = (String)status.get("username");
        String uic = (String)status.get("uic");
        String validLicense = (String)status.get("validLicense");
        this.preferences.put("username", userName);
        this.preferences.put("uic", uic);
        boolean isValid = "true".equals(validLicense);
        boolean wasValid = this.preferences.getBoolean("validLicense", false);
        this.preferences.putBoolean("validLicense", isValid);
        if (!wasIdentified) {
            this.firePropertyChange("identified", false, true);
        }
        if (isValid != wasValid) {
            this.firePropertyChange("licenseValid", wasValid, isValid);
        }
    }

    public String getUserName() {
        return this.preferences.get("username", "");
    }

    public int getUserId() {
        String uic = this.preferences.get("uic", null);
        try {
            if (uic != null) {
                int dashIndex = uic.indexOf(45);
                return Integer.parseInt(uic.substring(0, dashIndex));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public String getUIC() {
        return this.preferences.get("uic", null);
    }

    public boolean isLicenseValid() {
        return this.preferences.getBoolean("validLicense", false);
    }

    public String getLicenseCode() {
        return this.isLicenseValid() ? DigestUtil.md5(this.getUserName() + "part" + "of" + "it") : "";
    }

    public boolean isOldDonor() {
        return this.preferences.getBoolean(JALBUM_SUPPORTER, false);
    }

    protected JAlbumFrame getWindow() {
        return this.context.getFrame();
    }
}

