/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Metadata;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import se.datadosen.jalbum.AlbumBean;

public class MetaObjectCache
implements Map,
Serializable {
    private SoftReference<Map> meta;
    private File thisFile;

    public MetaObjectCache(Metadata data, File imageFile) {
        Map m = AlbumBean.getMetaObjectContent(data);
        this.meta = new SoftReference<Map>(m);
        this.thisFile = imageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map load() {
        Map res = this.meta.get();
        if (res == null) {
            MetaObjectCache metaObjectCache = this;
            synchronized (metaObjectCache) {
                if (this.meta.get() == null) {
                    try {
                        Metadata imageInfo = JpegMetadataReader.readMetadata((File)this.thisFile);
                        if (imageInfo == null) {
                            throw new RuntimeException("Can't read metadata for " + this.thisFile);
                        }
                        res = AlbumBean.getMetaObjectContent(imageInfo);
                        this.meta = new SoftReference<Map>(res);
                    }
                    catch (JpegProcessingException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return res;
    }

    public int size() {
        Map m = this.load();
        return m.size();
    }

    public boolean isEmpty() {
        Map m = this.load();
        return m.isEmpty();
    }

    public boolean containsKey(Object key) {
        Map m = this.load();
        return m.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Map m = this.load();
        return m.containsValue(value);
    }

    public Object get(Object key) {
        Map m = this.load();
        return m.get(key);
    }

    public Object put(Object key, Object value) {
        Map m = this.load();
        return m.put(key, value);
    }

    public Object remove(Object key) {
        Map m = this.load();
        return m.remove(key);
    }

    public void putAll(Map t) {
        Map m = this.load();
        m.putAll(t);
    }

    public void clear() {
        Map m = this.load();
        m.clear();
    }

    public Set keySet() {
        Map m = this.load();
        return m.keySet();
    }

    public Collection values() {
        Map m = this.load();
        return m.values();
    }

    public Set entrySet() {
        Map m = this.load();
        return m.entrySet();
    }

    public boolean equals(Object o) {
        Map m = this.load();
        return ((Object)m).equals(o);
    }

    public int hashCode() {
        Map m = this.load();
        return ((Object)m).hashCode();
    }

    public String toString() {
        Map m = this.load();
        return m.toString();
    }
}

