/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FilterPluginList;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.Main;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.IO;

public class PluginManager {
    private static final String PLUGIN_POSTFIX = "Plugin.class";
    public static final String JALBUM_PLUGIN_TYPE = ".jaext";
    private static List<JAlbumPlugin> plugins = new ArrayList<JAlbumPlugin>();

    static void loadPlugins() {
        File[] jars;
        PluginManager.loadPlugins(Config.getConfig().pluginsDir, "");
        for (File jar : jars = PluginManager.buildFileList(Config.getConfig().chainedExtDir)) {
            PluginManager.loadPlugins(jar);
        }
        FilterPluginList.getInstance().sort();
    }

    private static File[] buildFileList(File dir) {
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return s.endsWith(".jar") || s.endsWith(".zip") || s.endsWith(PluginManager.JALBUM_PLUGIN_TYPE);
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return files;
    }

    public static void registerPlugin(JAlbumPlugin plugin) {
        plugins.add(plugin);
    }

    private static void loadPlugins(File jarFile) {
        try {
            Preferences disabledPlugins = Preferences.userNodeForPackage(PluginManager.class).node("disabledPlugins");
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> files = zf.entries();
            while (files.hasMoreElements()) {
                String s;
                String className;
                ZipEntry e = files.nextElement();
                if (!e.getName().endsWith(PLUGIN_POSTFIX) || disabledPlugins.getBoolean(className = (s = e.getName()).substring(0, s.length() - 6).replace('/', '.'), false)) continue;
                PluginManager.createPlugin(className);
            }
        }
        catch (ZipException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadPlugins(File dir, String javaPackage) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                PluginManager.loadPlugins(f, javaPackage.length() == 0 ? f.getName() : javaPackage + "." + f.getName());
                continue;
            }
            if (!f.getName().endsWith(PLUGIN_POSTFIX)) continue;
            String className = javaPackage.length() == 0 ? IO.baseName(f) : javaPackage + "." + IO.baseName(f);
            PluginManager.createPlugin(className);
        }
    }

    private static void createPlugin(String className) {
        ClassLoader cl = Main.getJAlbumClassLoader();
        try {
            Class<?> c = cl.loadClass(className);
            if (PluginManager.isPlugin(c)) {
                Object o = c.newInstance();
                plugins.add((JAlbumPlugin)o);
            }
            if (PluginManager.isImageFilter(c)) {
                FilterPluginList.getInstance().addFilterClass(className);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (Throwable t) {
            System.err.println("Error loading plugin " + className + ": " + t.toString());
        }
    }

    private static boolean isPlugin(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumPlugin.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    private static boolean isImageFilter(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumImageFilter.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static void initPlugins() {
        for (JAlbumPlugin plugin : plugins) {
            try {
                plugin.init(JAlbumContext.getInstance().getPluginContext());
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    public static void installPlugin(File file) {
        try {
            ChainedDirectory chainedExtDir = Config.getConfig().chainedExtDir;
            chainedExtDir.mkdir();
            int answer = JOptionPane.showConfirmDialog(null, Msg.get("em.extensionInstallerInfo", IO.baseName(file)), Msg.get("em.extensionManagerTitle"), 2, 1);
            if (answer != 0) {
                return;
            }
            IO.copyFile(file, (File)chainedExtDir);
            JOptionPane.showMessageDialog(null, Msg.get("em.extensionInstalledInfo", chainedExtDir.getAbsolutePath()), Msg.get("em.extensionManagerTitle"), 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("em.extensionManagerTitle"), 0);
        }
    }

    public static boolean onExit() {
        boolean okToExit = true;
        for (JAlbumPlugin plugin : plugins) {
            try {
                boolean ok = plugin.onExit();
                if (ok) continue;
                okToExit = false;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        return okToExit;
    }
}

