/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.util.NoSuchElementException;
import java.util.Properties;
import se.datadosen.tags.ElementException;

public class AttributeTokenizer {
    private char[] buf;
    int offset = 0;

    public AttributeTokenizer(String text) {
        this.buf = text.toCharArray();
    }

    public AttributeTokenizer(String text, int startPosition) {
        this.buf = text.toCharArray();
        this.offset = startPosition;
    }

    public static Properties getProperties(String text) throws ElementException {
        Properties p = new Properties();
        AttributeTokenizer tokens = new AttributeTokenizer(text);
        while (tokens.hasMoreTokens()) {
            String n = tokens.nextName();
            String v = tokens.nextValue();
            p.setProperty(n, v);
        }
        return p;
    }

    public int getPosition() {
        return this.offset;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f';
    }

    public boolean hasMoreTokens() {
        this.offset = this.skipWhiteSpace();
        return this.offset != -1 && this.buf[this.offset] != '/' && this.buf[this.offset] != '>';
    }

    public int skipWhiteSpace() {
        for (int i = this.offset; i < this.buf.length; ++i) {
            if (this.isWhiteSpace(this.buf[i])) continue;
            return i;
        }
        return -1;
    }

    public int skipPastName() {
        int i;
        for (i = this.offset; i < this.buf.length; ++i) {
            if (!this.isWhiteSpace(this.buf[i]) && this.buf[i] != '=' && this.buf[i] != '/' && this.buf[i] != '>') continue;
            return i;
        }
        return i;
    }

    public int skipPastScriptlet(int i) {
        while (i < this.buf.length - 1) {
            if (this.buf[i] == '%' && this.buf[i + 1] == '>') {
                return i + 2;
            }
            ++i;
        }
        return -1;
    }

    public int skipPastValue() {
        int i;
        for (i = this.offset; i < this.buf.length; ++i) {
            if (this.isWhiteSpace(this.buf[i]) || this.buf[i] == '>') {
                return i;
            }
            if (this.buf[i] != '<' || i >= this.buf.length - 1 || this.buf[i + 1] != '%') continue;
            i = this.skipPastScriptlet(i + 2) - 1;
        }
        return i;
    }

    public int skipPastQuotation() {
        for (int i = this.offset; i < this.buf.length; ++i) {
            if (this.buf[i] == '\"') {
                return i + 1;
            }
            if (this.buf[i] != '<' || i >= this.buf.length - 1 || this.buf[i + 1] != '%') continue;
            i = this.skipPastScriptlet(i + 2) - 1;
        }
        return -1;
    }

    public String nextName() throws NoSuchElementException {
        this.offset = this.skipWhiteSpace();
        if (this.offset == -1) {
            throw new NoSuchElementException();
        }
        int endOffset = this.skipPastName();
        String s = new String(this.buf, this.offset, endOffset - this.offset);
        this.offset = endOffset;
        return s;
    }

    public String nextValue() throws NoSuchElementException, ElementException {
        int nextOffset = this.skipWhiteSpace();
        if (nextOffset == -1) {
            return null;
        }
        this.offset = nextOffset;
        if (this.buf[this.offset] == '/' || this.buf[this.offset] == '>') {
            return null;
        }
        if (this.offset == this.buf.length || this.buf[this.offset] != '=') {
            return null;
        }
        ++this.offset;
        this.offset = this.skipWhiteSpace();
        if (this.buf[this.offset] == '\"') {
            ++this.offset;
            int endOffset = this.skipPastQuotation();
            if (endOffset == -1) {
                throw new ElementException("No matching closing quote for attribute value");
            }
            String value = new String(this.buf, this.offset, endOffset - this.offset - 1);
            this.offset = endOffset;
            return value;
        }
        int endOffset = this.skipPastValue();
        String value = new String(this.buf, this.offset, endOffset - this.offset);
        this.offset = endOffset;
        return value;
    }
}

