/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.BandwidthThrottler;
import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.DirectoryEmptyStrings;
import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileNotFoundStrings;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.MLSXEntryParser;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.TransferCompleteStrings;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.127 2011-08-26 03:48:46 bruceb Exp $";
    public static final int DEFAULT_MONITOR_INTERVAL = 65535;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_PORT = 65535;
    public static final int DEFAULT_TIMEOUT = 60000;
    private static final int SHORT_TIMEOUT = 500;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_DELAY = 5000;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final byte[] FTP_LINE_SEPARATOR = new byte[]{13, 10};
    private static final String STOU_FILENAME_MARKER = "FILE:";
    private static final String STORE_CMD = "STOR ";
    private static final String STORE_UNIQ_CMD = "STOU ";
    private static final String MODTIME_STR = "modtime";
    public static Locale[] DEFAULT_LISTING_LOCALES;
    private static Logger log;
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    protected int timeout = 60000;
    protected int serverWakeupInterval = 0;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected String id;
    private static int masterId;
    protected int controlPort = 21;
    private boolean autoPassiveIPSubstitution = true;
    private String activeIP = null;
    protected String controlEncoding = "US-ASCII";
    private boolean strictReturnCodes = false;
    protected DirectoryEmptyStrings dirEmptyStrings = new DirectoryEmptyStrings();
    protected TransferCompleteStrings transferCompleteStrings = new TransferCompleteStrings();
    protected FileNotFoundStrings fileNotFoundStrings = new FileNotFoundStrings();
    private boolean cancelTransfer = false;
    private boolean resume = false;
    private boolean mdtmSupported = true;
    private boolean sizeSupported = true;
    private long resumeMarker = 0L;
    private boolean deleteOnFailure = true;
    protected boolean detectTransferMode = false;
    private int lowPort = -1;
    private int highPort = -1;
    private String storeCommand = "STOR ";
    protected long monitorInterval = 65535L;
    protected int transferBufferSize = 16384;
    protected int dataReceiveBufferSize = 0;
    protected int dataSendBufferSize = 0;
    private int downloadCount = 0;
    private int uploadCount = 0;
    private int deleteCount = 0;
    private int retryCount = 3;
    private int retryDelay = 5000;
    private boolean listenOnAllInterfaces = true;
    private FTPFileFactory fileFactory = null;
    private Locale[] listingLocales;
    private MLSXEntryParser mlsxParser = new MLSXEntryParser();
    protected FTPProgressMonitor monitor = null;
    protected FTPMessageListener messageListener = null;
    protected FTPProgressMonitorEx monitorEx = null;
    protected FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    protected FTPReply lastReply;
    protected String user;
    protected String password;
    protected BandwidthThrottler throttler = null;
    protected DataChannelCallback dataChannelCallback = null;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this(remoteHost, controlPort, 0);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, encoding);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this(remoteAddr, controlPort, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, encoding, null));
    }

    public FTPClient() {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        log.debug(VersionDetails.report(this));
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        if (this.remoteAddr == null) {
            this.remoteAddr = InetAddress.getByName(this.remoteHost);
        }
        log.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public boolean connected() {
        if (this.control == null) {
            return false;
        }
        return this.control.controlSock == null ? false : this.control.controlSock.isConnected();
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket control) throws IOException {
        this.control = control;
        control.setMessageListener(this.messageListener);
        control.setStrictReturnCodes(this.strictReturnCodes);
        control.setListenOnAllInterfaces(this.listenOnAllInterfaces);
        control.setTimeout(this.timeout);
        control.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
        control.setDataChannelCallback(this.dataChannelCallback);
        if (this.activeIP != null) {
            control.setActivePortIPAddress(this.activeIP);
        }
        if (this.lowPort > 0 && this.highPort > 0) {
            control.setActivePortRange(this.lowPort, this.highPort);
        }
    }

    public void debugResponses(boolean on) {
        if (on) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }

    public void resetDownloadCount() {
        this.downloadCount = 0;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void resetUploadCount() {
        this.uploadCount = 0;
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public void resetDeleteCount() {
        this.deleteCount = 0;
    }

    public void setDataChannelCallback(DataChannelCallback callback) {
        this.dataChannelCallback = callback;
        if (this.control != null) {
            this.control.setDataChannelCallback(callback);
        }
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
        if (this.control != null) {
            this.control.setStrictReturnCodes(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public void setListenOnAllInterfaces(boolean listenOnAll) {
        this.listenOnAllInterfaces = listenOnAll;
        if (this.control != null) {
            this.control.setListenOnAllInterfaces(listenOnAll);
        }
    }

    public boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    public FileNotFoundStrings getFileNotFoundMessages() {
        return this.fileNotFoundStrings;
    }

    public void setFileNotFoundMessages(FileNotFoundStrings fileNotFoundStrings) {
        this.fileNotFoundStrings = fileNotFoundStrings;
    }

    public TransferCompleteStrings getTransferCompleteMessages() {
        return this.transferCompleteStrings;
    }

    public void setTransferCompleteMessages(TransferCompleteStrings transferCompleteStrings) {
        this.transferCompleteStrings = transferCompleteStrings;
    }

    public DirectoryEmptyStrings getDirectoryEmptyMessages() {
        return this.dirEmptyStrings;
    }

    public void setDirectoryEmptyMessages(DirectoryEmptyStrings dirEmptyStrings) {
        this.dirEmptyStrings = dirEmptyStrings;
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.detectTransferMode = detectTransferMode;
    }

    public boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    public void setForceUniqueNames(boolean forceUnique) {
        this.storeCommand = forceUnique ? STORE_UNIQ_CMD : STORE_CMD;
    }

    protected FTPTransferType chooseTransferMode(String filename) throws IOException, FTPException {
        if (this.detectTransferMode) {
            if (filename == null) {
                log.warn("Cannot choose transfer mode as filename not supplied");
                return this.getType();
            }
            if (FileTypes.ASCII.matches(filename) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.setType(FTPTransferType.ASCII);
                log.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(filename) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.setType(FTPTransferType.BINARY);
                log.debug("Autodetect on - changed transfer type to binary");
            }
        }
        return this.getType();
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        if (this.control != null) {
            this.control.setTimeout(millis);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.controlPort;
    }

    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = remotePort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = controlPort;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress remoteAddr) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteAddr.getHostAddress();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = remoteHost;
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.autoPassiveIPSubstitution;
    }

    public void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(autoPassiveIPSubstitution);
        }
    }

    public int getServerWakeupInterval() {
        return this.serverWakeupInterval;
    }

    public void setServerWakeupInterval(int interval) {
        this.serverWakeupInterval = interval;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setDataReceiveBufferSize(int size) {
        this.dataReceiveBufferSize = size;
    }

    public int getDataReceiveBufferSize() {
        return this.dataReceiveBufferSize;
    }

    public void setDataSendBufferSize(int size) {
        this.dataSendBufferSize = size;
    }

    public int getDataSendBufferSize() {
        return this.dataSendBufferSize;
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = controlEncoding;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
        if (this.control != null) {
            this.control.setMessageListener(listener);
        }
    }

    public FTPProgressMonitorEx getProgressMonitorEx() {
        return this.monitorEx;
    }

    public void setProgressMonitorEx(FTPProgressMonitorEx monitorEx) {
        this.monitorEx = monitorEx;
        this.monitor = monitorEx;
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public FTPConnectMode getConnectMode() {
        return this.connectMode;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.monitorInterval = interval;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public FTPProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(long interval) {
        this.monitorInterval = interval;
    }

    public void setTransferBufferSize(int size) {
        this.transferBufferSize = size;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void cancelTransfer() {
        this.cancelTransfer = true;
        log.warn("cancelTransfer() called");
    }

    public boolean isTransferCancelled() {
        return this.cancelTransfer;
    }

    public boolean isDeleteOnFailure() {
        return this.deleteOnFailure;
    }

    public void setDeleteOnFailure(boolean deleteOnFailure) {
        this.deleteOnFailure = deleteOnFailure;
    }

    public void setPORTIP(String IPAddress) throws FTPException {
        this.setActiveIPAddress(IPAddress);
    }

    public void setActiveIPAddress(String activeIP) throws FTPException {
        this.activeIP = activeIP;
        if (this.control != null) {
            this.control.setActivePortIPAddress(activeIP);
        }
    }

    public String getActiveIPAddress() {
        return this.activeIP;
    }

    public void setActivePortRange(int lowest, int highest) throws FTPException {
        this.lowPort = lowest;
        this.highPort = highest;
        if (lowest < 0 || lowest > highest || highest > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        if (this.control != null) {
            this.control.setActivePortRange(lowest, highest);
        }
        log.debug("setActivePortRange(" + lowest + "," + highest + ")");
    }

    public int getActiveLowPort() {
        return this.lowPort;
    }

    public int getActiveHighPort() {
        return this.highPort;
    }

    public void login(String user, String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.password = password;
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(password);
    }

    public void login(String user, String password, String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.password = password;
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(password);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(accountInfo);
        }
    }

    public void user(String user) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.lastReply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "232", "331"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.password = password;
        this.lastReply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public void account(String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ACCT " + accountInfo);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put(SOCKS_PORT, port);
        props.put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        props.put("java.net.socks.username", username);
        props.put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public static void clearSOCKS() {
        Properties prop = System.getProperties();
        prop.remove(SOCKS_HOST);
        prop.remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public String quote(String command, String[] validCodes) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand(command);
        this.lastValidReply = validCodes != null ? this.control.validateReply(this.lastReply, validCodes) : this.lastReply;
        return this.lastValidReply.getReplyText();
    }

    public String quote(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastValidReply = this.control.sendCommand(command);
        return this.lastValidReply.getRawReply();
    }

    public String executeCommand(String command) throws FTPException, IOException {
        return this.quote(command);
    }

    public boolean existsFile(String remoteFile) throws IOException, FTPException {
        char ch;
        this.checkConnection(true);
        if (this.sizeSupported) {
            this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.sizeSupported = false;
            log.debug("SIZE not supported - trying MDTM");
        }
        if (this.mdtmSupported) {
            this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.mdtmSupported = false;
            log.debug("MDTM not supported - trying LIST");
        }
        try {
            FTPFile[] files = this.dirDetails(".");
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(remoteFile)) continue;
                return files[i].isFile();
            }
            return false;
        }
        catch (ParseException ex) {
            log.warn(ex.getMessage());
            return false;
        }
    }

    public boolean existsDirectory(String remoteDirectory) throws IOException, FTPException {
        String initDir = this.pwd();
        try {
            this.chdir(remoteDirectory);
        }
        catch (Exception ex) {
            return false;
        }
        this.chdir(initDir);
        return true;
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        return this.existsFile(remoteFile);
    }

    FTPReply readReply() throws IOException, FTPException {
        return this.control.readReply();
    }

    String getPASVAddress(String pasvReply) {
        int i;
        int start = -1;
        for (i = 0; i < pasvReply.length(); ++i) {
            if (!Character.isDigit(pasvReply.charAt(i))) continue;
            start = i;
            break;
        }
        int end = -1;
        for (i = pasvReply.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(pasvReply.charAt(i))) continue;
            end = i;
            break;
        }
        if (start < 0 || end < 0) {
            return null;
        }
        return pasvReply.substring(start, end + 1);
    }

    public FTPReply sendCommand(String command) throws IOException, FTPException {
        return this.control.sendCommand(command);
    }

    public void validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        this.control.validateReply(reply, expectedReplyCode);
    }

    public void validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        this.control.validateReply(reply, expectedReplyCodes);
    }

    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        String replyText = this.lastValidReply.getReplyText();
        int spacePos = replyText.indexOf(32);
        if (spacePos >= 0) {
            replyText = replyText.substring(0, spacePos);
        }
        try {
            return Long.parseLong(replyText);
        }
        catch (NumberFormatException ex) {
            throw new FTPException("Failed to parse reply: " + replyText);
        }
    }

    public void resume() throws FTPException {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.resume = true;
        log.info("Resume=true");
    }

    public void cancelResume() throws IOException, FTPException {
        try {
            this.restart(0L);
        }
        catch (FTPException ex) {
            log.debug("REST failed which is ok (" + ex.getMessage() + ")");
        }
        this.resumeMarker = 0L;
        this.resume = false;
    }

    protected void forceResumeOff() {
        this.resume = false;
    }

    public void restart(long size) throws IOException, FTPException {
        this.lastReply = this.control.sendCommand("REST " + size);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    private boolean processTransferException(Exception ex, int attemptNumber) {
        if (attemptNumber <= this.retryCount + 1) {
            if (this.retryDelay > 0) {
                try {
                    log.debug("Sleeping for " + this.retryDelay + " ms prior to retry");
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            log.error("Transfer error on attempt #" + attemptNumber + " retrying: ", ex);
            return true;
        }
        if (attemptNumber > 0) {
            log.info("Failed " + attemptNumber + " attempts - giving up");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        FTPTransferType currentTransferType;
        block12: {
            String cwd = this.safePwd();
            FTPTransferType previousType = this.transferType;
            currentTransferType = this.chooseTransferMode(remoteFile);
            File localFile = new File(localPath);
            if (localFile.isDirectory()) {
                localPath = localPath + File.separator + remoteFile;
                log.debug("Setting local path to " + localPath);
            }
            try {
                if (this.retryCount == 0) {
                    this.getFile(localPath, remoteFile);
                    break block12;
                }
                int attempt = 1;
                while (true) {
                    block13: {
                        try {
                            if (attempt > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + attempt);
                            this.getFile(localPath, remoteFile);
                            break;
                        }
                        catch (ControlChannelIOException ex) {
                            if (!this.processControlChannelException(cwd, ex, attempt)) {
                                throw ex;
                            }
                        }
                        catch (MalformedReplyException ex) {
                            throw ex;
                        }
                        catch (IOException ex) {
                            if (this.processTransferException(ex, attempt)) break block13;
                            throw ex;
                        }
                    }
                    ++attempt;
                }
            }
            finally {
                this.resetTransferMode(previousType);
            }
        }
        this.postTransferChecks(localPath, remoteFile, currentTransferType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        FTPTransferType currentTransferType = this.chooseTransferMode(remoteFile);
        try {
            String string = this.putStream(srcStream, remoteFile, append);
            return string;
        }
        finally {
            this.resetTransferMode(previousType);
        }
    }

    private boolean processControlChannelException(String cwd, Exception ex, int attemptNumber) throws IOException, FTPException {
        if (attemptNumber <= this.retryCount + 1) {
            if (this.retryDelay > 0) {
                try {
                    log.debug("Sleeping for " + this.retryDelay + " ms prior to retry");
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            log.error("Transfer error on attempt #" + attemptNumber + ": reconnecting & retrying: ", ex);
            this.reconnect(cwd);
            return true;
        }
        log.info("Failed " + attemptNumber + " attempts - giving up");
        return false;
    }

    protected void reconnect(String cwd) throws IOException, FTPException {
        try {
            this.quitImmediately();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Reconnecting");
        this.connect();
        this.login(this.user, this.password);
        this.setType(this.transferType);
        if (cwd != null) {
            this.chdir(cwd);
        }
    }

    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        return this.put(localPath, remoteFile, false);
    }

    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentTransferType;
        block11: {
            String cwd = this.safePwd();
            FTPTransferType previousType = this.transferType;
            currentTransferType = this.chooseTransferMode(remoteFile);
            try {
                FileInputStream srcStream = null;
                if (this.retryCount == 0 || append) {
                    srcStream = new FileInputStream(localPath);
                    remoteFile = this.putStream(srcStream, remoteFile, append);
                    break block11;
                }
                int attempt = 1;
                while (true) {
                    block12: {
                        try {
                            if (attempt > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + attempt);
                            srcStream = new FileInputStream(localPath);
                            remoteFile = this.putStream(srcStream, remoteFile, append);
                            break;
                        }
                        catch (ControlChannelIOException ex) {
                            if (!this.processControlChannelException(cwd, ex, attempt)) {
                                throw ex;
                            }
                        }
                        catch (MalformedReplyException ex) {
                            throw ex;
                        }
                        catch (IOException ex) {
                            if (this.processTransferException(ex, attempt)) break block12;
                            throw ex;
                        }
                    }
                    ++attempt;
                }
            }
            finally {
                this.resetTransferMode(previousType);
            }
        }
        this.postTransferChecks(localPath, remoteFile, currentTransferType, append);
        return remoteFile;
    }

    private String putStream(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.UPLOAD, remoteFile);
            }
            remoteFile = this.putData(srcStream, remoteFile, append);
            this.validateTransfer();
            ++this.uploadCount;
        }
        catch (FTPException ex) {
            throw ex;
        }
        catch (ControlChannelIOException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        return remoteFile;
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"225", "226", "250"};
        this.lastReply = this.control.readReply();
        if (this.cancelTransfer) {
            this.lastValidReply = this.lastReply;
            log.warn("Transfer has been cancelled!");
            throw new FTPTransferCancelledException();
        }
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateTransferOnError(IOException ex) throws IOException, FTPException {
        log.debug("Validate transfer on error after exception", ex);
        this.checkConnection(true);
        this.control.setTimeout(500);
        try {
            this.validateTransfer();
        }
        catch (Exception e) {
            log.warn("Validate transfer on error failed", e);
        }
        finally {
            this.control.setTimeout(this.timeout);
        }
    }

    private void closeDataSocket() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
    }

    protected void closeDataSocket(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    protected void closeDataSocket(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    protected void setupDataSocket() throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        if (this.dataReceiveBufferSize > 0) {
            this.data.setReceiveBufferSize(this.dataReceiveBufferSize);
        }
        if (this.dataSendBufferSize > 0) {
            this.data.setSendBufferSize(this.dataSendBufferSize);
        }
    }

    protected String initPut(String remoteFile, boolean append) throws IOException, FTPException {
        boolean storeUnique;
        this.checkConnection(true);
        boolean bl = storeUnique = remoteFile == null || remoteFile.length() == 0;
        if (storeUnique) {
            remoteFile = "";
            if (append) {
                String msg = "A remote filename must be supplied when appending";
                log.error(msg);
                throw new FTPException(msg);
            }
        }
        this.cancelTransfer = false;
        boolean close = false;
        try {
            this.resumeMarker = 0L;
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                try {
                    this.resumeMarker = this.size(remoteFile);
                }
                catch (FTPException ex) {
                    this.resumeMarker = 0L;
                    this.resume = false;
                    log.warn("SIZE failed '" + remoteFile + "' - resume will not be used (" + ex.getMessage() + ")");
                }
            }
            this.setupDataSocket();
            if (this.resume) {
                try {
                    this.restart(this.resumeMarker);
                }
                catch (FTPException ex) {
                    this.resumeMarker = 0L;
                    this.resume = false;
                    log.warn("REST failed - resume will not be used (" + ex.getMessage() + ")");
                }
            }
            String cmd = append ? "APPE " : (storeUnique ? "STOU" : this.storeCommand);
            this.lastReply = this.control.sendCommand(cmd + remoteFile);
            String[] validCodes = new String[]{"125", "150", "151", "350"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
            String replyText = this.lastValidReply.getReplyText();
            if (storeUnique) {
                int pos = replyText.indexOf(STOU_FILENAME_MARKER);
                if (pos >= 0) {
                    remoteFile = replyText.substring(pos += STOU_FILENAME_MARKER.length()).trim();
                } else {
                    log.debug("Could not find FILE: in reply - using last word instead.");
                    pos = replyText.lastIndexOf(32);
                    remoteFile = replyText.substring(++pos);
                    int len = remoteFile.length();
                    if (len > 0 && remoteFile.charAt(len - 1) == '.') {
                        remoteFile = remoteFile.substring(0, len - 1);
                    }
                }
            }
            String string = remoteFile;
            return string;
        }
        catch (IOException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initPut()", ex);
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initPut()", ex);
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String putData(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        IOException storedEx = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        long size = 0L;
        try {
            in = new BufferedInputStream(srcStream);
            remoteFile = this.initPut(remoteFile, append);
            out = new BufferedOutputStream(new DataOutputStream(this.getOutputStream()), this.transferBufferSize * 2);
            if (this.resume && this.resumeMarker > 0L) {
                in.skip(this.resumeMarker);
            } else {
                this.resumeMarker = 0L;
            }
            byte[] buf = new byte[this.transferBufferSize];
            byte[] prevBuf = new byte[FTP_LINE_SEPARATOR.length];
            int matchpos = 0;
            long monitorCount = 0L;
            int count = 0;
            boolean isASCII = this.getType() == FTPTransferType.ASCII;
            long start = System.currentTimeMillis();
            if (this.throttler != null) {
                this.throttler.reset();
            }
            while ((count = in.read(buf)) > 0 && !this.cancelTransfer) {
                if (isASCII) {
                    for (int i = 0; i < count; ++i) {
                        if (buf[i] == 10 && matchpos == 0) {
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                            continue;
                        }
                        if (buf[i] == FTP_LINE_SEPARATOR[matchpos]) {
                            prevBuf[matchpos] = buf[i];
                            if (++matchpos != FTP_LINE_SEPARATOR.length) continue;
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                            matchpos = 0;
                            continue;
                        }
                        if (matchpos > 0) {
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                        }
                        out.write(buf[i]);
                        ++size;
                        ++monitorCount;
                        matchpos = 0;
                    }
                } else {
                    out.write(buf, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (this.throttler != null) {
                    this.throttler.throttleTransfer(size);
                }
                if (this.monitor != null && monitorCount > this.monitorInterval) {
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - start <= (long)(this.serverWakeupInterval * 1000)) continue;
                start = System.currentTimeMillis();
                this.sendServerWakeup();
            }
            if (isASCII && matchpos > 0) {
                out.write(13);
                out.write(10);
                size += 2L;
                monitorCount += 2L;
            }
            this.resume = false;
        }
        catch (IOException ex) {
            storedEx = ex;
            log.error("Caught and rethrowing exception in getDataAfterInitGet()", ex);
            return remoteFile;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            log.warn("Caught exception closing input stream", ex);
        }
        this.closeDataSocket(out);
        if (storedEx != null) {
            throw storedEx;
        }
        if (this.monitor != null) {
            this.monitor.bytesTransferred(size);
        }
        log.debug("Transferred " + size + " bytes to remote host");
        return remoteFile;
        finally {
            this.resume = false;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing input stream", ex);
            }
            this.closeDataSocket(out);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes to remote host");
        }
    }

    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        String result;
        FTPTransferType currentTransferType;
        block11: {
            String cwd = this.safePwd();
            FTPTransferType previousType = this.transferType;
            currentTransferType = this.chooseTransferMode(remoteFile);
            result = null;
            try {
                ByteArrayInputStream input = null;
                if (this.retryCount == 0 || append) {
                    input = new ByteArrayInputStream(bytes);
                    result = this.putStream(input, remoteFile, append);
                    break block11;
                }
                int attempt = 1;
                while (true) {
                    block12: {
                        try {
                            if (attempt > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + attempt);
                            input = new ByteArrayInputStream(bytes);
                            result = this.putStream(input, remoteFile, append);
                            break;
                        }
                        catch (ControlChannelIOException ex) {
                            if (!this.processControlChannelException(cwd, ex, attempt)) {
                                throw ex;
                            }
                        }
                        catch (MalformedReplyException ex) {
                            throw ex;
                        }
                        catch (IOException ex) {
                            if (this.processTransferException(ex, attempt)) break block12;
                            throw ex;
                        }
                    }
                    ++attempt;
                }
            }
            finally {
                this.resetTransferMode(previousType);
            }
        }
        this.postTransferChecks(bytes, remoteFile, currentTransferType, append);
        return result;
    }

    private void getFile(String localPath, String remoteFile) throws IOException, FTPException {
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.getData(localPath, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
        }
        catch (FTPException ex) {
            throw ex;
        }
        catch (ControlChannelIOException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
    }

    protected void postTransferChecks(String localPath, String remotePath, FTPTransferType transferType, boolean append) throws FTPException, IOException {
    }

    protected void postTransferChecks(byte[] localBytes, String remotePath, FTPTransferType transferType, boolean append) throws FTPException, IOException {
    }

    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.getData(destStream, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
        }
        catch (FTPException ex) {
            throw ex;
        }
        catch (ControlChannelIOException ex) {
            throw ex;
        }
        catch (IOException ex) {
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
    }

    public void resetTransferMode(FTPTransferType previousType) throws IOException, FTPException {
        if (!this.transferType.equals(previousType)) {
            this.setType(previousType);
        }
    }

    protected void initGet(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean close = false;
        try {
            this.setupDataSocket();
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                try {
                    this.restart(this.resumeMarker);
                }
                catch (FTPException ex) {
                    this.resumeMarker = 0L;
                    this.resume = false;
                    log.warn("REST failed - resume will not be used (" + ex.getMessage() + ")");
                }
            } else {
                this.resumeMarker = 0L;
            }
            this.lastReply = this.control.sendCommand("RETR " + remoteFile);
            String[] validCodes1 = new String[]{"125", "150"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes1);
        }
        catch (IOException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initGet()", ex);
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initGet()", ex);
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    private void getData(String localPath, String remoteFile) throws IOException, FTPException {
        this.resumeMarker = 0L;
        File localFile = new File(localPath);
        if (localFile.exists()) {
            if (!localFile.canWrite()) {
                throw new FTPException(localPath + " is readonly - cannot write");
            }
            if (this.resume) {
                this.resumeMarker = localFile.length();
            }
        }
        this.initGet(remoteFile);
        FileOutputStream out = new FileOutputStream(localPath, this.resume);
        try {
            this.getDataAfterInitGet(out);
        }
        catch (IOException ex) {
            if (this.deleteOnFailure) {
                localFile.delete();
                log.debug("Deleting local file '" + localFile.getAbsolutePath() + "'");
            } else {
                log.debug("Possibly partial local file not deleted");
            }
            throw ex;
        }
    }

    private void getData(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.resumeMarker = 0L;
        this.initGet(remoteFile);
        this.getDataAfterInitGet(destStream);
    }

    protected InputStream getInputStream() throws IOException {
        return this.data.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataAfterInitGet(OutputStream destStream) throws IOException, FTPException {
        BufferedOutputStream out = new BufferedOutputStream(destStream);
        BufferedInputStream in = null;
        long size = 0L;
        IOException storedEx = null;
        try {
            int count;
            in = new BufferedInputStream(new DataInputStream(this.getInputStream()));
            long monitorCount = 0L;
            byte[] chunk = new byte[this.transferBufferSize];
            boolean isASCII = this.getType() == FTPTransferType.ASCII;
            long start = System.currentTimeMillis();
            if (this.throttler != null) {
                this.throttler.reset();
            }
            byte[] prevBuf = new byte[FTP_LINE_SEPARATOR.length];
            int matchpos = 0;
            while ((count = this.readChunk(in, chunk, this.transferBufferSize)) >= 0 && !this.cancelTransfer) {
                if (isASCII) {
                    for (int i = 0; i < count; ++i) {
                        if (chunk[i] == FTP_LINE_SEPARATOR[matchpos]) {
                            prevBuf[matchpos] = chunk[i];
                            if (++matchpos != FTP_LINE_SEPARATOR.length) continue;
                            out.write(LINE_SEPARATOR);
                            size += (long)LINE_SEPARATOR.length;
                            monitorCount += (long)LINE_SEPARATOR.length;
                            matchpos = 0;
                            continue;
                        }
                        if (matchpos > 0) {
                            out.write(prevBuf, 0, matchpos);
                            size += (long)matchpos;
                            monitorCount += (long)matchpos;
                        }
                        out.write(chunk[i]);
                        ++size;
                        ++monitorCount;
                        matchpos = 0;
                    }
                } else {
                    out.write(chunk, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (this.throttler != null) {
                    this.throttler.throttleTransfer(size);
                }
                if (this.monitor != null && monitorCount > this.monitorInterval) {
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - start <= (long)(this.serverWakeupInterval * 1000)) continue;
                start = System.currentTimeMillis();
                this.sendServerWakeup();
            }
            if (isASCII && matchpos > 0) {
                out.write(prevBuf, 0, matchpos);
                size += (long)matchpos;
                monitorCount += (long)matchpos;
            }
        }
        catch (IOException ex) {
            storedEx = ex;
            log.error("Caught and rethrowing exception in getDataAfterInitGet()", ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing output stream", ex);
            }
            this.resume = false;
            this.closeDataSocket(in);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes from remote host");
        }
    }

    public byte[] get(String remoteFile) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream(this.transferBufferSize);
            this.getData(result, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
            byte[] byArray = result == null ? null : result.toByteArray();
            return byArray;
        }
        catch (FTPException ex) {
            throw ex;
        }
        catch (ControlChannelIOException ex) {
            throw ex;
        }
        catch (IOException ex) {
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
    }

    public boolean site(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "250", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastReply.getReplyCode().equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < list.length; ++i) {
            result.append(list[i]);
            result.append(sep);
        }
        return result.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fileFactory) {
        this.fileFactory = fileFactory;
        log.debug("Set new FTPFileFactory: " + fileFactory.toString());
    }

    public void setParserLocale(Locale locale) {
        this.listingLocales = new Locale[1];
        this.listingLocales[0] = locale;
    }

    public void setParserLocales(Locale[] locales) {
        this.listingLocales = locales;
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("MLST " + name);
            this.lastValidReply = this.control.validateReply(this.lastReply, "250");
            String[] data = this.lastReply.getReplyData();
            if (data != null && data.length >= 2) {
                return this.mlsxParser.parse(this.lastReply.getReplyData()[1]);
            }
            throw new FTPException("Failed to retrieve data");
        }
        catch (IOException ex1) {
            throw ex1;
        }
        catch (Exception ex1) {
            log.debug("MLST failed: " + ex1.getMessage() + " Trying SIZE");
            try {
                String wd = this.safePwd();
                long size = this.size(name);
                Date lastModified = this.modtime(name);
                FTPFile file = new FTPFile("");
                file.setName(name);
                file.setLastModified(lastModified);
                file.setSize(size);
                file.setPath(wd);
                return file;
            }
            catch (FTPException ex2) {
                String msg = "Failed to retrieve file details for " + name + ": " + ex2.getMessage();
                log.debug(msg);
                throw new FTPException(msg);
            }
        }
    }

    public void dirDetails(String dirname, DirectoryListCallback lister) throws IOException, FTPException, ParseException {
        String path = this.setupDirDetails(dirname);
        DirectoryCallbackImpl callback = new DirectoryCallbackImpl(this.fileFactory, lister, path);
        this.dir(dirname, true, null, callback);
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        String path = this.setupDirDetails(dirname);
        FTPFile[] result = this.fileFactory.parse(this.dir(dirname, true));
        if (path != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i].setPath(path);
            }
        }
        return result;
    }

    private String setupDirDetails(String dirname) throws FTPException, IOException {
        if (this.fileFactory == null) {
            try {
                this.fileFactory = new FTPFileFactory(this.system());
            }
            catch (FTPException ex) {
                log.warn("SYST command failed - setting Unix as default parser", ex);
                this.fileFactory = new FTPFileFactory("UNIX");
            }
        }
        this.fileFactory.setLocales(this.listingLocales);
        String path = this.safePwd();
        if (path != null && dirname != null && dirname.length() > 0 && dirname.indexOf(42) < 0 && dirname.indexOf(63) < 0 && !dirname.equals(".")) {
            path = path + "/" + dirname;
        }
        log.debug("setupDirDetails(" + dirname + ") returning: " + path);
        return path;
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dir(String dirname, boolean full, Vector lines, DirectoryCallback lister) throws IOException, FTPException, ParseException {
        block21: {
            this.checkConnection(true);
            this.cancelTransfer = false;
            try {
                String command;
                this.setupDataSocket();
                String string = command = full ? "LIST " : "NLST ";
                if (dirname != null) {
                    command = command + dirname;
                }
                command = command.trim();
                this.lastReply = this.control.sendCommand(command);
                String[] validCodes1 = new String[]{"125", "150", "226", "450", "550"};
                this.lastValidReply = this.control.validateReply(this.lastReply, validCodes1);
                Object[] result = new String[]{};
                String replyCode = this.lastValidReply.getReplyCode();
                if (!(replyCode.equals("450") || replyCode.equals("550") || replyCode.equals("226"))) {
                    BufferedReader in = null;
                    try {
                        in = new LineNumberReader(new InputStreamReader(this.getInputStream(), this.controlEncoding));
                        String line = null;
                        while ((line = this.readLine((LineNumberReader)in)) != null && !this.cancelTransfer) {
                            DirectoryListArgument arg;
                            if (lines != null) {
                                lines.addElement(line);
                            }
                            if (lister != null && (arg = lister.listEntry(line)) != null && arg.isListingAborted()) {
                                log.warn("Aborting listing");
                                this.cancelTransfer = true;
                            }
                            log.log(Level.ALL, line, null);
                        }
                    }
                    catch (IOException ex) {
                        this.validateTransferOnError(ex);
                        throw ex;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex) {
                            log.error("Failed to close socket in dir()", ex);
                        }
                        this.closeDataSocket();
                    }
                    String[] validCodes2 = new String[]{"226", "250"};
                    this.lastReply = this.control.readReply();
                    this.lastValidReply = this.control.validateReply(this.lastReply, validCodes2);
                    if (lines != null && !lines.isEmpty()) {
                        result = new String[lines.size()];
                        lines.copyInto(result);
                    }
                    break block21;
                }
                String replyText = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.dirEmptyStrings.matches(replyText) && !this.transferCompleteStrings.matches(replyText)) {
                    throw new FTPException(this.lastReply);
                }
            }
            finally {
                this.closeDataSocket();
            }
        }
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        Vector lines = new Vector();
        try {
            this.dir(dirname, full, lines, null);
        }
        catch (ParseException ignore) {
            // empty catch block
        }
        Object[] result = new String[]{};
        if (!lines.isEmpty()) {
            result = new String[lines.size()];
            lines.copyInto(result);
        }
        return result;
    }

    public int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        return in.read(chunk, 0, chunksize);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        return in.read();
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPReply getLastReply() {
        return this.lastReply;
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.checkConnection(true);
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String[] validCodes = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        ++this.deleteCount;
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
        this.lastReply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RMD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MKD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CDUP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    public void setModTime(String remoteFile, Date modTime) throws IOException, FTPException {
        this.checkConnection(true);
        String time = this.tsFormat.format(modTime);
        this.lastReply = this.control.sendCommand("MFMT " + time + " " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(this.lastReply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    private String safePwd() throws IOException {
        String result = null;
        try {
            result = this.pwd();
        }
        catch (FTPException ex) {
            log.debug("Ignoring exception: " + ex.getMessage());
        }
        return result;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("FEAT");
        String[] validCodes = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            String[] features = null;
            String[] data = this.lastValidReply.getReplyData();
            if (data != null && data.length > 2) {
                features = new String[data.length - 2];
                for (int i = 0; i < data.length - 2; ++i) {
                    features[i] = data[i + 1].trim();
                }
            } else {
                features = new String[]{};
            }
            return features;
        }
        throw new FTPException(this.lastReply);
    }

    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SYST");
        String[] validCodes = new String[]{"200", "213", "215", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("NOOP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public String stat() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("STAT");
        String[] validCodes = new String[]{"211", "212", "213"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void sendServerWakeup() throws IOException, FTPException {
        this.noOperation();
    }

    public void keepAlive() throws IOException, FTPException {
        log.debug("keepAlive() called");
        int op = (int)Math.ceil(Math.random() * 2.0);
        switch (op) {
            case 1: {
                this.noOperation();
                break;
            }
            case 2: {
                this.pwd();
                break;
            }
            default: {
                this.pwd();
            }
        }
    }

    public String help(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ABOR");
        String[] validCodes = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        }
        finally {
            try {
                this.control.logout();
            }
            finally {
                this.control = null;
            }
        }
        this.closeDataSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quitImmediately() throws IOException, FTPException {
        this.cancelTransfer();
        try {
            if (this.control != null && this.control.controlSock != null) {
                this.control.controlSock.close();
            }
        }
        finally {
            this.control = null;
        }
        this.closeDataSocket();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        result.append("FTP").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return result.toString();
    }

    static {
        log = Logger.getLogger("FTPClient");
        masterId = 0;
        DEFAULT_LISTING_LOCALES = new Locale[2];
        FTPClient.DEFAULT_LISTING_LOCALES[0] = Locale.ENGLISH;
        FTPClient.DEFAULT_LISTING_LOCALES[1] = Locale.getDefault();
    }

    class DirectoryCallbackImpl
    implements DirectoryCallback {
        private FTPFileFactory fileFactory;
        private DirectoryListCallback lister;
        private String path;

        DirectoryCallbackImpl(FTPFileFactory fileFactory, DirectoryListCallback lister, String path) {
            this.fileFactory = fileFactory;
            this.lister = lister;
            this.path = path;
        }

        public DirectoryListArgument listEntry(String entry) throws ParseException {
            FTPFile file = this.fileFactory.parse(entry);
            if (this.lister != null && file != null) {
                file.setPath(this.path);
                DirectoryListArgument arg = new DirectoryListArgument(file);
                this.lister.listDirectoryEntry(arg);
                return arg;
            }
            return null;
        }
    }

    static interface DirectoryCallback {
        public DirectoryListArgument listEntry(String var1) throws ParseException;
    }
}

