/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.NetwareFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FTPFileFactory {
    public static final String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.25 2011-05-03 01:58:08 bruceb Exp $";
    private static Logger log = Logger.getLogger("FTPFileFactory");
    static final String WINDOWS_STR = "WINDOWS";
    static final String NETWARE_STR = "NETWARE";
    static final String UNIX_STR = "UNIX";
    static final String VMS_STR = "VMS";
    static final String AIX_STR = "AIX";
    private String system;
    private WindowsFileParser windows = new WindowsFileParser();
    private FTPFileParser unix = new UnixFileParser();
    private VMSFileParser vms = new VMSFileParser();
    private NetwareFileParser netware = new NetwareFileParser();
    private FTPFileParser parser = null;
    private boolean userSetParser = false;
    private boolean parserDetected = false;
    private Locale[] localesToTry;
    private int localeIndex = 0;
    private List parsers = new ArrayList();

    public FTPFileFactory(String system) throws FTPException {
        this.parsers.add(this.unix);
        this.parsers.add(this.windows);
        this.parsers.add(this.vms);
        this.parsers.add(this.netware);
        this.setParser(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.parsers.add(this.unix);
        this.parsers.add(this.windows);
        this.parsers.add(this.vms);
        this.parsers.add(this.netware);
        this.parser = parser;
        this.userSetParser = true;
    }

    public String toString() {
        return this.parser.getClass().getName();
    }

    public VMSFileParser getVMSParser() {
        return this.vms;
    }

    public void addParser(FTPFileParser parser) {
        this.parsers.add(parser);
    }

    public void setLocale(Locale locale) {
        this.parser.setLocale(locale);
        for (FTPFileParser p : this.parsers) {
            p.setLocale(locale);
        }
    }

    public void setLocales(Locale[] locales) {
        this.localesToTry = locales;
        this.setLocale(locales[0]);
        this.localeIndex = 1;
    }

    private void setParser(String system) {
        this.parserDetected = false;
        String string = this.system = system != null ? system.trim() : null;
        if (system.toUpperCase().startsWith(WINDOWS_STR)) {
            this.parser = this.windows;
        } else if (system.toUpperCase().indexOf(UNIX_STR) >= 0 || system.toUpperCase().indexOf(AIX_STR) >= 0) {
            this.parser = this.unix;
        } else if (system.toUpperCase().indexOf(VMS_STR) >= 0) {
            this.parser = this.vms;
        } else if (system.toUpperCase().indexOf(NETWARE_STR) >= 0) {
            this.parser = this.netware;
        } else {
            this.parser = this.unix;
            log.warn("Unknown SYST '" + system + "' - defaulting to Unix parsing");
        }
    }

    private void reinitializeParsers() {
        this.parser.setIgnoreDateParseErrors(false);
        for (FTPFileParser p : this.parsers) {
            p.setIgnoreDateParseErrors(false);
        }
    }

    private void detectParser(String[] files) {
        if (this.parser.isValidFormat(files)) {
            log.debug("Confirmed format " + this.parser.toString());
            this.parserDetected = true;
            return;
        }
        for (FTPFileParser p : this.parsers) {
            if (!p.isValidFormat(files)) continue;
            this.parser = p;
            log.debug("Detected format " + this.parser.toString());
            this.parserDetected = true;
            return;
        }
        this.parser = this.unix;
        log.warn("Could not detect format. Using default " + this.parser.toString());
    }

    public FTPFile parse(String line) throws ParseException {
        if (this.parser.isMultiLine()) {
            throw new ParseException("Cannot use this method with multi-line parsers", 0);
        }
        FTPFile file = null;
        try {
            file = this.parser.parse(line);
        }
        catch (DateParseException ex) {
            this.parser.setIgnoreDateParseErrors(true);
            file = this.parser.parse(line);
        }
        return file;
    }

    public FTPFile[] parse(String[] files) throws ParseException {
        this.reinitializeParsers();
        FTPFile[] temp = new FTPFile[files.length];
        if (files.length == 0) {
            return temp;
        }
        if (!this.userSetParser && !this.parserDetected) {
            this.detectParser(files);
        }
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].trim().length() == 0) continue;
            try {
                FTPFile file = null;
                if (this.parser.isMultiLine()) {
                    StringBuffer filename = new StringBuffer(files[i]);
                    while (i + 1 < files.length && files[i + 1].indexOf(59) < 0) {
                        filename.append(" ").append(files[i + 1]);
                        ++i;
                    }
                    file = this.parser.parse(filename.toString());
                } else {
                    file = this.parser.parse(files[i]);
                }
                if (file == null) continue;
                temp[count++] = file;
                continue;
            }
            catch (DateParseException ex) {
                if (this.localesToTry != null && this.localesToTry.length > this.localeIndex) {
                    log.info("Trying " + this.localesToTry[this.localeIndex].toString() + " locale");
                    this.setLocale(this.localesToTry[this.localeIndex]);
                    ++this.localeIndex;
                    count = 0;
                    i = -1;
                    continue;
                }
                count = 0;
                i = -1;
                this.parser.setIgnoreDateParseErrors(true);
                log.debug("Ignoring date parsing errors");
            }
        }
        FTPFile[] result = new FTPFile[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public String getSystem() {
        return this.system;
    }
}

