/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAutoModeTransfer
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestAutoModeTransfer.java,v 1.1 2007/02/06 07:23:09 bruceb Exp $";

    protected String getLogName() {
        return "TestAutoModeTransfer.log";
    }

    public void testAutoModeTransfer() throws Exception {
        log.debug("testAutoModeTransfer()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        this.ftp.setDetectTransferMode(true);
        TestProgressMonitor monitor = new TestProgressMonitor(this.ftp);
        this.ftp.setProgressMonitor(monitor, 1000L);
        String filename = this.generateRandomFilename() + ".txt";
        this.ftp.put(this.localDataDir + this.localTextFile, filename);
        TestAutoModeTransfer.assertTrue((boolean)this.ftp.getType().equals(FTPTransferType.BINARY));
        TestAutoModeTransfer.assertTrue((boolean)monitor.getType().equals(FTPTransferType.ASCII));
        this.ftp.get(this.localDataDir + filename, filename);
        TestAutoModeTransfer.assertTrue((boolean)this.ftp.getType().equals(FTPTransferType.BINARY));
        TestAutoModeTransfer.assertTrue((boolean)monitor.getType().equals(FTPTransferType.ASCII));
        this.ftp.delete(filename);
        this.assertIdentical(this.localDataDir + this.localTextFile, this.localDataDir + filename);
        File local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.setType(FTPTransferType.ASCII);
        filename = this.generateRandomFilename() + ".exe";
        this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
        TestAutoModeTransfer.assertTrue((boolean)this.ftp.getType().equals(FTPTransferType.ASCII));
        TestAutoModeTransfer.assertTrue((boolean)monitor.getType().equals(FTPTransferType.BINARY));
        this.ftp.get(this.localDataDir + filename, filename);
        TestAutoModeTransfer.assertTrue((boolean)this.ftp.getType().equals(FTPTransferType.ASCII));
        TestAutoModeTransfer.assertTrue((boolean)monitor.getType().equals(FTPTransferType.BINARY));
        this.ftp.delete(filename);
        this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
        local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(TestAutoModeTransfer.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestAutoModeTransfer.suite());
    }

    class TestProgressMonitor
    implements FTPProgressMonitor {
        private FTPClientInterface ftpClient;
        private FTPTransferType type;

        public TestProgressMonitor(FTPClientInterface ftp) {
            this.ftpClient = ftp;
        }

        public FTPTransferType getType() {
            return this.type;
        }

        public void setType(FTPTransferType type) {
            this.type = type;
        }

        public void bytesTransferred(long count) {
            FTPTestCase.log.debug("Saving transfer type (count=" + count + ")");
            this.type = this.ftpClient.getType();
        }
    }
}

