/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFileOperations
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestFileOperations.java,v 1.12 2008-05-14 05:52:23 bruceb Exp $";
    private SimpleDateFormat modFormatter = new SimpleDateFormat("yyyy/MM/dd @ HH:mm:ss");

    protected String getLogName() {
        return "TestFileOperations.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        log.debug("testDelete() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            try {
                String file = this.generateRandomFilename();
                log.debug("Deleting a non-existent file");
                this.ftp.delete(file);
                TestFileOperations.fail();
            }
            catch (FTPException ex) {
                log.debug("Expected exception: " + ex.getMessage());
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testDelete() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRename() throws Exception {
        log.debug("testRename() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            String rename = this.remoteTextFile + ".renamed";
            this.ftp.rename(this.remoteTextFile, rename);
            Date modTime = this.ftp.modtime(rename);
            String mod = this.modFormatter.format(modTime);
            log.debug(rename + ": " + mod);
            try {
                this.ftp.modtime(this.remoteTextFile);
                TestFileOperations.fail();
            }
            catch (FTPException ex) {
                log.debug("Expected exception: " + ex.getMessage());
            }
            this.ftp.rename(rename, this.remoteTextFile);
            modTime = this.ftp.modtime(this.remoteTextFile);
            mod = this.modFormatter.format(modTime);
            log.debug(this.remoteTextFile + ": " + mod);
            try {
                this.ftp.modtime(rename);
                TestFileOperations.fail();
            }
            catch (FTPException ex) {
                log.debug("Expected exception: " + ex.getMessage());
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testRename() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModtime() throws Exception {
        log.debug("testModtime() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            log.debug("Modtime on existing file: " + this.remoteTextFile);
            Date modTime = this.ftp.modtime(this.remoteTextFile);
            String mod = this.modFormatter.format(modTime);
            log.debug(this.remoteTextFile + ": " + mod);
            try {
                String file = this.generateRandomFilename();
                log.debug("Modtime on non-existent file");
                modTime = this.ftp.modtime(file);
                TestFileOperations.fail();
            }
            catch (FTPException ex) {
                log.debug("Expected exception: " + ex.getMessage());
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testModtime() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetModtime() throws Exception {
        log.debug("testSetModtime() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            log.debug("Existing modtime on existing file: " + this.remoteTextFile);
            Date modTime = this.ftp.modtime(this.remoteTextFile);
            log.debug(this.remoteTextFile + ": " + modTime.toString());
            Calendar cal = Calendar.getInstance();
            cal.setTime(modTime);
            cal.add(6, 1);
            cal.add(11, 2);
            cal.add(12, 3);
            cal.add(13, 4);
            Date desiredModTime = cal.getTime();
            log.debug("Setting mod-time to " + desiredModTime.toString());
            this.ftp.setModTime(this.remoteTextFile, desiredModTime);
            Date actualModTime = this.ftp.modtime(this.remoteTextFile);
            log.debug(this.remoteTextFile + ": " + actualModTime.toString());
            if ((int)desiredModTime.getTime() / 1000 != (int)actualModTime.getTime() / 1000) {
                String msg = "Desired mod-time(" + desiredModTime + ") != actual mod-time(" + actualModTime + ")";
                log.debug(msg);
                TestFileOperations.fail((String)msg);
            }
            this.ftp.quit();
        }
        finally {
            log.debug("setModtime() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSize() throws Exception {
        log.debug("testSize() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localTextFile, filename);
            File local = new File(this.localDataDir + this.localTextFile);
            long sizeLocal = local.length();
            long sizeRemote = this.ftp.size(filename);
            this.ftp.delete(filename);
            if (sizeLocal != sizeRemote) {
                String msg = "Local size(" + sizeLocal + ") != remote size(" + sizeRemote + ")";
                log.debug(msg);
                throw new Exception(msg);
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testSize() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestFileOperations.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestFileOperations.suite());
    }
}

