/*
	Gui.java - Turtle's User Interface
*/

import java.io.*;
import java.awt.*;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.*;
import javax.swing.*;

import se.datadosen.util.Item;
import se.datadosen.util.IO;
import se.datadosen.component.*;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumWindow;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.event.*;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.JAlbumSite;

import edu.stanford.ejalbert.BrowserLauncher;

public class Gui extends se.datadosen.jalbum.CompiledScript {
	
	private Object[] getPosition() {
		return new Object[] {
			new Item("left top", texts.getString("ui.bg_left_top")), 
			new Item("center top", texts.getString("ui.bg_center_top")), 
			new Item("right top", texts.getString("ui.bg_right_top")), 
			new Item("left middle", texts.getString("ui.bg_left_middle")), 
			new Item("center middle", texts.getString("ui.bg_center_middle")), 
			new Item("right middle", texts.getString("ui.bg_right_middle")), 
			new Item("left bottom", texts.getString("ui.bg_left_bottom")), 
			new Item("center bottom", texts.getString("ui.bg_center_bottom")), 
			new Item("right bottom", texts.getString("ui.bg_right_bottom"))
		};
	}

	private Color getHighlightedColor(String s) {
		long[] rgb = {Integer.parseInt(s.substring(1, 3), 16), Integer.parseInt(s.substring(3, 5), 16), Integer.parseInt(s.substring(5, 7), 16)};
		int i;
		if (((double) (3 * rgb[0] + 4 * rgb[1] + rgb[2]) / 2040) < 0.85D) {
			for (i = 0; i < 3; i++) {
				if (rgb[i] < 128) {
					rgb[i] = Math.round(127 * Math.pow(((double) rgb[i]) / 127.0D, 2.0D));
				} else {
					rgb[i] = Math.round(255 - 127 * Math.pow(((double) (255 - rgb[i])) / 127.0D, 2.0D));
				}
				rgb[i] = Math.round(Math.floor(127 + rgb[i] * 0.5D));
			}
		} else {
			for (i = 0; i < 3; i++) {
				rgb[i] = Math.round((double) rgb[i] * 0.8D);
			}
		}
		return new Color((int) rgb[0], (int) rgb[1], (int) rgb[2]);
	}
	/*
	private String getThemeImageSize() {
		String[] size = engine.getImageSize().split("x");
		int h = (int)Math.round(Integer.parseInt(size[1]) * 0.4D);
		return size[0] + "x" + h;
	}
	*/
	private ImageIcon createImageIcon(String path) {
		java.net.URL imgURL = getClass().getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL, path);
		} else {
			System.out.println("Couldn't find file: " + path);
			return null;
		}
	}
	
	private String attemptSignIn() {
		SignInManager mgr = SignInManager.getInstance();
		if ( mgr != null && mgr.isSignedIn() ) {
			return "&cid=" + AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
		}
		return "";
	}
	
	private String getLicense() {
		return licenseManager.isLicenseValid() ? licenseManager.getUserName() : "";
	}
	
	private String license = getLicense();
	
	private String getFileContents(String name) {
		StringBuilder cont = new StringBuilder();
		String line;
		String nl = System.getProperty("line.separator");
		File f = new File(skinDirectory, name);
		try {
			java.io.BufferedReader in =  new java.io.BufferedReader(new java.io.FileReader(f));
			try {
				while ((line = in.readLine()) != null) {
					cont.append(line);
					cont.append(nl);
				}
			}
			finally {
				in.close();
			}
		} catch (FileNotFoundException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
		return cont.toString();
	}
	
	JTextArea readme = new JSmartTextArea( getFileContents("readme.txt"), 20, 30 );
	
	{
		readme.setLineWrap(true);
		readme.setWrapStyleWord(true);
		readme.setEditable(false);
	}
	
	JScrollPane aboutPanel = new JScrollPane(readme, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    
	private JFileChooser fc = new JFileChooser();
	private JFileFilter imgFilter = new JFileFilter(new String[] {"jpg", "png", "gif"}, "Images");
	
	private void getFileToRes(String[] ext, JTextField name) {
		getFileToRes(new JFileFilter(ext, "allowed files"), name);
	}
		 
	private void getFileToRes(JFileFilter filter, JTextField name) {
		fc.setFileFilter(filter);
		int returnVal = fc.showOpenDialog(window);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String fn = fc.getSelectedFile().toString();
			if ( !fn.trim().equals("") ) {
				File src = new File(fn);
				File dst = new File(engine.getDirectory(), "res");
				if (!dst.exists()) {
					dst.mkdir();
				}
				if (src.exists() &&  dst.exists()) {
					try {
						IO.copyFile(src, dst);
						name.setText( src.getName() );
					} catch (IOException e) {
						System.out.println(e);
					}
				}
			}
		}
	}
	
	StateMonitor commercialMonitor = new StateMonitor() {
		public void onChange() {
			if ( ((JCheckBox)source).isSelected() && license.length() == 0 ) {
				Object[] options = { 
					texts.getString("ui.signUp"),
					texts.getString("ui.noThanks")
				};
				int n = JOptionPane.showOptionDialog(window, 
					texts.getString("ui.licenseWarning"), 
					texts.getString("ui.licenseWarningTitle"), 
					JOptionPane.YES_NO_OPTION, 
					JOptionPane.INFORMATION_MESSAGE,
					null,
					options,
					options[1]
				);
				if (n == 0) {
					try {
						BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?referrer=" + skin + attemptSignIn());
					} catch (se.datadosen.tags.ElementException x) {
					} catch (IOException x) {
					}
				}
				((JCheckBox)source).setSelected(false);
			}
		}
	};
	
	ControlPanel ui = new ControlPanel() {

		JTextField skinVersion = new JTextField( new SkinProperties(skinDirectory).getProperty(SkinProperties.VERSION) );
		JCheckBox guiExists = new JCheckBox("", true);
		
		JLabel formattingHint1h = new JLabel(texts.getString("ui.formattingHint1"));
		JLabel formattingHint2h = new JLabel(texts.getString("ui.formattingHint2"));
		JLabel formattingHint1f = new JLabel(texts.getString("ui.formattingHint1"));
		JLabel formattingHint2f = new JLabel(texts.getString("ui.formattingHint2"));
		
		ControlPanel site = new ControlPanel() {
			
			JCheckBox showBreadcrumbPath = new JCheckBox(texts.getString("ui.useBreadcrumbPath"), false);
			JCheckBox useSearch = new JCheckBox(texts.getString("ui.useSearchBox"));
			JCheckBox skipThumbnailPage = new JCheckBox(texts.getString("ui.skipThumbnailPage"));
			JComboBox zipImages = new JComboBox(new Object[] {
				new Item("none", texts.getString("ui.nothing")),
				new Item("slides", texts.getString("ui.scaledDown")),
				new Item("originals", texts.getString("ui.originals")),
				new Item("album", texts.getString("ui.wholeAlbum"))
			});
			JLabel zipInfo = new JLabel(createImageIcon("info.png"));
		
			ControlPanel topNavigation = new ControlPanel(texts.getString("ui.topNavigation")) {
				JCheckBox showTopNavigation = new JCheckBox(texts.getString("ui.showTopNavigation"), false);
				JCheckBox topNavigationExcludeFolders = new JCheckBox(texts.getString("ui.excludeFolders"), false);
				JTextField logoName = new JSmartTextField(30);
				JButton selectLogo = new JButton(texts.getString("ui.select"));
				
				{
					showTopNavigation.setToolTipText(texts.getString("ui.showTopNavigationInfo"));
					topNavigationExcludeFolders.setToolTipText(texts.getString("ui.excludeFoldersInfo"));
					selectLogo.addActionListener(new ActionListener() { 
						public void actionPerformed(ActionEvent e) {
							getFileToRes(imgFilter, logoName);
					}});
					ComponentUtilities.whenSelectedEnable(showTopNavigation, new JComponent[]{topNavigationExcludeFolders, logoName, selectLogo});

					add(showTopNavigation);
					add("tab", topNavigationExcludeFolders);
					add("br", new JLabelFor(texts.getString("ui.logo"), logoName));
					add("hfill", logoName);
					add("", selectLogo);
				}
			};
			
			{
				skipThumbnailPage.setToolTipText(texts.getString("ui.skipThumbnailPageInfo"));
				showBreadcrumbPath.setToolTipText(texts.getString("ui.useBreadcrumbPathInfo"));
				useSearch.setToolTipText(texts.getString("ui.useSearchBoxInfo"));
				
				zipInfo.addMouseListener(new MouseAdapter() {  
						public void mouseReleased(MouseEvent e) {
							JOptionPane.showMessageDialog(window, texts.getString("ui.nonAsciiWarning"), "Warning", JOptionPane.WARNING_MESSAGE);
				}});
				
				add("hfill", topNavigation);
				add("br", showBreadcrumbPath);
				add("br", useSearch);
				add("br", skipThumbnailPage);
				add("br", new JLabelFor(texts.getString("ui.offerDownload"), zipImages));
				add("", zipImages);
				add("", zipInfo);
			}
		};
		
		ControlPanel design = new ControlPanel() {

			JComboBox fontFamily = new JComboBox(new Object[] {
				new Item("Arial, \"Helvetica Neue\", Helvetica, sans-serif", "Arial"),
				new Item("Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", "Baskerville"),
				new Item("Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", "Calibri"),
				new Item("Cambria, Georgia, Times, \"Times New Roman\", serif", "Cambria"),
				new Item("\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", "Century Gothic"),
				new Item("\"Comic Sans MS\", cursive", "Comic Sans"),
				new Item("Consolas, \"Lucida Console\", Monaco, monospace", "Consolas"),
				new Item("Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", "Constantia"),
				new Item("\"Copperplate Light\", \"Copperplate Gothic Light\", serif", "Copperplate Light"),
				new Item("\"Courier New\", Courier, monospace", "Courier New"),
				new Item("\"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", "Franklin Gothic"),
				new Item("Futura, \"Century Gothic\", AppleGothic, sans-serif", "Futura"),
				new Item("Garamond, \"Hoefler Text\", Times New Roman, Times, serif", "Garamond"),
				new Item("Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", "Geneva"),
				new Item("Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", "Georgia"),
				new Item("\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", "Gill Sans"),
				new Item("\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", "Goudy Old Style"),
				new Item("\"Helvetica Neue\", Helvetica, Arial, sans-serif", "Helvetica Neue"),
				new Item("\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", "Hoefler Text"),
				new Item("Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", "Impact"),
				new Item("\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", "Lucida Sans"),
				new Item("\"Lucida Bright\", Georgia, serif", "Lucida Bright"),
				new Item("Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", "Palatino"),
				new Item("Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", "Segoe"),
				new Item("Tahoma, Geneva, Verdana, sans-serif", "Tahoma"),
				new Item("Times, \"Times New Roman\", Georgia, serif", "Times"),
				new Item("\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", "Trebuchet MS"),
				new Item("Verdana, Geneva, Tahoma, sans-serif", "Verdana") 
			});
			JComboBox fontSize = new JComboBox(new Object[] {
				new Item("10px", "77%"),
				new Item("11px", "85%"),
				new Item("12px", "92%"),
				new Item("13px", "100%"),
				new Item("14px", "108%"),
				new Item("15px", "115%"),
				new Item("16px", "123%"),
				new Item("17px", "131%"),
				new Item("18px", "138%")
			});
			JComboBox headlineFamily = new JComboBox(new Object[] {
				new Item("", "[ " + texts.getString("ui.sameAsBaseFont") + " ]"),
				new Item("Arial, \"Helvetica Neue\", Helvetica, sans-serif", "Arial"),
				new Item("Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", "Baskerville"),
				new Item("Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", "Calibri"),
				new Item("Cambria, Georgia, Times, \"Times New Roman\", serif", "Cambria"),
				new Item("\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", "Century Gothic"),
				new Item("\"Comic Sans MS\", cursive", "Comic Sans"),
				new Item("Consolas, \"Lucida Console\", Monaco, monospace", "Consolas"),
				new Item("Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", "Constantia"),
				new Item("Copperplate, \"Copperplate Gothic\", serif", "Copperplate"),
				new Item("\"Courier New\", Courier, monospace", "Courier New"),
				new Item("\"Franklin Gothic\", \"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", "Franklin Gothic"),
				new Item("Futura, \"Futura Bk BT\", \"Century Gothic\", AppleGothic, sans-serif", "Futura"),
				new Item("Garamond, \"Hoefler Text\", Times New Roman, Times, serif", "Garamond"),
				new Item("Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", "Geneva"),
				new Item("Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", "Georgia"),
				new Item("\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", "Gill Sans"),
				new Item("\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", "Goudy Old Style"),
				new Item("\"Helvetica Neue\", Helvetica, Arial, sans-serif", "Helvetica Neue"),
				new Item("\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", "Hoefler Text"),
				new Item("Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", "Impact"),
				new Item("\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", "Lucida Sans"),
				new Item("\"Lucida Bright\", Georgia, serif", "Lucida Bright"),
				new Item("Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", "Palatino"),
				new Item("Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", "Segoe"),
				new Item("Tahoma, Geneva, Verdana, sans-serif", "Tahoma"),
				new Item("Times, \"Times New Roman\", Georgia, serif", "Times"),
				new Item("\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", "Trebuchet MS"),
				new Item("Verdana, Geneva, Tahoma, sans-serif", "Verdana"),
				new Item("", "--- " + texts.getString("ui.webFonts") + " ---"), 
				new Item("Abril Fatface::abrilfatface/v5/X1g_KwGeBV3ajZIXQ9VnDuhS-En80r5m6Wj7KydCWb8.woff", "Abril Fatface"),
				new Item("Alex Brush::alexbrush/v3/0JFIM7b_LgqHWlCbkgAO2fesZW2xOQ-xsNqO47m55DA.woff", "Alex Brush"),
				new Item("Amaranth::amaranth/v3/BHyuYFj9nqLFNvOvGh0xT4SoAJ3FdnHwSRdilZRLja4.woff", "Amaranth"),
				new Item("Amatic SC::amaticsc/v3/IDnkRTPGcrSVo50UyYNK7xsxEYwM7FgeyaSgU71cLG0.woff", "Amatic SC"),
				new Item("Cantata One::cantataone/v1/-a5FDvnBqaBMDaGgZYnEfj8E0i7KZn-EPnyo3HZu7kw.woff", "Cantata One"),
				new Item("Cookie::cookie/v4/FRKZFc5cUzT1rhNTWK08-w.woff", "Cookie"),
				new Item("Dancing Script::dancingscript/v3/KGBfwabt0ZRLA5W1ywjowQcy1_X8izNRf-j_WdFlHLs.woff", "Dancing Script"),
				new Item("Dosis::dosis/v1/4u2QrYwRDIT2YdFfRbG7og.woff", "Dosis"),
				new Item("Dynalight::dynalight/v2/fFTIQo5srxFzkXPDHWokhw.woff", "Dynalight"),
				new Item("Emilys Candy::emilyscandy/v1/PofLVm6v1SwZGOzC8s-I3RsxEYwM7FgeyaSgU71cLG0.woff", "Emilys Candy"),
				new Item("Euphoria Script::euphoriascript/v1/c4XB4Iijj_NvSsCF4I0O2HVXOZy8HQCyPSdnDJOr3a8.woff", "Euphoria Script"),
				new Item("Fredericka the Great::frederickathegreat/v2/7Es8Lxoku-e5eOZWpxw18t2QR9E88_XBMnxeisbi_2k.woff", "Fredericka the Great"),
				new Item("Germania One::germaniaone/v1/3_6AyUql_-FbDi1e68jHdBsxEYwM7FgeyaSgU71cLG0.woff", "Germania One"),
				new Item("Geo::geo/v4/ehOHD8ipeE9ZZlLcSuyETw.woff", "Geo"),
				new Item("Great Vibes::greatvibes/v1/4Mi5RG_9LjQYrTU55GN_Lz8E0i7KZn-EPnyo3HZu7kw.woff", "Great Vibes"),
				new Item("Gruppo::gruppo/v4/5HbckBWnUDolflDIG6jXoQ.woff", "Gruppo"),
				new Item("IM Fell English::imfellenglish/v3/xwIisCqGFi8pff-oa9uSVMyhYfqH3mbn79-t0w0Xep4.woff", "IM Fell English"),
				new Item("Indie Flower::indieflower/v4/10JVD_humAd5zP2yrFqw6hsxEYwM7FgeyaSgU71cLG0.woff", "Indie Flower"),
				new Item("La Belle Aurore::labelleaurore/v3/Irdbc4ASuUoWDjd_Wc3mdw8tuJzfDdJzet9TevnX4dY.woff", "La Belle Aurore"),
				new Item("Lobster::lobster/v5/9eID_a1kLfzp_BP9s4L15g.woff", "Lobster"),
				new Item("Loved by the King::lovedbytheking/v3/wg03xD4cWigj4YDufLBSrwvs-PHmBmba6eqIx5ccdqU.woff", "Loved by the King"),
				new Item("Mountains of Christmas::mountainsofchristmas/v5/PymufKtHszoLrY0uiAYKNFojKXOXw05l2_H_A7IX6_4.woff", "Mountains of Christmas"),
				new Item("Maiden Orange::maidenorange/v3/ZhKIA2SPisEwdhW7g0RUWuhS-En80r5m6Wj7KydCWb8.woff", "Maiden Orange"),
				new Item("Oswald::oswald/v2/-g5pDUSRgvxvOl5u-a_WHw.woff", "Oswald"),
				new Item("Poiret One::poiretone/v1/BTpJg8_B_DLGSuk_1Pf0tvesZW2xOQ-xsNqO47m55DA.woff", "Poiret One"),
				new Item("Princess Sofia::princesssofia/v1/8g5l8r9BM0t1QsXLTajDe2y1RO09RDKWlu_EElX0vQo.woff", "Princess Sofia"),
				new Item("PT Mono::ptmono/v1/q-8MB3u-6uRcCyTjD42CkA.woff", "PT Mono"),
				new Item("Shadows Into Light::shadowsintolight/v3/clhLqOv7MXn459PTh0gXYJxCHKeeY4rq5IoKkeW6lEs.woff", "Shadows Into Light"),
				new Item("Special Elite::specialelite/v3/9-wW4zu3WNoD5Fjka35Jm-hS-En80r5m6Wj7KydCWb8.woff", "Special Elite"),
				new Item("Raleway::raleway/v5/b1OWH1QXUjVxHio22EJrRQ.woff", "Raleway"),
				new Item("Rochester::rochester/v3/f_NvJxIwJC1g7a4yzlmghQ.woff", "Rochester"),
				new Item("Squada One::squadaone/v2/f-OUPQPez9RsgdltZVHvEvesZW2xOQ-xsNqO47m55DA.woff", "Squada One"),
				new Item("Ubuntu Condensed::ubuntucondensed/v3/DBCt-NXN57MTAFjitYxdrO3ikv6SQm_yYbVf3nddkGw.woff", "Ubuntu Condensed"),
				new Item("Yanone Kaffeesatz::yanonekaffeesatz/v4/We_iSDqttE3etzfdfhuPRRI4n1MudG51cocQgCMY5FY.woff", "Yanone Kaffeesatz")
			});
			JComboBox headlineSize = new JComboBox(new Object[] { 
				"200%", "240%", "300%", "360%", "420%", "500%" 
			}); 
			JTextField backgroundImageName = new JSmartTextField(20);
			JButton selectImage = new JButton();
			JComboBox backgroundPos = new JComboBox( getPosition() );
			JComboBox backgroundRepeat = new JComboBox(new Object[] {
				new Item("no-repeat", texts.getString("ui.bg_no_repeat")),
				new Item("repeat-x", texts.getString("ui.bg_repeat_x")),
				new Item("repeat-y", texts.getString("ui.bg_repeat_y")),
				new Item("repeat", texts.getString("ui.bg_repeat_both")),
				new Item("stretch", texts.getString("ui.bg_stretch")),
			});
			JCheckBox use3dEffects = new JCheckBox(texts.getString("ui.use3dEffects"), true);
			JCheckBox stickControlsToTop = new JCheckBox(texts.getString("ui.stickControlsToTop"), true);
			
			ControlPanel colors = new ControlPanel(texts.getString("ui.colors")) {
				
				JColorSelector backgroundColor = new JColorSelector(texts.getString("ui.backgroundColor"), new JSmartTextField("#111111", 6));
				JColorSelector textColor = new JColorSelector(texts.getString("ui.textColor"), new JSmartTextField("#bbbbbb", 6));
				JColorSelector highlightColor = new JColorSelector(); // Hidden, automatically assigned
				JColorSelector linkColor = new JColorSelector(texts.getString("ui.linkColor"), new JSmartTextField("#dddddd", 6));
				JColorSelector hoverColor = new JColorSelector(texts.getString("ui.hoverColor"), new JSmartTextField("#ffffff", 6));
				JColorSelector borderColor = new JColorSelector(texts.getString("ui.borderColor"), new JSmartTextField("#eeeeee", 6));
				JSpinner borderWidth = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
				
				{
					backgroundColor.setToolTipText(texts.getString("ui.backgroundColorInfo"));
					textColor.setToolTipText(texts.getString("ui.textColorInfo"));
					linkColor.setToolTipText(texts.getString("ui.linkColorInfo"));
					hoverColor.setToolTipText(texts.getString("ui.hoverColorInfo"));
					borderColor.setToolTipText(texts.getString("ui.borderColorInfo"));
					textColor.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							highlightColor.setColor(getHighlightedColor(textColor.getHTMLColor()));
						}
					});
					linkColor.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							hoverColor.setColor(getHighlightedColor(linkColor.getHTMLColor()));
						}
					});
					
					add("", new JLabelFor(texts.getString("ui.backgroundColor"), backgroundColor));
					add("tab", backgroundColor);
					add("tab", backgroundColor.getTextComponent());
					add("tab", new JLabelFor(texts.getString("ui.textColor"), textColor));
					add("tab", textColor);
					add("tab", textColor.getTextComponent());
					add("br", new JLabelFor(texts.getString("ui.linkColor"), linkColor));
					add("tab", linkColor);
					add("tab", linkColor.getTextComponent());
					add("tab", new JLabelFor(texts.getString("ui.hoverColor"), hoverColor));
					add("tab", hoverColor);
					add("tab", hoverColor.getTextComponent());
					add("br", new JLabelFor(texts.getString("ui.borderColor"), borderColor));
					add("tab", borderColor);
					add("tab", borderColor.getTextComponent());
					add("tab", new JLabelFor(texts.getString("ui.borderWidth"), borderWidth));
					add("", borderWidth);
					add("", new JLabel("px"));
				}
			};
			
			{
				fontSize.setSelectedIndex(3);
				headlineSize.setSelectedIndex(2);
				backgroundImageName.setToolTipText(texts.getString("ui.backgroundImageInfo"));
				selectImage.setText(texts.getString("ui.select"));
				selectImage.addActionListener(new ActionListener() { 
					public void actionPerformed(ActionEvent e) {
						getFileToRes(imgFilter, backgroundImageName);
				}});
				backgroundPos.setSelectedIndex(4);
				backgroundRepeat.setSelectedIndex(4);
				use3dEffects.setToolTipText(texts.getString("ui.use3dEffectsInfo"));
				stickControlsToTop.setToolTipText(texts.getString("ui.stickControlsToTopInfo"));
				
				add(new JLabel(texts.getString("ui.fontFamily")));
				add("tab", fontFamily);
				add(" ", new JLabel(texts.getString("ui.fontSize")));
				add("tab", fontSize);
				add("br", new JLabel(texts.getString("ui.headlineFamily")));
				add("tab", headlineFamily);
				add("tab", headlineSize);
				add("br tab", new JLinkLabel("http://lazaworx.com/font-selection-in-turtle-skin/", texts.getString("ui.fontSamples"), texts.getString("ui.seeFontSamples")));
				add("br", new JLabelFor(texts.getString("ui.backgroundImage"), backgroundImageName));
				add("tab", backgroundImageName);
				add("", selectImage);
				add("br tab", backgroundPos);
				add("", backgroundRepeat);
				add("br", use3dEffects);
				add(" ", stickControlsToTop);
				add("br hfill", colors);
			}
		};

		ControlPanel header = new ControlPanel() {
			
			ControlPanel themeImage = new ControlPanel(texts.getString("ui.themeImage")) {
				
				JTextField folderImageSize = new JSmartTextField("900x240", 10);
				JTextField folderImageHeightPages = new JSmartTextField("80", 5);
				JTextField folderImageHeightSubAlbums = new JSmartTextField("240", 5);
				JCheckBox themeImageSame = new JCheckBox(texts.getString("ui.themeImageSame"));
				
				{
					folderImageSize.setToolTipText(texts.getString("ui.folderImageSizeInfo"));
					folderImageHeightPages.setToolTipText(texts.getString("ui.heightOnPagesInfo"));
					folderImageHeightSubAlbums.setToolTipText(texts.getString("ui.heightOnSubFoldersInfo"));
					themeImageSame.setToolTipText(texts.getString("ui.themeImageSameInfo"));
					
					add("", new JLabel(texts.getString("ui.folderImageSize")));
					add("tab", folderImageSize);
					add(" ", themeImageSame);
					add("br", new JLabel(texts.getString("ui.heightOnPages")));
					add("tab", folderImageHeightPages);
					add("br", new JLabel(texts.getString("ui.heightOnSubFolders")));
					add("tab", folderImageHeightSubAlbums);
				}
				
			};
			
			JCheckBox descriptionVisible = new JCheckBox(texts.getString("ui.descriptionVisible"), true);
			JCheckBox showStartSlideshow = new JCheckBox(texts.getString("ui.showStartSlideshow"), true);
			
			ControlPanel headerPanel = new ControlPanel(texts.getString("ui.albumInfo")) {
				
				JCheckBox headerTopLevelOnly = new JCheckBox(texts.getString("ui.topLevelOnly"), true);
				JTextArea header = new JSmartTextArea(6, 30);
				JScrollPane headerPane = new JScrollPane(header);
				
				{
					header.setEditable(true);
					header.setLineWrap(true);
					header.setWrapStyleWord(true);
					header.setToolTipText(texts.getString("ui.customContentInfo"));
				
					add(headerTopLevelOnly);
					add("br hfill", headerPane);
					add("br", formattingHint1h);
					add("br", formattingHint2h);
				}
			};

			{
				//folderImageSize.setText(getThemeImageSize());
				descriptionVisible.setToolTipText(texts.getString("ui.descriptionVisibleInfo"));
				showStartSlideshow.setToolTipText(texts.getString("ui.showStartSlideshowInfo"));
				
				add("hfill", themeImage);
				add("br", descriptionVisible);
				add("br", showStartSlideshow);
				add("br hfill", headerPanel);
			}
		};
		
		ControlPanel thumbnails = new ControlPanel() {
			
			String s = " > ", f = texts.getString("ui.folders"), p = texts.getString("ui.pages"), i = texts.getString("ui.images");
			JTextField newDaysCount = new JSmartTextField("0", 3);
			JComboBox newDaysRef = new JComboBox(new Object[] {
				new Item("dateTaken", texts.getString("ui.dateTaken")),
				new Item("fileModified", texts.getString("ui.fileModified"))
			});
			JCheckBox fixedShapeThumbs = new JCheckBox(texts.getString("ui.fixedShapeThumbs"), true);
			JTextField preZoomThumbs = new JSmartTextField("0", 3);
			JComboBox itemsOrder = new JComboBox(new Object[] {
				new Item("fpi", f + s + p + s + i),
				new Item("fip", f + s + i + s + p),
				new Item("pfi", p + s + f + s + i),
				new Item("pif", p + s + i + s + f),
				new Item("ifp", i + s + f + s + p),
				new Item("ipf", i + s + p + s + f),
				new Item("fi", f + s + i),
				new Item("if", i + s + f),
				new Item("i", i)
			});
				
			ControlPanel folders = new ControlPanel(texts.getString("ui.folders")) {
				
				JCheckBox showFolderDescription = new JCheckBox(texts.getString("ui.showFolderDescription"), true);
				JCheckBox showFolderImageCount = new JCheckBox(texts.getString("ui.showFolderImageCount"), true);
				
				{					
					add(showFolderDescription);
					add("br", showFolderImageCount);
				}
			};
			
			ControlPanel pages = new ControlPanel(texts.getString("ui.pages")) {
				
				JCheckBox showPagesAsThumbs = new JCheckBox(texts.getString("ui.showPagesAsThumbnails"), false);
				JCheckBox showPageExcerpt = new JCheckBox(texts.getString("ui.showPageExcerpt"), false);
				
				{
					showPageExcerpt.setToolTipText(texts.getString("ui.showPageExcerptInfo"));
					
					add(showPageExcerpt);
				}
			};
			
			ControlPanel thumbs = new ControlPanel(texts.getString("ui.images")) {
			
				JTextArea thumbCaptionTemplate = new JSmartTextArea(4, 30);
				JScrollPane tCaptionPane = new JScrollPane(thumbCaptionTemplate);
				JComboBox captionPlacement = new JComboBox(new Object[] {
					new Item("tooltip", texts.getString("ui.tooltip")), 
					new Item("below", texts.getString("ui.below"))
				});
				
				{
					thumbCaptionTemplate.setText("<span class=\"nr\">${imageNum}</span> <strong>${fileTitle}</strong> <small>${comment}</small>");
					thumbCaptionTemplate.setEditable(true);
					thumbCaptionTemplate.setLineWrap(true);
					thumbCaptionTemplate.setWrapStyleWord(true);
					
					add(new JLabel(texts.getString("ui.placeThumbCaptions")));
					add(captionPlacement);
					add("br", new JLabel(texts.getString("ui.captionTemplate")));
					add("br hfill", tCaptionPane);
				}
			};
			
			{
				newDaysCount.setToolTipText(texts.getString("ui.newDaysCountInfo"));
				fixedShapeThumbs.setToolTipText(texts.getString("ui.fixedShapeThumbsInfo"));
				ComponentUtilities.whenSelectedEnable(fixedShapeThumbs, new JComponent[]{preZoomThumbs});
				preZoomThumbs.setToolTipText(texts.getString("ui.preZoomThumbsInfo"));
				itemsOrder.setSelectedIndex(1);
				
				add(new JLabel(texts.getString("ui.markFilesNew")));
				add("", newDaysCount);
				add(new JLabel(texts.getString("ui.daysOld")));
				add(" ", new JLabel(texts.getString("ui.reference")));
				add(newDaysRef);
				add("br", fixedShapeThumbs);
				add("tab", new JLabel(texts.getString("ui.preZoomThumbs") + " 100+"));
				add("", preZoomThumbs);
				add("", new JLabel("%"));
				add("br", new JLabel(texts.getString("ui.itemsOrder")));
				add("", itemsOrder);
				add("br", folders);
				add("hfill", pages);
				add("br hfill", thumbs);
				
			}
		};
	
		
		ControlPanel footer = new ControlPanel() {
			
			JCheckBox showImageCount = new JCheckBox(texts.getString("ui.showFolderImageCount"), true);	
			JCheckBox showBottomNavigation = new JCheckBox(texts.getString("ui.showBottomNavigation"), false);	
			JCheckBox showHelp = new JCheckBox(texts.getString("ui.showHelpLink"), true);	
			
			ControlPanel customLinkPanel = new ControlPanel(texts.getString("ui.customLink")) {
				
				JTextField customLink = new JSmartTextField();
				JTextField customLinkText = new JSmartTextField();
				
				{
					customLink.setToolTipText(texts.getString("ui.customLinkInfo"));
					customLinkText.setToolTipText(texts.getString("ui.customLinkTextInfo"));
					
					add(new JLabel("URL"));
					add("tab hfill", customLink);
					add("br", new JLabel(texts.getString("ui.customLinkText")));
					add("tab hfill", customLinkText);
				}
				
			};
			
			ControlPanel footerPanel = new ControlPanel(texts.getString("ui.customContent")) {
				
				JCheckBox footerTopLevelOnly = new JCheckBox(texts.getString("ui.topLevelOnly"), false);
				JTextArea footer = new JSmartTextArea(6, 30);
				JScrollPane footerPane = new JScrollPane(footer);
				
				{
					footer.setEditable(true);
					footer.setLineWrap(true);
					footer.setWrapStyleWord(true);
					footer.setToolTipText(texts.getString("ui.customContentInfo"));
				
					add(footerTopLevelOnly);
					add("br hfill", footerPane);
					add("br", formattingHint1f);
					add("br", formattingHint2f);
				}
			};

			{
				showImageCount.setToolTipText(texts.getString("ui.showFolderImageCountInfo"));
				showBottomNavigation.setToolTipText(texts.getString("ui.showBottomNavigationInfo"));
				showHelp.setToolTipText(texts.getString("ui.displayHelpButtonInfo"));

				add("", showImageCount);
				add("br", showBottomNavigation);
				add("br hfill", customLinkPanel);
				add("br", showHelp);
				add("br hfill", footerPanel);
			}
		};
		
		
		ControlPanel images = new ControlPanel() {

			JComboBox transitionType = new JComboBox(new Object[] {
				new Item("crossFade", texts.getString("ui.crossFade")),
				new Item("crossFadeAndZoom", texts.getString("ui.crossFadeAndZoom")),
				new Item("none", texts.getString("ui.none"))
			});
			JTextField transitionSpeed = new JSmartTextField("600", 8);
			JTextField slideshowDelay = new JSmartTextField("4", 3);
			JCheckBox slideshowLoop = new JCheckBox(texts.getString("ui.loop"));
			JCheckBox slideshowAuto = new JCheckBox(texts.getString("ui.autoStart"));
			JComboBox afterLast = new JComboBox(new Object[] {
				new Item("donothing", texts.getString("ui.doNothing")), 
				new Item("startover", texts.getString("startOver")),
				new Item("onelevelup", texts.getString("upOneLevel")),
				new Item("backtoindex", texts.getString("backToIndex")),
				new Item("ask", texts.getString("ui.ask"))
			});
			JCheckBox slideshowFullScreen = new JCheckBox(texts.getString("ui.slideshowFullScreen"));
			
			ControlPanel visibility = new ControlPanel(texts.getString("ui.visibility")) {
				
				JCheckBox thumbnailsVisible = new JCheckBox(texts.getString("ui.thumbnailsVisible"));
				JComboBox reduceThumbs = new JComboBox(new Object[] {
					new Item("1.0", "1 / 1"), 
					new Item("0.75", "3 / 4"), 
					new Item("0.66666667", "2 / 3"), 
					new Item("0.5", "1 / 2"), 
					new Item("0.33333333", "1 / 3"), 
					new Item("0.25", "1 / 4") 
				});
				JCheckBox infoPanelVisible = new JCheckBox(texts.getString("ui.infoPanelVisible"));
				JCheckBox photoDataVisible = new JCheckBox(texts.getString("ui.photoData"));
				JCheckBox regionsVisible = new JCheckBox(texts.getString("ui.regions"));
				JCheckBox mapVisible = new JCheckBox(texts.getString("ui.map"));
				JCheckBox shopVisible = new JCheckBox(texts.getString("ui.sellingPhotos"));
				JCheckBox showImageNumbers = new JCheckBox(texts.getString("ui.showImageNumbers"), true);
				
				{
					showImageNumbers.setToolTipText(texts.getString("ui.showImageNumbersInfo"));
					thumbnailsVisible.setToolTipText(texts.getString("ui.thumbnailsVisibleInfo"));
					reduceThumbs.setSelectedIndex(2);
					infoPanelVisible.setToolTipText(texts.getString("ui.infoPanelVisibleInfo"));
					ComponentUtilities.whenSelectedEnable(infoPanelVisible, new JComponent[]{photoDataVisible, regionsVisible, mapVisible, shopVisible});
					
					add(thumbnailsVisible);
					add(" ", new JLabel(texts.getString("ui.shrink")));
					add("", reduceThumbs);
					add("br", infoPanelVisible);
					add("br", new JLabel(texts.getString("ui.openByDefault")));
					add(" ", photoDataVisible);
					add(" ", regionsVisible);
					add(" ", mapVisible);
					add(" ", shopVisible);
					add("br", showImageNumbers);
				}
			};
			
			JCheckBox fitImages = new JCheckBox(texts.getString("ui.fitImages"));
			JCheckBox fitShrinkonly = new JCheckBox(texts.getString("ui.fitShrinkonly"));
			JCheckBox autoCorrect = new JCheckBox(texts.getString("ui.autoCorrect"), false);
			JTextField watermark = new JSmartTextField(30);
			JComboBox watermarkPosition = new JComboBox( getPosition() );
			JTextField watermarkStrength = new JSmartTextField("15", 3);
			JTextField watermarkSize = new JSmartTextField("20", 3);
			
			JTextArea imgCaptionTemplate = new JSmartTextArea(3, 30);
			JScrollPane iCaptionPane = new JScrollPane(imgCaptionTemplate);

			{
				transitionType.setSelectedIndex(1);
				transitionSpeed.setToolTipText(texts.getString("ui.transitionSpeedInfo"));
				slideshowDelay.setToolTipText(texts.getString("ui.slideshowDelayInfo"));
				slideshowFullScreen.setToolTipText(texts.getString("ui.slideshowFullScreenInfo"));
				afterLast.setToolTipText(texts.getString("ui.afterLastInfo"));
				afterLast.setSelectedIndex(4);
				fitImages.setToolTipText(texts.getString("ui.fitImagesInfo"));
				fitShrinkonly.setToolTipText(texts.getString("ui.fitShrinkonlyInfo"));
				autoCorrect.setToolTipText(texts.getString("ui.autoCorrectInfo"));
				watermark.setToolTipText(texts.getString("ui.watermarkInfo"));
				watermarkPosition.setSelectedIndex(8);
				watermarkStrength.setToolTipText(texts.getString("ui.strengthInfo"));
				watermarkSize.setToolTipText(texts.getString("ui.sizeInfo"));
				ComponentUtilities.whenSelectedEnable(fitImages, new JComponent[]{fitShrinkonly});
				imgCaptionTemplate.setText("<h2>${fileLabel}</h2><div class=\"comment\">${comment}</div>");
				imgCaptionTemplate.setEditable(true);
				imgCaptionTemplate.setLineWrap(true);
				imgCaptionTemplate.setWrapStyleWord(true);

				add(new JLabelFor(texts.getString("ui.transition"), transitionType));
				add("tab", transitionType);
				add(" ", new JLabelFor(texts.getString("ui.transitionSpeed"), transitionSpeed));
				add(transitionSpeed);
				add(new JLabel("ms"));
				add("br", new JLabel(texts.getString("ui.slideshowDelay")));
				add("tab", slideshowDelay);
				add(" ", slideshowLoop);
				add(" ", slideshowAuto);
				add(" ", slideshowFullScreen);
				add("br", new JLabelFor(texts.getString("ui.afterLast"), afterLast));
				add("tab", afterLast);
				add("br", fitImages);
				add(" ", fitShrinkonly);
				add("br", autoCorrect);
				add("br", new JLabelFor(texts.getString("ui.watermark"), watermark));
				add("tab", watermark);
				add("br tab", watermarkPosition);
				add(" ", new JLabelFor(texts.getString("ui.strength"), watermarkStrength));
				add(watermarkStrength);
				add(new JLabelFor(texts.getString("ui.size"), watermarkSize));
				add(watermarkSize);
				add("br hfill", visibility);
				add("br", new JLabelFor(texts.getString("ui.captionTemplate"), iCaptionPane));
				add("br hfill", iCaptionPane);
			}
		};
		
		
		ControlPanel social = new ControlPanel() {

			ControlPanel buttons = new ControlPanel(texts.getString("ui.buttons")) {
				
				JCheckBox facebookLike = new JCheckBox(texts.getString("ui.facebookLikeButton"));
				JCheckBox twitterTweet = new JCheckBox(texts.getString("ui.tweetButton"));
				JCheckBox googlePlus = new JCheckBox(texts.getString("ui.googlePlus"));
				JCheckBox tumblrButton = new JCheckBox(texts.getString("ui.tumblrButton"));
				JCheckBox pinItButton = new JCheckBox(texts.getString("ui.pinItButton"));
				
				{
					facebookLike.setToolTipText(texts.getString("ui.facebookLikeButtonInfo"));
					twitterTweet.setToolTipText(texts.getString("ui.tweetButtonInfo"));
					googlePlus.setToolTipText(texts.getString("ui.googlePlusInfo"));
					tumblrButton.setToolTipText(texts.getString("ui.tumblrButtonInfo"));
					pinItButton.setToolTipText(texts.getString("ui.pinItButtonInfo"));
					
					add(facebookLike);
					add("tab", twitterTweet);
					add("br", googlePlus);
					add("tab", tumblrButton);
					add("br", pinItButton);
				}
			};
			
			ControlPanel shares = new ControlPanel(texts.getString("shareOn")) {
				
				JCheckBox shareFacebook = new JCheckBox("Facebook");
				JCheckBox shareTwitter = new JCheckBox("Twitter");
				JCheckBox shareGplus = new JCheckBox("Google+");
				JCheckBox shareDigg = new JCheckBox("Digg");
				JCheckBox shareDelicious = new JCheckBox("Delicious");
				JCheckBox shareMyspace = new JCheckBox("MySpace");
				JCheckBox shareStumbleupon = new JCheckBox("StumbleUpon");
				JCheckBox shareReddit = new JCheckBox("Reddit");
				JCheckBox shareEmail = new JCheckBox("Email");
				
				{
					add(shareFacebook);
					add("tab", shareTwitter);
					add("tab", shareGplus);
					add("tab", shareDigg);
					add("tab", shareDelicious);
					add("br", shareMyspace);
					add("tab", shareStumbleupon);
					add("tab", shareReddit);
					add("tab", shareEmail);
				}
			};

			ControlPanel commenting = new ControlPanel(texts.getString("ui.commenting")) {
			
				JCheckBox facebookCommenting = new JCheckBox(texts.getString("ui.facebookCommenting"));
				JTextField facebookAppId = new JSmartTextField("");
				JTextField facebookCommentingPosts = new JSmartTextField("3", 2);
				
				{
					facebookAppId.setToolTipText(texts.getString("ui.facebookAppIdInfo"));
					facebookCommentingPosts.setToolTipText(texts.getString("ui.facebookCommentingPostsInfo"));
					ComponentUtilities.whenSelectedEnable(facebookCommenting, new JComponent[]{facebookAppId, facebookCommentingPosts});
					
					add(facebookCommenting);
					add(" ", new JLinkLabel("https://developers.facebook.com/", texts.getString("ui.signUp")));
					add("br", new JLabel(texts.getString("ui.facebookAppId")));
					add("tab hfill", facebookAppId);
					add("br", new JLabel(texts.getString("ui.facebookCommentingPosts")));
					add("tab", facebookCommentingPosts);
				}
				
			};
			
			{
				add("hfill", buttons);
				add("br hfill", shares);
				add("br hfill", commenting);
			}
		};
		
		ControlPanel photoData = new ControlPanel() {

			JCheckBox showRegions = new JCheckBox(texts.getString("ui.showRegions"), true);
			JCheckBox showPhotoData = new JCheckBox(texts.getString("ui.showPhotoData"));
			JCheckBox showPhotoDataLabel = new JCheckBox(texts.getString("ui.showLabel"), true);
			JTextArea photoDataTemplate = new JSmartTextArea(12, 30);
			JScrollPane photoDataPane = new JScrollPane(photoDataTemplate);

			{
				showRegions.setToolTipText(texts.getString("ui.showRegionsInfo"));
				showPhotoData.setToolTipText(texts.getString("ui.showPhotoDataInfo"));
				showPhotoDataLabel.setToolTipText(texts.getString("ui.showLabelInfo"));
				photoDataTemplate.setText("photographer|artist|Artist|Owner|Copyright|Iptc.By-line|Iptc.Copyright Notice, Xmp.Creator, Xmp.Title, objectName, Xmp.Subject, Xmp.Description, Iptc.keywords, Xmp.Format, Xmp.Rights, Xmp.Identifier, Xmp.Label, Country/Primary Location, Province/State, City, Sub-location, originalDate|Date/Time Original|Date/Time|CreateDate|ModifyDate, camera|Model, lens|Lens|Xmp.Lens-Information|Canon Makernote.Unknown tag (0x0095), focalLength35mm|focusDistance|Focal Length|Focallength, SubjectDistance, meteringMode|Metering Mode, isoEquivalent|ISO Speed Ratings, exposureTime|Exposure Time|Shutter Speed Value|ShutterSpeedValue, Aperture Value|aperture|F-Number|FNumber|Aperturevalue, Exposure Bias Value, Exposure Program|Exposureprogram|Exposure Mode, Xmp.SceneType, White Balance|WhiteBalance, Xmp.ColorSpace, Xmp.LightSource, flash|Flash, resolution");
				photoDataTemplate.setEditable(true);
				photoDataTemplate.setLineWrap(true);
				photoDataTemplate.setWrapStyleWord(true);

				ComponentUtilities.whenSelectedEnable(showPhotoData, new JComponent[]{showPhotoDataLabel, photoDataTemplate});
				add(showRegions);
				add("br", showPhotoData);
				add("tab", showPhotoDataLabel);
				add("br hfill vfill", photoDataPane);
			}
		};
		
		ControlPanel map = new ControlPanel() {

			JCheckBox showMap = new JCheckBox(texts.getString("ui.showMap"));
			JComboBox mapType = new JComboBox(new Object[]{
				new Item("roadmap", texts.getString("ui.roadmap")),
				new Item("satellite", texts.getString("ui.satellite")),
				new Item("hybrid", texts.getString("ui.hybrid")),
				new Item("terrain", texts.getString("ui.terrain"))
			});
			JSlider mapZoom = new JSlider(JSlider.HORIZONTAL, 1, 20, 18);
			JCheckBox mapAll = new JCheckBox(texts.getString("ui.allMarkers"));

			{
				showMap.setToolTipText(texts.getString("ui.showMapInfo"));
				mapAll.setToolTipText(texts.getString("ui.allMarkersInfo"));
				mapZoom.setOrientation(JSlider.HORIZONTAL);
				mapZoom.setMinimum(0);
				mapZoom.setMaximum(20);
				mapZoom.setValue(18);
				mapZoom.setMajorTickSpacing(10);
				mapZoom.setMinorTickSpacing(1);
				mapZoom.setPaintTicks(true);
				mapZoom.setPaintLabels(true);
				mapZoom.setSnapToTicks(true);

				ComponentUtilities.whenSelectedEnable(showMap, new JComponent[]{ mapAll, mapType, mapZoom });
				add(showMap);
				add("", mapAll);
				add("br", new JLabelFor(texts.getString("ui.initialView"), mapType));
				add("tab", mapType);
				add("br", new JLabelFor(texts.getString("ui.initialZoom"), mapZoom));
				add("tab", mapZoom);
			}
		};
		
		ControlPanel shop = new ControlPanel() {
			
			ControlPanel shoppingCart = new ControlPanel(texts.getString("ui.shoppingCart")) {
			
				JCheckBox showShop = new JCheckBox(texts.getString("ui.sellPhotos"));
				JComboBox shopGateway = new JComboBox(new Object[]{
					new Item("paypal", "PayPal Website Standards Payment"),
					new Item("google", "Google Checkout") /*,
					new Item("amazon", "Checkout by Amazon")*/
				});
				JTextField shopId = new JTextField(10);
				JComboBox shopCurrency = new JComboBox(new Object[]{ 
					new Item("USD", "United States Dollars"),
					new Item("EUR", "Euro"),
					new Item("GBP", "United Kingdom Pounds"),
					new Item("CAD", "Canada Dollars"),
					new Item("AUD", "Australia Dollars"),
					//new Item("RUB", "Russia Rubles"),
					new Item("JPY", "Japan Yen"),
					//new Item("INR", "India Rupees"),
					new Item("NZD", "New Zealand Dollars"),
					new Item("CHF", "Switzerland Francs"),
					//new Item("ARS", "Argentina Pesos"),
					//new Item("BHD", "Bahrain Dinars"),
					//new Item("BYR", "Belarus Rubles"),
					//new Item("BAM", "Bosnia & Herzegovina C.Marka"),
					//new Item("BRL", "Brazil Reais"),
					//new Item("BGN", "Bulgaria Leva"),
					//new Item("CLP", "Chile Pesos"),
					//new Item("CNY", "China Yuan Renminbi"),
					//new Item("COP", "Colombia Pesos"),
					//new Item("CRC", "Costa Rica Colones"),
					//new Item("HRK", "Croatia Kuna"),
					new Item("CZK", "Czech Republic Koruny"),
					new Item("DKK", "Denmark Kroner"),
					//new Item("EGP", "Egypt Pounds"),
					//new Item("EEK", "Estonia Krooni"),
					//new Item("GTQ", "Guatemala Quetzales"),
					new Item("HKD", "Hong Kong Dollars"),
					new Item("HUF", "Hungary Forint"),
					//new Item("ISK", "Iceland Kronur"),
					//new Item("IDR", "Indonesia Rupiahs"),
					//new Item("IQD", "Iraq Dinars"),
					new Item("ILS", "Israel New Shekels"),
					//new Item("JMD", "Jamaica Dollars"),
					//new Item("JOD", "Jordan Dinars"),
					//new Item("KWD", "Kuwait Dinars"),
					//new Item("LVL", "Latvia Lati"),
					//new Item("LBP", "Lebanon Pounds"),
					//new Item("LTL", "Lithuania Litai"),
					//new Item("MKD", "Macedonia Denars"),
					new Item("MXN", "Mexico Pesos"),
					//new Item("MDL", "Moldova Lei"),
					//new Item("MAD", "Morocco Dirhams"),
					new Item("NOK", "Norway Kroner"),
					//new Item("PEN", "Peru Nuevos Soles"),
					//new Item("PHP", "Philippines Pesos"),
					new Item("PLN", "Poland Zlotych"),
					//new Item("RON", "Romania New Lei"),
					//new Item("SAR", "Saudi Arabia Riyals"),
					//new Item("RSD", "Serbia Dinars"),
					new Item("SGD", "Singapore Dollars"),
					//new Item("ZAR", "South Africa Rand"),
					//new Item("KRW", "South Korea Won"),
					new Item("SEK", "Sweden Kronor"),
					//new Item("TWD", "Taiwan New Dollars"),
					new Item("THB", "Thailand Baht")//,
					//new Item("TRY", "Turkey Lira"),
					//new Item("UAH", "Ukraine Hryvnia"),
					//new Item("AED", "United Arab Emirates Dirhams"),
					//new Item("UYU", "Uruguay Pesos"),
					//new Item("VND", "Vietnam Dong")
				});
				JTextField shopHandling = new JSmartTextField(4);
				JTextField shopQuantityCap = new JSmartTextField(4);
				JTextArea shopOptions = new JSmartTextArea(7, 30);
				ActionListener checkCurrency = new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						int i = shopGateway.getSelectedIndex();
						if ( i == 1 && (i = shopCurrency.getSelectedIndex()) != 0 && i != 2) {
							JOptionPane.showMessageDialog(window, texts.getString("ui.gcCurrencyWarning"), "Warning", JOptionPane.WARNING_MESSAGE);
							shopCurrency.setSelectedIndex(0);
						}
				}};
				
				{
					if ( license.length() == 0 ) {
						showShop.setSelected(false);
						commercialMonitor.add(showShop);
					}
					showShop.setToolTipText(texts.getString("ui.sellPhotosInfo"));
					shopGateway.setToolTipText(texts.getString("ui.paymentGatewayInfo"));
					shopGateway.addActionListener(checkCurrency); 
					shopId.setToolTipText(texts.getString("ui.sellerIdInfo"));
					shopCurrency.setEditable(false);
					//shopCurrency.setToolTipText(texts.getString("ui.currencyInfo"));
					shopCurrency.addActionListener(checkCurrency);
					shopHandling.setToolTipText(texts.getString("ui.handlingInfo"));
					shopQuantityCap.setToolTipText(texts.getString("ui.shopQuantityCapInfo"));
					shopOptions.setToolTipText(texts.getString("ui.shopOptionsInfo"));
					shopOptions.setText("5x3.75\" Print=0.07\n6x4\" Print=0.1\n6x4.5\" Print=0.15\n7.5x5\" Print=0.3\n9x6\" Print=0.4\n12x8\" Print=1.0\n15x10\" Print=2.0");
					shopOptions.setEditable(true);
					shopOptions.setLineWrap(true);
					shopOptions.setWrapStyleWord(true);
	
					JScrollPane shopPane = new JScrollPane(shopOptions);
					ComponentUtilities.whenSelectedEnable(showShop, new JComponent[]{shopGateway, shopId, shopCurrency, shopHandling, shopQuantityCap, shopOptions});
	
					add(showShop);
					add(" ", new JLinkLabel("https://www.paypal.com/cgi-bin/webscr?cmd=_registration-run", "Paypal"));
					add(" ", new JLinkLabel("https://checkout.google.com/customer/gadget/businessSignup.html", "Google Checkout"));
					add("br", new JLabelFor(texts.getString("ui.paymentGateway"), shopGateway));
					add("tab", shopGateway);
					add("br", new JLabelFor(texts.getString("ui.sellerId"), shopId));
					add("tab hfill", shopId);
					add("br", new JLabelFor(texts.getString("ui.currency"), shopCurrency));
					add("tab", shopCurrency);
					add("br", new JLabelFor(texts.getString("ui.handling"), shopHandling));
					add("tab", shopHandling);
					add("tab", new JLabelFor(texts.getString("ui.shopQuantityCap"), shopQuantityCap));
					add("tab", shopQuantityCap);
					add("br", new JLabelFor(texts.getString("ui.shopOptions"), shopOptions));
					add("br hfill", shopPane);
				}
			};
			
			ControlPanel fotomoto = new ControlPanel("Fotomoto") {
			
				JCheckBox useFotomoto = new JCheckBox(texts.getString("ui.useFotomoto"));
				JTextField fotomotoID = new JSmartTextField();
				
				{
					fotomotoID.setToolTipText(texts.getString("ui.fotomotoIDInfo"));
					ComponentUtilities.whenSelectedEnable(useFotomoto, new JComponent[]{fotomotoID});
					
					add(useFotomoto);
					add(new JLinkLabel("http://my.fotomoto.com/signup", texts.getString("ui.signUp")));
					add("br", new JLabelFor(texts.getString("ui.sellerId"), fotomotoID));
					add("tab hfill", fotomotoID);
				}
				
			};
	
			{	
				add("hfill", shoppingCart);
				add("br hfill", fotomoto);
			}
		};
				
		ControlPanel av = new ControlPanel() {
			
			JCheckBox videoAutoPlay = new JCheckBox(texts.getString("ui.startVideo"));
			JTextField videoSize = new JSmartTextField("640x480", 10);
			JCheckBox audioAutoPlay = new JCheckBox(texts.getString("ui.startMusic"));

			ControlPanel backgroundAudio = new ControlPanel(texts.getString("ui.backgroundMusic")) {

				JCheckBox useAlbumAudioAsBackground = new JCheckBox(texts.getString("ui.useAlbumAudioAsBackground"));
				JPlaylist playlist = new JPlaylist();
				JCheckBox backgroundAudioAutoPlay = new JCheckBox(texts.getString("ui.autoStart"));
				JCheckBox backgroundAudioLoop = new JCheckBox(texts.getString("ui.loop"));

				{
					ComponentUtilities.whenSelectedDisable(useAlbumAudioAsBackground, new JComponent[]{playlist});
					add(useAlbumAudioAsBackground);
					add("br hfill", playlist);
					add("br", backgroundAudioAutoPlay);
					add("tab", backgroundAudioLoop);
				}
			};
			
			{
				add("", videoAutoPlay);
				add("tab", new JLabel(texts.getString("ui.videoSize")));
				add("", videoSize);
				add("br", audioAutoPlay);
				add("br hfill", backgroundAudio);
			}
		};
		
		ControlPanel advanced = new ControlPanel() {
			
			ControlPanel general = new ControlPanel() {

				JCheckBox enableMouseWheel = new JCheckBox(texts.getString("ui.enableMouseWheel"), true);
				JCheckBox enableKeyboard = new JCheckBox(texts.getString("ui.enableKeyboard"), true);
				JCheckBox autohideControls = new JCheckBox(texts.getString("ui.autohideControls"), true);
				JCheckBox rightClickProtect = new JCheckBox(texts.getString("ui.rightClickProtect"));
				JCheckBox preFormat = new JCheckBox(texts.getString("ui.preFormatPages"), true);
				JCheckBox copyFolderThumbs = new JCheckBox(texts.getString("ui.copyFolderThumbs"), false);
				JCheckBox addAltTags = new JCheckBox(texts.getString("ui.addAltTags"), true);
				JTextField googleSiteID = new JSmartTextField();
				JTextField uploadPath = new JSmartTextField();
				JCheckBox debugMode = new JCheckBox(texts.getString("ui.debugMode"));
				JTextField debugVars = new JSmartTextField();				
				
				{
					enableMouseWheel.setToolTipText(texts.getString("ui.enableMouseWheelInfo"));
					enableKeyboard.setToolTipText(texts.getString("ui.enableKeyboardInfo"));
					autohideControls.setToolTipText(texts.getString("ui.autohideControlsInfo"));
					rightClickProtect.setToolTipText(texts.getString("ui.rightClickProtectInfo"));
					preFormat.setToolTipText(texts.getString("ui.preFormatPagesInfo"));
					copyFolderThumbs.setToolTipText(texts.getString("ui.copyFolderThumbsInfo"));
					addAltTags.setToolTipText(texts.getString("ui.addAltTagsInfo"));
					ComponentUtilities.whenSelectedEnable(preFormat, new JComponent[]{
						formattingHint1h, formattingHint2h,
						formattingHint1f, formattingHint2f 
					});
					googleSiteID.setToolTipText(texts.getString("ui.googleSiteIDInfo"));
					uploadPath.setToolTipText(texts.getString("ui.uploadPathInfo"));
					ComponentUtilities.whenSelectedEnable(debugMode, new JComponent[]{debugVars});
					
					add("", enableMouseWheel);
					add("br", enableKeyboard);
					add("br", autohideControls);
					add("br", rightClickProtect);
					add("br", preFormat);
					add("br", copyFolderThumbs);
					add("br", addAltTags);
					add("br", new JLabelFor(texts.getString("ui.googleSiteID"), googleSiteID));
					add("tab hfill", googleSiteID);
					add(" ", new JLinkLabel("http://www.google.com/analytics/", texts.getString("ui.signUp")));
					add("br", new JLabelFor(texts.getString("ui.uploadPath"), uploadPath));
					add("tab hfill", uploadPath);
					add("br", debugMode);
					add(" ", new JLabelFor(texts.getString("ui.variables"), debugVars));
					add("hfill", debugVars);
				}
			};
			
			ControlPanel codeHooks = new ControlPanel() {

				JTextArea headHook = new JSmartTextArea(5, 30);
				JScrollPane headHookPane = new JScrollPane(headHook);
				JTextArea bodyHook = new JSmartTextArea(5, 30);
				JScrollPane bodyHookPane = new JScrollPane(bodyHook);
				JTextArea cssHook = new JSmartTextArea(5, 30);
				JScrollPane cssHookPane = new JScrollPane(cssHook);
				
				{
					headHook.setEditable(true);
					headHook.setLineWrap(false);
					bodyHook.setEditable(true);
					bodyHook.setLineWrap(false);
					cssHook.setEditable(true);
					cssHook.setLineWrap(false);
					
					add(new JLabel("HEAD"));
					add("tab hfill", headHookPane);
					add("br", new JLabel("BODY"));
					add("tab hfill", bodyHookPane);
					add("br", new JLabel("CSS"));
					add("tab hfill", cssHookPane);
				}
			};
			
			JTabbedPane advancedTabs = new JTabbedPane() {

				{
					addTab(texts.getString("ui.general"), general);
					addTab(texts.getString("ui.codeToAdd"), codeHooks);
				}
			};
			
			{
				add("hfill", advancedTabs);
			}

		};
		
		ControlPanel about = new ControlPanel() {
			
			{
				add("hfill vfill", aboutPanel );
			}
		};
		
		JTabbedPane tabs = new JTabbedPane() {
			
			{
				addTab(texts.getString("ui.site"), createImageIcon("site.png"), site);
				addTab(texts.getString("ui.design"), createImageIcon("design.png"), design);
				addTab(texts.getString("ui.header"), createImageIcon("header.png"), header);
				addTab(texts.getString("ui.thumbnails"), createImageIcon("index.png"), thumbnails);
				addTab(texts.getString("ui.footer"), createImageIcon("footer.png"), footer);
				addTab(texts.getString("ui.images"), createImageIcon("slide.png"), images);
				addTab(texts.getString("ui.social"), createImageIcon("share.png"), social);
				addTab(texts.getString("ui.photoData"), createImageIcon("photodata.png"), photoData);
				addTab(texts.getString("ui.map"), createImageIcon("map.png"), map);
				addTab(texts.getString("ui.sellingPhotos"), createImageIcon("shop.png"), shop);
				addTab(texts.getString("ui.audioVideo"), createImageIcon("av.png"), av);
				addTab(texts.getString("ui.advanced"), createImageIcon("advanced.png"), advanced);
				addTab(texts.getString("ui.about"), about);
				
			}
		};
		
		{			
			add("hfill vfill", tabs);
			add("br center", new JLabel("Jalbum " + internalVersion));
			add(new JLinkLabel("http://jalbum.net/software/download/current", texts.getString("ui.upgrade"), texts.getString("ui.downloadJalbum")));
			add(new JLabel("|  " + skin + " skin " + (new SkinProperties(skinDirectory).getProperty(SkinProperties.VERSION))));
			add(new JLinkLabel("http://jalbum.net/skins/skin/" + skin, texts.getString("ui.upgrade"), texts.getString("ui.downloadSkin")));
			add(new JLabel("|"));
			add(new JLinkLabel("http://lazaworx.com/turtle-skin-settings-explained/", texts.getString("help")));
			add(new JLabel("|"));
			add(new JLinkLabel("http://jalbum.net/forum/index.jspa?categoryID=1", texts.getString("ui.support")));
		}
		
	};
		
	class ImageDataUI extends JCustomPanel {

		JTextField location = new JSmartTextField(10);
		JTextField videoSize = new JSmartTextField(10);
		JTextArea shopOptions = new JSmartTextArea(4, 10);
		JScrollPane shopPane = new JScrollPane(shopOptions);

		public ImageDataUI(JAlbumContext context) {
			super(context);
			setBackground(SystemColor.text);
			setOpaque(true);
			location.setToolTipText(texts.getString("ui.gpsLocationInfo"));
			videoSize.setToolTipText(texts.getString("ui.videoSizeInfo"));
			shopOptions.setToolTipText(texts.getString("ui.shopOptionsInfo"));
			shopOptions.setText("");
			shopOptions.setEditable(true);
			shopOptions.setLineWrap(true);
			shopOptions.setWrapStyleWord(true);

			add(new JLabel(texts.getString("ui.gpsLocation")));
			add("tab hfill", location);
			add("br", new JLabel(texts.getString("ui.videoSize")));
			add("tab hfill", videoSize);
			add("br", new JLabel(texts.getString("ui.shopOptions")));
			add("br hfill vfill", shopPane);

			init();
		}
	}
	
	class ExternalContentUI extends JCustomPanel {

		JTextArea externalContent = new JSmartTextArea(3, 10);
		JScrollPane externalContentPane = new JScrollPane(externalContent);
		JTextField externalContentSize = new JSmartTextField(10);

		public ExternalContentUI(JAlbumContext context) {
			super(context);
			setBackground(SystemColor.text);
			setOpaque(true);
			externalContent.setToolTipText(texts.getString("ui.externalContentInfo"));
			externalContent.setText("");
			externalContent.setEditable(true);
			externalContent.setLineWrap(true);
			externalContent.setWrapStyleWord(true);
			externalContentSize.setToolTipText(texts.getString("ui.externalContentSizeInfo"));

			add(new JLabel(texts.getString("ui.externalContent")));
			add("br hfill vfill", externalContentPane);
			add("br", new JLabel(texts.getString("ui.externalContentSize")));
			add("tab hfill", externalContentSize);

			init();
			
		}
	}
	
	public Gui(JAlbumWindow window, JAlbumContext context) {
		
		super(context.getEngine());
		PluginContext pc = context.getPluginContext();
		EditPanel editPanel = pc.getEditPanel();
		
		ImageDataUI imageDataUI = new ImageDataUI(context);
		ExternalContentUI externalContentUI = new ExternalContentUI(context);
		
		editPanel.addCustomTab(texts.getString("ui.imageData"), imageDataUI);
		editPanel.addCustomTab(texts.getString("ui.external"), externalContentUI);

		ui.setBorder(BorderFactory.createEmptyBorder());
		window.setSkinUI(ui);
		window.pack();
		
		// Check for variables need to change in albums made with an older skin version
		if ( !engine.getSkinVariables().containsKey("skinVersion") ) {
			window.ui2Engine();
			engine.setSlides(false);
			context.getFrame().engine2UI();
		}
		
	}
	
}
