/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPConnectionClosedException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.IPEndpoint;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.internal.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.internal.FTPPassiveDataSocket;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.PlainSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Random;
import java.util.Vector;

public class FTPControlSocket {
    public static final String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.56 2010-04-27 08:35:13 bruceb Exp $";
    static final String EOL = "\r\n";
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte LINE_FEED = 10;
    public static final int MAX_ACTIVE_RETRY = 100;
    public static final int CONTROL_PORT = 21;
    private static final String DEBUG_ARROW = "---> ";
    private static final String PASSWORD_MESSAGE = "---> PASS";
    private static final String ACCT_MESSAGE = "---> ACCT";
    private static Logger log = Logger.getLogger("FTPControlSocket");
    private boolean strictReturnCodes = true;
    protected boolean listenOnAllInterfaces = true;
    protected StreamSocket controlSock = null;
    protected Writer writer = null;
    protected Reader reader = null;
    private FTPMessageListener messageListener = null;
    protected String forcedActiveIP;
    private int lowPort = -1;
    private int highPort = -1;
    private int nextPort = 0;
    private String encoding;
    protected InetAddress remoteAddr;
    protected boolean autoPassiveIPSubstitution = false;
    protected DataChannelCallback dataChannelCallback = null;

    protected FTPControlSocket(InetAddress remoteAddr, int controlPort, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this(remoteAddr, PlainSocket.createPlainSocket(remoteAddr, controlPort, timeout), timeout, encoding, messageListener);
    }

    protected FTPControlSocket(InetAddress remoteAddr, StreamSocket controlSock, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this.remoteAddr = remoteAddr;
        this.controlSock = controlSock;
        this.messageListener = messageListener;
        this.encoding = encoding;
        try {
            this.setTimeout(timeout);
            this.initStreams();
            this.validateConnection();
        }
        catch (IOException ex) {
            log.error("Failed to initialize control socket", ex);
            controlSock.close();
            controlSock = null;
            throw ex;
        }
        catch (FTPException ex) {
            log.error("Failed to initialize control socket", ex);
            controlSock.close();
            controlSock = null;
            throw ex;
        }
    }

    protected void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
    }

    private void validateConnection() throws IOException, FTPException {
        FTPReply reply = this.readReply();
        String[] validCodes = new String[]{"220", "230"};
        this.validateReply(reply, validCodes);
    }

    protected void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new InputStreamReader(is, this.encoding);
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os, this.encoding);
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
    }

    void setListenOnAllInterfaces(boolean listenOnAll) {
        this.listenOnAllInterfaces = listenOnAll;
    }

    boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    void setTimeout(int millis) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(millis);
    }

    void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
    }

    public void close() throws IOException {
        this.controlSock.close();
    }

    public void logout() throws IOException {
        IOException ex = null;
        try {
            this.writer.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    FTPDataSocket createDataSocket(FTPConnectMode connectMode) throws IOException, FTPException {
        if (connectMode == FTPConnectMode.ACTIVE) {
            return this.createDataSocketActive();
        }
        return this.createDataSocketPASV();
    }

    FTPDataSocket createDataSocketActive() throws IOException, FTPException {
        try {
            int range;
            int count = 0;
            int maxCount = 100;
            if (this.lowPort >= 0 && this.highPort >= 0 && (range = this.highPort - this.lowPort + 1) < 100) {
                maxCount = range;
            }
            while (count < maxCount) {
                ++count;
                try {
                    FTPDataSocket socket = this.newActiveDataSocket(this.nextPort);
                    int port = socket.getLocalPort();
                    InetAddress addr = socket.getLocalAddress();
                    this.sendPORTCommand(addr, port);
                    FTPDataSocket fTPDataSocket = socket;
                    return fTPDataSocket;
                }
                catch (SocketException ex) {
                    if (count >= maxCount) continue;
                    log.warn("Detected socket in use - retrying and selecting new port");
                    this.setNextAvailablePortFromRange();
                }
            }
            throw new FTPException("Exhausted active port retry count - giving up");
        }
        finally {
            this.setNextAvailablePortFromRange();
        }
    }

    private void setNextAvailablePortFromRange() {
        if (this.lowPort < 0 && this.highPort < 0) {
            return;
        }
        this.nextPort = this.nextPort == 0 ? this.lowPort + new Random().nextInt(this.highPort - this.lowPort) : ++this.nextPort;
        if (this.nextPort > this.highPort) {
            this.nextPort = this.lowPort;
        }
        log.debug("Next active port will be: " + this.nextPort);
    }

    void sendPORTCommand(InetAddress addr, int port) throws IOException, FTPException {
        this.setDataPort(addr, port);
    }

    private short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    protected byte[] toByteArray(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    void setDataChannelCallback(DataChannelCallback callback) {
        this.dataChannelCallback = callback;
    }

    void setActivePortIPAddress(String forcedActiveIP) {
        this.forcedActiveIP = forcedActiveIP;
    }

    public void setActivePortRange(int lowest, int highest) {
        this.lowPort = lowest;
        this.highPort = highest;
        this.nextPort = this.lowPort;
    }

    private byte[] getIPAddressBytes(String IPAddress) throws FTPException {
        byte[] ipbytes = new byte[4];
        int len = IPAddress.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len && partCount <= 4; ++i) {
            char ch = IPAddress.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
            if (ch != '.' && i + 1 != len) continue;
            try {
                ipbytes[partCount++] = (byte)Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
        }
        return ipbytes;
    }

    protected void setDataPort(InetAddress host, int portNo) throws IOException, FTPException {
        String hostIP = host.getHostAddress();
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = this.toByteArray(portNo);
        if (this.forcedActiveIP != null) {
            log.info("Forcing use of fixed IP for PORT command");
            hostBytes = this.getIPAddressBytes(this.forcedActiveIP);
            hostIP = this.forcedActiveIP;
        }
        if (this.dataChannelCallback != null) {
            IPEndpoint origEndpoint = new IPEndpoint(hostIP, portNo);
            IPEndpoint newEndpoint = this.dataChannelCallback.onPORTCommand(origEndpoint);
            hostBytes = this.getIPAddressBytes(newEndpoint.getIPAddress());
            portBytes = this.toByteArray(newEndpoint.getPort());
            log.info("Changed PORT endpoint from " + origEndpoint.toString() + " => " + newEndpoint.toString());
        }
        String cmd = new StringBuffer("PORT ").append(this.toUnsignedShort(hostBytes[0])).append(",").append(this.toUnsignedShort(hostBytes[1])).append(",").append(this.toUnsignedShort(hostBytes[2])).append(",").append(this.toUnsignedShort(hostBytes[3])).append(",").append(this.toUnsignedShort(portBytes[0])).append(",").append(this.toUnsignedShort(portBytes[1])).toString();
        FTPReply reply = this.sendCommand(cmd);
        String[] validCodes = new String[]{"200", "250"};
        this.validateReply(reply, validCodes);
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        FTPReply replyObj = this.sendCommand("PASV");
        this.validateReply(replyObj, "227");
        String reply = replyObj.getReplyText();
        int[] parts = this.getPASVParts(reply);
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        String hostIP = ipAddress;
        if (this.autoPassiveIPSubstitution) {
            if (this.usingProxy()) {
                hostIP = this.controlSock.getRemoteHost();
                log.debug("Using proxy");
            } else {
                hostIP = this.remoteAddr.getHostAddress();
            }
            StringBuffer msg = new StringBuffer("Substituting server supplied IP (");
            msg.append(ipAddress).append(") with remote host IP (").append(hostIP).append(")");
            log.info(msg.toString());
        }
        if (this.dataChannelCallback != null) {
            IPEndpoint origEndpoint = new IPEndpoint(hostIP, port);
            IPEndpoint newEndpoint = this.dataChannelCallback.onPASVResponse(origEndpoint);
            hostIP = newEndpoint.getIPAddress();
            port = newEndpoint.getPort();
            log.info("Changed PASV endpoint from " + origEndpoint.toString() + " => " + newEndpoint.toString());
        }
        return this.newPassiveDataSocket(hostIP, port);
    }

    protected boolean usingProxy() {
        return false;
    }

    int[] getPASVParts(String reply) throws FTPException {
        int startIP = reply.indexOf(40);
        int endIP = reply.indexOf(41);
        if (startIP < 0) {
            for (startIP = 0; startIP < reply.length() && !Character.isDigit(reply.charAt(startIP)); ++startIP) {
            }
            --startIP;
        }
        if (endIP < 0) {
            for (endIP = reply.length() - 1; endIP > 0 && !Character.isDigit(reply.charAt(endIP)); --endIP) {
            }
            if (++endIP >= reply.length()) {
                reply = reply + ")";
            }
        }
        String ipData = reply.substring(startIP + 1, endIP).trim();
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len && partCount <= 6; ++i) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',' && ch != ' ') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch != ',' && i + 1 != len) continue;
            try {
                parts[partCount++] = Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
        }
        return parts;
    }

    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        PlainSocket sock = PlainSocket.createPlainSocket(remoteHost, port, this.controlSock.getSoTimeout());
        return new FTPPassiveDataSocket(sock);
    }

    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        ServerSocket sock = this.listenOnAllInterfaces ? new ServerSocket(port) : new ServerSocket(port, 0, this.controlSock.getLocalAddress());
        log.debug("ListenOnAllInterfaces=" + this.listenOnAllInterfaces);
        sock.setSoTimeout(this.controlSock.getSoTimeout());
        FTPActiveDataSocket activeSock = new FTPActiveDataSocket(sock);
        activeSock.setLocalAddress(this.controlSock.getLocalAddress());
        return activeSock;
    }

    public FTPReply sendCommand(String command) throws IOException, IOException, FTPException {
        this.writeCommand(command);
        return this.readReply();
    }

    void writeCommand(String command) throws IOException {
        this.log(DEBUG_ARROW + command, true);
        try {
            this.writer.write(command + EOL);
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new ControlChannelIOException(ex.getMessage());
        }
    }

    private String readLine() throws IOException {
        int current = 0;
        StringBuffer str = new StringBuffer();
        StringBuffer err = new StringBuffer();
        while (true) {
            try {
                current = this.reader.read();
            }
            catch (IOException ex) {
                log.error("Read failed ('" + err.toString() + "' read so far)");
                throw new ControlChannelIOException(ex.getMessage());
            }
            if (current < 0) {
                String msg = "Control channel unexpectedly closed ('" + err.toString() + "' read so far)";
                log.error(msg);
                throw new ControlChannelIOException(msg);
            }
            if (current == 10) break;
            if (current != 13) {
                str.append((char)current);
                err.append((char)current);
                continue;
            }
            err.append("<cr>");
        }
        return str.toString();
    }

    FTPReply readReply() throws IOException, FTPException {
        String line = this.readLine();
        while (line != null && line.length() == 0) {
            line = this.readLine();
        }
        this.log(line, false);
        if (line.length() < 3) {
            String msg = "Short reply received (" + line + ")";
            log.error(msg);
            throw new MalformedReplyException(msg);
        }
        String replyCode = line.substring(0, 3);
        StringBuffer reply = new StringBuffer("");
        if (line.length() > 3) {
            reply.append(line.substring(4));
        }
        Vector<String> dataLines = null;
        if (line.charAt(3) == '-') {
            dataLines = new Vector<String>();
            boolean complete = false;
            while (!complete) {
                line = this.readLine();
                if (line == null) {
                    String msg = "Control channel unexpectedly closed";
                    log.error(msg);
                    throw new ControlChannelIOException(msg);
                }
                if (line.length() == 0) continue;
                this.log(line, false);
                if (line.length() > 3 && line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ").append(line);
                dataLines.addElement(line);
            }
        }
        if (dataLines != null) {
            Object[] data = new String[dataLines.size()];
            dataLines.copyInto(data);
            return new FTPReply(replyCode, reply.toString(), (String[])data);
        }
        return new FTPReply(replyCode, reply.toString());
    }

    FTPReply validateReply(String reply, String expectedReplyCode) throws FTPException {
        FTPReply replyObj = new FTPReply(reply);
        if (this.validateReplyCode(replyObj, expectedReplyCode)) {
            return replyObj;
        }
        throw new FTPException(replyObj);
    }

    public FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        FTPReply replyObj = new FTPReply(reply);
        return this.validateReply(replyObj, expectedReplyCodes);
    }

    public FTPReply validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        for (int i = 0; i < expectedReplyCodes.length; ++i) {
            if (!this.validateReplyCode(reply, expectedReplyCodes[i])) continue;
            return reply;
        }
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < expectedReplyCodes.length; ++i) {
            buf.append(expectedReplyCodes[i]);
            if (i + 1 >= expectedReplyCodes.length) continue;
            buf.append(",");
        }
        buf.append("]");
        log.info("Expected reply codes = " + buf.toString());
        throw new FTPException(reply);
    }

    public FTPReply validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        if (this.validateReplyCode(reply, expectedReplyCode)) {
            return reply;
        }
        log.info("Expected reply code = [" + expectedReplyCode + "]");
        throw new FTPException(reply);
    }

    private boolean validateReplyCode(FTPReply reply, String expectedReplyCode) throws FTPConnectionClosedException {
        String replyCode = reply.getReplyCode();
        if ("421".equals(replyCode)) {
            throw new FTPConnectionClosedException(reply.getReplyText());
        }
        if (this.strictReturnCodes) {
            return replyCode.equals(expectedReplyCode);
        }
        return replyCode.charAt(0) == expectedReplyCode.charAt(0);
    }

    void log(String msg, boolean command) {
        if (msg.startsWith(PASSWORD_MESSAGE)) {
            msg = "---> PASS ********";
        } else if (msg.startsWith(ACCT_MESSAGE)) {
            msg = "---> ACCT ********";
        }
        log.debug(msg);
        if (this.messageListener != null) {
            if (command) {
                this.messageListener.logCommand(msg);
            } else {
                this.messageListener.logReply(msg);
            }
        }
    }
}

