/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.jalbum.editor.JTabComponent;
import net.jalbum.editor.JTextPad;
import net.jalbum.editor.Main;
import net.jalbum.editor.OperationCanceledException;
import net.jalbum.io.PCWriter;
import org.fife.io.UnicodeReader;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import se.datadosen.component.JStackLabel;
import se.datadosen.component.ToggleAction;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.StringCodec;

public class JTextPadDocument
extends JPanel {
    private JTextPad owner;
    private JTabComponent tabComponent = new JTabComponent();
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu tabsMenu;
    JMenu lineTerminationMenu;
    JMenu viewMenu;
    JMenu helpMenu;
    JRadioButtonMenuItem pcTerminationStyle = new JRadioButtonMenuItem("PC style");
    JRadioButtonMenuItem unixTerminationStyle = new JRadioButtonMenuItem("UNIX style");
    ButtonGroup terminationStyle = new ButtonGroup();
    private RSyntaxTextArea textArea;
    private AutoCompletion autoCompletion;
    private DefaultCompletionProvider provider;
    private RTextScrollPane textScroller;
    private JStackLabel statusBar;
    private JFileChooser fileChooser;
    private PrinterJob printerJob;
    int textHash;
    Action undoAction;
    Action newWindowAction;
    Action newTabAction;
    Action openAction;
    Action closeAction;
    Action saveAction;
    Action saveAsAction;
    Action pageSetupAction;
    Action printAction;
    Action goToAction;
    Action completeCodeAction;
    Action tabSizeAction;
    ToggleAction emulatedTabs;
    Action convertTabsToSpaces;
    Action convertSpacesToTabs;
    ToggleAction lineWrapAction;
    ToggleAction lineNumbersAction;
    ToggleAction whiteSpaceAction;
    ToggleAction highlightCurrentLineAction;
    Action fontSizeAction;
    Action aboutAction;

    public AbstractCompletionProvider getCompletionProvider() {
        return this.provider;
    }

    JTextPad getOwner() {
        return this.owner;
    }

    public JTextPadDocument(JTextPad owner) {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new RSyntaxTextArea(60, 120){

            protected void paintComponent(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                RenderingHints hints = (RenderingHints)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                g.setRenderingHints(hints);
                super.paintComponent(g);
            }
        };
        this.provider = new DefaultCompletionProvider();
        this.statusBar = new JStackLabel();
        this.fileChooser = new JFileChooser();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.tabComponent.getCloseButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.owner.closeDocument(JTextPadDocument.this);
            }
        });
        this.undoAction = RSyntaxTextArea.getAction(6);
        this.newWindowAction = new AbstractAction("New window"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad editor = new JTextPad();
                Point rel = JTextPadDocument.this.owner.getLocationOnScreen();
                editor.setLocation(rel.x + 50, rel.y + 50);
                editor.openDocument(null);
            }
        };
        this.newTabAction = new AbstractAction("New tab"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument document = JTextPadDocument.this.owner.openDocument(null);
                document.setCurrentDirectory(JTextPadDocument.this.getCurrentDirectory());
                JTextPadDocument.this.owner.setCurrentDocument(document);
            }
        };
        this.openAction = new AbstractAction("Open..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(JTextPadDocument.this.fileChooser.getCurrentDirectory());
                chooser.setSelectedFile(JTextPadDocument.this.fileChooser.getSelectedFile());
                chooser.setMultiSelectionEnabled(true);
                int choice = chooser.showOpenDialog(JTextPadDocument.this.owner);
                File[] files = chooser.getSelectedFiles();
                if (choice == 0) {
                    boolean first = true;
                    for (File f : files) {
                        JTextPadDocument document = JTextPadDocument.this.owner.openDocument(f);
                        if (!first) continue;
                        JTextPadDocument.this.owner.setCurrentDocument(document);
                        first = false;
                    }
                }
            }
        };
        this.closeAction = new AbstractAction("Close"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.owner.closeDocument(JTextPadDocument.this);
            }
        };
        this.saveAction = new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                File file = JTextPadDocument.this.getFile();
                if (file == null) {
                    if (e == null) {
                        JTextPadDocument.this.owner.setCurrentDocument(JTextPadDocument.this);
                    }
                    JTextPadDocument.this.saveAsAction.actionPerformed(e);
                } else {
                    JTextPadDocument.this.saveFile(file);
                }
            }
        };
        this.saveAsAction = new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent e) {
                int choice = JTextPadDocument.this.fileChooser.showSaveDialog(JTextPadDocument.this.owner);
                File selectedFile = JTextPadDocument.this.fileChooser.getSelectedFile();
                if (choice == 0 && selectedFile != null) {
                    if (selectedFile.exists()) {
                        int answer = JOptionPane.showConfirmDialog(JTextPadDocument.this.owner, "" + selectedFile.getAbsolutePath() + " already exists.\nDo you wish to replace it?", "Save As", 1, 2);
                        if (answer == 0) {
                            JTextPadDocument.this.saveFile(selectedFile);
                            return;
                        }
                        if (answer == 1) {
                            return;
                        }
                    }
                    JTextPadDocument.this.saveFile(selectedFile);
                    return;
                }
                throw new OperationCanceledException();
            }
        };
        this.pageSetupAction = new AbstractAction("Page Setup..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask | 1));
            }

            public void actionPerformed(ActionEvent e) {
                PageFormat pf = JTextPadDocument.this.printerJob.pageDialog(JTextPadDocument.this.printerJob.defaultPage());
                JTextPadDocument.this.printerJob.setPrintable(JTextPadDocument.this.textArea, pf);
            }
        };
        this.printAction = new AbstractAction("Print..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                boolean doPrint = JTextPadDocument.this.printerJob.printDialog();
                if (doPrint) {
                    try {
                        JTextPadDocument.this.printerJob.print();
                    }
                    catch (PrinterException ex) {
                        JOptionPane.showMessageDialog(JTextPadDocument.this.owner, "An error occured during printing: " + ex.getMessage(), "Jalbum Textpad", 0);
                    }
                }
            }
        };
        this.goToAction = new AbstractAction("Go To..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Line Number:", "Goto line", -1);
                int line = Integer.parseInt(s) - 1;
                try {
                    int i = JTextPadDocument.this.textArea.getLineStartOffset(line);
                    JTextPadDocument.this.textArea.setCaretPosition(i);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        };
        this.completeCodeAction = new AbstractAction("Complete Code"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 2));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.autoCompletion.doCompletion();
            }
        };
        this.tabSizeAction = new AbstractAction("Set tab size"){

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Tab size:", "" + JTextPadDocument.this.textArea.getTabSize());
                int tabSize = Integer.parseInt(s);
                JTextPadDocument.this.textArea.setTabSize(tabSize);
            }
        };
        this.emulatedTabs = new ToggleAction("Emulate tabs with spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setTabsEmulated(this.isSelected());
            }
        };
        this.convertTabsToSpaces = new ToggleAction("Convert tabs to spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.convertTabsToSpaces();
            }
        };
        this.convertSpacesToTabs = new ToggleAction("Convert spaces to tabs"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.convertSpacesToTabs();
            }
        };
        this.lineWrapAction = new ToggleAction("Line Wrap"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setLineWrap(this.isSelected());
            }
        };
        this.lineNumbersAction = new ToggleAction("Line Numbers"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textScroller.setLineNumbersEnabled(this.isSelected());
            }
        };
        this.whiteSpaceAction = new ToggleAction("White Space"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setWhitespaceVisible(this.isSelected());
            }
        };
        this.highlightCurrentLineAction = new ToggleAction("Highlight current line"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setHighlightCurrentLine(this.isSelected());
            }
        };
        this.fontSizeAction = new AbstractAction("Set font size..."){

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Font size:", "" + JTextPadDocument.this.textArea.getFont().getSize());
                float fontSize = Float.parseFloat(s);
                JTextPadDocument.this.textArea.setFont(JTextPadDocument.this.textArea.getFont().deriveFont(fontSize));
                Preferences.userNodeForPackage(JTextPadDocument.class).putFloat("fontSize", fontSize);
            }
        };
        this.aboutAction = new AbstractAction("About Jalbum Textpad"){

            public void actionPerformed(ActionEvent e) {
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(0, 1));
                panel.add(new JLabel("Jalbum Textpad 2.2"));
                panel.add(new JLabel("By David Ekholm, Jalbum"));
                panel.add(new JLabel("Thanks to Robert Futrell for providing the excellent"));
                panel.add(new JLabel("text editor engine RSyntaxTextArea!"));
                JOptionPane.showMessageDialog(JTextPadDocument.this.owner, panel, "About Jalbum Textpad", 1);
            }
        };
        this.init(owner);
    }

    public JTextPadDocument(JTextPad owner, File file) {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new /* invalid duplicate definition of identical inner class */;
        this.provider = new DefaultCompletionProvider();
        this.statusBar = new JStackLabel();
        this.fileChooser = new JFileChooser();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.tabComponent.getCloseButton().addActionListener(new /* invalid duplicate definition of identical inner class */);
        this.undoAction = RSyntaxTextArea.getAction(6);
        this.newWindowAction = new /* invalid duplicate definition of identical inner class */;
        this.newTabAction = new /* invalid duplicate definition of identical inner class */;
        this.openAction = new /* invalid duplicate definition of identical inner class */;
        this.closeAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAsAction = new /* invalid duplicate definition of identical inner class */;
        this.pageSetupAction = new /* invalid duplicate definition of identical inner class */;
        this.printAction = new /* invalid duplicate definition of identical inner class */;
        this.goToAction = new /* invalid duplicate definition of identical inner class */;
        this.completeCodeAction = new /* invalid duplicate definition of identical inner class */;
        this.tabSizeAction = new /* invalid duplicate definition of identical inner class */;
        this.emulatedTabs = new /* invalid duplicate definition of identical inner class */;
        this.convertTabsToSpaces = new /* invalid duplicate definition of identical inner class */;
        this.convertSpacesToTabs = new /* invalid duplicate definition of identical inner class */;
        this.lineWrapAction = new /* invalid duplicate definition of identical inner class */;
        this.lineNumbersAction = new /* invalid duplicate definition of identical inner class */;
        this.whiteSpaceAction = new /* invalid duplicate definition of identical inner class */;
        this.highlightCurrentLineAction = new /* invalid duplicate definition of identical inner class */;
        this.fontSizeAction = new /* invalid duplicate definition of identical inner class */;
        this.aboutAction = new /* invalid duplicate definition of identical inner class */;
        this.init(owner);
        if (file != null) {
            if (file.isDirectory()) {
                this.setCurrentDirectory(file);
            } else {
                this.setCurrentDirectory(file.getParentFile());
                this.openFile(file);
            }
        }
    }

    public JTabComponent getTabComponent() {
        return this.tabComponent;
    }

    JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.createMenuBar();
        }
        return this.menuBar;
    }

    JStackLabel getStatusBar() {
        return this.statusBar;
    }

    RSyntaxTextArea getTextArea() {
        return this.textArea;
    }

    void openFile(File file) {
        try {
            String line;
            byte[] raw = IO.readBytes(file);
            StringCodec sc = new StringCodec();
            String tmp = sc.decode(raw);
            if (tmp.indexOf(13) >= 0) {
                this.pcTerminationStyle.setSelected(true);
            } else {
                this.unixTerminationStyle.setSelected(true);
            }
            String encoding = sc.getDetectedEncoding();
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader(new UnicodeReader(new ByteArrayInputStream(raw), encoding));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String text = buf.toString();
            this.fileChooser.setSelectedFile(file);
            this.owner.getRootPane().putClientProperty("Window.documentFile", file);
            this.setSyntaxStyle();
            this.textArea.setText(text);
            this.textArea.setCaretPosition(0);
            this.textArea.discardAllEdits();
            this.owner.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.tabComponent.setChanged(false);
            this.textHash = text.hashCode();
            this.updateTitle();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.owner, "Can't open file " + file.getName() + ": " + ex.getMessage(), "Jalbum Textpad", 0);
        }
    }

    private void writeTextFile(String content, File file, String encoding) throws IOException {
        Writer writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        if (this.pcTerminationStyle.isSelected()) {
            writer = new PCWriter(writer);
        }
        writer.write(content);
        ((Writer)writer).close();
    }

    void saveFile(File file) {
        try {
            String text = this.textArea.getText();
            this.writeTextFile(text, file, "UTF-8");
            this.textHash = text.hashCode();
            this.owner.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.tabComponent.setChanged(false);
            this.fileChooser.setSelectedFile(file);
            this.setSyntaxStyle();
            this.updateTitle();
            this.statusBar.setText("Document written to " + file.getAbsolutePath());
            this.owner.getRootPane().putClientProperty("Window.documentFile", file);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.owner, "Can't write to file " + file.getName() + ": " + ex.getMessage(), "Jalbum Textpad", 0);
        }
    }

    void ensureNoLoss() throws OperationCanceledException {
        int currentTextHash = this.textArea.getText().hashCode();
        if (currentTextHash != this.textHash) {
            this.owner.setCurrentDocument(this);
            this.owner.setVisible(true);
            int answer = JOptionPane.showConfirmDialog(this.owner, "Save changes to " + this.getTitle() + "?", "Jalbum Textpad", 1, 2);
            if (answer == 1) {
                this.owner.setVisible(false);
                return;
            }
            if (answer == 0) {
                this.saveAction.actionPerformed(null);
                this.owner.setVisible(false);
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    public void setSyntaxStyle() {
        String ext = IO.extensionOf(this.getFile()).toLowerCase();
        String syntaxStyle = JTextPad.fileTypes.get(ext);
        if (syntaxStyle == null) {
            syntaxStyle = "text/plain";
        }
        this.textArea.setSyntaxEditingStyle(syntaxStyle);
        this.updateStatusBar();
    }

    public File getFile() {
        return this.fileChooser.getSelectedFile();
    }

    public String getTitle() {
        File file = this.getFile();
        if (file == null) {
            return "Untitled";
        }
        return file.getName();
    }

    private void updateStatusBar() {
        int line = this.textArea.getCaretLineNumber() + 1;
        int col = this.textArea.getCaretOffsetFromLineStart() + 1;
        String style = this.pcTerminationStyle.isSelected() ? "PC" : "UNIX";
        this.statusBar.setText("Mode " + this.textArea.getSyntaxEditingStyle() + " | UTF-8 | " + style + " | Ln " + line + ", Col " + col);
    }

    private void init(final JTextPad owner) {
        this.owner = owner;
        this.setLayout(new BorderLayout());
        this.printerJob.setPrintable(this.textArea);
        this.updateTitle();
        ActionListener terminationStyleListner = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.updateStatusBar();
            }
        };
        this.pcTerminationStyle.addActionListener(terminationStyleListner);
        this.unixTerminationStyle.addActionListener(terminationStyleListner);
        this.textScroller = new RTextScrollPane(this.textArea);
        if (Platform.isWindows()) {
            this.textArea.setFont(new Font("Lucida Sans Typewriter", 0, 13));
        }
        float fontSize = Preferences.userNodeForPackage(JTextPadDocument.class).getFloat("fontSize", 13.0f);
        this.textArea.setFont(this.textArea.getFont().deriveFont(fontSize));
        this.textArea.restoreDefaultSyntaxScheme();
        this.textArea.setSyntaxEditingStyle("text/plain");
        this.textArea.setLineWrap(true);
        this.provider.setParent(owner.getCompletionProvider());
        this.autoCompletion = new AutoCompletion(this.provider){

            protected String getReplacementText(Completion c, Document doc, int start, int len) {
                try {
                    if (start >= 2 && "${".equals(doc.getText(start - 2, 2)) && !JTextPadDocument.this.endsWithCurlyBrace(doc, start)) {
                        return c.getReplacementText() + "}";
                    }
                    return super.getReplacementText(c, doc, start, len);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        this.autoCompletion.setShowDescWindow(true);
        this.autoCompletion.setDescriptionWindowSize(400, 400);
        this.autoCompletion.setExternalURLHandler(new ExternalURLHandler(){

            public void urlClicked(URL url) {
                System.out.println("URL clicked: " + url.toString());
                try {
                    BrowserLauncher.openURL(url.toString());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(owner, "Can't open URL: " + ex.getMessage(), "Jalbum Textpad", 0);
                }
            }
        });
        this.autoCompletion.install(this.textArea);
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                JTextPadDocument.this.updateStatusBar();
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JTextPadDocument.this.tabComponent.setChanged(true);
            }

            public void removeUpdate(DocumentEvent e) {
                JTextPadDocument.this.tabComponent.setChanged(true);
            }

            public void changedUpdate(DocumentEvent e) {
                JTextPadDocument.this.tabComponent.setChanged(true);
            }
        });
        this.add((Component)this.textScroller, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 6));
        southPanel.add((Component)this.statusBar, "Before");
        southPanel.add((Component)new JLabel(" "), "After");
        this.statusBar.setText("no text");
        this.add((Component)southPanel, "South");
        this.undoAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (owner.getCurrentDocument() != JTextPadDocument.this) {
                    return;
                }
                if ("enabled".equals(evt.getPropertyName())) {
                    int currentTextHash = JTextPadDocument.this.textArea.getText().hashCode();
                    boolean changed = currentTextHash != JTextPadDocument.this.textHash;
                    owner.getRootPane().putClientProperty("Window.documentModified", "" + changed);
                    JTextPadDocument.this.tabComponent.setChanged(changed);
                }
            }
        });
    }

    private boolean endsWithCurlyBrace(Document doc, int offset) throws BadLocationException {
        char[] chars;
        int len = doc.getLength();
        int remaining = len - offset;
        if (remaining > 100) {
            remaining = 100;
        }
        String text = doc.getText(offset, remaining);
        for (char c : chars = text.toCharArray()) {
            if (c == '}') {
                return true;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return false;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.editMenu = new JMenu("Edit");
        this.tabsMenu = new JMenu("Tabs");
        this.lineTerminationMenu = new JMenu("Line termination");
        this.viewMenu = new JMenu("View");
        this.helpMenu = new JMenu("Help");
        this.fileMenu.add(new JMenuItem(this.newWindowAction));
        this.fileMenu.add(new JMenuItem(this.newTabAction));
        this.fileMenu.add(new JMenuItem(this.openAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.saveAction));
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.add(new JMenuItem(this.owner.saveAllAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.pageSetupAction));
        this.fileMenu.add(new JMenuItem(this.printAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.owner.exitAction));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(6)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(4)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(1)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(0)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(3)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.owner.findAction));
        this.editMenu.add(new JMenuItem(this.owner.findNextAction));
        this.editMenu.add(new JMenuItem(this.owner.replaceAction));
        this.editMenu.add(new JMenuItem(this.goToAction));
        this.editMenu.add(new JSeparator());
        this.tabsMenu.add(this.tabSizeAction);
        this.tabsMenu.add(this.emulatedTabs.createJCheckBoxMenuItem());
        this.tabsMenu.add(this.convertTabsToSpaces);
        this.tabsMenu.add(this.convertSpacesToTabs);
        this.editMenu.add(this.tabsMenu);
        this.lineTerminationMenu.add(this.pcTerminationStyle);
        this.lineTerminationMenu.add(this.unixTerminationStyle);
        this.editMenu.add(this.lineTerminationMenu);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.completeCodeAction));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(5)));
        this.viewMenu.add(this.lineWrapAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.lineNumbersAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.whiteSpaceAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.highlightCurrentLineAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.fontSizeAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.owner.previousDocumentAction);
        this.viewMenu.add(this.owner.nextDocumentAction);
        this.helpMenu.add(new JMenuItem(this.aboutAction));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        if (!Main.isMac() || !Main.runsStandalone) {
            this.menuBar.add(this.helpMenu);
        }
    }

    private void updateTitle() {
        this.tabComponent.setTitle(this.getTitle());
        this.owner.updateTitle();
    }
}

