/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private Color altBG;
    private Font font;

    public CompletionCellRenderer() {
        this.setDisplayFont(new Font("Monospaced", 0, 12));
        this.setAlternateBackground(new Color(240, 240, 240));
    }

    public Color getAlternateBackground() {
        return this.altBG;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        this.setFont(this.font);
        if (object instanceof FunctionCompletion) {
            FunctionCompletion functionCompletion = (FunctionCompletion)object;
            this.prepareForFunctionCompletion(jList, functionCompletion, n, bl, bl2);
        } else if (object instanceof VariableCompletion) {
            VariableCompletion variableCompletion = (VariableCompletion)object;
            this.prepareForVariableCompletion(jList, variableCompletion, n, bl, bl2);
        } else if (object instanceof MarkupTagCompletion) {
            MarkupTagCompletion markupTagCompletion = (MarkupTagCompletion)object;
            this.prepareForMarkupTagCompletion(jList, markupTagCompletion, n, bl, bl2);
        } else {
            Completion completion = (Completion)object;
            this.prepareForOtherCompletion(jList, completion, n, bl, bl2);
        }
        if (!bl && (n & 1) == 0 && this.altBG != null) {
            this.setBackground(this.altBG);
        }
        return this;
    }

    protected void prepareForFunctionCompletion(JList jList, FunctionCompletion functionCompletion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("<html><b><em>");
        stringBuffer.append(functionCompletion.getName());
        stringBuffer.append("</em></b>");
        stringBuffer.append(functionCompletion.getProvider().getParameterListStart());
        int n2 = functionCompletion.getParamCount();
        for (int i = 0; i < n2; ++i) {
            ParameterizedCompletion.Parameter parameter = functionCompletion.getParam(i);
            String string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                if (!bl) {
                    stringBuffer.append("<font color='#aa0077'>");
                }
                stringBuffer.append(string);
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                if (string2 != null) {
                    stringBuffer.append(' ');
                }
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(functionCompletion.getProvider().getParameterListSeparator());
        }
        stringBuffer.append(functionCompletion.getProvider().getParameterListEnd());
        stringBuffer.append(" : ");
        if (!bl) {
            stringBuffer.append("<font color='#a0a0ff'>");
        }
        stringBuffer.append(functionCompletion.getType());
        if (!bl) {
            stringBuffer.append("</font>");
        }
        this.setText(stringBuffer.toString());
    }

    protected void prepareForMarkupTagCompletion(JList jList, MarkupTagCompletion markupTagCompletion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("<html><b><em>");
        stringBuffer.append(markupTagCompletion.getName());
        stringBuffer.append("</em></b>");
        this.setText(stringBuffer.toString());
    }

    protected void prepareForOtherCompletion(JList jList, Completion completion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("<html><b><em>");
        stringBuffer.append(completion.getInputText());
        stringBuffer.append("</em></b>");
        this.setText(stringBuffer.toString());
    }

    protected void prepareForVariableCompletion(JList jList, VariableCompletion variableCompletion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("<html><b><em>");
        stringBuffer.append(variableCompletion.getName());
        stringBuffer.append("</em></b>");
        if (variableCompletion.getType() != null) {
            stringBuffer.append(" : ");
            if (!bl) {
                stringBuffer.append("<font color='#a0a0ff'>");
            }
            stringBuffer.append(variableCompletion.getType());
            if (!bl) {
                stringBuffer.append("</font>");
            }
        }
        this.setText(stringBuffer.toString());
    }

    public void setAlternateBackground(Color color) {
        this.altBG = color;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }
}

