/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class JPlainButton
extends JButton {
    protected boolean showLabel = true;

    public JPlainButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JPlainButton(Action a) {
        super(a);
        this.init();
    }

    public JPlainButton(Action a, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.init();
    }

    public JPlainButton(String text) {
        super(text);
        this.init();
    }

    public JPlainButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JPlainButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.init();
        this.setRolloverEnabled(true);
        this.setRolloverIcon(rolloverIcon);
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setBorder(Border border) {
    }

    public void setRealBorder(Border border) {
        super.setBorder(border);
    }

    private void init() {
        super.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
    }

    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (defaultIcon != null) {
            this.setRolloverEnabled(true);
            if (defaultIcon instanceof ImageIcon) {
                this.setRolloverIcon(JPlainButton.brighten((ImageIcon)defaultIcon, 1.2f));
            }
        } else {
            this.setRolloverEnabled(false);
        }
    }

    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }

    private static ImageIcon brighten(ImageIcon icon, float value) {
        BufferedImage buff = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = buff.createGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        Kernel kernel = new Kernel(1, 1, new float[]{value});
        ConvolveOp op = new ConvolveOp(kernel);
        buff = op.filter(buff, null);
        return new ImageIcon(buff);
    }
}

