/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import se.datadosen.explorer.Cache;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.scaling.ImageScaler;

public class ImageCache {
    private Cache cache;
    Dimension imageDim;
    private AlbumObject toLoad;
    private Thread preloaderThread;
    private Object preloadMonitor = new Object();
    private boolean debug = false;

    public ImageCache(int nImages, Dimension imageDim) {
        this.cache = new Cache(nImages);
        this.imageDim = imageDim;
    }

    public boolean contains(AlbumObject ao) {
        return this.cache.get(ao.getFile()) != null;
    }

    public void setImageDimension(Dimension imageDim) {
        this.imageDim = imageDim;
    }

    public void clear() {
        this.cache.clear();
    }

    public void dispose() {
        if (this.preloaderThread != null) {
            this.preloaderThread.interrupt();
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(AlbumObject ao) {
        if (ao == null || this.contains(ao)) {
            return;
        }
        Object object = this.preloadMonitor;
        synchronized (object) {
            this.toLoad = ao;
            this.preloadMonitor.notify();
        }
        if (this.preloaderThread == null) {
            this.preloaderThread = new Thread("PreloaderThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ImageCache.this.log("Launching preloader thread");
                    while (true) {
                        ImageCache.this.log("preloading " + ImageCache.this.toLoad.getName());
                        try {
                            AlbumObject ao = ImageCache.this.toLoad;
                            ImageCache.this.toLoad = null;
                            ImageCache.this.getImage(ao);
                        }
                        catch (IOException ex1) {
                            ex1.printStackTrace(System.err);
                        }
                        Object object = ImageCache.this.preloadMonitor;
                        synchronized (object) {
                            try {
                                ImageCache.this.log("Waiting...");
                                ImageCache.this.preloadMonitor.wait();
                            }
                            catch (InterruptedException ex) {
                                ImageCache.this.log("Preloader thread quitting");
                                ImageCache.this.preloaderThread = null;
                                return;
                            }
                        }
                    }
                }
            };
            this.preloaderThread.setDaemon(true);
            this.preloaderThread.setPriority(1);
            this.preloaderThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(AlbumObject ao) throws IOException {
        LoadingImageIndicator loading;
        File key = ao.getFile();
        Object value = this.cache.get(key);
        if (value != null) {
            if (!(value instanceof LoadingImageIndicator)) {
                return (Image)value;
            }
            Object object = value;
            synchronized (object) {
                return (Image)this.cache.get(key);
            }
        }
        LoadingImageIndicator loadingImageIndicator = loading = new LoadingImageIndicator();
        synchronized (loadingImageIndicator) {
            this.cache.put(key, loading);
            Image im = this.load(ao);
            im = this.ensureRgbMode(im);
            this.cache.put(key, im);
            return im;
        }
    }

    private Image load(AlbumObject ao) throws IOException {
        Image im = ao.loadImage(true, this.imageDim);
        if (im != null) {
            this.log("Scaling to " + this.imageDim);
            Image scaled = ImageCache.scaleToFit(im, this.imageDim);
            im.flush();
            return scaled;
        }
        return ao.getRepresentingIcon(this.imageDim, false).getImage();
    }

    private Image ensureRgbMode(Image im) {
        BufferedImage i;
        if (im instanceof BufferedImage && (i = (BufferedImage)im).getType() != 1) {
            i = new BufferedImage(i.getWidth(), i.getHeight(), 1);
            Graphics g = i.getGraphics();
            g.drawImage(im, 0, 0, null);
            g.dispose();
        }
        return im;
    }

    public static Image scaleToFit(Image image, Dimension boundingBox) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return image;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        return ImageCache.scale(image, newWidth, newHeight);
    }

    public static BufferedImage scale(Image image, int destinationWidth, int destinationHeight) {
        ImageScaler scaler = ImageScaler.getScaler("ScaleMedium");
        BufferedImage bufImage = scaler.scale(image, destinationWidth, destinationHeight);
        image.flush();
        return bufImage;
    }

    private void log(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    class LoadingImageIndicator {
        LoadingImageIndicator() {
        }
    }
}

