/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import com.adobe.xmp.XMPException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.WordList;
import se.datadosen.explorer.CaptionEditor;
import se.datadosen.explorer.FileNameEditor;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumObject
extends JComponent
implements Transferable,
PropertyChangeListener {
    static boolean tabCycling;
    private static ImageIcon isCommentedIcon;
    private static ImageIcon isFolderThumbnailIcon;
    private static ImageIcon isMediaFileIcon;
    private static ImageIcon hasImageFiltersIcon;
    private static ImageIcon hasOriginalIcon;
    public static DataFlavor jAlbumObjectFlavor;
    private static Image excludedImage;
    private static ImageIcon defaultImageIcon;
    private static ImageIcon[] stars;
    private Image linkImage;
    public final AlbumObject ao;
    final JExplorerPanel context;
    private boolean selected;
    private boolean rubberbanded;
    private boolean isMediaFile;
    private JPanel imagePanel = new JPanel();
    LabelEditor editor;
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 1, 1));
    private JPanel statusPanel = new JPanel(new FlowLayout(2, 0, 1));
    private JLabel image;
    private boolean renderingDone = false;
    private boolean firstPaint = true;
    private JLabel isCommentedStatus = JAlbumObject.createStatusLabel(isCommentedIcon);
    @ToolTipText(value="ui.isFolderThumbnailToolTip")
    private JLabel isFolderThumbnailStatus = JAlbumObject.createStatusLabel(isFolderThumbnailIcon);
    @ToolTipText(value="ui.isMediaFileToolTip")
    private JLabel isMediaFileStatus = JAlbumObject.createStatusLabel(isMediaFileIcon);
    @ToolTipText(value="ui.hasImageFiltersToolTip")
    private JLabel hasImageFiltersToolTip = new JFiltersLabel();
    @ToolTipText(value="ui.hasOriginaToolTip")
    private JLabel hasOriginalStatus = JAlbumObject.createStatusLabel(hasOriginalIcon);
    private JLabel ratingStatus = JAlbumObject.createStatusLabel(null);
    private JLabel flagStatus = JAlbumObject.createStatusLabel(null);

    private static JLabel createStatusLabel(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        label.setVisible(false);
        return label;
    }

    private void updateStatusIcons() {
        int rating;
        AlbumObject rep;
        boolean isFolderThumbnail = false;
        if (this.context.context.currentFolder != null && (rep = this.context.context.currentFolder.getRepresentingAlbumObject()) != null && rep.equals(this.ao)) {
            isFolderThumbnail = true;
        }
        this.isFolderThumbnailStatus.setVisible(isFolderThumbnail);
        if (this.editor instanceof FileNameEditor) {
            this.isCommentedStatus.setVisible(this.ao.getComment().length() > 0);
        }
        if ((rating = this.ao.getRating()) > 0 && rating <= 5) {
            if (this.ratingStatus.getIcon() != stars[rating - 1]) {
                this.ratingStatus.setIcon(stars[rating - 1]);
                this.ratingStatus.setToolTipText(Msg.get("ui.ratingToolTip", rating));
            }
            this.ratingStatus.setVisible(true);
        } else {
            this.ratingStatus.setVisible(false);
        }
        Flag flag = this.ao.getFlag();
        if (flag != Flag.NoFlag) {
            this.flagStatus.setIcon(flag.getIcon());
            this.flagStatus.setToolTipText(flag.toString());
            this.flagStatus.setVisible(true);
        } else {
            this.flagStatus.setVisible(false);
        }
        FilterList filterList = (FilterList)this.ao.getProperties().get("filterList");
        boolean hasFilters = filterList != null && filterList.getPosition() > 0;
        this.hasImageFiltersToolTip.setVisible(hasFilters);
        this.isMediaFileStatus.setVisible(this.isMediaFile);
        Boolean includeOriginal = (Boolean)this.ao.getProperties().get("includeOriginal");
        this.hasOriginalStatus.setVisible(includeOriginal != null && includeOriginal != false);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("JAlbum Objects are not serializable");
    }

    public JAlbumObject(AlbumObject ao, JExplorerPanel context) {
        this.ao = ao;
        this.context = context;
        WordList knownKeywords = context.context.knownKeywords;
        try {
            XmpManager manager = ao.getXmpManager();
            if (manager != null) {
                knownKeywords.addAll(manager.getKeywordSet());
            }
        }
        catch (XMPException ex) {
            // empty catch block
        }
        Config config = Config.getConfig();
        if (ao.isFolder() || config.getLabelType() == Config.LabelType.fileName) {
            this.editor = new FileNameEditor(this);
        } else if (config.getLabelType() == Config.LabelType.caption) {
            this.editor = new CaptionEditor(this);
        }
        ao.addPropertyChangeListener(this);
        this.linkImage = Platform.isMac() ? new ImageIcon(JAlbumObject.class.getResource("images/link_mac.png")).getImage() : new ImageIcon(JAlbumObject.class.getResource("images/link.png")).getImage();
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        try {
            if (ao.isDisplayableImage()) {
                this.image = new JLabel(defaultImageIcon);
            } else {
                this.image = new JLabel(ao.getRepresentingIcon(context.iconBounds, false));
                this.renderingDone = true;
            }
        }
        catch (IOException ex) {
            this.image = new JLabel("No image");
            this.renderingDone = true;
        }
        this.image.setPreferredSize(context.iconBounds);
        this.image.setLayout(new BorderLayout());
        this.buttonPanel.setOpaque(false);
        this.statusPanel.setOpaque(false);
        this.statusPanel.add(this.isFolderThumbnailStatus);
        this.statusPanel.add(this.isMediaFileStatus);
        this.statusPanel.add(this.hasImageFiltersToolTip);
        this.statusPanel.add(this.ratingStatus);
        this.statusPanel.add(this.flagStatus);
        if (this.editor instanceof FileNameEditor) {
            this.statusPanel.add(this.isCommentedStatus);
        }
        this.statusPanel.add(this.hasOriginalStatus);
        this.statusPanel.add(Box.createHorizontalStrut(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setOpaque(false);
        northPanel.add((Component)this.buttonPanel, "West");
        northPanel.add((Component)this.statusPanel, "East");
        this.image.add((Component)northPanel, "North");
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.add((Component)this.image, "Center");
        this.add((Component)this.imagePanel, "North");
        this.add((Component)this.editor, "Center");
        this.setSelected(this.selected);
        File rep = ao.getRepresentingIconFile();
        if (rep != null && rep.getName().toLowerCase().endsWith(".thm")) {
            this.isMediaFile = true;
        }
        Msg.setTexts(this);
    }

    void attachEditButton(JButton editButton) {
        if (this.buttonPanel.getComponentCount() > 0 && editButton == this.buttonPanel.getComponent(0)) {
            editButton.setVisible(true);
            return;
        }
        Container c = editButton.getParent();
        if (c != null) {
            c.remove(editButton);
        }
        this.buttonPanel.add(editButton);
        editButton.setVisible(true);
        if (!TipOfTheDay.isPendingNotification() && !TipOfTheDay.isShowingNotification()) {
            TipOfTheDay.showInBackground(Msg.get("tip.editMode"));
        }
    }

    void renderIcon() {
        try {
            this.image.setIcon(this.ao.getRepresentingIcon(this.context.iconBounds, false));
            this.renderingDone = true;
        }
        catch (IOException ex) {
            this.image.setText("Broken");
            this.renderingDone = true;
        }
    }

    public void paintChildren(Graphics g) {
        if (this.firstPaint) {
            this.updateToolTip();
            this.firstPaint = false;
        }
        Graphics2D g2d = (Graphics2D)g;
        super.paintChildren(g);
        this.updateStatusIcons();
        if (this.ao.isLink()) {
            int ypos = this.image.getHeight() - this.linkImage.getHeight(null);
            g2d.drawImage(this.linkImage, 2, ypos, null);
        }
        if (!this.ao.isIncluded()) {
            g2d.drawImage(excludedImage, (this.getWidth() - excludedImage.getWidth(null)) / 2, (this.image.getHeight() - excludedImage.getHeight(null)) / 2, null);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    boolean isEditing() {
        return this.editor.isEditing();
    }

    void setEditing(boolean editing) {
        this.editor.setEditing(editing);
    }

    private void updateToolTip() {
        String comment = this.ao.getComment();
        if (!this.ao.getFile().exists()) {
            this.setToolTipText(Msg.get("edit.brokenLinkError", this.ao.getFile()));
        } else {
            this.setToolTipText(this.ao.getFile().toString());
            if (comment != null && comment.length() > 0 && this.editor instanceof FileNameEditor) {
                this.isCommentedStatus.setToolTipText("<html><body>" + this.ao.getComment() + "</body></html>");
            } else if (this.getToolTipText() != null) {
                this.isCommentedStatus.setToolTipText(null);
            }
        }
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.isVisible() && this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public void setIncluded(boolean included) {
        this.ao.setIncluded(included);
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.editor.setSelected(selected);
        if (selected) {
            this.imagePanel.setBorder(JAlbumBorders.createSelectedImageBorder());
        } else {
            this.setEditing(false);
            this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        }
        if (selected != oldSelected) {
            this.context.selectionModel.objectSelected(this, selected);
        }
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(jAlbumObjectFlavor)) {
            return null;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{jAlbumObjectFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return jAlbumObjectFlavor.equals(flavor);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String type = evt.getPropertyName();
        if ("comment".equals(type)) {
            this.updateToolTip();
            this.editor.refresh();
        } else if ("name".equals(type)) {
            this.editor.refresh();
            this.updateToolTip();
        } else if ("orientation".equals(type)) {
            this.renderIcon();
            this.validate();
        } else if ("imageUpdated".equals(type)) {
            this.renderIcon();
            this.validate();
        } else if ("hidden".equals(type)) {
            this.renderIcon();
            this.validate();
        } else if ("linkRepaired".equals(type)) {
            this.renderIcon();
            this.updateToolTip();
            this.validate();
        } else if ("properties".equals(type)) {
            this.updateStatusIcons();
            this.context.context.applyFilter(this);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    public static Image getCrossImage() {
        return excludedImage;
    }

    static {
        isCommentedIcon = Icons.getIcon("small.message");
        isFolderThumbnailIcon = Icons.getIcon("small.folder");
        isMediaFileIcon = Icons.getIcon("small.film");
        hasImageFiltersIcon = Icons.getIcon("small.edited");
        hasOriginalIcon = Icons.getIcon("small.original");
        jAlbumObjectFlavor = new DataFlavor(JAlbumObject.class, "JAlbum object");
        excludedImage = new ImageIcon(JAlbumObject.class.getResource("images/forbidden.png")).getImage();
        stars = new ImageIcon[5];
        for (int i = 1; i <= 5; ++i) {
            JAlbumObject.stars[i - 1] = Icons.getIcon("small.star" + i);
        }
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/img.gif").toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class JFiltersLabel
    extends JLabel {
        public JFiltersLabel() {
            super(hasImageFiltersIcon);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setVisible(false);
        }

        public String getToolTipText(MouseEvent event) {
            FilterList filterList = (FilterList)JAlbumObject.this.ao.getProperties().get("filterList");
            boolean hasFilters = filterList != null && filterList.getPosition() > 0;
            JAlbumObject.this.hasImageFiltersToolTip.setVisible(hasFilters);
            if (hasFilters) {
                Vector<JAlbumImageFilter> filters = filterList.getFilters();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < filterList.getPosition(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(filters.get(i).getName());
                }
                return Msg.get("ui.hasImageFiltersToolTip") + " (" + buf.toString() + ")";
            }
            return "";
        }
    }

    static abstract class LabelEditor
    extends JPanel {
        public static final Font labelFont = new Font("SansSerif", 0, 11);
        protected final JAlbumObject jao;

        LabelEditor(JAlbumObject jao) {
            this.jao = jao;
        }

        abstract void refresh();

        abstract void setEditing(boolean var1);

        abstract boolean isEditing();

        abstract void setSelected(boolean var1);
    }
}

