/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import se.datadosen.jalbum.TransferProtocol;

public class AccountProfile {
    public static final String VALUE_UNSET = "VALUE_UNSET";
    private String name = "";
    private String ftpServer = "";
    private int ftpPort = 21;
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean passiveMode = true;
    private TransferProtocol protocol = TransferProtocol.ftp;
    private boolean ftpForceUTF8 = true;
    private String ftpWebRootDirectory = "VALUE_UNSET";
    private String webRootURL = "";
    private boolean showServerRootDirectory = false;
    private boolean protect = false;
    private boolean myjalbum = false;
    private String privateKeyPath = "";
    private String passphrase = "";
    private boolean ignoreSecureSetting;

    public AccountProfile() {
    }

    public AccountProfile(String name) {
        this.setName(name);
    }

    private static String makeSafe(String name) {
        if (name == null) {
            return "";
        }
        name = name.replaceAll("<", "");
        name = name.replaceAll(">", "");
        name = name.replaceAll("\"", "");
        return name;
    }

    public String getName() {
        return this.name.replaceAll(".myjalbum.net", ".jalbum.net");
    }

    public void setName(String name) {
        this.name = AccountProfile.makeSafe(name);
    }

    public String getFtpServer() {
        return this.ftpServer.replaceAll(".myjalbum.net", ".jalbum.net");
    }

    public void setFtpServer(String ftpServer) {
        this.ftpServer = AccountProfile.makeSafe(ftpServer);
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public void setFtpPort(int ftpPort) {
        this.ftpPort = ftpPort;
    }

    public TransferProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TransferProtocol protocol) {
        this.protocol = protocol;
        this.ignoreSecureSetting = true;
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpUser(String ftpUser) {
        this.ftpUser = AccountProfile.makeSafe(ftpUser);
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setFtpPassword(String ftpPassword) {
        this.ftpPassword = AccountProfile.makeSafe(ftpPassword);
    }

    public void setSecureFtp(boolean secureFtp) {
        if (!this.ignoreSecureSetting) {
            this.protocol = secureFtp ? TransferProtocol.sftp : TransferProtocol.ftp;
        }
    }

    public boolean isSecureFtp() {
        return this.protocol != TransferProtocol.ftp;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public boolean isFtpForceUTF8() {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean forceUTF8) {
        this.ftpForceUTF8 = forceUTF8;
    }

    public String getFtpWebRootDirectory() {
        return this.ftpWebRootDirectory;
    }

    public void setFtpWebRootDirectory(String webRootDirectory) {
        this.ftpWebRootDirectory = AccountProfile.makeSafe(webRootDirectory);
    }

    public String getWebRootURL() {
        if (this.webRootURL == null || this.webRootURL.length() == 0) {
            return "http://" + this.getFtpServer().replaceAll("ftp.", "www.");
        }
        return this.webRootURL.replaceAll(".myjalbum.net", ".jalbum.net");
    }

    public void setWebRootURL(String webRootURL) {
        this.webRootURL = AccountProfile.makeSafe(webRootURL);
    }

    public boolean isShowServerRootDirectory() {
        return this.showServerRootDirectory;
    }

    public void setShowServerRootDirectory(boolean show) {
        this.showServerRootDirectory = show;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void setProtected(boolean b) {
        this.protect = b;
    }

    public boolean isMyjalbum() {
        return this.myjalbum;
    }

    public void setMyjalbum(boolean b) {
        this.myjalbum = b;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.name.equals(o.toString());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

