/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.util.PersistentList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWidgetList
extends JList
implements PersistentList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected Vector<JCheckBox> listData = new Vector();

    public JWidgetList() {
        this.setCellRenderer(new CheckBoxCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!JWidgetList.this.isEnabled()) {
                    return;
                }
                int index = JWidgetList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)JWidgetList.this.getModel().getElementAt(index)).isSelected());
                    JWidgetList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int index;
                if (!JWidgetList.this.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 32 && (index = JWidgetList.this.getSelectedIndex()) != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)JWidgetList.this.getModel().getElementAt(index)).isSelected());
                    JWidgetList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
        JAlbumSite site = JAlbumSite.getInstance();
        StringTokenizer tokens = new StringTokenizer(site.getDefaultWidgets(), ",");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            this.listData.add(new JCheckBox(name));
        }
        this.setModel(new WidgetListModel());
    }

    @Override
    public List<String> getContent() {
        Vector<String> selectedData = new Vector<String>();
        for (JCheckBox cb : this.listData) {
            if (!cb.isSelected()) continue;
            selectedData.add(cb.getText());
        }
        return selectedData;
    }

    @Override
    public void setContent(List<String> data) {
        HashSet<String> existing = new HashSet<String>();
        for (JCheckBox cb : this.listData) {
            existing.add(cb.getText());
        }
        HashSet<String> names = new HashSet<String>();
        for (String s : data) {
            names.add(s);
        }
        for (String s : data) {
            if (existing.contains(s)) continue;
            this.listData.add(new JCheckBox(s));
        }
        for (JCheckBox cb : this.listData) {
            cb.setSelected(names.contains(cb.getText()));
        }
        this.setModel(new WidgetListModel());
    }

    protected class CheckBoxCellRenderer
    implements ListCellRenderer {
        protected CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            checkbox.setBackground(JWidgetList.this.getBackground());
            checkbox.setForeground(JWidgetList.this.getForeground());
            checkbox.setEnabled(JWidgetList.this.isEnabled());
            checkbox.setFont(JWidgetList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return checkbox;
        }
    }

    class WidgetListModel
    extends AbstractListModel {
        WidgetListModel() {
        }

        public int getSize() {
            return JWidgetList.this.listData.size();
        }

        public Object getElementAt(int i) {
            return JWidgetList.this.listData.get(i);
        }
    }
}

