/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;
import se.datadosen.util.Scope;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Template;

final class TemplateParser {
    private static final char magic = '\f';
    private static final String magicString = "\f";
    final AlbumBean engine;
    private Map variables = new HashMap();
    int imageNum;
    Set includedPages = new HashSet();
    Set evaluatedDefinitions = new HashSet();
    private final String[] names = new String[]{"ja:ignore", "ja:if", "ja:switch", "ja:eval", "%", "ja:include", "ja:rowiterator", "ja:coliterator", "ja:fileiterator", "ja:widget"};

    public TemplateParser(AlbumBean engine) {
        this.engine = engine;
    }

    public TemplateParser(AlbumBean engine, Map variables) throws ElementException {
        this(engine);
        this.putAll(variables);
    }

    public void putAll(Map variables) throws ElementException {
        this.variables.putAll(variables);
        AlbumBean.setVars(variables, this.engine.interpreter);
    }

    public void reset() throws ElementException {
        try {
            for (String name : this.variables.keySet()) {
                if (name.indexOf(46) != -1) continue;
                this.engine.interpreter.unset(name);
            }
            this.variables.clear();
        }
        catch (EvalError e) {
            throw new ElementException(e.getMessage());
        }
    }

    public void removeAll(Collection variableKeys) throws ElementException {
        try {
            this.variables.keySet().removeAll(variableKeys);
            for (String name : variableKeys) {
                if (name.indexOf(46) != -1) continue;
                this.engine.interpreter.unset(name);
            }
        }
        catch (EvalError e) {
            throw new ElementException(e.getMessage());
        }
    }

    public Map getVariables() {
        return this.variables;
    }

    public String parseElements(String doc) throws ElementException {
        StringBuilder buf = new StringBuilder();
        try {
            doc = TemplateParser.stripJSPComments(doc);
            this.parseElements(doc, buf);
            String res = buf.toString();
            return this.removeEmptyLines(res);
        }
        catch (EvalError ex) {
            throw new ElementException(ex.getMessage());
        }
        catch (UtilEvalError ex) {
            throw new ElementException(ex.getMessage());
        }
    }

    private void parseElements(String doc, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        Element elem = Elements.getNextElement(this.names, doc, true);
        if (elem == null) {
            buf.append(doc);
            return;
        }
        buf.append('\f');
        buf.append(elem.getPreElement());
        if (elem.getName().equals("ja:if")) {
            this.handleIfElse(elem, buf);
        } else if (elem.getName().equals("ja:switch")) {
            this.handleSwitch(elem, buf);
        } else if (elem.getName().equals("ja:ignore")) {
            this.handleIgnore(elem, buf);
        } else if (elem.getName().equals("ja:include")) {
            this.handleInclude(elem, buf);
        } else if (elem.getName().equals("ja:eval")) {
            this.handleEval(elem, buf);
        } else if (elem.getName().equals("%")) {
            this.handleScriptlet(elem, buf);
        } else if (elem.getName().equals("$")) {
            this.handleExpressionLanguage(elem, buf);
        } else if (elem.getName().equals("ja:rowiterator")) {
            this.handleRowIterator(elem, buf);
        } else if (elem.getName().equals("ja:coliterator")) {
            this.handleColIterator(elem, buf);
        } else if (elem.getName().equals("ja:fileiterator")) {
            this.handleFileIterator(elem, buf);
        } else if (elem.getName().equals("ja:widget")) {
            this.handleWidget(elem, buf);
        } else {
            throw new ElementException(Msg.get("scripting.unknownElementError") + elem.getName());
        }
        buf.append('\f');
    }

    private void handleRowIterator(Element rowIterator, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        this.imageNum = this.engine.indexNum * this.engine.imagesPerIndex;
        for (int row = 0; row < this.engine.currentRows; ++row) {
            this.parseElements(rowIterator.getContent(), buf);
            this.imageNum += this.engine.getCols();
        }
        this.parseElements(rowIterator.getPostElement(), buf);
    }

    private void handleColIterator(Element colsElement, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        Template template = new Template(colsElement.getContent());
        for (int i = this.imageNum; i < this.engine.currentObjects.length && i < this.imageNum + this.engine.getCols(); ++i) {
            Scope locals = this.engine.currentObjects[i].getVars();
            Map allLocals = locals.flatten();
            this.putAll(allLocals);
            this.parseElements(template.toString(allLocals), buf);
            this.removeAll(allLocals.keySet());
        }
        this.putAll(this.engine.indexVariables);
        this.parseElements(colsElement.getPostElement(), buf);
    }

    private AlbumObject[] filterFiles(AlbumObject[] objects, boolean folders) {
        LinkedList<AlbumObject> res = new LinkedList<AlbumObject>();
        for (AlbumObject ao : objects) {
            if (ao.isFolder()) {
                if (!folders) continue;
                res.add(ao);
                continue;
            }
            if (folders) continue;
            res.add(ao);
        }
        return res.toArray(new AlbumObject[res.size()]);
    }

    private void handleFileIterator(Element fileIterator, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        this.imageNum = this.engine.indexNum * this.engine.imagesPerIndex;
        boolean dirs = fileIterator.getAttributes().containsKey("dirs");
        boolean nodirs = fileIterator.getAttributes().containsKey("nodirs");
        AlbumObject[] localObjects = this.engine.currentObjects;
        if (dirs) {
            localObjects = this.filterFiles(this.engine.currentObjects, true);
        }
        if (nodirs) {
            localObjects = this.filterFiles(this.engine.currentObjects, false);
        }
        HashMap variablesBackup = new HashMap();
        variablesBackup.putAll(this.variables);
        Template template = new Template(fileIterator.getContent());
        if (fileIterator.getAttributes().containsKey("start")) {
            int start;
            boolean relative = false;
            String s = this.parseAttributeValue(fileIterator.getAttribute("start"));
            if (s.startsWith("+")) {
                relative = true;
                start = Integer.parseInt(s.substring(1));
            } else {
                start = Integer.parseInt(s);
            }
            if (start < 0) {
                relative = true;
            }
            int count = Integer.parseInt(this.parseAttributeValue(fileIterator.getAttribute("count", "2147483647")));
            int step = Integer.parseInt(this.parseAttributeValue(fileIterator.getAttribute("step", "1")));
            if (relative) {
                NameSpace ns = this.engine.interpreter.getNameSpace();
                try {
                    Primitive imageNum = (Primitive)ns.getVariable("imageNum");
                    if (imageNum == Primitive.VOID) {
                        throw new ElementException("Relative indexing in ja:fileiterator not allowed in this scope");
                    }
                    int current = imageNum.intValue() - 1;
                    start += current;
                }
                catch (UtilEvalError ex) {
                    throw new ElementException(ex.toString());
                }
            }
            int oldStart = start;
            if (start < 0) {
                start = 0;
            }
            count -= Math.abs(start - oldStart);
            for (int i = start; i >= 0 && i < localObjects.length && count-- > 0; i += step) {
                this.handleIteration(i, template, buf, localObjects);
            }
        } else {
            for (int i = this.imageNum; i < localObjects.length && i - this.imageNum < this.engine.currentRows * this.engine.getCols(); ++i) {
                this.handleIteration(i, template, buf, localObjects);
            }
        }
        this.putAll(variablesBackup);
        this.parseElements(fileIterator.getPostElement(), buf);
    }

    private void handleIteration(int i, Template template, StringBuilder buf, AlbumObject[] localObjects) throws ElementException, EvalError, UtilEvalError {
        Scope locals = localObjects[i].getVars();
        Scope fix = new Scope(locals);
        fix.put("imageNum", new Integer(i + 1));
        fix.put("files", AlbumBean.toFileArray(localObjects));
        Map allLocals = fix.flatten();
        this.putAll(allLocals);
        this.parseElements(template.toString(allLocals), buf);
        this.removeAll(allLocals.keySet());
    }

    private void handleSwitch(Element switchElem, StringBuilder buf) throws ElementException {
        String testExpression = switchElem.getAttribute("test");
        if (testExpression == null) {
            throw new ElementException(Msg.get("scripting.missingTestAttibuteForJaSwitchElement"));
        }
        try {
            String value = this.parseAttributeValue(testExpression);
            Element nextElem = Elements.getElementByName("ja:", switchElem.getContent(), true);
            while (nextElem != null) {
                if (nextElem.getName().equals("ja:case")) {
                    String caseValue = nextElem.getAttribute("value");
                    if (value.equals(caseValue)) {
                        this.parseElements(nextElem.getContent(), buf);
                        break;
                    }
                } else if (nextElem.getName().equals("ja:default")) {
                    if (Elements.getElementByName("ja:", nextElem.getPostElement(), true) != null) {
                        throw new ElementException(Msg.get("scripting.JaDefaultNotLastInJaSwitch"));
                    }
                    this.parseElements(nextElem.getContent(), buf);
                } else {
                    throw new ElementException(Msg.get("scripting.invalidElementForJaSwitch") + ": " + nextElem.getName());
                }
                nextElem = Elements.getElementByName("ja:", nextElem.getPostElement(), true);
            }
            this.parseElements(switchElem.getPostElement(), buf);
        }
        catch (Exception ex) {
            throw new ElementException(ex.toString());
        }
    }

    private void handleIfElse(Element ifElem, StringBuilder buf) throws ElementException {
        String whiteCheck;
        StringTokenizer testTokenizer;
        String existTest = ifElem.getAttribute("exists");
        String testExpression = ifElem.getAttribute("test");
        String valueExpression = ifElem.getAttribute("value");
        if (valueExpression == null) {
            valueExpression = "true";
        }
        boolean not = ifElem.getAttributes().containsKey("not");
        if (existTest == null && testExpression == null) {
            throw new ElementException(Msg.get("scripting.missingAttibutesForJaIfElement"));
        }
        Element elseElem = null;
        Element nextElem = Elements.getElementByName("ja:", ifElem.getPostElement(), true);
        if (nextElem != null && nextElem.getName().equals("ja:else") && (testTokenizer = new StringTokenizer(whiteCheck = (elseElem = nextElem).getPreElement())).hasMoreTokens()) {
            throw new ElementException(Msg.get("scripting.elseNotFollowingIfError"));
        }
        try {
            if (existTest != null && (!not ? this.exists(existTest) : !this.exists(existTest)) || testExpression != null && (not ? !this.parseAttributeValue(testExpression).equals(valueExpression) : this.parseAttributeValue(testExpression).equals(valueExpression))) {
                this.parseElements(ifElem.getContent(), buf);
                if (elseElem == null) {
                    this.parseElements(ifElem.getPostElement(), buf);
                } else {
                    this.parseElements(elseElem.getPostElement(), buf);
                }
            } else if (elseElem == null) {
                this.parseElements(ifElem.getPostElement(), buf);
            } else {
                this.parseElements(elseElem.getContent(), buf);
                this.parseElements(elseElem.getPostElement(), buf);
            }
        }
        catch (ElementException ex) {
            throw ex;
        }
        catch (OperationAbortedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new ElementException(Msg.get("scripting.expressionNotEvaluatingToBooleanError") + testExpression + Msg.get("scripting.expressionNotEvaluatingToBooleanError2"));
        }
    }

    private boolean exists(String name) throws UtilEvalError {
        NameSpace ns = this.engine.interpreter.getNameSpace();
        Object val = ns.getVariable(name);
        if (val == null || val == Primitive.NULL || val == Primitive.VOID) {
            return false;
        }
        if (!(val instanceof String) && !(val instanceof StringBuilder)) {
            return true;
        }
        return val.toString().length() > 0;
    }

    private void handleIgnore(Element elem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        buf.append(elem.getContent());
        this.parseElements(elem.getPostElement(), buf);
    }

    private void handleInclude(Element elem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        String page = (String)elem.getAttributes().get("page");
        if (page == null) {
            throw new ElementException(Msg.get("scripting.missingPageAttributeForJaIncludeElementError"));
        }
        page = this.parseAttributeValue(page);
        File f = new File(page);
        boolean once = elem.getAttributes().containsKey("once");
        boolean root = elem.getAttributes().containsKey("root");
        if (once && this.includedPages.contains(f.getAbsolutePath())) {
            this.parseElements(elem.getPostElement(), buf);
            return;
        }
        this.includedPages.add(f.getAbsolutePath());
        if (!f.isAbsolute()) {
            File curdir;
            if (root) {
                curdir = (File)this.variables.get("rootImageDirectory");
                if (curdir != null) {
                    f = new File(curdir, page);
                }
            } else {
                curdir = (File)this.variables.get("imageDirectory");
                if (curdir != null) {
                    f = new File(curdir, page);
                }
                if (!f.exists() && (curdir = (File)this.variables.get("skinDirectory")) != null && !(f = new File(curdir, page)).exists()) {
                    curdir = new File(Config.getConfig().progDir, "includes");
                    f = new File(curdir, page);
                }
            }
        }
        try {
            if (f.exists()) {
                String data = IO.readTextFile(f);
                Template t = new Template(data);
                data = t.toString(this.variables);
                String res = this.parseElements(data);
                buf.append(res);
            } else {
                this.parseElements(elem.getContent(), buf);
            }
        }
        catch (IOException ex) {
            buf.append(elem.getContent());
        }
        this.parseElements(elem.getPostElement(), buf);
    }

    private void handleEval(Element evalElem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        StringWriter sw = new StringWriter();
        String result = this.eval(evalElem.getContent(), sw);
        buf.append(sw.toString());
        buf.append(result);
        this.parseElements(evalElem.getPostElement(), buf);
    }

    private void handleWidget(Element elem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        if (this.engine.isWidgetInjection()) {
            String pageType = elem.getAttribute("pageType");
            if (pageType == null) {
                throw new ElementException(Msg.get("scripting.missingPageTypeAttributeForJaWidgetElementError"));
            }
            String rootPath = (String)this.engine.interpreter.get("rootPath");
            String injectionCode = this.engine.getWidgetInjectionCode(pageType, rootPath);
            buf.append(injectionCode);
        }
        this.parseElements(elem.getPostElement(), buf);
    }

    private String upperInitial(String s) {
        return "" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private Object invokeGetter(Object bean, String name) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Class<?> beanClass = bean.getClass();
        Method m = null;
        try {
            m = beanClass.getMethod("get" + this.upperInitial(name), null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanClass.getMethod("is" + this.upperInitial(name), null);
            }
            catch (NoSuchMethodException ex2) {
                throw ex;
            }
        }
        return m.invoke(bean, (Object[])null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExpressionLanguage(Element exprElem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        try {
            Object o;
            block11: {
                String next;
                StringTokenizer tokens;
                block13: {
                    String expr;
                    block12: {
                        expr = exprElem.getContent();
                        o = null;
                        if (expr.indexOf(46) == -1) break block12;
                        tokens = new StringTokenizer(expr, ".");
                        String token = tokens.nextToken();
                        next = tokens.nextToken();
                        o = this.engine.interpreter.get(token);
                        if (!(o instanceof SmartResourceBundle)) break block13;
                        String key = expr.substring(expr.indexOf(46) + 1);
                        buf.append(((SmartResourceBundle)o).getString(key));
                        o = null;
                        break block11;
                    }
                    if (this.engine.using != null) {
                        try {
                            Field f = this.engine.using.getClass().getField(expr);
                            o = f.get(this.engine.using);
                        }
                        catch (NoSuchFieldException ex) {
                            NameSpace ns = this.engine.interpreter.getNameSpace();
                            o = ns.getVariable(expr);
                        }
                        break block11;
                    } else {
                        NameSpace ns = this.engine.interpreter.getNameSpace();
                        o = ns.getVariable(expr);
                    }
                    break block11;
                }
                while (true) {
                    if (o instanceof Map) {
                        o = ((Map)o).get(next);
                    } else if (o != null) {
                        o = this.invokeGetter(o, next);
                    }
                    if (!tokens.hasMoreTokens()) break;
                    next = tokens.nextToken();
                }
            }
            if (o != null && o != Primitive.NULL && o != Primitive.VOID) {
                buf.append(o.toString());
            }
        }
        catch (Exception ex) {
            throw new ElementException(ex.toString());
        }
        this.parseElements(exprElem.getPostElement(), buf);
    }

    private void handleScriptlet(Element scriptlet, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
        if (scriptlet.isDefinitionScriptlet()) {
            Integer contentHash = new Integer(scriptlet.getContent().hashCode());
            if (this.evaluatedDefinitions.contains(contentHash)) {
                this.parseElements(scriptlet.getPostElement(), buf);
                return;
            }
            this.evaluatedDefinitions.add(contentHash);
        }
        StringWriter sw = new StringWriter();
        String result = this.eval(scriptlet.getContent(), sw);
        buf.append(sw.toString());
        if (scriptlet.isEvalScriptlet()) {
            buf.append(result);
        }
        this.parseElements(scriptlet.getPostElement(), buf);
    }

    private String parseAttributeValue(String s) throws ElementException, EvalError, UtilEvalError {
        StringWriter sw = new StringWriter();
        StringBuilder buf = new StringBuilder();
        Element scriptlet = Elements.getScriptlet(s);
        if (scriptlet == null) {
            scriptlet = Elements.getExpressionLanguage(s);
            if (scriptlet == null) {
                return s;
            }
            buf.append(scriptlet.getPreElement());
            this.handleExpressionLanguage(scriptlet, buf);
            return buf.toString();
        }
        buf.append(scriptlet.getPreElement());
        String result = this.eval(scriptlet.getContent(), sw);
        buf.append(sw.toString());
        if (scriptlet.isEvalScriptlet()) {
            buf.append(result);
        }
        buf.append(scriptlet.getPostElement());
        return buf.toString();
    }

    private String eval(String expr, Writer writer) throws ElementException {
        PrintWriter out = new PrintWriter(writer);
        try {
            this.engine.interpreter.set("out", (Object)out);
            Object ret = this.engine.doProcessExpression(expr);
            out.flush();
            return ret != null ? ret.toString() : "";
        }
        catch (EvalError e) {
            throw new ElementException("Evaluation error on line " + e.getErrorLineNumber() + ":\n\nDetails:\n" + e.getMessage());
        }
    }

    private String removeEmptyLines(String res) {
        StringBuilder buf = new StringBuilder();
        Scanner sc = new Scanner(res);
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            if (line.indexOf(12) != -1 && (line = line.replace(magicString, "")).trim().length() == 0) continue;
            buf.append(line);
            buf.append("\r\n");
        }
        return buf.toString();
    }

    private static String stripJSPComments(String doc) {
        int cEnd;
        int cStart = doc.indexOf("<%--");
        if (cStart == -1) {
            return doc;
        }
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(doc.substring(0, cStart));
            doc = doc.substring(cStart);
            cEnd = doc.indexOf("--%>");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = (doc = '\f' + doc.substring(cEnd + 4) + '\f').indexOf("<%--")) != -1);
        buf.append(doc);
        return buf.toString();
    }
}

