/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import se.datadosen.component.JLinkButton;
import se.datadosen.util.Platform;

public class JSmartButton
extends JButton {
    public JSmartButton() {
        this.init();
    }

    public JSmartButton(Action action) {
        super(action);
        this.init();
    }

    public JSmartButton(String name, ImageIcon icon) {
        super(name, icon);
        this.init();
    }

    private void init() {
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.putClientProperty("JButton.buttonType", "bevel");
        if (Platform.isMac()) {
            this.setBorder(new DarkenBorder());
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent arg0) {
                    JSmartButton.this.setBorderPainted(true);
                }

                public void mouseReleased(MouseEvent arg0) {
                    JSmartButton.this.setBorderPainted(false);
                }
            });
        }
    }

    protected void paintComponent(Graphics gg) {
        if (Platform.isMac() && !(this instanceof JLinkButton)) {
            Graphics2D g = (Graphics2D)gg;
            Color top = new Color(254, 254, 254);
            Color bottom = new Color(170, 170, 170);
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(top);
            g.setPaint(new GradientPaint(0.0f, 1.0f, top, 0.0f, height - 1, bottom));
            g.fillRoundRect(0, 0, width - 1, height - 1, 5, 5);
            g.setColor(new Color(241, 241, 241));
            g.drawRoundRect(0, 0, width - 1, height - 1, 5, 5);
            g.setColor(new Color(104, 104, 104));
            g.drawRoundRect(0, 0, width - 1, height - 2, 5, 5);
        }
        super.paintComponent(gg);
    }

    private class DarkenBorder
    extends AbstractBorder {
        private DarkenBorder() {
        }

        public Insets getBorderInsets(Component arg0) {
            return new Insets(3, 3, 3, 3);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(new Color(0, 0, 0, 64));
            g.fillRoundRect(0, 0, width - 1, height - 1, 5, 5);
        }
    }
}

