/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import se.datadosen.component.buttonbar.ButtonBarUI;
import se.datadosen.component.buttonbar.JButtonBar;
import se.datadosen.component.buttonbar.PercentLayout;

class BasicButtonBarUI
extends ButtonBarUI {
    protected JButtonBar bar;
    protected PropertyChangeListener propertyListener;

    BasicButtonBarUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.bar = (JButtonBar)c;
        this.installDefaults();
        this.installListeners();
        this.updateLayout();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyChangeListener();
        this.bar.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        this.bar.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ChangeListener();
    }

    protected void updateLayout() {
        if (this.bar.getOrientation() == 0) {
            this.bar.setLayout(new PercentLayout(0, 1));
        } else {
            this.bar.setLayout(new PercentLayout(1, 1));
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        JButtonBar b = (JButtonBar)c;
        Dimension preferred = b.getLayout() == null ? new Dimension(74, 56) : b.getLayout().preferredLayoutSize(c);
        if (b.getOrientation() == 0) {
            return new Dimension(preferred.width, 56);
        }
        return new Dimension(74, preferred.height);
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("orientation")) {
                BasicButtonBarUI.this.updateLayout();
                BasicButtonBarUI.this.bar.revalidate();
                BasicButtonBarUI.this.bar.repaint();
            }
        }
    }
}

