/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;

public class JNewProjectDialog
extends JSmartDialog {
    private JLabel albumNameLabel = new JLabel(Msg.get("newproject.albumNameLabel"));
    private JTextField albumName = new JSmartTextField(20);
    private JLabel albumDescriptionLabel = new JLabel(Msg.get("edit.albumDescription"));
    private JTextArea albumDescription = new JSmartTextArea(6, 20);
    private JLabel albumLocationLabel = new JLabel(Msg.get("newproject.albumLocationLabel"));
    private JTextField albumLocation = new JTextField(20);
    private JButton browseButton = new JButton();
    private DirectoryChooser albumLocationChooser = ChooserFactory.createDirectoryChooser(this);
    private List files;
    private int dropAction;
    Action okAction;
    Action cancelAction;

    public JNewProjectDialog(Frame parent) {
        super(parent, Msg.get("newproject.title"), true);
        this.initComponents();
        Tracer.getInstance().trace("new project dialog presented");
    }

    public void setAlbumName(String albumName) {
        this.albumName.setText(albumName);
        this.fixUIDisabling();
    }

    public void setFiles(List files, int dropAction) {
        this.files = files;
        this.dropAction = dropAction;
    }

    private File getAlbumDirectory() {
        return new File(this.albumLocation.getText() + File.separator + this.albumName.getText().trim()).getAbsoluteFile();
    }

    private void initComponents() {
        this.setResizable(false);
        File myAlbums = new File(Config.getConfig().getMyAlbumsLocation());
        this.albumLocationChooser.setSelectedFile(myAlbums);
        this.albumLocation.setText(myAlbums.getAbsolutePath());
        this.okAction = new AbstractAction(Msg.get("ok")){

            public void actionPerformed(ActionEvent e) {
                try {
                    File albumDirectory = JNewProjectDialog.this.getAlbumDirectory();
                    if (!albumDirectory.exists()) {
                        albumDirectory.mkdirs();
                    } else if (albumDirectory.listFiles() != null && albumDirectory.listFiles().length > 0) {
                        JOptionPane.showMessageDialog(JNewProjectDialog.this, Msg.get("newProject.projectAlreadyExistsError", JNewProjectDialog.this.albumName.getText().trim()), Msg.get("newproject.title"), 0);
                        return;
                    }
                    if (albumDirectory.listFiles() == null) {
                        throw new IOException("Can't create directory " + albumDirectory.getName());
                    }
                    JNewProjectDialog.this.setVisible(false);
                    JNewProjectDialog.this.dispose();
                    ((JAlbumFrame)JNewProjectDialog.this.getOwner()).initProject(JNewProjectDialog.this.getAlbumDirectory());
                    AlbumObject root = ((JAlbumFrame)JNewProjectDialog.this.getOwner()).albumExplorer.getRootFolder();
                    try {
                        root.setComment(JNewProjectDialog.this.albumDescription.getText());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    ((JAlbumFrame)JNewProjectDialog.this.getOwner()).saveProject(new File(JNewProjectDialog.this.getAlbumDirectory(), "jalbum-settings.jap"));
                    if (JNewProjectDialog.this.files != null && JNewProjectDialog.this.files.size() > 0) {
                        JAlbum.mainFrame.albumExplorer.explorer.handleFileAdd(JNewProjectDialog.this.files, JNewProjectDialog.this.dropAction);
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JNewProjectDialog.this, ex);
                }
            }
        };
        this.cancelAction = new AbstractAction(Msg.get("cancel")){

            public void actionPerformed(ActionEvent e) {
                JNewProjectDialog.this.setVisible(false);
                JNewProjectDialog.this.dispose();
            }
        };
        this.initEventListeners();
        this.albumName.setDocument(new FileNameDocument());
        this.albumNameLabel.setLabelFor(this.albumName);
        this.albumDescriptionLabel.setLabelFor(this.albumDescription);
        this.albumLocationLabel.setLabelFor(this.albumLocation);
        this.browseButton.setIcon(JAlbum.mainFrame.icons.openIcon);
        this.albumDescription.setFocusTraversalKeys(0, null);
        this.albumDescription.setFocusTraversalKeys(1, null);
        this.albumDescription.setLineWrap(true);
        this.albumDescription.setWrapStyleWord(true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 6, 4, 6));
        content.add((Component)new JLabel(Icons.getIcon("decorations.dorholdingalbum")), "Before");
        ControlPanel rightPanel = new ControlPanel();
        rightPanel.add(this.albumNameLabel);
        rightPanel.add("br", this.albumName);
        rightPanel.add("p", this.albumDescriptionLabel);
        rightPanel.add("br hfill", new JScrollPane(this.albumDescription));
        content.add((Component)rightPanel, "Center");
        JCollapsiblePanel cp = new JCollapsiblePanel(Msg.get("ui.more"));
        cp.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JNewProjectDialog.this.pack();
            }
        });
        JPanel moreContent = cp.getContentPanel();
        cp.setBackground(Color.yellow);
        moreContent.setLayout(new RiverLayout());
        moreContent.add(this.albumLocationLabel);
        moreContent.add("br hfill", this.albumLocation);
        moreContent.add(this.browseButton);
        content.add((Component)cp, "South");
        this.getContentPane().add((Component)content, "Center");
        this.registerActions(this.okAction, this.cancelAction);
        this.fixUIDisabling();
    }

    private void fixUIDisabling() {
        this.okAction.setEnabled(this.albumName.getText().trim().length() > 0);
    }

    private void initEventListeners() {
        this.albumName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JNewProjectDialog.this.fixUIDisabling();
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JNewProjectDialog.this.albumLocationChooser.setCurrentDirectory(new File(JNewProjectDialog.this.albumLocation.getText()));
                if (JNewProjectDialog.this.albumLocationChooser.showOpenDialog(JNewProjectDialog.this) == 0) {
                    JNewProjectDialog.this.albumLocation.setText(JNewProjectDialog.this.albumLocationChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }
}

