/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;
import org.mortbay.util.MultiException;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextComponentSupport;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumTrayIcon;
import se.datadosen.jalbum.JShareSecuritySettingsDialog;
import se.datadosen.jalbum.JWebServerSettingsDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ShareBean;
import se.datadosen.jalbum.event.StatusListener;
import se.datadosen.net.Share;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class JShareWindow
extends JSmartDialog
implements StatusListener {
    JAlbumFrame parent;
    ShareBean shareBean = new ShareBean();
    Action closeAction;
    Action startAction;
    Action stopAction;
    Action settingsAction;
    Action shareCurrentAlbumAction;
    Action updateShareAction;
    Action removeShareAction;
    Action securitySettingsAction;
    Action copyURLAction;
    JAlbumTrayIcon trayIcon;
    ImageIcon copyIcon;
    ImageIcon addShareIcon;
    ImageIcon deleteShareIcon;
    ImageIcon infoIcon;
    ImageIcon startIcon;
    ImageIcon stopIcon;
    ImageIcon settingsIcon;
    JLabel infoLabel = new JLabel();
    JButton shareCurrentAlbumButton;
    ControlPanel currentShare = new ControlPanel();
    JCheckBox active = new JCheckBox();
    JButton securitySettingsButton;
    JLabel localPathLabel = new JLabel();
    JTextField localPath = new JSmartTextField();
    JLabel uriLabel = new JLabel();
    JTextField uri = new JSmartTextField();
    JLabel urlLabel = new JLabel();
    JLinkLabel url = new JLinkLabel("");
    JButton copyURLButton;
    JButton updateShareButton;
    JButton removeShareButton;
    JLabel sharesLabel = new JLabel();
    JList sharesList = new JList();
    JScrollPane sharesScrollPane = new JScrollPane(this.sharesList);
    ControlPanel serverControl = new ControlPanel();
    ButtonGroup serverControlButtons = new ButtonGroup();
    JToggleButton startButton;
    JToggleButton stopButton;
    JButton settingsButton;
    JWebServerSettingsDialog settingsDialog;
    JShareSecuritySettingsDialog securityDialog;

    public JShareWindow(JAlbumFrame parent) {
        super(parent);
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.shareBean.addStatusListener(this);
        this.addShareIcon = new ImageIcon(JAlbumFrame.class.getResource("images/book_blue_add.png"));
        this.deleteShareIcon = new ImageIcon(JAlbumFrame.class.getResource("images/book_blue_delete.png"));
        this.copyIcon = new ImageIcon(JSmartTextComponentSupport.class.getResource("images/copy.png"));
        this.infoIcon = new ImageIcon(JAlbumFrame.class.getResource("images/information.png"));
        this.startIcon = new ImageIcon(JAlbumFrame.class.getResource("images/media_play_green.png"));
        this.stopIcon = new ImageIcon(JAlbumFrame.class.getResource("images/media_stop_red.png"));
        this.settingsIcon = new ImageIcon(JAlbumFrame.class.getResource("images/preferences.png"));
        this.closeAction = new AbstractAction("closeAction"){

            public void actionPerformed(ActionEvent e) {
                JShareWindow.this.setVisible(false);
            }
        };
        this.startAction = new AbstractAction("startAction", this.startIcon){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                BeanBinder.setProperties((Object)JShareWindow.this.shareBean, JShareWindow.this);
                JShareWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JShareWindow.this.shareBean.start();
                    JShareWindow.this.startButton.setSelected(true);
                    JShareWindow.this.updateURL();
                    JShareWindow.this.addTrayIcon(e != null);
                }
                catch (MultiException ex) {
                    JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                    JShareWindow.this.stopButton.setSelected(true);
                    if (!(ex.getException(0) instanceof BindException)) return;
                    JOptionPane.showMessageDialog(JShareWindow.this, Msg.get("share.bindErrorInfo", JShareWindow.this.shareBean.getPort()), Msg.get("share.shareAlbum"), 0);
                    return;
                }
                catch (Exception ex) {
                    JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                    JShareWindow.this.stopButton.setSelected(true);
                    Debug.showErrorDialog((Component)JShareWindow.this.parent, ex);
                    return;
                }
                try {
                    block11: {
                        try {
                            if (JShareWindow.this.shareBean.isDoPortMapping()) {
                                JShareWindow.this.shareBean.ensurePortMapping();
                            }
                            if (JShareWindow.this.shareBean.albumAccessTest()) break block11;
                            JOptionPane.showMessageDialog(JShareWindow.this, Msg.get("share.softwareFirewallInfo"), Msg.get("share.shareAlbum"), 2);
                        }
                        catch (Exception ex) {
                            if (!JShareWindow.this.shareBean.albumAccessTest()) {
                                try {
                                    JOptionPane.showMessageDialog(JShareWindow.this, Msg.get("share.portForwardingInfo", JShareWindow.this.shareBean.getPort(), InetAddress.getLocalHost().getHostAddress()), Msg.get("share.shareAlbum"), 2);
                                }
                                catch (IOException iOException) {
                                }
                            }
                            Object var5_6 = null;
                            JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                    Object var5_5 = null;
                    JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
            }
        };
        this.stopAction = new AbstractAction("stopAction", this.stopIcon){

            public void actionPerformed(ActionEvent e) {
                try {
                    JShareWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                    JShareWindow.this.shareBean.stop();
                    JShareWindow.this.updateURL();
                    JShareWindow.this.removeTrayIcon();
                }
                catch (Exception ex) {
                    JShareWindow.this.setCursor(Cursor.getDefaultCursor());
                    Debug.showErrorDialog((Component)JShareWindow.this.parent, ex);
                }
                JShareWindow.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.settingsAction = new AbstractAction("settingsAction", this.settingsIcon){

            public void actionPerformed(ActionEvent e) {
                try {
                    BeanBinder.getProperties((Object)JShareWindow.this.shareBean, JShareWindow.this.settingsDialog);
                    JShareWindow.this.settingsDialog.setVisible(true);
                    if (JShareWindow.this.settingsDialog.isOkPressed()) {
                        boolean running = JShareWindow.this.shareBean.isRunning();
                        if (running) {
                            JShareWindow.this.stopAction.actionPerformed(null);
                        }
                        BeanBinder.setProperties((Object)JShareWindow.this.shareBean, JShareWindow.this.settingsDialog);
                        JShareWindow.this.shareBean.setLogger();
                        if (running) {
                            JShareWindow.this.startAction.actionPerformed(null);
                        }
                        JShareWindow.this.shareBean.saveSettings();
                    }
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JShareWindow.this, ex);
                }
            }
        };
        this.shareCurrentAlbumAction = new AbstractAction("shareCurrentAlbumAction"){

            public void actionPerformed(ActionEvent e) {
                JShareWindow.this.parent.ui2Engine();
                JShareWindow.this.uri.setText("/" + new File(JShareWindow.this.parent.engine.getDirectory()).getName());
                File dir = JShareWindow.this.parent.engine.getInterpretedOutputDirectory();
                JShareWindow.this.localPath.setText(dir.getAbsolutePath());
                JShareWindow.this.active.setSelected(true);
                JShareWindow.this.updateShareAction.actionPerformed(null);
                JShareWindow.this.startAction.actionPerformed(null);
                JOptionPane.showMessageDialog(JShareWindow.this.parent, Msg.get("share.shareCurrentAlbumInfo"), Msg.get("share.shareAlbum"), 1);
            }
        };
        this.copyURLAction = new AbstractAction(null, this.copyIcon){

            public void actionPerformed(ActionEvent e) {
                StringSelection stringSelection = new StringSelection(JShareWindow.this.url.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        };
        this.updateShareAction = new AbstractAction("updateShareAction"){

            public void actionPerformed(ActionEvent e) {
                try {
                    Share updatedShare = new Share(JShareWindow.this.localPath.getText(), JShareWindow.this.uri.getText(), JShareWindow.this.active.isSelected());
                    updatedShare.passwordProtect = JShareWindow.this.securityDialog.passwordProtect.isSelected();
                    updatedShare.userName = JShareWindow.this.securityDialog.userName.getText();
                    updatedShare.password = JShareWindow.this.securityDialog.password.getText();
                    JShareWindow.this.validateShareUri(updatedShare);
                    List shares = JShareWindow.this.shareBean.getShares();
                    shares.remove(updatedShare);
                    shares.add(updatedShare);
                    JShareWindow.this.shareBean.setShares(shares);
                    JShareWindow.this.sharesList.setListData(shares.toArray());
                    JShareWindow.this.updateURL();
                    JShareWindow.this.shareBean.saveSettings();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JShareWindow.this.parent, ex);
                }
                catch (ValidationFailedException ex) {
                    System.err.println("Err: " + ex);
                    JOptionPane.showMessageDialog(JShareWindow.this, ex.getLocalizedMessage(), "This is the title", 0);
                }
            }
        };
        this.removeShareAction = new AbstractAction("removeShareAction"){

            public void actionPerformed(ActionEvent e) {
                List shares = JShareWindow.this.shareBean.getShares();
                Share share = new Share(JShareWindow.this.localPath.getText(), JShareWindow.this.uri.getText(), JShareWindow.this.active.isSelected());
                shares.remove(share);
                JShareWindow.this.shareBean.setShares(shares);
                JShareWindow.this.sharesList.setListData(shares.toArray());
                try {
                    JShareWindow.this.shareBean.saveSettings();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JShareWindow.this.parent, ex);
                }
            }
        };
        this.securitySettingsAction = new AbstractAction("securitySettingsAction", this.settingsIcon){

            public void actionPerformed(ActionEvent e) {
                JShareWindow.this.securityDialog.setVisible(true);
                Share share = JShareWindow.this.getCurrentShare();
                if (share != null) {
                    share.passwordProtect = JShareWindow.this.securityDialog.passwordProtect.isSelected();
                }
            }
        };
        this.url.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JShareWindow.this.shareBean.loopbackAccessOk && JShareWindow.this.shareBean.accessViaProxyOk) {
                    int answer = JOptionPane.showConfirmDialog(JShareWindow.this, Msg.get("share.loopbackAccessInfo"), Msg.get("share.shareAlbum"), 0, 1);
                    if (answer == 0) {
                        try {
                            BrowserLauncher.openURL(JShareWindow.this.getFinalLocalURL(JShareWindow.this.uri.getText()));
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    try {
                        BrowserLauncher.openURL(JShareWindow.this.url.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.shareCurrentAlbumButton = new JButton(this.shareCurrentAlbumAction);
        this.shareCurrentAlbumButton.setIcon(this.addShareIcon);
        this.copyURLButton = new JButton(this.copyURLAction);
        this.copyURLAction.setEnabled(false);
        this.updateShareButton = new JButton(this.updateShareAction);
        this.removeShareButton = new JButton(this.removeShareAction);
        this.removeShareButton.setIcon(this.deleteShareIcon);
        this.securitySettingsButton = new JButton(this.securitySettingsAction);
        this.startButton = new JToggleButton(this.startAction);
        this.stopButton = new JToggleButton(this.stopAction);
        this.serverControlButtons.add(this.startButton);
        this.serverControlButtons.add(this.stopButton);
        this.settingsButton = new JButton(this.settingsAction);
        this.settingsDialog = new JWebServerSettingsDialog((Frame)this.parent, true);
        this.securityDialog = new JShareSecuritySettingsDialog((Frame)this.parent, true);
        this.stopButton.setSelected(true);
        this.sharesList.setSelectionMode(0);
        this.sharesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JShareWindow.this.updateCurrentShare();
            }
        });
        this.sharesList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    JShareWindow.this.removeShareAction.actionPerformed(null);
                }
            }
        });
        this.registerActions(this.closeAction);
        this.setTexts();
        Container content = this.getContentPane();
        content.setLayout(new RiverLayout());
        Font boldFont = this.sharesLabel.getFont().deriveFont(1);
        this.sharesLabel.setFont(boldFont);
        content.add("br hfill", this.sharesLabel);
        content.add(this.infoLabel);
        content.add("br", this.shareCurrentAlbumButton);
        content.add(this.removeShareButton);
        this.sharesScrollPane.setPreferredSize(new Dimension(370, 130));
        content.add("br vtop hfill", this.sharesScrollPane);
        this.serverControl.setUseExtraSpace(false);
        this.serverControl.add(this.startButton);
        this.serverControl.add(this.stopButton);
        this.serverControl.add("br", this.settingsButton);
        content.add("", this.serverControl);
        this.currentShare.add(this.uriLabel);
        this.currentShare.add("tab hfill", this.uri);
        this.currentShare.add(this.securitySettingsButton);
        this.currentShare.add(this.active);
        this.currentShare.add("br", this.localPathLabel);
        this.currentShare.add("tab hfill", this.localPath);
        this.currentShare.add("br", this.urlLabel);
        this.currentShare.add("tab", this.url);
        this.currentShare.add(this.copyURLButton);
        this.currentShare.add("hfill", new JLabel());
        this.currentShare.add(this.updateShareButton);
        content.add("br hfill", this.currentShare);
        this.shareBean.loadSettings();
        List shares = this.shareBean.getShares();
        this.sharesList.setListData(shares.toArray());
        int index = this.sharesList.getModel().getSize() - 1;
        if (index >= 0) {
            this.sharesList.setSelectedIndex(index);
        }
    }

    private void validateShareUri(Share share) throws ValidationFailedException {
        share.uri = IO.combinePaths("/", share.uri);
    }

    private void addTrayIcon(boolean showMsg) {
        if (this.trayIcon != null) {
            return;
        }
        try {
            SystemTray tray = SystemTray.getDefaultSystemTray();
            this.trayIcon = new JAlbumTrayIcon(this.parent);
            tray.addTrayIcon((TrayIcon)this.trayIcon);
            this.trayIcon.displayMessage(Msg.get("trayIcon.title"), Msg.get("trayIcon.message"), 0);
        }
        catch (Throwable t) {
            System.err.println("Tray Icon trouble: " + t.toString());
        }
    }

    private void removeTrayIcon() {
        if (this.trayIcon != null) {
            SystemTray tray = SystemTray.getDefaultSystemTray();
            tray.removeTrayIcon((TrayIcon)this.trayIcon);
            this.trayIcon = null;
        }
    }

    private Share getCurrentShare() {
        List shares = this.shareBean.getShares();
        int index = this.sharesList.getSelectedIndex();
        if (index >= 0) {
            return (Share)shares.get(index);
        }
        return null;
    }

    private void updateCurrentShare() {
        Share share = this.getCurrentShare();
        if (share != null) {
            this.uri.setText(share.uri);
            this.localPath.setText(share.localPath);
            this.active.setSelected(share.active);
            this.securityDialog.passwordProtect.setSelected(share.passwordProtect);
            this.securityDialog.userName.setText(share.userName);
            this.securityDialog.password.setText(share.password);
            this.securityDialog.passwordProtectAction.actionPerformed(null);
            this.updateURL();
        }
    }

    public void setTexts() {
        this.setTitle(Msg.get("ui.sharePanel"));
        this.infoLabel.setIcon(this.infoIcon);
        this.infoLabel.setToolTipText(Msg.get("share.infoLabel"));
        this.sharesLabel.setText(Msg.get("share.sharesList"));
        this.shareCurrentAlbumAction.putValue("Name", Msg.get("share.shareCurrentAlbum"));
        this.updateShareAction.putValue("Name", Msg.get("share.update"));
        this.removeShareAction.putValue("Name", Msg.get("remove"));
        this.securitySettingsAction.putValue("Name", Msg.get("share.securitySettings"));
        this.serverControl.setTitle(Msg.get("share.serverControlBorder"));
        this.closeAction.putValue("Name", Msg.get("close"));
        this.startAction.putValue("Name", Msg.get("share.start"));
        this.stopAction.putValue("Name", Msg.get("share.stop"));
        this.settingsAction.putValue("Name", Msg.get("share.settings"));
        this.currentShare.setTitle(Msg.get("share.currentShareBorder"));
        this.active.setText(Msg.get("share.active"));
        this.uriLabel.setText(Msg.get("share.name"));
        this.localPathLabel.setText(Msg.get("share.localPath"));
        this.urlLabel.setText(Msg.get("share.url"));
        this.copyURLAction.putValue("ShortDescription", Msg.get("share.urlToolTip"));
    }

    private String getFinalURL(String uri) throws IOException, UPNPResponseException {
        String portStr = this.shareBean.getPort() == 80 ? "" : ":" + this.shareBean.getPort();
        return "http://" + (this.shareBean.getHostName().length() > 0 ? this.shareBean.getHostName() : this.shareBean.getExternalAddress()) + portStr + uri.replaceAll(" ", "%20");
    }

    private String getFinalLocalURL(String uri) throws IOException, UPNPResponseException {
        String portStr = this.shareBean.getPort() == 80 ? "" : ":" + this.shareBean.getPort();
        return "http://" + InetAddress.getLocalHost().getHostAddress() + portStr + uri.replaceAll(" ", "%20");
    }

    private void updateURL() {
        if (this.shareBean.isRunning()) {
            try {
                this.url.setText(this.getFinalURL(this.uri.getText()));
                this.url.setURL(this.getFinalURL(this.uri.getText()));
                this.copyURLAction.setEnabled(true);
            }
            catch (UPNPResponseException ex) {
            }
            catch (IOException iOException) {}
        } else {
            this.url.setText("Web server not running");
            this.url.setURL(null);
            this.copyURLAction.setEnabled(false);
        }
    }

    public void statusChanged(String msg) {
        System.out.println(msg);
        this.parent.statusBar.setText(msg);
    }

    public void setShareCurrentEnabled(boolean enabled) {
        this.shareCurrentAlbumAction.setEnabled(enabled);
    }

    private static class ValidationFailedException
    extends Exception {
        private String description;

        ValidationFailedException(String description) {
            this.description = description;
        }

        public String getLocalizedMessage() {
            return this.description;
        }
    }
}

