/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFile;
import java.io.File;
import java.util.Date;
import se.datadosen.util.IO;

public class RemoteFileImpl
extends RemoteFile {
    protected String fullPath;
    protected boolean directory = false;
    protected boolean link = false;

    public RemoteFileImpl(File f, File root) {
        this(IO.relativePath(f, root), f.length(), f.lastModified());
    }

    public RemoteFileImpl(String fullPath) {
        this(fullPath, 0L, 0L);
    }

    public RemoteFileImpl(String fullPath, long size, long modificationDate) {
        this.fullPath = fullPath;
        int i = fullPath.lastIndexOf(47);
        this.name = fullPath.substring(i + 1);
        this.modificationDate = new Date(modificationDate);
        this.size = size;
    }

    public RemoteFileImpl(String dir, RemoteFile rf) {
        this.fullPath = IO.combinePaths(dir, rf.getName());
        this.name = rf.getName();
        this.creationDate = rf.getCreationDate();
        this.modificationDate = rf.getModificationDate();
        this.directory = rf.isDirectory();
        this.link = rf.isLink();
        this.size = rf.size();
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isLink() {
        return this.link;
    }
}

