/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

class SoundPlayer {
    SoundPlayer() {
    }

    public static void playAudioFile(String fileName) {
        File soundFile = new File(fileName);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
            SoundPlayer.playAudioStream(audioInputStream);
        }
        catch (Exception e) {
            System.out.println("Problem with file " + fileName + ":");
            e.printStackTrace();
        }
    }

    public static void playAudioStream(InputStream in) throws UnsupportedAudioFileException, IOException {
        SoundPlayer.playAudioStream(AudioSystem.getAudioInputStream(in));
    }

    public static void playAudioStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            return;
        }
        try {
            SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);
            dataLine.open(audioFormat);
            if (dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl volume = (FloatControl)dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue(0.0f);
            }
            dataLine.start();
            int bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
            byte[] buffer = new byte[bufferSize];
            try {
                int bytesRead = 0;
                while (bytesRead >= 0) {
                    bytesRead = audioInputStream.read(buffer, 0, buffer.length);
                    if (bytesRead < 0) continue;
                    int framesWritten = dataLine.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            dataLine.drain();
            dataLine.close();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

