/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    String name;
    boolean evalScriptlet = false;
    boolean definitionScriptlet = false;
    String preElement;
    String content;
    String postElement;
    int postIndex;
    Map<String, String> attributes = new HashMap<String, String>();
    List contentElements;

    public Element() {
    }

    public Element(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPreElement() {
        return this.preElement;
    }

    public String getPostElement() {
        return this.postElement;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public String getContent() {
        return this.content;
    }

    public List getContentElements() {
        return this.contentElements;
    }

    public void setContentElements(List contentElements) {
        this.contentElements = contentElements;
    }

    public void addContentElement(Element el) {
        if (this.contentElements == null) {
            this.contentElements = new LinkedList();
        }
        this.contentElements.add(el);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attr) {
        this.attributes = attr;
    }

    public void setAttributes(Properties props) {
        this.attributes = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            this.attributes.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, "" + value);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, "" + value);
    }

    public String getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    public boolean getBooleanAttribute(String attr) {
        return "true".equals(this.getAttribute(attr));
    }

    public String getAttribute(String attr, String def) {
        String val = this.getAttribute(attr);
        return val != null ? val : def;
    }

    public boolean isEvalScriptlet() {
        return this.evalScriptlet;
    }

    public boolean isDefinitionScriptlet() {
        return this.definitionScriptlet;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.spaces(indent)).append("<").append(this.name);
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            buf.append(" ").append((Object)e.getKey()).append("=\"").append((Object)e.getValue()).append("\"");
        }
        if (this.contentElements != null && this.contentElements.size() > 0) {
            buf.append(">\n");
            for (Element el : this.contentElements) {
                buf.append(el.toString(indent + 2));
            }
            buf.append(this.spaces(indent)).append("</").append(this.name).append(">\n");
        } else {
            buf.append("/>\n");
        }
        return buf.toString();
    }

    private String spaces(int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

