/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

public class VersionNumber {
    private String version;

    public VersionNumber(String version) {
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    private int countDots() {
        char[] ca = this.version.toCharArray();
        int n = 0;
        for (char c : ca) {
            if (c != '.') continue;
            ++n;
        }
        return n;
    }

    private String getNormalized() {
        String v = this.version.toLowerCase();
        int left = 3 - this.countDots();
        for (int i = 0; i < left; ++i) {
            v = v + ".0";
        }
        return v;
    }

    public int compareTo(VersionNumber other) {
        char[] c1 = this.getNormalized().toCharArray();
        char[] c2 = other.getNormalized().toCharArray();
        int diff = 0;
        int i = 0;
        int j = 0;
        while (i < c1.length && j < c2.length) {
            if (Character.isDigit(c1[i]) && Character.isDigit(c2[j])) {
                int startI = i;
                int startJ = j;
                while (i < c1.length && Character.isDigit(c1[i])) {
                    ++i;
                }
                while (j < c2.length && Character.isDigit(c2[j])) {
                    ++j;
                }
                long num1 = Long.parseLong(new String(c1, startI, i - startI));
                long num2 = Long.parseLong(new String(c2, startJ, j - startJ));
                if (i < c1.length && c1[i] != '.' && c1[i] != '_') {
                    --num1;
                }
                if (j < c2.length && c2[j] != '.' && c2[j] != '_') {
                    --num2;
                }
                if (num1 < num2) {
                    diff = -1;
                } else if (num1 > num2) {
                    diff = 1;
                }
                if (diff == 0) continue;
                break;
            }
            diff = c1[i] - c2[j];
            if (diff != 0) break;
            ++i;
            ++j;
        }
        if (diff == 0) {
            diff = c1.length - c2.length;
        }
        return diff;
    }
}

