/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestResume
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestResume.java,v 1.12 2009-03-20 05:07:24 bruceb Exp $";

    protected String getLogName() {
        return "TestResume.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResumePut() throws Exception {
        this.log.debug("testResumePut()");
        try {
            this.setup();
            String filename = this.generateRandomFilename();
            this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 50000L);
            boolean cancelled = false;
            try {
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            }
            catch (FTPTransferCancelledException ex) {
                this.log.debug("Caught expected cancellation exception", ex);
                cancelled = true;
            }
            this.ftp.quit();
            TestResume.assertTrue((boolean)cancelled);
            this.setup();
            this.ftp.resume();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            this.ftp.cancelResume();
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
        }
        finally {
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResumeGet() throws Exception {
        this.log.debug("testResumeGet()");
        try {
            this.setup();
            String filename = this.generateRandomFilename();
            this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 131072L);
            boolean cancelled = false;
            try {
                this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
            }
            catch (FTPTransferCancelledException ex) {
                this.log.debug("Caught expected cancellation exception", ex);
                cancelled = true;
            }
            this.ftp.quit();
            TestResume.assertTrue((boolean)cancelled);
            this.setup();
            this.ftp.resume();
            this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
            String filename2 = this.generateRandomFilename();
            this.ftp.get(this.localDataDir + filename2, this.remoteBinaryFile);
            this.assertIdentical(this.localDataDir + filename, this.localDataDir + filename2);
            File local = new File(this.localDataDir + filename);
            local.delete();
            local = new File(this.localDataDir + filename2);
            local.delete();
            this.ftp.quit();
        }
        finally {
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    protected void setup() throws Exception {
        this.connect();
        if (this.ftp instanceof FTPClient) {
            ((FTPClient)this.ftp).setRetryCount(0);
            this.log.debug("Set retry count to 0");
        }
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
    }

    public static Test suite() {
        return new TestSuite(TestResume.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestResume.suite());
    }

    class CancelProgressMonitor
    implements FTPProgressMonitor {
        private boolean cancelled = false;
        private FTPClientInterface ftpClient;

        public CancelProgressMonitor(FTPClientInterface ftp) {
            this.ftpClient = ftp;
        }

        public void bytesTransferred(long bytes) {
            TestResume.this.log.debug("bytesTransferred(" + bytes + ") called");
            if (!this.cancelled) {
                TestResume.this.log.debug("Cancelling transfer");
                this.ftpClient.cancelTransfer();
                this.cancelled = true;
            }
        }
    }
}

