/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import jgnash.engine.Account;
import jgnash.engine.AccountProxy;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.util.DateUtils;

public class InvestmentAccountProxy
extends AccountProxy {
    public InvestmentAccountProxy(Account account) {
        super(account);
    }

    @Override
    public BigDecimal getBalance(Date start, Date end) {
        return this.getCashBalance(start, end).add(this.getMarketValue(start, end));
    }

    @Override
    public BigDecimal getBalance() {
        return this.getCashBalance().add(this.getMarketValue());
    }

    @Override
    public BigDecimal getBalance(Date date) {
        return this.getCashBalance(date).add(this.getMarketValue(date));
    }

    @Override
    public BigDecimal getCashBalance() {
        return super.getBalance();
    }

    private BigDecimal getCashBalanceAt(int index) {
        return super.getBalanceAt(index);
    }

    @Override
    public BigDecimal getCashBalance(Date start, Date end) {
        return super.getBalance(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getCashBalance(Date end) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = !this.account.transactions.isEmpty() ? this.getCashBalance(this.account.transactions.get(0).getDate(), end) : BigDecimal.ZERO;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getMarketPrice(SecurityNode node, Date date) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            Date testDate = DateUtils.levelDate(date);
            SecurityHistoryNode hNode = node.getHistoryNode(date);
            BigDecimal rate = EngineFactory.getEngine("default").getExchangeRate(node.getReportedCurrencyNode(), this.account.getCurrencyNode());
            if (hNode != null && testDate.equals(DateUtils.levelDate(hNode.getDate()))) {
                BigDecimal bigDecimal = hNode.getPrice().multiply(rate);
                return bigDecimal;
            }
            Date priceDate = null;
            BigDecimal price = BigDecimal.ZERO;
            int count = this.account.getTransactionCount();
            block12: for (int i = 0; i < count; ++i) {
                Transaction t = this.account.getTransactionAt(i);
                if (!(t instanceof InvestmentTransaction)) continue;
                BigDecimal p = ((InvestmentTransaction)t).getPrice();
                if (((InvestmentTransaction)t).getSecurityNode() != node || p == null || p.compareTo(BigDecimal.ZERO) != 1) continue;
                switch (t.getDate().compareTo(testDate)) {
                    case -1: {
                        price = p;
                        priceDate = t.getDate();
                        continue block12;
                    }
                    case 0: {
                        BigDecimal bigDecimal = p;
                        return bigDecimal;
                    }
                }
            }
            if (hNode == null && priceDate == null) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
                return bigDecimal;
            }
            if (priceDate != null && hNode != null) {
                if (priceDate.compareTo(hNode.getDate()) >= 0) {
                    BigDecimal bigDecimal = price;
                    return bigDecimal;
                }
            } else if (hNode == null) {
                BigDecimal bigDecimal = price;
                return bigDecimal;
            }
            BigDecimal bigDecimal = hNode.getPrice().multiply(rate);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getMarketValue() {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal marketValue = BigDecimal.ZERO;
            int count = this.account.getTransactionCount();
            if (count > 0) {
                Date lastDate = this.account.transactions.get(count - 1).getDate();
                marketValue = lastDate.compareTo(new Date()) >= 0 ? this.getMarketValue(this.account.transactions.get(0).getDate(), lastDate) : this.getMarketValue(this.account.transactions.get(0).getDate(), new Date());
            }
            BigDecimal bigDecimal = marketValue;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getMarketValue(Date date) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal marketValue = BigDecimal.ZERO;
            if (this.account.getTransactionCount() > 0) {
                marketValue = this.getMarketValue(this.account.transactions.get(0).getDate(), date);
            }
            BigDecimal bigDecimal = marketValue;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getMarketValue(Date start, Date end) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            HashMap<SecurityNode, BigDecimal> priceMap = new HashMap<SecurityNode, BigDecimal>();
            for (SecurityNode node : this.account.securities) {
                priceMap.put(node, this.getMarketPrice(node, end));
            }
            BigDecimal balance = BigDecimal.ZERO;
            int count = this.account.getTransactionCount();
            for (int i = 0; i < count; ++i) {
                Transaction t = this.account.getTransactionAt(i);
                if (t.getDate().compareTo(start) < 0 || t.getDate().compareTo(end) > 0 || !(t instanceof InvestmentTransaction)) continue;
                balance = balance.add(((InvestmentTransaction)t).getMarketValue((BigDecimal)priceMap.get(((InvestmentTransaction)t).getSecurityNode())));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getMarketValueAt(int index) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            HashMap<SecurityNode, BigDecimal> priceMap = new HashMap<SecurityNode, BigDecimal>();
            for (SecurityNode node : this.account.securities) {
                priceMap.put(node, node.getMarketPrice());
            }
            BigDecimal balance = BigDecimal.ZERO;
            for (int i = 0; i <= index; ++i) {
                Transaction t = this.account.getTransactionAt(i);
                if (!(t instanceof InvestmentTransaction)) continue;
                balance = balance.add(((InvestmentTransaction)t).getMarketValue((BigDecimal)priceMap.get(((InvestmentTransaction)t).getSecurityNode())));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getReconciledMarketValue() {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            HashMap<SecurityNode, BigDecimal> priceMap = new HashMap<SecurityNode, BigDecimal>();
            for (SecurityNode node : this.account.securities) {
                priceMap.put(node, node.getMarketPrice(this.account.getCurrencyNode()));
            }
            BigDecimal balance = BigDecimal.ZERO;
            for (Transaction t : this.account.transactions) {
                if (!(t instanceof InvestmentTransaction) || t.getReconciled(this.account) != ReconciledState.RECONCILED) continue;
                balance = balance.add(((InvestmentTransaction)t).getMarketValue((BigDecimal)priceMap.get(((InvestmentTransaction)t).getSecurityNode())));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public BigDecimal getReconciledBalance() {
        return super.getReconciledBalance().add(this.getReconciledMarketValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getOpeningBalanceForReconcile() {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            Date date = this.account.getFirstUnreconciledTransactionDate();
            BigDecimal balance = BigDecimal.ZERO;
            for (int i = 0; i < this.account.transactions.size(); ++i) {
                if (!this.account.transactions.get(i).getDate().equals(date)) continue;
                if (i <= 0) break;
                balance = this.getCashBalanceAt(i - 1).add(this.getMarketValueAt(i - 1));
                break;
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }
}

