/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.xml.AbstractXMLDAO;
import jgnash.engine.xml.XMLContainer;

public class XMLAccountDAO
extends AbstractXMLDAO
implements AccountDAO {
    private static Logger logger = Logger.getLogger(XMLAccountDAO.class.getName());

    XMLAccountDAO(XMLContainer container) {
        super(container);
    }

    @Override
    public RootAccount getRootAccount() {
        RootAccount root = null;
        List<RootAccount> list = this.container.query(RootAccount.class);
        if (list.size() == 1) {
            root = list.get(0);
        }
        if (list.size() > 1) {
            logger.severe("More than one RootAccount found");
            root = list.get(0);
        }
        return root;
    }

    @Override
    public List<Account> getAccountList() {
        return XMLAccountDAO.stripMarkedForRemoval(this.container.query(Account.class));
    }

    @Override
    public boolean addAccount(Account parent, Account child) {
        this.container.set(child);
        this.commit();
        return true;
    }

    @Override
    public boolean addRootAccount(RootAccount account) {
        this.container.set(account);
        this.commit();
        return true;
    }

    @Override
    public boolean addAccountSecurity(Account account, SecurityNode node) {
        this.container.set(node);
        this.commit();
        return true;
    }

    @Override
    public List<Account> getIncomeAccountList() {
        return this.getAccountByType(AccountType.INCOME);
    }

    @Override
    public List<Account> getExpenseAccountList() {
        return this.getAccountByType(AccountType.EXPENSE);
    }

    @Override
    public List<Account> getInvestmentAccountList() {
        return this.getAccountByType(AccountType.INVEST);
    }

    @Override
    public Account getAccountByUuid(String uuid) {
        Account account = null;
        StoredObject o = this.container.get(uuid);
        if (o != null && o instanceof Account) {
            account = (Account)o;
        }
        return account;
    }

    @Override
    public boolean updateAccount(Account account) {
        this.commit();
        return true;
    }

    @Override
    public boolean setAccountProperty(Account account, Object object) {
        this.commit();
        return true;
    }

    @Override
    public boolean removeAccountProperty(Account account, Object object) {
        this.commit();
        return true;
    }

    @Override
    public boolean toggleAccountVisability(Account account) {
        this.commit();
        return true;
    }

    @Override
    public void refreshAccount(Account account) {
    }

    private List<Account> getAccountByType(AccountType type) {
        ArrayList<Account> list = new ArrayList<Account>();
        for (Account a : this.getAccountList()) {
            if (a.getAccountType() != type) continue;
            list.add(a);
        }
        return list;
    }
}

