/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.ofx;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jgnash.imports.ofx.OfxBank;
import jgnash.imports.ofx.OfxTags;
import jgnash.imports.ofx.OfxTransaction;

public class OfxV2Parser
implements OfxTags {
    private Logger logger = Logger.getLogger("OfxV2Parser");
    private static final boolean debug = false;
    private OfxBank bank;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream) {
        this.logger.entering(OfxV2Parser.class.getName(), "parse");
        this.bank = new OfxBank();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(stream);
            XMLStreamReader reader = inputFactory.createXMLStreamReader(input, "UTF-8");
            this.readOfx(reader);
        }
        catch (XMLStreamException e) {
            this.logger.log(Level.SEVERE, e.toString(), e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parse");
    }

    public void parse(File file) {
        try {
            this.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    public void parse(String string) {
        this.parse(new ByteArrayInputStream(string.getBytes()));
    }

    private void readOfx(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "readOfx");
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("SIGNONMSGSRSV1")) {
                        this.parseSignonMessageSet(reader);
                        break;
                    }
                    if (reader.getLocalName().equals("BANKMSGSRSV1")) {
                        this.parseBankMessageSet(reader);
                        break;
                    }
                    if (!reader.getLocalName().equals("CREDITCARDMSGSRSV1")) break;
                    this.parseCreditCardMessageSet(reader);
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "readOfx");
    }

    private void parseBankMessageSet(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseBankMessageSet");
        QName parsingElement = reader.getName();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("CURDEF")) {
                        this.bank.currency = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("LEDGERBAL")) {
                        this.parseLedgerBalance(reader);
                        break;
                    }
                    if (reader.getLocalName().equals("AVAILBAL")) {
                        this.parseAvailableBalance(reader);
                        break;
                    }
                    if (reader.getLocalName().equals("BANKACCTFROM")) {
                        this.parseAccountInfo(reader);
                        break;
                    }
                    if (!reader.getLocalName().equals("BANKTRANLIST")) break;
                    this.parseBankTransactionList(reader);
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the bank message set aggregate");
                    break;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseBankMessageSet");
    }

    private void parseCreditCardMessageSet(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseCreditCardMessageSet");
        QName parsingElement = reader.getName();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("CURDEF")) {
                        this.bank.currency = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("LEDGERBAL")) {
                        this.parseLedgerBalance(reader);
                        break;
                    }
                    if (reader.getLocalName().equals("AVAILBAL")) {
                        this.parseAvailableBalance(reader);
                        break;
                    }
                    if (reader.getLocalName().equals("CCACCTFROM")) {
                        this.parseAccountInfo(reader);
                        break;
                    }
                    if (!reader.getLocalName().equals("BANKTRANLIST")) break;
                    this.parseBankTransactionList(reader);
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the credit card message set aggregate");
                    break;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseCreditCardMessageSet");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseBankTransactionList(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseBankTransactionList");
        QName parsingElement = reader.getName();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("DTSTART")) {
                        this.bank.dateStart = OfxV2Parser.parseDate(reader.getElementText());
                        break;
                    }
                    if (reader.getLocalName().equals("DTEND")) {
                        this.bank.dateEnd = OfxV2Parser.parseDate(reader.getElementText());
                        break;
                    }
                    if (!reader.getLocalName().equals("STMTTRN")) break;
                    this.parseBankTransaction(reader);
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the bank transaction list");
                    break block4;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseBankTransactionList");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseBankTransaction(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseBankTransaction");
        QName parsingElement = reader.getName();
        OfxTransaction tran = new OfxTransaction();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("TRNTYPE")) {
                        tran.transactionType = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("DTPOSTED")) {
                        tran.datePosted = OfxV2Parser.parseDate(reader.getElementText());
                        break;
                    }
                    if (reader.getLocalName().equals("DTUSER")) {
                        tran.dateUser = OfxV2Parser.parseDate(reader.getElementText());
                        break;
                    }
                    if (reader.getLocalName().equals("TRNAMT")) {
                        tran.amount = OfxV2Parser.parseAmount(reader.getElementText());
                        break;
                    }
                    if (reader.getLocalName().equals("FITID")) {
                        tran.transactionID = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("CHECKNUM")) {
                        tran.checkNumber = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("NAME")) {
                        tran.payee = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("MEMO")) {
                        tran.memo = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("SIC")) {
                        tran.sic = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("REFNUM")) {
                        tran.refNum = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("PAYEEID")) {
                        tran.payeeId = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("CURRENCY")) {
                        tran.currency = reader.getElementText();
                        break;
                    }
                    if (!reader.getLocalName().equals("ORIGCURRENCY")) break;
                    tran.currency = reader.getElementText();
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the banktransaction");
                    break block4;
                }
            }
        }
        this.bank.addTransaction(tran);
        this.logger.exiting(OfxV2Parser.class.getName(), "parseBankTransaction");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseAccountInfo(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseAccountInfo");
        QName parsingElement = reader.getName();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("BANKID")) {
                        this.bank.bankId = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("ACCTID")) {
                        this.bank.accountId = reader.getElementText();
                        break;
                    }
                    if (reader.getLocalName().equals("ACCTTYPE")) {
                        this.bank.accountType = reader.getElementText();
                        break;
                    }
                    if (!reader.getLocalName().equals("BRANCHID")) break;
                    this.bank.branchId = reader.getElementText();
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the bank and account info aggregate");
                    break block4;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseAccountInfo");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseLedgerBalance(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseLedgerBalance");
        QName parsingElement = reader.getName();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("BALAMT")) {
                        this.bank.ledgerBalance = OfxV2Parser.parseAmount(reader.getElementText());
                        break;
                    }
                    if (!reader.getLocalName().equals("DTASOF")) break;
                    this.bank.ledgerBalanceDate = OfxV2Parser.parseDate(reader.getElementText());
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the ledger balance aggregate");
                    break block4;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseLedgerBalance");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseAvailableBalance(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseAvailableBalance");
        QName parsingElement = reader.getName();
        block4: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (reader.getLocalName().equals("BALAMT")) {
                        this.bank.ledgerBalance = OfxV2Parser.parseAmount(reader.getElementText());
                        break;
                    }
                    if (!reader.getLocalName().equals("DTASOF")) break;
                    this.bank.ledgerBalanceDate = OfxV2Parser.parseDate(reader.getElementText());
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    this.logger.info("Found the end of the ledger balance aggregate");
                    break block4;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseAvailableBalance");
    }

    private void parseSignonMessageSet(XMLStreamReader reader) throws XMLStreamException {
        this.logger.entering(OfxV2Parser.class.getName(), "parseSignonMessageSet");
        QName parsingElement = reader.getName();
        block3: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 2: {
                    if (reader.getName().equals(parsingElement)) {
                        this.logger.info("Found the end of the sign-on message set aggregate");
                        break block3;
                    }
                }
                default: {
                    continue block3;
                }
            }
        }
        this.logger.exiting(OfxV2Parser.class.getName(), "parseSignonMessageSet");
    }

    public OfxBank getBank() {
        return this.bank;
    }

    private static Date parseDate(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, 0, 0, 0);
        return calendar.getTime();
    }

    private static BigDecimal parseAmount(String amount) {
        return new BigDecimal(amount);
    }
}

