/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.qif;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountProperty;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionFactory;
import jgnash.imports.ImportUtils;
import jgnash.imports.qif.NoAccountException;
import jgnash.imports.qif.QifAccount;
import jgnash.imports.qif.QifCategory;
import jgnash.imports.qif.QifParser;
import jgnash.imports.qif.QifSplitTransaction;
import jgnash.imports.qif.QifTransaction;
import jgnash.imports.qif.QifUtils;

public class QifImport {
    private QifParser parser;
    private Engine engine;
    private HashMap<String, Account> expenseMap = new HashMap();
    private HashMap<String, Account> incomeMap = new HashMap();
    private HashMap<String, Account> accountMap = new HashMap();
    private boolean stripDuplicates = true;
    private ArrayList<Transaction> duplicates = new ArrayList();
    private int duplicatesFound;
    private Logger logger = Logger.getLogger("qifimport");
    private Account unassignedExpense = null;
    private Account unassignedIncome = null;

    public QifImport() {
        this.engine = EngineFactory.getEngine("default");
    }

    public QifParser getParser() {
        return this.parser;
    }

    public void setStripDuplicates(boolean strip) {
        this.stripDuplicates = strip;
    }

    public void doFullParse(File file, String dateFormat) throws NoAccountException {
        if (file != null) {
            this.parser = new QifParser(dateFormat);
            this.parser.parseFullFile(file);
            this.logger.info("*** Parsing Complete ***");
        }
    }

    public void doFullImport() {
        if (this.parser != null) {
            this.importCategories();
            this.importAccounts();
            this.logger.info("*** Importing Complete ***");
        }
    }

    public void doPartialParse(File file) {
        if (file != null) {
            this.parser = new QifParser("mm/dd/yyyy");
            this.parser.parsePartialFile(file);
        }
    }

    public void doPartialImport(Account account) {
        if (this.parser != null) {
            if (account != null) {
                ArrayList<QifAccount> list = this.parser.accountList;
                if (list.size() == 1) {
                    QifAccount qAcc = (QifAccount)list.get(0);
                    this.addTransactions(qAcc, account);
                } else {
                    this.logger.severe("Only one account expected");
                    this.logger.severe("Size: " + list.size());
                }
            } else {
                this.logger.severe("Import failed");
            }
        }
    }

    public void dumpStats() {
        if (this.parser != null) {
            this.parser.dumpStats();
        }
    }

    private void importCategories() {
        this.logger.info("*** Importing Categories ***");
        this.loadCategoryMap(this.engine.getExpenseAccountList(), this.expenseMap);
        this.loadCategoryMap(this.engine.getIncomeAccountList(), this.incomeMap);
        this.reduceCategories();
        this.addCategories();
    }

    private void importAccounts() {
        this.loadAccountMap();
        this.addAccounts();
    }

    private void loadCategoryMap(List<Account> list, Map<String, Account> map) {
        if (list != null) {
            for (Account aList : list) {
                this.loadCategoryMap(aList, map);
            }
        }
    }

    private void loadCategoryMap(Account acc, Map<String, Account> map) {
        String pathName = acc.getPathName();
        int index = pathName.indexOf(58);
        if (index != -1) {
            map.put(pathName.substring(index + 1), acc);
        }
    }

    private void loadAccountMap() {
        List<Account> list = this.engine.getBankAccountList();
        for (Account aList : list) {
            this.loadAccountMap(aList);
        }
    }

    private void loadAccountMap(Account acc) {
        String pathName = acc.getPathName();
        int index = pathName.indexOf(58);
        if (index != -1) {
            this.accountMap.put(pathName.substring(index + 1), acc);
        }
    }

    private void addAccounts() {
        Account acc;
        this.logger.info("*** Importing Accounts ***");
        ArrayList<QifAccount> list = this.parser.accountList;
        for (QifAccount qAcc : list) {
            if (this.accountMap.containsKey(qAcc.name) || (acc = this.generateAccount(qAcc)) == null) continue;
            this.engine.addAccount(this.engine.getRootAccount(), acc);
            this.loadAccountMap(acc);
        }
        this.logger.info("*** Importing Transactions ***");
        for (QifAccount qAcc : list) {
            acc = this.accountMap.get(qAcc.name);
            if (acc == null) {
                acc = this.engine.getAccountByName(qAcc.name);
            }
            if (acc != null && !acc.getAccountType().equals((Object)AccountType.INVEST)) {
                this.addTransactions(qAcc, acc);
                continue;
            }
            if (acc != null && acc.getAccountType().equals((Object)AccountType.INVEST)) {
                this.logger.severe("Investment transactions not fully supported");
                continue;
            }
            this.logger.severe("Lost the account: " + qAcc.name);
        }
    }

    private void addTransactions(QifAccount qAcc, Account acc) {
        if (qAcc.numItems() == 0) {
            return;
        }
        ArrayList<QifTransaction> list = qAcc.items;
        for (QifTransaction aList : list) {
            Transaction tran = this.generateTransaction(aList, acc);
            if (this.stripDuplicates && tran != null && this.isDuplicate(tran, acc)) {
                this.logger.fine("duplicate striped");
                ++this.duplicatesFound;
                this.duplicates.add(tran);
                continue;
            }
            if (tran != null) {
                this.engine.addTransaction(tran);
                continue;
            }
            this.logger.warning("Null Transaction!");
        }
    }

    private boolean isDuplicate(Transaction t, Account a) {
        List<Transaction> l = a.getTransactions();
        for (Transaction tran : l) {
            if (!tran.equalsIgnoreDate(t)) continue;
            return true;
        }
        return false;
    }

    public int getDuplicateCount() {
        return this.duplicatesFound;
    }

    public Transaction[] getDuplicates() {
        return this.duplicates.toArray(new Transaction[this.duplicates.size()]);
    }

    private void addCategories() {
        ArrayList<QifCategory> list = this.parser.categories;
        for (QifCategory cat : list) {
            Account acc = this.generateAccount(cat);
            HashMap<String, Account> map = acc.getAccountType() == AccountType.EXPENSE ? this.expenseMap : this.incomeMap;
            Account parent = this.findBestParent(cat, map);
            this.engine.addAccount(parent, acc);
            this.loadCategoryMap(acc, map);
        }
    }

    private Account findBestParent(QifCategory cat, Map<String, Account> map) {
        Account parent;
        int i = cat.name.lastIndexOf(58);
        if (i != -1) {
            String pathName = cat.name.substring(0, i);
            while (true) {
                if (map.containsKey(pathName)) {
                    return map.get(pathName);
                }
                int j = pathName.lastIndexOf(58);
                if (j == -1) break;
                pathName = pathName.substring(0, j);
            }
        }
        if ((parent = cat.type.equals("E") ? ImportUtils.getRootExpenseAccount() : ImportUtils.getRootIncomeAccount()) != null) {
            return parent;
        }
        return this.engine.getRootAccount();
    }

    private Account findBestAccount(String category) {
        Account acc = null;
        if (category != null && category.length() > 0) {
            String name = category;
            if (this.isAccount(name)) {
                name = category.substring(1, category.length() - 1);
                this.logger.finest("Looking for bank account: " + name);
                acc = this.accountMap.get(name);
            }
            if (acc == null && (acc = this.expenseMap.get(name = QifUtils.stripCategoryTags(name))) == null) {
                acc = this.incomeMap.get(name);
            }
            if (acc == null) {
                this.logger.warning("No account match for: " + name);
            }
        }
        return acc;
    }

    private boolean isAccount(String category) {
        return category.startsWith("[") && category.endsWith("]");
    }

    private void reduceCategories() {
        ArrayList<QifCategory> list = this.parser.categories;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            QifCategory cat = (QifCategory)i.next();
            String path = cat.name;
            if (cat.type.equals("E") && this.expenseMap.containsKey(path)) {
                i.remove();
                continue;
            }
            if (!cat.type.equals("I") || !this.incomeMap.containsKey(path)) continue;
            i.remove();
        }
    }

    private Account generateAccount(QifCategory cat) {
        CurrencyNode defaultCurrency = this.engine.getDefaultCurrency();
        Account account = cat.type.equals("E") ? new Account(AccountType.EXPENSE, defaultCurrency) : new Account(AccountType.INCOME, defaultCurrency);
        int index = cat.name.lastIndexOf(58);
        if (index != -1) {
            account.setName(cat.name.substring(index + 1));
        } else {
            account.setName(cat.name);
        }
        account.setDescription(cat.description);
        return account;
    }

    private Account generateAccount(QifAccount acc) {
        Account account;
        CurrencyNode defaultCurrency = this.engine.getDefaultCurrency();
        if (acc.type.equals("Bank")) {
            account = new Account(AccountType.BANK, defaultCurrency);
        } else if (acc.type.equals("CCard")) {
            account = new Account(AccountType.CREDIT, defaultCurrency);
            account.setProperty(AccountProperty.CREDITLIMIT, QifUtils.parseMoney(acc.creditLimit));
        } else if (acc.type.equals("Cash")) {
            account = new Account(AccountType.CASH, defaultCurrency);
        } else if (acc.type.equals("Invst") || acc.type.equals("Port")) {
            account = new Account(AccountType.INVEST, defaultCurrency);
        } else if (acc.type.equals("Oth A")) {
            account = new Account(AccountType.ASSET, defaultCurrency);
        } else if (acc.type.equals("Oth L")) {
            account = new Account(AccountType.LIABILITY, defaultCurrency);
        } else {
            this.logger.severe("Could not generate an account for:\n" + acc.toString());
            return null;
        }
        account.setName(acc.name);
        account.setDescription(acc.description);
        return account;
    }

    private Transaction generateTransaction(QifTransaction qTran, Account acc) {
        Transaction tran;
        assert (acc != null);
        boolean reconciled = "x".equalsIgnoreCase(qTran.status);
        Account cAcc = qTran._category != null ? qTran._category : this.findBestAccount(qTran.category);
        if (qTran.hasSplits()) {
            tran = new Transaction();
            ArrayList<QifSplitTransaction> splits = qTran.splits;
            for (QifSplitTransaction splitTransaction : splits) {
                TransactionEntry split = this.generateSplitTransaction(splitTransaction, acc);
                if (split == null) continue;
                tran.addTransactionEntry(split);
            }
            ReconcileManager.reconcileTransaction(acc, tran, reconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        } else if (acc == cAcc && !qTran.hasSplits() || cAcc == null) {
            tran = TransactionFactory.generateSingleEntryTransaction(acc, qTran.amount, qTran.date, reconciled, qTran.memo, qTran.payee, qTran.number);
        } else if (!qTran.hasSplits()) {
            tran = qTran.amount.signum() == -1 ? TransactionFactory.generateDoubleEntryTransaction(cAcc, acc, qTran.amount, qTran.date, qTran.memo, qTran.payee, qTran.number) : TransactionFactory.generateDoubleEntryTransaction(acc, cAcc, qTran.amount, qTran.date, qTran.memo, qTran.payee, qTran.number);
            ReconcileManager.reconcileTransaction(cAcc, tran, reconciled);
            ReconcileManager.reconcileTransaction(acc, tran, reconciled);
            if (this.isAccount(qTran.category)) {
                this.removeMirrorTransaction(qTran, acc);
            }
        } else {
            this.logger.warning("Could not create following transaction:\n" + qTran.toString());
            return null;
        }
        tran.setDate(qTran.date);
        tran.setPayee(qTran.payee);
        tran.setNumber(qTran.number);
        return tran;
    }

    private TransactionEntry generateSplitTransaction(QifSplitTransaction qTran, Account acc) {
        TransactionEntry tran = new TransactionEntry();
        Account account = this.findBestAccount(qTran.category);
        if (account == acc) {
            this.logger.warning("Detected an invalid split transactions entry, correcting problem");
            account = null;
        }
        if (account != null && this.isAccount(qTran.category)) {
            this.removeMirrorSplitTransaction(qTran);
        }
        if (account == null) {
            if (qTran.amount.signum() == -1) {
                if (this.unassignedExpense == null) {
                    this.unassignedExpense = new Account(AccountType.EXPENSE, this.engine.getDefaultCurrency());
                    this.unassignedExpense.setName("** QIF Import - Unassigned Expense Account");
                    this.unassignedExpense.setDescription("Fix transactions and delete this account");
                    this.engine.addAccount(this.engine.getRootAccount(), this.unassignedExpense);
                    this.logger.info("Created an account for unassigned expense account");
                }
                account = this.unassignedExpense;
            } else {
                if (this.unassignedIncome == null) {
                    this.unassignedIncome = new Account(AccountType.INCOME, this.engine.getDefaultCurrency());
                    this.unassignedIncome.setName("** QIF Import - Unassigned Income Account");
                    this.unassignedIncome.setDescription("Fix transactions and delete this account");
                    this.engine.addAccount(this.engine.getRootAccount(), this.unassignedIncome);
                    this.logger.info("Created an account for unassigned income account");
                }
                account = this.unassignedIncome;
            }
        }
        if (qTran.amount.signum() == -1) {
            tran.setDebitAccount(acc);
            tran.setCreditAccount(account);
        } else {
            tran.setDebitAccount(account);
            tran.setCreditAccount(acc);
        }
        tran.setAmount(qTran.amount.abs());
        tran.setMemo(qTran.memo);
        return tran;
    }

    private void removeMirrorTransaction(QifTransaction qTran, Account acc) {
        String name = qTran.category.substring(1, qTran.category.length() - 1);
        ArrayList<QifAccount> list = this.parser.accountList;
        for (QifAccount qAcc : list) {
            if (!qAcc.name.equals(name)) continue;
            ArrayList<QifTransaction> items = qAcc.items;
            Iterator i = items.iterator();
            while (i.hasNext()) {
                QifTransaction tran = (QifTransaction)i.next();
                if (!tran.amount.equals(qTran.amount.negate()) || !tran.date.equals(qTran.date) || !tran.category.contains(acc.getName())) continue;
                i.remove();
                this.logger.finest("Removed mirror transaction");
                return;
            }
        }
    }

    private void removeMirrorSplitTransaction(QifSplitTransaction qTran) {
        QifTransaction tran;
        Iterator i;
        ArrayList<QifTransaction> items;
        String name = qTran.category.substring(1, qTran.category.length() - 1);
        this.logger.fine("Categorie name is: " + name);
        ArrayList<QifAccount> list = this.parser.accountList;
        for (QifAccount qAcc : list) {
            if (!qAcc.name.equals(name)) continue;
            items = qAcc.items;
            i = items.iterator();
            while (i.hasNext()) {
                tran = (QifTransaction)i.next();
                if (tran != null) {
                    if (!tran.amount.equals(qTran.amount.negate()) || !tran.memo.equals(qTran.memo)) continue;
                    i.remove();
                    this.logger.finest("Removed mirror split transaction");
                    return;
                }
                this.logger.severe("There was a null QifTransaction in QifAccount: \n" + qAcc.toString());
            }
        }
        for (QifAccount qAcc : list) {
            if (!qAcc.name.equals(name)) continue;
            items = qAcc.items;
            i = items.iterator();
            while (i.hasNext()) {
                tran = (QifTransaction)i.next();
                if (!tran.amount.equals(qTran.amount.negate()) || !this.isAccount(tran.category) || tran.hasSplits()) continue;
                this.logger.fine("Found a match:\n" + tran.toString());
                i.remove();
                return;
            }
        }
        this.logger.warning("Did not find matching mirror:\n" + qTran.toString());
    }
}

