/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jgnash.message.LocalServerListener;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.util.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBusRemoteServer {
    private int port = 0;
    private IoAcceptor acceptor;
    private Logger logger;
    private Set<IoSession> clientSessions = Collections.synchronizedSet(new HashSet());
    private Set<LocalServerListener> listeners = Collections.synchronizedSet(new HashSet());

    public MessageBusRemoteServer(int port) {
        this.logger = LoggerFactory.getLogger(MessageBusRemoteServer.class);
        this.port = port;
    }

    public void startServer() {
        this.acceptor = new SocketAcceptor();
        SocketAcceptorConfig cfg = new SocketAcceptorConfig();
        cfg.setThreadModel(ThreadModel.MANUAL);
        cfg.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("UTF-8"))));
        try {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port), (IoHandler)new MessageHandler(), (IoServiceConfig)cfg);
        }
        catch (IOException e) {
            this.logger.error(e.toString());
        }
        this.logger.info("MessageBusRemoteServer started");
    }

    public void stopServer() {
        for (IoSession client : this.clientSessions) {
            client.close();
        }
        this.acceptor.unbindAll();
        this.listeners.clear();
    }

    public void addLocalListener(LocalServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeLocalListener(LocalServerListener listener) {
        this.listeners.remove(listener);
    }

    static {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
    }

    private class MessageHandler
    extends IoHandlerAdapter {
        private MessageHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable t) throws Exception {
            t.printStackTrace();
            session.close();
            MessageBusRemoteServer.this.clientSessions.remove(session);
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            SessionLog.info((IoSession)session, (String)"Disconnecting the idle.");
            session.close();
            MessageBusRemoteServer.this.clientSessions.remove(session);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            String str = message.toString();
            for (IoSession client : MessageBusRemoteServer.this.clientSessions) {
                if (!client.isConnected()) continue;
                client.write((Object)str);
            }
            for (LocalServerListener listener : MessageBusRemoteServer.this.listeners) {
                listener.messagePosted(str);
            }
            MessageBusRemoteServer.this.logger.info("Broadcast: " + str);
        }

        public void sessionCreated(IoSession session) throws Exception {
            MessageBusRemoteServer.this.clientSessions.add(session);
        }
    }
}

