/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jgnash.ui.ThemeManager;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.components.VerticalTextIcon;
import jgnash.ui.util.GradientPanel;

class MainViewPanel
extends JPanel
implements ActionListener {
    private JPanel contentPanel;
    private CardLayout cardLayout;
    private ButtonPanel buttonPanel;
    private Component last = null;
    private Preferences pref = Preferences.userNodeForPackage(MainViewPanel.class);
    private static final String LASTVIEW = "lastview";
    private static Insets margin = new Insets(10, 1, 10, 1);

    public MainViewPanel() {
        this.init();
    }

    private void init() {
        this.cardLayout = new CardLayout();
        this.contentPanel = new JPanel(this.cardLayout);
        this.contentPanel.setBorder(new ShadowBorder());
        this.buttonPanel = new ButtonPanel();
        this.layoutPanel();
    }

    private void layoutPanel() {
        FormLayout layout = new FormLayout("min, 4dlu, fill:min:g", "fill:p:g");
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.buttonPanel, cc.xy(1, 1));
        this.add((Component)this.contentPanel, cc.xy(3, 1));
    }

    protected void addView(Component component, Icon icon, String description, String toolTip) {
        if (description == null || component == null || icon == null) {
            throw new RuntimeException();
        }
        JPanel p = new JPanel(new BorderLayout());
        InfoPanel i = new InfoPanel(icon, toolTip);
        p.add((Component)i, "North");
        p.add(component, "Center");
        component.setName(description);
        p.setName(description);
        Button button = new Button(component, (Icon)new VerticalTextIcon(description, false));
        button.addActionListener(this);
        button.setActionCommand(description);
        button.setName(description);
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        } else {
            button.setToolTipText(description);
        }
        this.buttonPanel.addButton(button);
        if (this.contentPanel.getComponentCount() == 0) {
            this.last = component;
        }
        this.contentPanel.add((Component)p, description);
        String lastComponent = this.pref.get(LASTVIEW, "");
        if (lastComponent.equals(description)) {
            this.cardLayout.show(this.contentPanel, description);
            this.last = component;
        }
    }

    @Override
    public void removeAll() {
        this.last = null;
        this.buttonPanel.removeAll();
        this.contentPanel.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.last != ((Button)e.getSource()).getComponent()) {
            this.last = ((Button)e.getSource()).getComponent();
            this.cardLayout.show(this.contentPanel, e.getActionCommand());
            this.fireActionPerformed(new ActionEvent(this, 1001, e.getActionCommand(), e.getWhen(), e.getModifiers()));
            this.pref.put(LASTVIEW, e.getActionCommand());
        }
    }

    public Component getVisibleComponent() {
        return this.last;
    }

    protected void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = "";
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    private static final class ButtonPanel
    extends JPanel {
        private FormLayout layout = null;

        public ButtonPanel() {
            this.setLayout();
        }

        protected void addButton(JButton button) {
            CellConstraints cc = new CellConstraints();
            if (this.layout.getRowCount() > 0) {
                this.layout.appendRow(RowSpec.decode((String)"$lg"));
            }
            this.layout.appendRow(RowSpec.decode((String)"min"));
            this.add((Component)button, cc.xy(1, this.layout.getRowCount()));
            this.layout.addGroupedRow(this.layout.getRowCount());
        }

        @Override
        public void removeAll() {
            super.removeAll();
            this.setLayout();
        }

        private void setLayout() {
            this.layout = new FormLayout("[min,15dlu]", "");
            this.setLayout((LayoutManager)this.layout);
        }
    }

    private static final class InfoPanel
    extends GradientPanel {
        private JLabel label;

        protected InfoPanel(Icon icon, String text) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
            this.label = new JLabel(text, icon, 2);
            this.label.setIconTextGap(10);
            this.label.setForeground(Color.WHITE);
            this.adjustFont();
            this.add(this.label);
        }

        @Override
        public void updateUI() {
            this.setBackground(UIManager.getColor("InternalFrame.activeTitleBackground"));
            this.adjustFont();
        }

        private void adjustFont() {
            Font font;
            if (this.label != null && (font = UIManager.getFont("Label.font")) != null) {
                font = font.deriveFont(1, font.getSize() + 4);
                this.label.setFont(font);
            }
        }
    }

    private static class Button
    extends JButton {
        private Component component;
        private Icon icon;

        protected Button(Component component, Icon icon) {
            super(icon);
            this.icon = icon;
            this.component = component;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setMargin(margin);
            this.setFocusPainted(false);
        }

        public Component getComponent() {
            return this.component;
        }

        @Override
        public void updateUI() {
            if (ThemeManager.isLookAndFeelOSX()) {
                margin = new Insets(20, 6, 20, 6);
            } else {
                margin = new Insets(10, 1, 10, 1);
            }
            this.setMargin(margin);
            if (this.icon instanceof VerticalTextIcon) {
                ((VerticalTextIcon)this.icon).updateUI();
            }
            super.updateUI();
        }
    }
}

