/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import javax.swing.tree.DefaultMutableTreeNode;
import jgnash.engine.Account;
import jgnash.ui.account.AccountListTreeTablePane;
import jgnash.ui.account.AccountTreeModel;
import jgnash.ui.treetable.TreeTableModel;
import jgnash.util.Resource;

public class AccountTreeTableModel
extends AccountTreeModel
implements TreeTableModel {
    private static final long serialVersionUID = 6076457926737396909L;
    private Resource rb = Resource.get();
    private String[] cNames = new String[]{this.rb.getString("Column.AccountName"), this.rb.getString("Column.Entries"), this.rb.getString("Column.Balance"), this.rb.getString("Column.ReconciledBalance"), this.rb.getString("Column.Currency"), this.rb.getString("Column.Type")};
    private Class<?>[] cTypes = new Class[]{TreeTableModel.class, String.class, AccountListTreeTablePane.AccountBalanceCellRenderer.class, AccountListTreeTablePane.ReconciledAccountBalanceCellRenderer.class, String.class, String.class};

    @Override
    public Class<?> getColumnClass(int col) {
        return this.cTypes[col];
    }

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.cNames[col];
    }

    @Override
    public Object getValueAt(Object obj, int col) {
        Account account = (Account)((DefaultMutableTreeNode)obj).getUserObject();
        switch (col) {
            case 0: {
                return account.getName();
            }
            case 1: {
                return account.getTransactionCount();
            }
            case 2: {
                return account;
            }
            case 3: {
                return account;
            }
            case 4: {
                return " " + (account.getCurrencyNode() != null ? account.getCurrencyNode().getSymbol() : "N/A");
            }
            case 5: {
                return account.getAccountType().toString();
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == TreeTableModel.class;
    }
}

