/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DefaultCurrencies;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.util.ValidationFactory;
import jgnash.util.Resource;

public class CurrenciesPanel
extends JPanel
implements ActionListener {
    private final Resource rb = Resource.get();
    private SortedListModel<CurrencyNode> aList;
    private SortedListModel<CurrencyElement> cList;
    private JList cJList;
    private JList aJList;
    private JButton customButton;
    private JTextField customField;
    private JButton addButton;
    private JButton removeButton;
    private Engine engine = EngineFactory.getEngine("default");

    public static void showDialog(final JFrame parent) {
        final Resource rb = Resource.get();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenericCloseDialog d = new GenericCloseDialog(null, new CurrenciesPanel(), rb.getString("Title.AddRemCurr"));
                d.pack();
                d.setMinimumSize(d.getSize());
                d.setLocationRelativeTo(parent);
                d.setVisible(true);
            }
        });
    }

    private CurrenciesPanel() {
        this.layoutMainPanel();
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.customButton.addActionListener(this);
    }

    private void initComponents() {
        this.addButton = new JButton(this.rb.getString("Button.Add"));
        this.addButton.setIcon(Resource.getIcon("/jgnash/resource/list-add.png"));
        this.addButton.setHorizontalTextPosition(10);
        this.removeButton = new JButton(this.rb.getString("Button.Remove"));
        this.removeButton.setIcon(Resource.getIcon("/jgnash/resource/list-remove.png"));
        this.customButton = new JButton(this.rb.getString("Button.Add"));
        this.customField = new JTextField();
        this.buildLists();
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("d:g(0.5), 8dlu, p, 8dlu, d:g(0.5)", "");
        layout.addGroupedColumn(1);
        layout.addGroupedColumn(5);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendTitle(this.rb.getString("Title.Available"));
        builder.append("");
        builder.appendTitle(this.rb.getString("Title.Current"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow("fill:80dlu:g");
        builder.append((Component)new JScrollPane(this.aJList), (Component)this.buildCenterPanel(), (Component)new JScrollPane(this.cJList));
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.layoutCustomPanel(), 5);
        builder.appendSeparator();
    }

    private JPanel layoutCustomPanel() {
        FormLayout layout = new FormLayout("p, 8dlu, 55dlu, 8dlu, max(30dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Label.CreateCurr"), (Component)this.customField, (Component)this.customButton);
        return builder.getPanel();
    }

    private JPanel buildCenterPanel() {
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.addButton);
        builder.append((Component)this.removeButton);
        return builder.getPanel();
    }

    private void customAction() {
        if (this.customField.getText().length() > 0) {
            if (this.engine.getCurrency(this.customField.getText()) != null) {
                ValidationFactory.showValidationErrorx(this.rb.getString("Message.Error.Duplicate"), this.customField);
            } else {
                CurrencyNode node = DefaultCurrencies.buildCustomNode(this.customField.getText());
                if (this.engine.addCommodity(node)) {
                    this.cList.addElement(new CurrencyElement(node, true));
                    this.customField.setText(null);
                    return;
                }
            }
        }
        ValidationFactory.showValidationErrorx(this.rb.getString("Message.Error.MissingSymbol"), this.customField);
    }

    private void addAction() {
        Object[] list;
        for (Object obj : list = this.aJList.getSelectedValues()) {
            if (obj == null) continue;
            this.aList.removeElement(obj);
            this.cList.addElement(new CurrencyElement((CurrencyNode)obj, true));
            this.engine.addCommodity((CurrencyNode)obj);
        }
    }

    private void removeAction() {
        Object[] list;
        for (Object element : list = this.cJList.getSelectedValues()) {
            CurrencyElement obj = (CurrencyElement)element;
            if (!obj.isEnabled()) continue;
            this.cList.removeElement(obj);
            this.aList.addElement(obj.getNode());
            this.engine.removeCommodity(obj.getNode());
        }
    }

    private void buildLists() {
        Set<CurrencyNode> defaultNodes = DefaultCurrencies.generateCurrencies();
        Set<CurrencyNode> activeNodes = this.engine.getActiveCurrencies();
        List<CurrencyNode> availNodes = this.engine.getCurrencies();
        for (CurrencyNode node : availNodes) {
            defaultNodes.remove(node);
        }
        this.aList = new SortedListModel<CurrencyNode>(defaultNodes);
        this.aJList = new JList<CurrencyNode>(this.aList);
        ArrayList<CurrencyElement> list = new ArrayList<CurrencyElement>();
        for (CurrencyNode node : availNodes) {
            if (activeNodes.contains(node)) {
                list.add(new CurrencyElement(node, false));
                continue;
            }
            list.add(new CurrencyElement(node, true));
        }
        this.cList = new SortedListModel(list);
        this.cJList = new JList<CurrencyElement>(this.cList);
        this.cJList.setCellRenderer(new CurrencyRenderer());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        } else if (e.getSource() == this.customButton) {
            this.customAction();
        }
    }

    private static final class CurrencyRenderer
    extends DefaultListCellRenderer {
        private CurrencyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            this.setEnabled(((CurrencyElement)value).isEnabled());
            return this;
        }
    }

    static class CurrencyElement
    implements Comparable<CurrencyElement> {
        private CurrencyNode node;
        private boolean enabled;

        protected CurrencyElement(CurrencyNode node, boolean enabled) {
            this.node = node;
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public CurrencyNode getNode() {
            return this.node;
        }

        public final String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(CurrencyElement cnode) {
            return this.node.compareTo(cnode.node);
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof CurrencyElement) {
                result = this.node.equals(((CurrencyElement)o).node);
            }
            return result;
        }

        public int hashCode() {
            int hash = 7;
            hash = 13 * hash + (this.node != null ? this.node.hashCode() : 0);
            hash = 13 * hash + (this.enabled ? 1 : 0);
            return hash;
        }
    }
}

