/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.JFloatField;
import jgnash.util.Resource;

public class AccountExchangePanel
extends JPanel
implements ActionListener,
FocusListener,
PopupMenuListener,
ItemListener {
    private static final long serialVersionUID = -4082990561708078467L;
    private CurrencyNode baseCurrency;
    private AccountListComboBox accountCombo;
    private JLabel amountLabel;
    private JFloatField exchangeAmountField;
    private JToggleButton expandButton;
    private boolean isLayoutCompact = true;
    private JFloatField amountField = null;
    private JPopupMenu detailWindow;
    private JFloatField exchangeRateField;
    private JLabel conversionLabel;
    private long eventTime;

    public AccountExchangePanel(CurrencyNode baseCurrency, Account account, JFloatField amountField) {
        assert (baseCurrency != null && amountField != null);
        Resource rb = Resource.get();
        this.baseCurrency = baseCurrency;
        this.amountField = amountField;
        if (amountField.isEditable()) {
            amountField.addFocusListener(this);
        } else {
            amountField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AccountExchangePanel.this.amountFieldAction();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        this.accountCombo = account != null ? new AccountListComboBox(account) : new AccountListComboBox();
        this.accountCombo.addActionListener(this);
        Account selectedAccount = this.accountCombo.getSelectedAccount();
        if (selectedAccount == null) {
            selectedAccount = account;
        }
        this.exchangeAmountField = new JFloatField(selectedAccount.getCurrencyNode());
        this.exchangeAmountField.addFocusListener(this);
        this.expandButton = new JToggleButton(Resource.getIcon("/jgnash/resource/mail-send-receive.png"));
        this.expandButton.setMargin(new Insets(0, 0, 0, 0));
        this.expandButton.addItemListener(this);
        this.expandButton.setFocusPainted(false);
        this.amountLabel = new JLabel(rb.getString("Label.ExchangeAmount"));
        this.exchangeRateField = new JFloatField(0, 6, 2);
        this.exchangeRateField.addFocusListener(this);
        this.updateExchangeRateField();
        this.conversionLabel = new JLabel();
        this.conversionLabel.setText(CommodityFormat.getConversion(baseCurrency, selectedAccount.getCurrencyNode()));
        this.detailWindow = new JPopupMenu();
        this.detailWindow.setLayout(new BorderLayout());
        this.detailWindow.add((Component)this.layoutRatePanel(), "Center");
        this.detailWindow.addPopupMenuListener(this);
        this.layoutPanel();
        this.updateLayout();
    }

    public AccountExchangePanel(CurrencyNode baseCurrency, JFloatField amountField) {
        this(baseCurrency, null, amountField);
    }

    private void updateExchangeRateField() {
        Engine engine = EngineFactory.getEngine("default");
        Account selectedAccount = this.accountCombo.getSelectedAccount();
        if (selectedAccount != null) {
            this.exchangeRateField.setDecimal(engine.getExchangeRate(this.baseCurrency, selectedAccount.getCurrencyNode()));
        }
    }

    private JPanel layoutRatePanel() {
        Resource rb = Resource.get();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("d, 6dlu, right:d, $lcgap, max(48dlu;min)", "f:d");
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(Borders.DLU2_BORDER);
        panel.add((Component)this.conversionLabel, cc.xy(1, 1));
        panel.add((Component)new JLabel(rb.getString("Label.ExchangeRate")), cc.xy(3, 1));
        panel.add((Component)this.exchangeRateField, cc.xy(5, 1));
        return panel;
    }

    private void layoutPanel() {
        FormLayout layout = new FormLayout("50dlu:g", "f:d:g");
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.accountCombo, cc.xy(1, 1));
        this.isLayoutCompact = true;
    }

    private void addExtraComponents() {
        FormLayout layout = (FormLayout)this.getLayout();
        layout.appendColumn(ColumnSpec.decode((String)"8dlu"));
        layout.appendColumn(ColumnSpec.decode((String)"right:d"));
        layout.appendColumn(ColumnSpec.decode((String)"$lcgap"));
        layout.appendColumn(ColumnSpec.decode((String)"max(48dlu;min)"));
        layout.appendColumn(ColumnSpec.decode((String)"1px"));
        layout.appendColumn(ColumnSpec.decode((String)"min"));
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.amountLabel, cc.xy(3, 1));
        this.add((Component)this.exchangeAmountField, cc.xy(5, 1));
        this.add((Component)this.expandButton, cc.xy(7, 1));
        this.invalidate();
        this.isLayoutCompact = false;
    }

    private void removeExtraComponents() {
        FormLayout layout = (FormLayout)this.getLayout();
        this.remove(this.expandButton);
        this.remove(this.exchangeAmountField);
        this.remove(this.amountLabel);
        layout.removeColumn(7);
        layout.removeColumn(6);
        layout.removeColumn(5);
        layout.removeColumn(4);
        layout.removeColumn(3);
        layout.removeColumn(2);
        this.invalidate();
        this.isLayoutCompact = true;
    }

    private void updateLayout() {
        if (this.accountCombo.getSelectedAccount() != null) {
            if (this.accountCombo.getSelectedAccount().getCurrencyNode().equals(this.baseCurrency) && !this.isLayoutCompact) {
                this.removeExtraComponents();
                this.validate();
            } else if (!this.accountCombo.getSelectedAccount().getCurrencyNode().equals(this.baseCurrency) && this.isLayoutCompact) {
                this.addExtraComponents();
                this.validate();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (System.currentTimeMillis() - this.eventTime < 250L) {
            this.expandButton.setSelected(false);
            return;
        }
        if (e.getStateChange() == 1) {
            Point location = this.exchangeAmountField.getLocation();
            this.detailWindow.show(this, location.x, location.y + this.exchangeAmountField.getHeight());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accountCombo && this.accountCombo.getSelectedAccount() != null) {
            Engine engine = EngineFactory.getEngine("default");
            BigDecimal rate = engine.getExchangeRate(this.baseCurrency, this.accountCombo.getSelectedAccount().getCurrencyNode());
            this.exchangeAmountField.setScale(this.accountCombo.getSelectedAccount().getCurrencyNode());
            this.exchangeAmountField.setDecimal(this.amountField.getDecimal().multiply(rate));
            this.conversionLabel.setText(CommodityFormat.getConversion(this.baseCurrency, this.accountCombo.getSelectedAccount().getCurrencyNode()));
            this.updateExchangeRateField();
            this.updateLayout();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.eventTime = System.currentTimeMillis();
        this.expandButton.setSelected(false);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public BigDecimal getExchangeRate() {
        if (this.isLayoutCompact) {
            return BigDecimal.ONE;
        }
        return this.exchangeRateField.getDecimal();
    }

    public BigDecimal getExchangedAmount() {
        return this.exchangeAmountField.getDecimal();
    }

    public Account getSelectedAccount() {
        return this.accountCombo.getSelectedAccount();
    }

    public void setSelectedAccount(Account account) {
        this.accountCombo.setSelectedAccount(account);
    }

    public void setExchangedAmount(BigDecimal amount) {
        this.exchangeAmountField.setDecimal(amount);
    }

    private void amountFieldAction() {
        if (this.exchangeRateField.getDecimal().compareTo(BigDecimal.ZERO) == 0) {
            if (this.amountField.getDecimal().compareTo(BigDecimal.ZERO) != 0) {
                this.exchangeRateField.setDecimal(this.exchangeAmountField.getDecimal().divide(this.amountField.getDecimal(), Engine.getContext()));
            }
        } else {
            this.exchangeAmountField.setDecimal(this.amountField.getDecimal().multiply(this.exchangeRateField.getDecimal(), Engine.getContext()));
        }
    }

    private void exchangeRateFieldAction() {
        if (this.amountField.getDecimal().compareTo(BigDecimal.ZERO) == 0 && this.amountField.isEditable()) {
            if (this.exchangeRateField.getDecimal().compareTo(BigDecimal.ZERO) != 0) {
                this.amountField.setDecimal(this.exchangeAmountField.getDecimal().divide(this.exchangeRateField.getDecimal(), Engine.getContext()));
            }
        } else {
            this.exchangeAmountField.setDecimal(this.amountField.getDecimal().multiply(this.exchangeRateField.getDecimal(), Engine.getContext()));
        }
    }

    private void exchangeAmountFieldAction() {
        if (this.amountField.getDecimal().compareTo(BigDecimal.ZERO) == 0 && this.amountField.isEditable()) {
            if (this.exchangeRateField.getDecimal().compareTo(BigDecimal.ZERO) != 0) {
                this.amountField.setDecimal(this.exchangeAmountField.getDecimal().divide(this.exchangeRateField.getDecimal(), Engine.getContext()));
            }
        } else if (this.amountField.getDecimal().compareTo(BigDecimal.ZERO) != 0) {
            this.exchangeRateField.setDecimal(this.exchangeAmountField.getDecimal().divide(this.amountField.getDecimal(), Engine.getContext()));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.exchangeAmountField && this.exchangeAmountField.getDecimal().compareTo(BigDecimal.ZERO) > 0) {
            this.exchangeAmountFieldAction();
        } else if (e.getSource() == this.amountField) {
            this.amountFieldAction();
        } else if (e.getSource() == this.exchangeRateField) {
            this.exchangeRateFieldAction();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.accountCombo.setEnabled(enabled);
        this.expandButton.setEnabled(enabled);
        this.exchangeRateField.setEnabled(enabled);
    }
}

