/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryBuyX;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionTag;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AccountSecurityComboBox;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.AccountExchangePanel;
import jgnash.ui.register.invest.AbstractInvTransactionPanel;
import jgnash.ui.register.invest.FeePanel;

public class BuySharePanel
extends AbstractInvTransactionPanel {
    private DatePanel datePanel;
    private JFloatField priceField;
    private JFloatField quantityField;
    private FeePanel feePanel;
    private JTextField memoField;
    private JFloatField totalField;
    private AccountSecurityComboBox securityCombo;
    private AccountExchangePanel accountExchangePanel;
    private Logger logger = UIApplication.getLogger();

    protected BuySharePanel(Account account) {
        super(account);
        this.datePanel = new DatePanel();
        this.feePanel = new FeePanel(account);
        this.memoField = AutoCompleteFactory.getMemoField();
        this.priceField = new JFloatField(0, 6, (int)account.getCurrencyNode().getScale());
        this.quantityField = new JFloatField(0, 6, 2);
        this.totalField = new JFloatField(account.getCurrencyNode());
        this.totalField.setEditable(false);
        this.totalField.setFocusable(false);
        this.securityCombo = new AccountSecurityComboBox(account);
        this.accountExchangePanel = new AccountExchangePanel(this.getAccount().getCurrencyNode(), this.totalField);
        this.accountExchangePanel.setSelectedAccount(this.getAccount());
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.layoutMainPanel();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BuySharePanel.this.updateTotalField();
            }
        };
        this.feePanel.addFocusListener(focusListener);
        this.feePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == BuySharePanel.this.feePanel) {
                    BuySharePanel.this.updateTotalField();
                }
            }
        });
        this.quantityField.addFocusListener(focusListener);
        this.priceField.addFocusListener(focusListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.feePanel.addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.priceField.addKeyListener(this.keyListener);
        this.quantityField.addKeyListener(this.keyListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.reconciledButton.addKeyListener(this.keyListener);
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $lgap, f:d, $lgap, f:d, $lgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        JPanel subPanel = this.buildHorizontalSubPanel("max(48dlu;min):g(0.5), 8dlu, d, $lcgap, max(48dlu;min):g(0.5)", new Object[]{this.priceField, "Label.Quantity", this.quantityField});
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)this.securityCombo, (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Price", (Object)cc.xy(1, 3));
        this.add((Component)subPanel, (Object)cc.xy(3, 3));
        this.add("Label.Fees", (Object)cc.xy(5, 3));
        this.add((Component)this.feePanel, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add("Label.Total", (Object)cc.xy(5, 5));
        this.add((Component)this.totalField, (Object)cc.xy(7, 5));
        this.add("Label.Account", (Object)cc.xy(1, 7));
        this.add((Component)this.accountExchangePanel, (Object)cc.xy(3, 7));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(5, 7, 3));
    }

    void updateTotalField() {
        BigDecimal fee = this.feePanel.getDecimal();
        BigDecimal quantity = this.quantityField.getDecimal();
        BigDecimal price = this.priceField.getDecimal();
        BigDecimal value = quantity.multiply(price);
        value = value.add(fee);
        this.totalField.setDecimal(value);
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        if (!(tran instanceof InvestmentTransaction)) {
            throw new IllegalArgumentException("bad tranType");
        }
        this.clearForm();
        this.datePanel.setDate(tran.getDate());
        List<TransactionEntry> entries = tran.getTransactionEntries();
        this.feePanel.setTransactionEntries(((InvestmentTransaction)tran).getInvestmentFeeEntries());
        for (TransactionEntry e : entries) {
            if (e instanceof TransactionEntryBuyX) {
                AbstractInvestmentTransactionEntry entry = (AbstractInvestmentTransactionEntry)e;
                this.memoField.setText(e.getMemo());
                this.priceField.setDecimal(entry.getPrice());
                this.quantityField.setDecimal(entry.getQuantity());
                this.securityCombo.setSelectedNode(entry.getSecurityNode());
                if (entry.getCreditAccount().equals(this.account)) {
                    this.accountExchangePanel.setSelectedAccount(entry.getDebitAccount());
                    this.accountExchangePanel.setExchangedAmount(entry.getDebitAmount().abs());
                    continue;
                }
                this.accountExchangePanel.setSelectedAccount(entry.getCreditAccount());
                this.accountExchangePanel.setExchangedAmount(entry.getCreditAmount());
                continue;
            }
            if (e.getTransactionTag() == TransactionTag.INVESTMENT_CASH_TRANSFER || e.getTransactionTag() == TransactionTag.INVESTMENT_FEE) continue;
            this.logger.warning("Tried to modify an invalid transaction");
        }
        this.updateTotalField();
        this.modTrans = tran;
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }

    @Override
    public Transaction buildTransaction() {
        BigDecimal exchangeRate = this.accountExchangePanel.getExchangeRate();
        List<TransactionEntry> fees = this.feePanel.getTransactions();
        return TransactionFactory.generateBuyXTransaction(this.accountExchangePanel.getSelectedAccount(), this.getAccount(), (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), exchangeRate, this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected(), fees);
    }

    @Override
    public void clearForm() {
        this.modTrans = null;
        if (!BuySharePanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.priceField.setDecimal(null);
        this.quantityField.setDecimal(null);
        this.feePanel.clearForm();
        this.reconciledButton.setSelected(false);
        this.accountExchangePanel.setSelectedAccount(this.getAccount());
        this.updateTotalField();
    }

    @Override
    public boolean validateForm() {
        if (this.securityCombo.getSelectedNode() == null) {
            this.logger.warning(this.rb.getString("Message.Error.SecuritySelection"));
            this.showValidationError(this.rb.getString("Message.Error.SecuritySelection"), this.securityCombo);
            return false;
        }
        if (this.priceField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityPrice"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityPrice"), this.priceField);
            return false;
        }
        if (this.quantityField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityQuantity"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityQuantity"), this.quantityField);
            return false;
        }
        return true;
    }

    @Override
    protected void cancelAction() {
        this.clearForm();
    }
}

