/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.treetable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jgnash.ui.treetable.AbstractCellEditor;
import jgnash.ui.treetable.TreeTableModel;
import jgnash.ui.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private TreeTableCellRenderer tree;
    private TableColumn treeColumn;
    private static Border firstColumnBorder = new EmptyBorder(0, 6, 0, 0);
    private static Border regColumnBorder = new EmptyBorder(0, 0, 0, 0);

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        this.findTreeColumn();
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new CellRenderer());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        this.updateEnclosingScrollPaneBackground();
    }

    private void findTreeColumn() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnClass(i) != TreeTableModel.class) continue;
            this.treeColumn = this.getColumnModel().getColumn(i);
            return;
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.updateEnclosingScrollPaneBackground();
    }

    private void updateEnclosingScrollPaneBackground() {
        Container p = this.getParent();
        if (p instanceof JViewport) {
            p.setBackground(this.tree.getBackground());
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.removeTreeSelectionListener(tsl);
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public void setRootVisible(boolean rootVisable) {
        this.tree.setRootVisible(rootVisable);
    }

    public void scrollPathToVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    public Object getLastSelectedPathComponent() {
        return this.tree.getLastSelectedPathComponent();
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.tree.getClosestPathForLocation(x, y);
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    public void setToggleClickCount(int clickCount) {
        this.tree.setToggleClickCount(clickCount);
    }

    public int getToggleClickCount() {
        return this.tree.getToggleClickCount();
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(rowHeight);
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 4982038776011113298L;
        private boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
            this.setSelectionMode(1);
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        private ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                int count = JTreeTable.this.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                this.setBorder(firstColumnBorder);
            } else {
                this.setBorder(regColumnBorder);
            }
            return this;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int visibleRow;

        protected TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setCellRenderer(new ClippingTreeCellRenderer());
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer r = this.getCellRenderer();
            if (r instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer d = (DefaultTreeCellRenderer)r;
                d.setBorderSelectionColor(null);
                d.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                d.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int height) {
            int rHeight = height;
            if (rHeight <= 0) {
                rHeight = 18;
            }
            if (rHeight > 0) {
                super.setRowHeight(rHeight);
                if (JTreeTable.this.getRowHeight() != rHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
                TreeCellRenderer r = this.getCellRenderer();
                if (r instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer d = (DefaultTreeCellRenderer)r;
                    d.setBorderSelectionColor(null);
                    d.setTextSelectionColor(table.getSelectionForeground());
                    d.setBackgroundSelectionColor(table.getSelectionBackground());
                }
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (column == 0) {
                this.setBorder(firstColumnBorder);
            } else {
                this.setBorder(regColumnBorder);
            }
            this.visibleRow = row;
            return this;
        }

        private class ClippingTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private Rectangle bounds = new Rectangle();

            private ClippingTreeCellRenderer() {
            }

            @Override
            public void paint(Graphics g) {
                this.bounds = this.getBounds(this.bounds);
                this.bounds.width = JTreeTable.this.treeColumn.getWidth() - this.bounds.x;
                this.setText(this.clipText(g.getFontMetrics(), this.bounds));
                super.paint(g);
            }

            private String clipText(FontMetrics fm, Rectangle clipBounds) {
                return SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), 0, 4, 0, 4, clipBounds, new Rectangle(), new Rectangle(), this.getIconTextGap());
            }
        }
    }
}

