/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Locale;

public class EncodeDecode {
    private EncodeDecode() {
    }

    public static String encodeDimension(Dimension d) {
        StringBuilder buf = new StringBuilder();
        buf.append(d.width);
        buf.append(',');
        buf.append(d.height);
        return buf.toString();
    }

    public static Dimension decodeDimension(String d) {
        if (d == null) {
            return null;
        }
        Dimension rect = null;
        String[] array = d.split(",");
        if (array.length == 2) {
            try {
                rect = new Dimension();
                rect.width = Integer.parseInt(array[0]);
                rect.height = Integer.parseInt(array[1]);
            }
            catch (NumberFormatException nfe) {
                rect = null;
            }
        }
        return rect;
    }

    public static String encodeRectangle(Rectangle bounds) {
        StringBuilder buf = new StringBuilder();
        buf.append(bounds.x);
        buf.append(',');
        buf.append(bounds.y);
        buf.append(',');
        buf.append(bounds.width);
        buf.append(',');
        buf.append(bounds.height);
        return buf.toString();
    }

    public static Rectangle decodeRectangle(String bounds) {
        if (bounds == null) {
            return null;
        }
        Rectangle rect = null;
        String[] array = bounds.split(",");
        if (array.length == 4) {
            try {
                rect = new Rectangle();
                rect.x = Integer.parseInt(array[0]);
                rect.y = Integer.parseInt(array[1]);
                rect.width = Integer.parseInt(array[2]);
                rect.height = Integer.parseInt(array[3]);
            }
            catch (NumberFormatException nfe) {
                rect = null;
            }
        }
        return rect;
    }

    public static String encodeLocale(Locale locale) {
        StringBuilder buf = new StringBuilder();
        buf.append(locale.getLanguage());
        if (!locale.getCountry().equals("")) {
            buf.append('.');
            buf.append(locale.getCountry());
            if (!locale.getVariant().equals("")) {
                buf.append('.');
                buf.append(locale.getVariant());
            }
        }
        return buf.toString();
    }

    public static Locale decodeLocale(String locale) {
        if (locale.equals("")) {
            return Locale.getDefault();
        }
        if (locale.indexOf(46) == -1) {
            return new Locale(locale);
        }
        String[] array = locale.split("\\x2E");
        if (array.length == 3) {
            return new Locale(array[0], array[1], array[2]);
        }
        if (array.length == 2) {
            return new Locale(array[0], array[1]);
        }
        return Locale.getDefault();
    }

    public static String encodeBooleanArray(boolean[] array) {
        StringBuilder buf = new StringBuilder();
        if (array != null) {
            for (boolean anArray : array) {
                if (anArray) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            return buf.toString();
        }
        return null;
    }

    public static boolean[] decodeBooleanArray(String array) {
        int len;
        if (array != null && (len = array.length()) > 0) {
            boolean[] b = new boolean[len];
            for (int i = 0; i < len; ++i) {
                if (array.charAt(i) != '1') continue;
                b[i] = true;
            }
            return b;
        }
        return null;
    }
}

