/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jgnash.util.SearchUtils;

public class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileLocked(String fileName) {
        boolean result = true;
        File file = new File(fileName);
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            FileLock lock = channel.tryLock();
            if (lock != null) {
                lock.release();
                result = false;
            }
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(FileUtils.class.getName()).fine("database file: " + fileName + " was not found");
        }
        catch (IOException e) {
            result = true;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return result;
    }

    public static String stripFileExtension(String fileName) {
        return fileName.split("\\.")[0];
    }

    public static boolean fileHasExtension(String fileName) {
        return !FileUtils.stripFileExtension(fileName).equals(fileName);
    }

    public static String getFileExtension(String fileName) {
        String regex = "(?<=\\.).*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dst) {
        if (src == null || dst == null || src.equals(dst)) {
            return false;
        }
        boolean result = false;
        if (src.exists()) {
            FileChannel dstChannel;
            FileChannel srcChannel;
            if (dst.exists() && !dst.canWrite()) {
                return false;
            }
            try {
                srcChannel = new FileInputStream(src).getChannel();
                dstChannel = new FileOutputStream(dst).getChannel();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            try {
                int maxCount = 67076096;
                long size = srcChannel.size();
                for (long position = 0L; position < size; position += srcChannel.transferTo(position, maxCount, dstChannel)) {
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (srcChannel != null) {
                    try {
                        srcChannel.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (dstChannel != null) {
                    try {
                        dstChannel.close();
                        result = true;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(File source, File destination) {
        byte[] ioBuffer = new byte[8192];
        FileInputStream in = null;
        try {
            int length;
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destination));
            zipOut.setLevel(9);
            in = new FileInputStream(source);
            zipOut.putNextEntry(new ZipEntry(source.getName()));
            while ((length = in.read(ioBuffer)) > 0) {
                zipOut.write(ioBuffer, 0, length);
            }
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<File> getDirectoryListing(File directory, String pattern) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (directory != null && directory.isDirectory()) {
            final Pattern p = SearchUtils.createSearchPattern(pattern, false);
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return p.matcher(name).matches();
                }
            });
            fileList.addAll(Arrays.asList(files));
            Collections.sort(fileList);
        }
        return fileList;
    }
}

