/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.defragment.AbstractContextIDMapping;
import com.db4o.defragment.DefragContextImpl;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.mapping.MappedIDPair;
import com.db4o.internal.mapping.MappedIDPairHandler;

public class BTreeIDMapping
extends AbstractContextIDMapping {
    private String _fileName;
    private LocalObjectContainer _mappingDb;
    private BTree _idTree;
    private MappedIDPair _cache = new MappedIDPair(0, 0);
    private BTreeSpec _treeSpec = null;
    private int _commitFrequency = 0;
    private int _insertCount = 0;

    public BTreeIDMapping(String string) {
        this(string, null, 0);
    }

    public BTreeIDMapping(String string, int n, int n2, int n3) {
        this(string, new BTreeSpec(n, n2), n3);
    }

    private BTreeIDMapping(String string, BTreeSpec bTreeSpec, int n) {
        this._fileName = string;
        this._treeSpec = bTreeSpec;
        this._commitFrequency = n;
    }

    public int mappedID(int n, boolean bl) {
        if (this._cache.orig() == n) {
            return this._cache.mapped();
        }
        int n2 = this.mappedClassID(n);
        if (n2 != 0) {
            return n2;
        }
        BTreeRange bTreeRange = this._idTree.search(this.trans(), new MappedIDPair(n, 0));
        Iterator4 iterator4 = bTreeRange.pointers();
        if (iterator4.moveNext()) {
            BTreePointer bTreePointer = (BTreePointer)iterator4.current();
            this._cache = (MappedIDPair)bTreePointer.key();
            return this._cache.mapped();
        }
        if (bl) {
            return this.mapLenient(n, bTreeRange);
        }
        return 0;
    }

    private int mapLenient(int n, BTreeRange bTreeRange) {
        BTreePointer bTreePointer = (bTreeRange = bTreeRange.smaller()).lastPointer();
        if (bTreePointer == null) {
            return 0;
        }
        MappedIDPair mappedIDPair = (MappedIDPair)bTreePointer.key();
        return mappedIDPair.mapped() + (n - mappedIDPair.orig());
    }

    protected void mapNonClassIDs(int n, int n2) {
        this._cache = new MappedIDPair(n, n2);
        this._idTree.add(this.trans(), this._cache);
        if (this._commitFrequency > 0) {
            ++this._insertCount;
            if (this._commitFrequency == this._insertCount) {
                this._idTree.commit(this.trans());
                this._insertCount = 0;
            }
        }
    }

    public void open() {
        this._mappingDb = DefragContextImpl.freshYapFile(this._fileName, 1);
        MappedIDPairHandler mappedIDPairHandler = new MappedIDPairHandler(this._mappingDb);
        this._idTree = this._treeSpec == null ? new BTree(this.trans(), 0, mappedIDPairHandler) : new BTree(this.trans(), 0, mappedIDPairHandler, this._treeSpec.nodeSize(), this._treeSpec.cacheHeight());
    }

    public void close() {
        this._mappingDb.close();
    }

    private Transaction trans() {
        return this._mappingDb.systemTransaction();
    }

    private static class BTreeSpec {
        private int _nodeSize;
        private int _cacheHeight;

        public BTreeSpec(int n, int n2) {
            this._nodeSize = n;
            this._cacheHeight = n2;
        }

        public int nodeSize() {
            return this._nodeSize;
        }

        public int cacheHeight() {
            return this._cacheHeight;
        }
    }
}

