/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Persistent;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public abstract class PersistentBase
implements Persistent {
    protected int _id;
    protected int _state = 2;

    public final boolean beginProcessing() {
        if (this.bitIsTrue(2)) {
            return false;
        }
        this.bitTrue(2);
        return true;
    }

    final void bitFalse(int n) {
        this._state &= ~(1 << n);
    }

    final boolean bitIsFalse(int n) {
        return (this._state | 1 << n) != this._state;
    }

    final boolean bitIsTrue(int n) {
        return (this._state | 1 << n) == this._state;
    }

    final void bitTrue(int n) {
        this._state |= 1 << n;
    }

    void cacheDirty(Collection4 collection4) {
        if (!this.bitIsTrue(3)) {
            this.bitTrue(3);
            collection4.add(this);
        }
    }

    public void endProcessing() {
        this.bitFalse(2);
    }

    public void free(Transaction transaction) {
        transaction.systemTransaction().slotFreePointerOnCommit(this.getID());
    }

    public int getID() {
        return this._id;
    }

    public final boolean isActive() {
        return this.bitIsTrue(1);
    }

    public boolean isDirty() {
        return this.bitIsTrue(1) && !this.bitIsTrue(0);
    }

    public final boolean isNew() {
        return this.getID() == 0;
    }

    public int linkLength() {
        return 4;
    }

    final void notCachedDirty() {
        this.bitFalse(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Transaction transaction) {
        if (!this.beginProcessing()) {
            return;
        }
        try {
            Buffer buffer = transaction.container().readReaderByID(transaction, this.getID());
            this.readThis(transaction, buffer);
            this.setStateOnRead(buffer);
        }
        finally {
            this.endProcessing();
        }
    }

    public void setID(int n) {
        this._id = n;
    }

    public final void setStateClean() {
        this.bitTrue(1);
        this.bitTrue(0);
    }

    public final void setStateDeactivated() {
        this.bitFalse(1);
    }

    public void setStateDirty() {
        this.bitTrue(1);
        this.bitFalse(0);
    }

    void setStateOnRead(Buffer buffer) {
        if (this.bitIsTrue(3)) {
            this.setStateDirty();
        } else {
            this.setStateClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Transaction transaction) {
        if (!this.writeObjectBegin()) {
            return;
        }
        try {
            Slot slot;
            LocalObjectContainer localObjectContainer = (LocalObjectContainer)transaction.container();
            int n = this.ownLength();
            n = localObjectContainer.blockAlignedBytes(n);
            Buffer buffer = new Buffer(n);
            if (this.isNew()) {
                Pointer4 pointer4 = localObjectContainer.newSlot(n);
                this.setID(pointer4._id);
                slot = pointer4._slot;
                transaction.setPointer(pointer4);
            } else {
                slot = localObjectContainer.getSlot(n);
                transaction.slotFreeOnRollbackCommitSetPointer(this._id, slot, this.isFreespaceComponent());
            }
            this.writeToFile(transaction, buffer, slot);
        }
        finally {
            this.endProcessing();
        }
    }

    public boolean isFreespaceComponent() {
        return false;
    }

    private final void writeToFile(Transaction transaction, Buffer buffer, Slot slot) {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)transaction.container();
        this.writeThis(transaction, buffer);
        localObjectContainer.writeEncrypt(buffer, slot.address(), 0);
        if (this.isActive()) {
            this.setStateClean();
        }
    }

    public boolean writeObjectBegin() {
        if (this.isDirty()) {
            return this.beginProcessing();
        }
        return false;
    }

    public void writeOwnID(Transaction transaction, Buffer buffer) {
        this.write(transaction);
        buffer.writeInt(this.getID());
    }

    public int hashCode() {
        if (this.isNew()) {
            throw new IllegalStateException();
        }
        return this.getID();
    }
}

