/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.ssa;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Subroutine;
import EDU.purdue.cs.bloat.ssa.PhiReturnStmt;
import EDU.purdue.cs.bloat.ssa.SSA;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class SSAConstructionInfo {
    FlowGraph cfg;
    VarExpr prototype;
    LinkedList[] reals;
    LinkedList allReals;
    PhiStmt[] phis;
    Set defBlocks;

    public SSAConstructionInfo(FlowGraph cfg, VarExpr expr) {
        this.cfg = cfg;
        this.prototype = (VarExpr)expr.clone();
        this.prototype.setDef(null);
        this.reals = new LinkedList[cfg.size()];
        this.allReals = new LinkedList();
        this.defBlocks = new HashSet();
        this.phis = new PhiStmt[cfg.size()];
    }

    public VarExpr prototype() {
        return this.prototype;
    }

    public void addDefBlock(Block block) {
        this.defBlocks.add(block);
    }

    public PhiStmt phiAtBlock(Block block) {
        return this.phis[this.cfg.preOrderIndex(block)];
    }

    public void removePhiAtBlock(Block block) {
        PhiStmt phi = this.phis[this.cfg.preOrderIndex(block)];
        if (phi != null) {
            if (SSA.DEBUG) {
                System.out.println("  removing " + phi + " at " + block);
            }
            phi.cleanup();
            this.phis[this.cfg.preOrderIndex((GraphNode)block)] = null;
        }
    }

    public void addPhi(Block block) {
        if (this.phis[this.cfg.preOrderIndex(block)] != null) {
            return;
        }
        VarExpr target = (VarExpr)this.prototype.clone();
        PhiJoinStmt phi = new PhiJoinStmt(target, block);
        this.phis[this.cfg.preOrderIndex((GraphNode)block)] = phi;
        if (SSA.DEBUG) {
            System.out.println("  place " + phi + " in " + block);
        }
    }

    public void addRetPhis(Subroutine sub) {
        Iterator paths = sub.paths().iterator();
        while (paths.hasNext()) {
            Block[] path = (Block[])paths.next();
            this.addRetPhi(sub, path[1]);
        }
    }

    public void addCatchPhi(Block block) {
        if (this.phis[this.cfg.preOrderIndex(block)] != null) {
            return;
        }
        if (this.prototype instanceof LocalExpr) {
            LocalExpr target = (LocalExpr)this.prototype.clone();
            PhiCatchStmt phi = new PhiCatchStmt(target);
            this.phis[this.cfg.preOrderIndex((GraphNode)block)] = phi;
            if (SSA.DEBUG) {
                System.out.println("  place " + phi + " in " + block);
            }
        }
    }

    private void addRetPhi(Subroutine sub, Block block) {
        if (this.phis[this.cfg.preOrderIndex(block)] != null) {
            return;
        }
        VarExpr target = (VarExpr)this.prototype.clone();
        PhiReturnStmt phi = new PhiReturnStmt(target, sub);
        this.phis[this.cfg.preOrderIndex((GraphNode)block)] = phi;
        if (SSA.DEBUG) {
            System.out.println("  place " + phi + " in " + block);
        }
    }

    public void addReal(VarExpr real) {
        if (real.stmt() instanceof PhiStmt) {
            return;
        }
        Block block = real.block();
        if (real.isDef()) {
            this.defBlocks.add(block);
        }
        Assert.isTrue(block != null, real + " not in a " + block);
        LinkedList<VarExpr> l = this.reals[this.cfg.preOrderIndex(block)];
        if (l == null) {
            this.reals[this.cfg.preOrderIndex((GraphNode)block)] = l = new LinkedList<VarExpr>();
        }
        l.add(real);
        this.allReals.add(real);
    }

    public Collection reals() {
        return this.allReals;
    }

    public Collection realsAtBlock(Block block) {
        LinkedList l = this.reals[this.cfg.preOrderIndex(block)];
        if (l == null) {
            this.reals[this.cfg.preOrderIndex((GraphNode)block)] = l = new LinkedList();
        }
        return l;
    }

    public Collection defBlocks() {
        return this.defBlocks;
    }
}

