/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.ArrayList;
import java.util.Collection;

public class PhiCatchStmt
extends PhiStmt {
    ArrayList operands = new ArrayList();

    public PhiCatchStmt(LocalExpr target) {
        super(target);
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            this.target.visit(visitor);
        }
        int i = 0;
        while (i < this.operands.size()) {
            LocalExpr expr = (LocalExpr)this.operands.get(i);
            expr.visit(visitor);
            ++i;
        }
        if (!visitor.reverse()) {
            this.target.visit(visitor);
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitPhiCatchStmt(this);
    }

    public boolean hasOperandDef(LocalExpr def) {
        int i = 0;
        while (i < this.operands.size()) {
            LocalExpr expr = (LocalExpr)this.operands.get(i);
            if (expr.def() == def) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addOperand(LocalExpr operand) {
        int i = 0;
        while (i < this.operands.size()) {
            LocalExpr expr = (LocalExpr)this.operands.get(i);
            Assert.isTrue(expr.def() != operand.def());
            ++i;
        }
        this.operands.add(operand);
        operand.setParent(this);
    }

    public Collection operands() {
        if (this.operands == null) {
            return new ArrayList();
        }
        int i = 0;
        while (i < this.operands.size()) {
            LocalExpr ei = (LocalExpr)this.operands.get(i);
            int j = this.operands.size() - 1;
            while (j > i) {
                LocalExpr ej = (LocalExpr)this.operands.get(j);
                if (ei.def() == ej.def()) {
                    ej.cleanup();
                    this.operands.remove(j);
                }
                --j;
            }
            ++i;
        }
        return this.operands;
    }

    public int numOperands() {
        return this.operands.size();
    }

    public void setOperandAt(int i, Expr expr) {
        Expr old = (Expr)this.operands.get(i);
        old.cleanup();
        this.operands.set(i, expr);
        expr.setParent(this);
    }

    public Expr operandAt(int i) {
        return (Expr)this.operands.get(i);
    }
}

