/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRHyperlinkHelper {
    public static final String HYPERLINK_TYPE_NONE = "None";
    public static final String HYPERLINK_TYPE_REFERENCE = "Reference";
    public static final String HYPERLINK_TYPE_LOCAL_ANCHOR = "LocalAnchor";
    public static final String HYPERLINK_TYPE_LOCAL_PAGE = "LocalPage";
    public static final String HYPERLINK_TYPE_REMOTE_ANCHOR = "RemoteAnchor";
    public static final String HYPERLINK_TYPE_REMOTE_PAGE = "RemotePage";
    public static final String HYPERLINK_TARGET_SELF = "Self";
    public static final String HYPERLINK_TARGET_BLANK = "Blank";
    public static final String HYPERLINK_TARGET_PARENT = "Parent";
    public static final String HYPERLINK_TARGET_TOP = "Top";
    private static final Map builtinTypes = JRHyperlinkHelper.createBuiltinTypes();
    private static final Map builtinTargets = JRHyperlinkHelper.createBuiltinTargets();

    private static Map createBuiltinTypes() {
        HashMap<String, Byte> types = new HashMap<String, Byte>();
        types.put(HYPERLINK_TYPE_NONE, new Byte(1));
        types.put(HYPERLINK_TYPE_REFERENCE, new Byte(2));
        types.put(HYPERLINK_TYPE_LOCAL_ANCHOR, new Byte(3));
        types.put(HYPERLINK_TYPE_LOCAL_PAGE, new Byte(4));
        types.put(HYPERLINK_TYPE_REMOTE_ANCHOR, new Byte(5));
        types.put(HYPERLINK_TYPE_REMOTE_PAGE, new Byte(6));
        return types;
    }

    private static Map createBuiltinTargets() {
        HashMap<String, Byte> targets = new HashMap<String, Byte>();
        targets.put(HYPERLINK_TARGET_BLANK, new Byte(2));
        targets.put(HYPERLINK_TARGET_PARENT, new Byte(3));
        targets.put(HYPERLINK_TARGET_SELF, new Byte(1));
        targets.put(HYPERLINK_TARGET_TOP, new Byte(4));
        return targets;
    }

    public static byte getHyperlinkType(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkType(hyperlink.getLinkType());
    }

    public static byte getHyperlinkType(String linkType) {
        Byte builtinType;
        int type = linkType == null ? 1 : ((builtinType = (Byte)builtinTypes.get(linkType)) == null ? 7 : (int)builtinType.byteValue());
        return (byte)type;
    }

    public static byte getHyperlinkTarget(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTarget(hyperlink.getLinkTarget());
    }

    public static byte getHyperlinkTarget(String linkTarget) {
        Byte builtinTarget;
        int target = linkTarget == null ? 1 : ((builtinTarget = (Byte)builtinTargets.get(linkTarget)) == null ? 5 : (int)builtinTarget.byteValue());
        return (byte)target;
    }

    public static String getLinkType(byte hyperlinkType) {
        String type;
        switch (hyperlinkType) {
            case 0: 
            case 1: {
                type = null;
                break;
            }
            case 2: {
                type = HYPERLINK_TYPE_REFERENCE;
                break;
            }
            case 3: {
                type = HYPERLINK_TYPE_LOCAL_ANCHOR;
                break;
            }
            case 4: {
                type = HYPERLINK_TYPE_LOCAL_PAGE;
                break;
            }
            case 5: {
                type = HYPERLINK_TYPE_REMOTE_ANCHOR;
                break;
            }
            case 6: {
                type = HYPERLINK_TYPE_REMOTE_PAGE;
                break;
            }
            case 7: {
                throw new JRRuntimeException("Custom hyperlink types cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink type " + hyperlinkType);
            }
        }
        return type;
    }

    public static String getLinkTarget(byte hyperlinkTarget) {
        String target;
        switch (hyperlinkTarget) {
            case 1: {
                target = null;
                break;
            }
            case 2: {
                target = HYPERLINK_TARGET_BLANK;
                break;
            }
            case 3: {
                target = HYPERLINK_TARGET_PARENT;
                break;
            }
            case 4: {
                target = HYPERLINK_TARGET_TOP;
                break;
            }
            case 5: {
                throw new JRRuntimeException("Custom hyperlink targets cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink target " + hyperlinkTarget);
            }
        }
        return target;
    }

    public static boolean isEmpty(JRHyperlink hyperlink) {
        return hyperlink == null || hyperlink.getHyperlinkType() == 1 && hyperlink.getHyperlinkTooltipExpression() == null;
    }
}

