/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.logging.Logger;
import jgnash.engine.CommodityNode;
import jgnash.engine.Engine;
import jgnash.engine.ExchangeRateDAO;

public class CurrencyNode
extends CommodityNode {
    private static final long serialVersionUID = 1339921229356331512L;
    private Locale locale = Locale.getDefault();
    private transient ExchangeRateDAO exchangeRateDAO;

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean matches(CommodityNode other) {
        boolean result = this.equals(other);
        if (!result && other instanceof CurrencyNode && this.getSymbol().equals(other.getSymbol()) && this.locale.toString().equals(((CurrencyNode)other).locale.toString())) {
            result = true;
        }
        return result;
    }

    @Override
    public int compareTo(CommodityNode node) {
        if (node instanceof CurrencyNode) {
            int result = this.getSymbol().compareTo(node.getSymbol());
            if (result != 0) {
                return result;
            }
            return this.locale.toString().compareTo(((CurrencyNode)node).locale.toString());
        }
        return super.compareTo(node);
    }

    private ExchangeRateDAO getExchangeRateDAO() {
        return this.exchangeRateDAO;
    }

    void setExchangeRateDAO(ExchangeRateDAO exchangeRateStore) {
        this.exchangeRateDAO = exchangeRateStore;
    }

    public BigDecimal getExchangeRate(CurrencyNode exchangeCurrency) {
        if (exchangeCurrency == null) {
            Logger.getLogger(CurrencyNode.class.getName()).severe("exchangeCurrency was null");
            return BigDecimal.ONE;
        }
        if (exchangeCurrency.equals(this)) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = this.getExchangeRateDAO().getExchangeRateNode(this, exchangeCurrency).getRate();
        if (this.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) < 0) {
            rate = BigDecimal.ONE.divide(rate, Engine.getContext());
        }
        return rate;
    }
}

