/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountProperty;
import jgnash.engine.AccountType;
import jgnash.engine.AmortizeObject;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DefaultCurrencies;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateDAO;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionType;
import jgnash.engine.TrashObject;
import jgnash.engine.UUIDUtil;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.dao.ConfigDAO;
import jgnash.engine.dao.EngineDAO;
import jgnash.engine.dao.RecurringDAO;
import jgnash.engine.dao.TransactionDAO;
import jgnash.engine.dao.TrashDAO;
import jgnash.engine.recurring.PendingReminder;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.util.DateUtils;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.Resource;

public class Engine {
    public static final float CURRENT_VERSION = 2.02f;
    private static final RoundingMode roundingMode = RoundingMode.HALF_UP;
    private static final MathContext mc = new MathContext(16, roundingMode);
    private final Resource rb = Resource.get();
    private final Logger logger = Logger.getLogger(Engine.class.getName());
    private MessageBus messageBus = null;
    private Config config;
    private RootAccount rootAccount;
    private ExchangeRateDAO exchangeRateDAO;
    private final Object accountLock = new Object();
    private final Object commodityLock = new Object();
    private final Object configLock = new Object();
    private EngineDAO eDAO;
    private String accountSeparator = null;
    private ScheduledExecutorService trashExecutor;
    private static final long MAXIMUM_TRASH_AGE = 300000L;
    private final String name;
    private final String uuid = UUIDUtil.getUID();

    public Engine(EngineDAO eDAO, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The engine name may not be null");
        }
        if (eDAO == null) {
            throw new IllegalArgumentException("The engineDAO may not be null");
        }
        this.eDAO = eDAO;
        this.name = name;
        this.initialize();
        this.messageBus = MessageBus.getInstance(name);
        this.checkAndCorrect();
        this.trashExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultDaemonThreadFactory());
        this.trashExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Engine.this.emptyTrash();
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.exchangeRateDAO = new ExchangeRateDAO(this.getCommodityDAO());
        for (CurrencyNode node : this.getCurrencies()) {
            node.setExchangeRateDAO(this.exchangeRateDAO);
        }
        Object object = this.getAccountLock();
        synchronized (object) {
            RootAccount root = this.getRootAccount();
            if (root == null) {
                CurrencyNode node = this.getDefaultCurrency();
                if (node == null) {
                    node = DefaultCurrencies.buildNode(Locale.getDefault());
                    node.setExchangeRateDAO(this.exchangeRateDAO);
                }
                root = new RootAccount(node);
                root.setName(this.rb.getString("Name.Root"));
                root.setDescription(this.rb.getString("Name.Root"));
                this.logInfo("Creating RootAccount");
                if (!this.getAccountDAO().addRootAccount(root)) {
                    this.logSevere("Was not able to add the root account");
                    throw new RuntimeException("Was not able to add the root account");
                }
                if (this.getDefaultCurrency() == null) {
                    this.setDefaultCurrency(node);
                }
            }
        }
        this.logInfo("Engine initialization is complete");
    }

    private void checkAndCorrect() {
        for (Account account : this.getAccountDAO().getAccountList()) {
            if (account.getParent() != null || account.instanceOf(AccountType.ROOT)) continue;
            account.setParent(this.getRootAccount());
            this.getAccountDAO().updateAccount(account);
            this.getAccountDAO().updateAccount(this.getRootAccount());
            this.logInfo("Fixing a detached account: " + account.getName());
        }
        if (this.getConfig().getFileVersion() < 2.01f) {
            this.logInfo("Checking for null account numbers");
            for (Account account : this.getAccountDAO().getAccountList()) {
                if (account.getAccountNumber() != null) continue;
                account.setAccountNumber("");
                this.getAccountDAO().updateAccount(account);
                this.logInfo("Fixed null account number");
            }
        }
        if (this.getConfig().getFileVersion() < 2.02f) {
            this.logInfo("Checking for a recursive account structure");
            for (Account account : this.getAccountDAO().getAccountList()) {
                if (!account.equals(account.getParent())) continue;
                this.logWarning("Correcting recursive account structure:" + account.getName());
                account.setParent(this.getRootAccount());
                this.getAccountDAO().updateAccount(account);
                this.getAccountDAO().updateAccount(this.getRootAccount());
            }
        }
        this.clearObsoleteExchangeRates();
        this.getConfig().setFileVersion(2.02f);
        this.getConfigDAO().commit(this.getConfig());
    }

    private void clearObsoleteExchangeRates() {
        for (ExchangeRate rate : this.getCommodityDAO().getExchangeRates()) {
            if (this.getBaseCurrencies(rate.getRateId()) != null) continue;
            this.removeExchangeRate(rate);
        }
    }

    private void removeExchangeRate(ExchangeRate rate) {
        for (ExchangeRateHistoryNode node : rate.getHistory()) {
            this.removeExchangeRateHistory(rate, node);
        }
        this.moveObjectToTrash(rate);
    }

    void shutdown() {
        this.trashExecutor.shutdownNow();
        this.eDAO.shutdownCommitExecutor();
    }

    public String getName() {
        return this.name;
    }

    private Object getAccountLock() {
        return this.accountLock;
    }

    private Object getCommodityLock() {
        return this.commodityLock;
    }

    private Object getConfigLock() {
        return this.configLock;
    }

    public static MathContext getContext() {
        return mc;
    }

    public static RoundingMode getRoundingMode() {
        return roundingMode;
    }

    private AccountDAO getAccountDAO() {
        return this.eDAO.getAccountDAO();
    }

    private CommodityDAO getCommodityDAO() {
        return this.eDAO.getCommodityDAO();
    }

    private ConfigDAO getConfigDAO() {
        return this.eDAO.getConfigDAO();
    }

    private RecurringDAO getReminderDAO() {
        return this.eDAO.getRecurringDAO();
    }

    private TransactionDAO getTransactionDAO() {
        return this.eDAO.getTransactionDAO();
    }

    private TrashDAO getTrashDAO() {
        return this.eDAO.getTrashDAO();
    }

    private void moveObjectToTrash(StoredObject object) {
        TrashObject trash = new TrashObject(object);
        this.getTrashDAO().add(trash);
    }

    private synchronized void emptyTrash() {
        this.logger.info("Checking for trash");
        List<TrashObject> trash = this.getTrashDAO().getTrashObjects();
        if (trash.isEmpty()) {
            this.logger.info("No trash was found");
        }
        long now = new Date().getTime();
        for (TrashObject o : trash) {
            if (now - o.getDate().getTime() < 300000L) continue;
            this.getTrashDAO().remove(o);
        }
    }

    public boolean addReminder(Reminder reminder) {
        assert (reminder.getUuid() != null);
        boolean result = this.getReminderDAO().addReminder(reminder);
        Message message = result ? new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_ADD, this) : new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_ADD_FAILED, this);
        message.setObject(MessageProperty.REMINDER, reminder);
        this.messageBus.fireEvent(message);
        return result;
    }

    public boolean removeReminder(Reminder reminder) {
        this.moveObjectToTrash(reminder);
        Message message = new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_REMOVE, this);
        message.setObject(MessageProperty.REMINDER, reminder);
        this.messageBus.fireEvent(message);
        return true;
    }

    public List<Reminder> getReminders() {
        return this.getReminderDAO().getReminderList();
    }

    public List<PendingReminder> getPendingReminders() {
        ArrayList<PendingReminder> pendingList = new ArrayList<PendingReminder>();
        List<Reminder> list = this.getReminders();
        Calendar c = Calendar.getInstance();
        Date now = new Date();
        for (Reminder r : list) {
            if (!r.isEnabled()) continue;
            RecurringIterator ri = r.getIterator();
            Date next = ri.next();
            while (next != null) {
                c.setTime(next);
                c.add(5, r.getDaysAdvance() * -1);
                if (DateUtils.before(c.getTime(), now)) {
                    pendingList.add(new PendingReminder(r, DateUtils.levelDate(next)));
                    next = ri.next();
                    continue;
                }
                next = null;
            }
        }
        return pendingList;
    }

    public StoredObject getStoredObjectByUuid(String id) {
        return this.eDAO.getObjectByUuid(id);
    }

    public Collection<StoredObject> getStoredObjects() {
        List<StoredObject> objects = this.eDAO.getStoredObjects();
        Iterator<StoredObject> i = objects.iterator();
        while (i.hasNext()) {
            StoredObject o = i.next();
            if (!(o instanceof TrashObject) && !o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(objects, new StoredObjectComparator());
        return objects;
    }

    private boolean isCommodityNodeValid(CommodityNode node) {
        boolean result = true;
        if (node.getUuid() == null) {
            result = false;
            this.logSevere("Commodity uuid was not valid");
            Thread.dumpStack();
        }
        if (node.getSymbol() == null || node.getSymbol().length() == 0) {
            result = false;
            this.logSevere("Commodity symbol was not valid");
            Thread.dumpStack();
        }
        if (node.getScale() < 0) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " had a scale less than zero");
            Thread.dumpStack();
        }
        if (node instanceof SecurityNode && ((SecurityNode)node).getReportedCurrencyNode() == null) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " was not assigned a currency");
            Thread.dumpStack();
        }
        if (this.eDAO.getObjectByUuid(node.getUuid()) != null) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " was not unique");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addCommodity(CommodityNode node) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            boolean status = this.isCommodityNodeValid(node);
            if (status) {
                if (node instanceof CurrencyNode) {
                    ((CurrencyNode)node).setExchangeRateDAO(this.exchangeRateDAO);
                    Locale locale = ((CurrencyNode)node).getLocale();
                    if (this.getCurrency(node.getSymbol(), locale) != null) {
                        this.logger.info("Prevented addition of a duplicate currency node: " + node.getSymbol());
                        status = false;
                    }
                } else if (this.getSecurity(node.getSymbol()) != null) {
                    this.logger.info("Prevented addition of a duplicate commodity node: " + node.getSymbol());
                    status = false;
                }
            }
            if (status) {
                status = this.getCommodityDAO().addCommodity(node);
                this.logger.fine("Adding: " + node.toString());
            }
            Message message = status ? new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_ADD, this) : new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_ADD_FAILED, this);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            Message message;
            List<SecurityHistoryNode> list = node.getHistoryNodes();
            for (SecurityHistoryNode h : list) {
                if (!h.equals(hNode)) continue;
                this.removeSecurityHistory(node, h);
                break;
            }
            node.addHistoryNode(hNode);
            boolean status = this.getCommodityDAO().addSecurityHistory(node, hNode);
            if (status) {
                this.clearCachedAccountBalance(node);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_ADD, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_ADD_FAILED, this);
            }
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            return status;
        }
    }

    public Set<Account> getInvestmentAccountList(SecurityNode node) {
        HashSet<Account> accounts = new HashSet<Account>();
        for (Account account : this.getInvestmentAccountList()) {
            if (!account.containsSecurity(node)) continue;
            accounts.add(account);
        }
        return accounts;
    }

    public static BigDecimal getMarketPrice(Collection<Transaction> transactions, SecurityNode node, CurrencyNode baseCurrency, Date date) {
        Date testDate = DateUtils.levelDate(date);
        SecurityHistoryNode hNode = node.getHistoryNode(testDate);
        BigDecimal rate = node.getReportedCurrencyNode().getExchangeRate(baseCurrency);
        if (hNode != null && testDate.equals(DateUtils.levelDate(hNode.getDate()))) {
            return hNode.getPrice().multiply(rate);
        }
        Date priceDate = null;
        BigDecimal price = BigDecimal.ZERO;
        block4: for (Transaction t : transactions) {
            if (!(t instanceof InvestmentTransaction)) continue;
            BigDecimal p = ((InvestmentTransaction)t).getPrice();
            if (((InvestmentTransaction)t).getSecurityNode() != node || p == null || p.compareTo(BigDecimal.ZERO) != 1) continue;
            switch (t.getDate().compareTo(testDate)) {
                case -1: {
                    price = p;
                    priceDate = t.getDate();
                    continue block4;
                }
                case 0: {
                    return p;
                }
            }
            break;
        }
        if (hNode == null && priceDate == null) {
            return BigDecimal.ZERO;
        }
        if (priceDate != null && hNode != null ? priceDate.compareTo(hNode.getDate()) >= 0 : hNode == null) {
            return price;
        }
        return hNode.getPrice().multiply(rate);
    }

    private void clearCachedAccountBalance(SecurityNode node) {
        for (Account account : this.getInvestmentAccountList(node)) {
            this.clearCachedAccountBalance(account);
        }
    }

    private void clearCachedAccountBalance(Account account) {
        account.clearCachedBalances();
        this.getAccountDAO().updateAccount(account);
        if (account.getParent() != null && account.getParent().getAccountType() != AccountType.ROOT) {
            this.clearCachedAccountBalance(account.getParent());
        }
    }

    static String buildExchangeRateId(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency) {
        String rateId = baseCurrency.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) > 0 ? baseCurrency.getSymbol() + exchangeCurrency.getSymbol() : exchangeCurrency.getSymbol() + baseCurrency.getSymbol();
        return rateId;
    }

    CurrencyNode[] getBaseCurrencies(String exchangeRateId) {
        List<CurrencyNode> currencies = this.getCurrencies();
        Collections.sort(currencies);
        Collections.reverse(currencies);
        for (CurrencyNode node1 : currencies) {
            for (CurrencyNode node2 : currencies) {
                if (node1 == node2 || !Engine.buildExchangeRateId(node1, node2).equals(exchangeRateId)) continue;
                return new CurrencyNode[]{node1, node2};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CurrencyNode> getActiveCurrencies() {
        Object object = this.getCommodityLock();
        synchronized (object) {
            return this.getCommodityDAO().getActiveCurrencies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyNode getCurrency(String symbol, Locale locale) {
        CurrencyNode rNode = null;
        Object object = this.getCommodityLock();
        synchronized (object) {
            for (CurrencyNode node : this.getCurrencies()) {
                if (!node.getSymbol().equals(symbol) || !node.getLocale().toString().equals(locale.toString())) continue;
                rNode = node;
                break;
            }
            return rNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyNode getCurrency(String symbol) {
        CurrencyNode rNode = null;
        Object object = this.getCommodityLock();
        synchronized (object) {
            for (CurrencyNode node : this.getCurrencies()) {
                if (!node.getSymbol().equals(symbol)) continue;
                rNode = node;
                break;
            }
            return rNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CurrencyNode> getCurrencies() {
        Object object = this.getCommodityLock();
        synchronized (object) {
            return this.getCommodityDAO().getCurrencies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecurityHistoryNode> getSecurityHistory(SecurityNode node) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            return node.getHistoryNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeRate getExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            return this.exchangeRateDAO.getExchangeRateNode(baseCurrency, exchangeCurrency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecurityNode> getSecurities() {
        Object object = this.getCommodityLock();
        synchronized (object) {
            return this.getCommodityDAO().getSecurities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SecurityNode getSecurity(String symbol) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            List<SecurityNode> list = this.getSecurities();
            SecurityNode sNode = null;
            for (SecurityNode node : list) {
                if (!node.getSymbol().equals(symbol)) continue;
                sNode = node;
                break;
            }
            return sNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCommodityNodeUsed(CommodityNode node) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            Object object2 = this.getAccountLock();
            synchronized (object2) {
                List<Account> list = this.getAccountList();
                for (Account a : list) {
                    if (a.getCurrencyNode().equals(node)) {
                        return true;
                    }
                    if (!a.getAccountType().equals((Object)AccountType.INVEST) && !a.getAccountType().equals((Object)AccountType.MUTUAL)) continue;
                    for (SecurityNode j : a.getSecurities()) {
                        if (!j.equals(node) && !j.getReportedCurrencyNode().equals(node)) continue;
                        return true;
                    }
                }
                List<SecurityNode> sList = this.getSecurities();
                for (SecurityNode sNode : sList) {
                    if (!sNode.getReportedCurrencyNode().equals(node)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCommodity(CommodityNode node) {
        boolean status = true;
        Object object = this.getCommodityLock();
        synchronized (object) {
            if (this.isCommodityNodeUsed(node)) {
                status = false;
            } else {
                if (node instanceof SecurityNode) {
                    List<SecurityHistoryNode> hNodes = ((SecurityNode)node).getHistoryNodes();
                    for (SecurityHistoryNode hNode : hNodes) {
                        this.removeSecurityHistory((SecurityNode)node, hNode);
                    }
                } else {
                    this.clearObsoleteExchangeRates();
                }
                this.moveObjectToTrash(node);
            }
            Message message = status ? new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_REMOVE, this) : new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_REMOVE_FAILED, this);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            Message message;
            node.removeHistoryNode(hNode);
            boolean status = this.getCommodityDAO().removeSecurityHistory(node, hNode);
            if (status) {
                this.clearCachedAccountBalance(node);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_REMOVE, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_REMOVE_FAILED, this);
            }
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCurrency(CurrencyNode defaultCurrency) {
        if (!this.isStored(defaultCurrency)) {
            this.addCommodity(defaultCurrency);
        }
        Object object = this.getCommodityLock();
        synchronized (object) {
            Object object2 = this.getConfigLock();
            synchronized (object2) {
                Config c = this.getConfig();
                c.setDefaultCurrency(defaultCurrency);
                this.getConfigDAO().commit(c);
                this.logInfo("Setting default currency: " + defaultCurrency.toString());
            }
        }
        object = this.getAccountLock();
        synchronized (object) {
            RootAccount root = this.getRootAccount();
            root.setCurrencyNode(defaultCurrency);
            this.getAccountDAO().updateAccount(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config getConfig() {
        Object object = this.getConfigLock();
        synchronized (object) {
            if (this.config == null) {
                this.config = this.getConfigDAO().getDefaultConfig();
            }
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyNode getDefaultCurrency() {
        Object object = this.getCommodityLock();
        synchronized (object) {
            Object object2 = this.getConfigLock();
            synchronized (object2) {
                CurrencyNode node = this.getConfig().getDefaultCurrency();
                if (node == null) {
                    this.logger.warning("No default currency assigned");
                }
                return node;
            }
        }
    }

    public void setExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency, BigDecimal rate) {
        this.setExchangeRate(baseCurrency, exchangeCurrency, rate, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency, BigDecimal rate, Date date) {
        assert (rate != null && rate.compareTo(BigDecimal.ZERO) > 0);
        if (baseCurrency.equals(exchangeCurrency)) {
            return;
        }
        Object object = this.getCommodityLock();
        synchronized (object) {
            ExchangeRate exchangeRate = this.getExchangeRate(baseCurrency, exchangeCurrency);
            if (exchangeRate == null) {
                exchangeRate = new ExchangeRate(Engine.buildExchangeRateId(baseCurrency, exchangeCurrency));
            }
            ExchangeRateHistoryNode historyNode = baseCurrency.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) > 0 ? new ExchangeRateHistoryNode(DateUtils.levelDate(date), rate) : new ExchangeRateHistoryNode(DateUtils.levelDate(date), BigDecimal.ONE.divide(rate, mc));
            List<ExchangeRateHistoryNode> history = exchangeRate.getHistory();
            for (ExchangeRateHistoryNode node : history) {
                if (!node.equals(historyNode)) continue;
                this.removeExchangeRateHistory(exchangeRate, node);
            }
            exchangeRate.addHistoryNode(historyNode);
            this.getCommodityDAO().addExchangeRateHistory(exchangeRate, historyNode);
            Message message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_ADD, this);
            message.setObject(MessageProperty.EXCHANGERATE, exchangeRate);
            this.messageBus.fireEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExchangeRateHistory(ExchangeRate exchangeRate, ExchangeRateHistoryNode history) {
        Object object = this.getCommodityLock();
        synchronized (object) {
            Message message;
            if (exchangeRate.contains(history)) {
                exchangeRate.removeHistoryNode(history);
                this.getCommodityDAO().removeExchangeRateHistory(exchangeRate, history);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_REMOVE, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_REMOVE_FAILED, this);
            }
            message.setObject(MessageProperty.EXCHANGERATE, exchangeRate);
            this.messageBus.fireEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCommodity(CommodityNode oldNode, CommodityNode templateNode) {
        assert (oldNode != null && templateNode != null);
        assert (oldNode != templateNode);
        Object object = this.getCommodityLock();
        synchronized (object) {
            Message message;
            boolean status = true;
            if (oldNode.getClass().equals(templateNode.getClass())) {
                oldNode.setDescription(templateNode.getDescription());
                oldNode.setPrefix(templateNode.getPrefix());
                oldNode.setScale(templateNode.getScale());
                oldNode.setSuffix(templateNode.getSuffix());
                if (templateNode instanceof SecurityNode) {
                    oldNode.setSymbol(templateNode.getSymbol());
                    ((SecurityNode)oldNode).setReportedCurrencyNode(((SecurityNode)templateNode).getReportedCurrencyNode());
                    ((SecurityNode)oldNode).setQuoteSource(((SecurityNode)templateNode).getQuoteSource());
                    ((SecurityNode)oldNode).setISIN(((SecurityNode)templateNode).getISIN());
                }
                this.getCommodityDAO().updateCommodityNode(oldNode);
            } else {
                status = false;
                this.logger.warning("Template object class did not match old object class");
            }
            if (status) {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_MODIFY, this);
                message.setObject(MessageProperty.COMMODITY, oldNode);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_MODIFY_FAILED, this);
                message.setObject(MessageProperty.COMMODITY, templateNode);
            }
            this.messageBus.fireEvent(message);
            return status;
        }
    }

    public void updateReminder(Reminder reminder) {
        this.getReminderDAO().updateReminder(reminder);
    }

    private void logInfo(String message) {
        this.logger.info(message);
    }

    private void logWarning(String message) {
        this.logger.warning(message);
    }

    private void logSevere(String message) {
        this.logger.severe(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountSeparator(String separator) {
        Object object = this.getConfigLock();
        synchronized (object) {
            this.accountSeparator = separator;
            Config c = this.getConfig();
            c.setAccountSeparator(separator);
            this.getConfigDAO().commit(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccountSeparator() {
        Object object = this.getConfigLock();
        synchronized (object) {
            if (this.accountSeparator == null) {
                this.accountSeparator = this.getConfig().getAccountSeparator();
            }
            return this.accountSeparator;
        }
    }

    public List<Account> getAccountList() {
        return this.getAccountDAO().getAccountList();
    }

    public Account getAccountByUuid(String id) {
        return this.getAccountDAO().getAccountByUuid(id);
    }

    public Account getAccountByName(String accountName) {
        assert (accountName != null);
        List<Account> list = this.getAccountList();
        Collections.sort(list);
        for (Account account : list) {
            if (!accountName.equals(account.getName())) continue;
            return account;
        }
        return null;
    }

    public List<Account> getIncomeAccountList() {
        return this.getAccountDAO().getIncomeAccountList();
    }

    public List<Account> getExpenseAccountList() {
        return this.getAccountDAO().getExpenseAccountList();
    }

    public List<Account> getBankAccountList() {
        ArrayList<Account> retList = new ArrayList<Account>();
        List<Account> list = this.getAccountList();
        for (Account a : list) {
            if (!a.getAccountType().equals((Object)AccountType.BANK) && !a.getAccountType().equals((Object)AccountType.CASH)) continue;
            retList.add(a);
        }
        return retList;
    }

    public List<Account> getInvestmentAccountList() {
        return this.getAccountDAO().getInvestmentAccountList();
    }

    public void refreshAccount(Account account) {
        this.getAccountDAO().refreshAccount(account);
    }

    public void refreshCommodity(CommodityNode node) {
        this.getCommodityDAO().refreshCommodityNode(node);
    }

    public void refreshExchangeRate(ExchangeRate rate) {
        this.getCommodityDAO().refreshExchangeRate(rate);
    }

    public void refreshReminder(Reminder reminder) {
        this.getReminderDAO().refreshReminder(reminder);
    }

    public void refreshTransaction(Transaction transaction) {
        this.getTransactionDAO().refreshTransaction(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addAccount(Account parent, Account child) {
        assert (child != null);
        assert (child.getUuid() != null);
        if (child.getAccountType() == AccountType.ROOT) {
            throw new RuntimeException("Invalid Account");
        }
        Object object = this.accountLock;
        synchronized (object) {
            boolean result = parent.addChild(child);
            if (result) {
                result = this.getAccountDAO().addAccount(parent, child);
            }
            if (result) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_ADD, this);
                message.setObject(MessageProperty.ACCOUNT, child);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountAdd"));
                result = true;
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_ADD_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, child);
                this.messageBus.fireEvent(message);
                result = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RootAccount getRootAccount() {
        Object object = this.getAccountLock();
        synchronized (object) {
            if (this.rootAccount == null) {
                this.rootAccount = this.getAccountDAO().getRootAccount();
            }
            return this.rootAccount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean moveAccount(Account account, Account newParent) {
        assert (account != null && newParent != null);
        Object object = this.getAccountLock();
        synchronized (object) {
            Message message;
            if (account.contains(newParent)) {
                Message message2 = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY_FAILED, this);
                message2.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message2);
                this.logInfo(this.rb.getString("Message.AccountMoveFailed"));
                return false;
            }
            Account oldParent = account.getParent();
            if (oldParent != null) {
                oldParent.removeChild(account);
                this.getAccountDAO().updateAccount(account);
                this.getAccountDAO().updateAccount(oldParent);
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
                message.setObject(MessageProperty.ACCOUNT, oldParent);
                this.messageBus.fireEvent(message);
            }
            newParent.addChild(account);
            this.getAccountDAO().updateAccount(account);
            this.getAccountDAO().updateAccount(newParent);
            message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
            message.setObject(MessageProperty.ACCOUNT, newParent);
            this.messageBus.fireEvent(message);
            this.logInfo(this.rb.getString("Message.AccountModify"));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyAccount(Account template, Account account) {
        Object object = this.getAccountLock();
        synchronized (object) {
            boolean result;
            account.setName(template.getName());
            account.setDescription(template.getDescription());
            account.setNotes(template.getNotes());
            account.setLocked(template.isLocked());
            account.setPlaceHolder(template.isPlaceHolder());
            account.setVisible(template.isVisible());
            account.setAccountNumber(template.getAccountNumber());
            if (account.getAccountType().isMutable()) {
                account.setAccountType(template.getAccountType());
            }
            if (account.getTransactionCount() == 0) {
                account.setCurrencyNode(template.getCurrencyNode());
            }
            if (result = this.getAccountDAO().updateAccount(account)) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountModify"));
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            if (account.parentAccount != template.parentAccount && template.parentAccount != null && result) {
                this.moveAccount(account, template.parentAccount);
            }
            return result;
        }
    }

    public void setAccountNumber(Account account, String number) {
        account.setAccountNumber(number);
        this.getAccountDAO().updateAccount(account);
        Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
        message.setObject(MessageProperty.ACCOUNT, account);
        this.messageBus.fireEvent(message);
        this.logInfo(this.rb.getString("Message.AccountModify"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeAccount(Account account) {
        boolean result = false;
        Object object = this.getAccountLock();
        synchronized (object) {
            Message message;
            if (account.getTransactionCount() > 0 || account.getChildCount() > 0) {
                result = false;
            } else {
                Account parent = account.getParent();
                if (parent != null && (result = parent.removeChild(account))) {
                    this.getAccountDAO().updateAccount(parent);
                }
                this.moveObjectToTrash(account);
            }
            if (result) {
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_REMOVE, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountRemove"));
            } else {
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_REMOVE_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAmortizeObject(Account account, AmortizeObject amortizeObject) {
        Object object = this.getAccountLock();
        synchronized (object) {
            if (account != null && amortizeObject != null && account.getAccountType().equals((Object)AccountType.LIABILITY)) {
                AmortizeObject oldAmortizeObject = (AmortizeObject)account.getProperty(AccountProperty.AMORTIZEOBJECT);
                if (oldAmortizeObject != null && account.removeProperty(AccountProperty.AMORTIZEOBJECT) && !this.getAccountDAO().removeAccountProperty(account, oldAmortizeObject)) {
                    this.logSevere("Was not able to remove the old amortize object");
                }
                account.setProperty(AccountProperty.AMORTIZEOBJECT, amortizeObject);
                if (!this.getAccountDAO().setAccountProperty(account, amortizeObject)) {
                    this.logSevere("Was not able to save the amortize object");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAccountVisibility(Account account) {
        Object object = this.getAccountLock();
        synchronized (object) {
            boolean result = false;
            account.setVisible(!account.isVisible());
            if (this.getAccountDAO().toggleAccountVisibility(account)) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_VISABILITY_CHANGE, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                result = true;
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_VISABILITY_CHANGE_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAccountSecurity(Account account, SecurityNode node) {
        Object object = this.getAccountLock();
        synchronized (object) {
            Object object2 = this.getCommodityLock();
            synchronized (object2) {
                boolean result = account.addSecurity(node);
                if (result) {
                    result = this.getAccountDAO().addAccountSecurity(account, node);
                }
                Message message = result ? new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_ADD, this) : new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_ADD_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                message.setObject(MessageProperty.COMMODITY, node);
                this.messageBus.fireEvent(message);
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAccountSecurity(Account account, SecurityNode node) {
        assert (node != null);
        Object object = this.getAccountLock();
        synchronized (object) {
            Object object2 = this.getCommodityLock();
            synchronized (object2) {
                boolean result = account.removeSecurity(node);
                if (result) {
                    this.getAccountDAO().updateAccount(account);
                }
                Message message = result ? new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_REMOVE, this) : new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_REMOVE_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                message.setObject(MessageProperty.COMMODITY, node);
                this.messageBus.fireEvent(message);
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccountSecurities(Account acc, Collection<SecurityNode> list) {
        boolean result = false;
        if (acc.memberOf(AccountGroup.INVEST)) {
            Object object = this.getAccountLock();
            synchronized (object) {
                Object object2 = this.getCommodityLock();
                synchronized (object2) {
                    Set<SecurityNode> oldList = acc.getSecurities();
                    for (SecurityNode node : oldList) {
                        if (list.contains(node)) continue;
                        this.removeAccountSecurity(acc, node);
                    }
                    for (SecurityNode node : list) {
                        if (oldList.contains(node)) continue;
                        this.addAccountSecurity(acc, node);
                    }
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isTransactionValid(Transaction transaction) {
        for (Account a : transaction.getAccounts()) {
            if (!a.isLocked()) continue;
            this.logWarning(this.rb.getString("Message.TransactionAccountLocked"));
            return false;
        }
        if (transaction.isMarkedForRemoval()) {
            this.logger.log(Level.WARNING, "Transaction already marked for removal");
            return false;
        }
        if (this.eDAO.getObjectByUuid(transaction.getUuid()) != null) {
            this.logger.log(Level.WARNING, "Transaction UUID was not unique");
            return false;
        }
        if (transaction.size() < 1) {
            this.logger.log(Level.WARNING, "Invalid Transaction");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e != null) continue;
            this.logger.log(Level.WARNING, "Null TransactionEntry");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e.getTransactionTag() != null) continue;
            this.logger.log(Level.WARNING, "Null TransactionTag");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e.getCreditAccount() == null) {
                this.logger.log(Level.WARNING, "Null Credit Account");
                return false;
            }
            if (e.getDebitAccount() == null) {
                this.logger.log(Level.WARNING, "Null Debit Account");
                return false;
            }
            if (e.getCreditAmount() == null) {
                this.logger.log(Level.WARNING, "Null Credit Amount");
                return false;
            }
            if (e.getDebitAmount() != null) continue;
            this.logger.log(Level.WARNING, "Null Debit Amount");
            return false;
        }
        if (transaction.getTransactionType() == TransactionType.SPLITENTRY && transaction.getCommonAccount() == null) {
            this.logger.log(Level.WARNING, "Entries do not share a common account");
            return false;
        }
        return !(transaction instanceof InvestmentTransaction) || transaction.getTransactionType() != null;
    }

    public boolean isStored(StoredObject object) {
        return this.eDAO.getObjectByUuid(object.getUuid()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTransaction(Transaction transaction) {
        Object object = this.getAccountLock();
        synchronized (object) {
            boolean result = this.isTransactionValid(transaction);
            if (result) {
                for (Account account : transaction.getAccounts()) {
                    if (account.addTransaction(transaction)) continue;
                    this.logSevere("Failed to add the Transaction");
                }
                result = this.getTransactionDAO().addTransaction(transaction);
                this.logInfo(this.rb.getString("Message.TransactionAdd"));
            }
            this.postTransactionAdd(transaction, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransaction(Transaction transaction) {
        Object object = this.getAccountLock();
        synchronized (object) {
            for (Account account : transaction.getAccounts()) {
                if (!account.isLocked()) continue;
                this.logWarning(this.rb.getString("Message.TransactionRemoveLocked"));
                return false;
            }
            for (Account account : transaction.getAccounts()) {
                if (account.removeTransaction(transaction)) continue;
                this.logSevere("Failed to add the Transaction");
            }
            this.logInfo(this.rb.getString("Message.TransactionRemove"));
            boolean result = this.getTransactionDAO().removeTransaction(transaction);
            if (result) {
                this.moveObjectToTrash(transaction);
            }
            this.postTransactionRemove(transaction, result);
            return result;
        }
    }

    public void setTransactionReconciled(Transaction transaction, Account account, ReconciledState state) {
        Transaction clone = (Transaction)transaction.clone();
        clone.setReconciled(account, state);
        if (this.removeTransaction(transaction)) {
            this.addTransaction(clone);
        }
    }

    public List<String> getTransactionNumberList() {
        return this.getConfig().getTransactionNumberList();
    }

    public void setTransactionNumberList(List<String> list) {
        Config c = this.getConfig();
        c.setTransactionNumberList(list);
        this.getConfigDAO().commit(c);
    }

    public List<Transaction> getTransactions() {
        return this.getTransactionDAO().getTransactions();
    }

    private void postTransactionAdd(Transaction transaction, boolean result) {
        for (Account a : transaction.getAccounts()) {
            Message message = result ? new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_ADD, this) : new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_ADD_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, a);
            message.setObject(MessageProperty.TRANSACTION, transaction);
            this.messageBus.fireEvent(message);
        }
    }

    private void postTransactionRemove(Transaction transaction, boolean result) {
        for (Account a : transaction.getAccounts()) {
            Message message = result ? new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_REMOVE, this) : new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_REMOVE_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, a);
            message.setObject(MessageProperty.TRANSACTION, transaction);
            this.messageBus.fireEvent(message);
        }
    }

    public String getUuid() {
        return this.uuid;
    }
}

